/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.reactive.engine.impl;

import java.lang.invoke.MethodHandles;
import java.util.concurrent.CompletionStage;
import org.hibernate.HibernateException;
import org.hibernate.action.internal.EntityDeleteAction;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.event.spi.EventSource;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.reactive.engine.ReactiveExecutable;
import org.hibernate.reactive.logging.impl.Log;
import org.hibernate.reactive.logging.impl.LoggerFactory;
import org.hibernate.reactive.persister.entity.impl.ReactiveEntityPersister;
import org.hibernate.reactive.util.impl.CompletionStages;
import org.hibernate.stat.spi.StatisticsImplementor;

public class ReactiveEntityDeleteAction
extends EntityDeleteAction
implements ReactiveExecutable {
    private static final Log LOG = LoggerFactory.make(Log.class, MethodHandles.lookup());

    public ReactiveEntityDeleteAction(Object id, Object[] state, Object version, Object instance, EntityPersister persister, boolean isCascadeDeleteEnabled, EventSource session) {
        super(id, state, version, instance, persister, isCascadeDeleteEnabled, session);
    }

    public ReactiveEntityDeleteAction(Object id, EntityPersister persister, EventSource session) {
        super(id, persister, session);
    }

    public void execute() throws HibernateException {
        throw LOG.nonReactiveMethodCall("reactiveExecute");
    }

    private boolean isInstanceLoaded() {
        return this.getInstance() != null;
    }

    @Override
    public CompletionStage<Void> reactiveExecute() throws HibernateException {
        Object id = this.getId();
        Object version = this.getCurrentVersion();
        EntityPersister persister = this.getPersister();
        EventSource session = this.getSession();
        Object instance = this.getInstance();
        boolean veto = this.isInstanceLoaded() && this.preDelete();
        Object ck = this.lockCacheItem();
        return this.deleteStep(veto, (ReactiveEntityPersister)persister, id, version, instance, (SharedSessionContractImplementor)session).thenAccept(arg_0 -> this.lambda$reactiveExecute$0(id, persister, (SharedSessionContractImplementor)session, instance, ck, veto, arg_0));
    }

    private CompletionStage<Void> deleteStep(boolean veto, ReactiveEntityPersister persister, Object id, Object version, Object instance, SharedSessionContractImplementor session) {
        return !this.isCascadeDeleteEnabled() && !veto ? persister.deleteReactive(id, version, instance, session) : CompletionStages.voidFuture();
    }

    private /* synthetic */ void lambda$reactiveExecute$0(Object id, EntityPersister persister, SharedSessionContractImplementor session, Object instance, Object ck, boolean veto, Void v) {
        if (this.isInstanceLoaded()) {
            this.postDeleteLoaded(id, persister, session, instance, ck);
        } else {
            this.postDeleteUnloaded(id, persister, session, ck);
        }
        StatisticsImplementor statistics = this.getSession().getFactory().getStatistics();
        if (statistics.isStatisticsEnabled() && !veto) {
            statistics.deleteEntity(this.getPersister().getEntityName());
        }
    }
}

