/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.reactive.engine.impl;

import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletionStage;
import org.hibernate.CacheMode;
import org.hibernate.Hibernate;
import org.hibernate.HibernateException;
import org.hibernate.bytecode.enhance.spi.interceptor.LazyAttributeLoadingInterceptor;
import org.hibernate.collection.spi.PersistentCollection;
import org.hibernate.engine.internal.CascadePoint;
import org.hibernate.engine.internal.ManagedTypeHelper;
import org.hibernate.engine.spi.CascadeStyle;
import org.hibernate.engine.spi.CollectionEntry;
import org.hibernate.engine.spi.EntityEntry;
import org.hibernate.engine.spi.PersistenceContext;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.engine.spi.Status;
import org.hibernate.event.spi.DeleteContext;
import org.hibernate.event.spi.EventSource;
import org.hibernate.metamodel.mapping.AttributeMapping;
import org.hibernate.persister.collection.CollectionPersister;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.pretty.MessageHelper;
import org.hibernate.reactive.engine.impl.CascadingAction;
import org.hibernate.reactive.engine.impl.CascadingActions;
import org.hibernate.reactive.logging.impl.Log;
import org.hibernate.reactive.logging.impl.LoggerFactory;
import org.hibernate.reactive.session.ReactiveSession;
import org.hibernate.reactive.util.impl.CompletionStages;
import org.hibernate.type.AssociationType;
import org.hibernate.type.CollectionType;
import org.hibernate.type.ComponentType;
import org.hibernate.type.CompositeType;
import org.hibernate.type.EntityType;
import org.hibernate.type.ForeignKeyDirection;
import org.hibernate.type.Type;

public final class Cascade<C> {
    private static final Log LOG = LoggerFactory.make(Log.class, MethodHandles.lookup());
    private final CascadingAction<C> action;
    private final EntityPersister persister;
    private final Object parent;
    private final EventSource eventSource;
    private final C context;
    private CascadePoint cascadePoint;
    private CompletionStage<Void> stage = CompletionStages.voidFuture();

    public Cascade(CascadingAction<C> action, CascadePoint cascadePoint, EntityPersister persister, Object parent, C context, EventSource eventSource) {
        this.action = action;
        this.parent = parent;
        this.persister = persister;
        this.cascadePoint = cascadePoint;
        this.eventSource = eventSource;
        this.context = context;
    }

    public static CompletionStage<?> fetchLazyAssociationsBeforeCascade(CascadingAction<?> action, EntityPersister persister, Object entity, EventSource session) {
        CompletionStage<Void> beforeDelete = CompletionStages.voidFuture();
        if (persister.hasCascades()) {
            CascadeStyle[] cascadeStyles = persister.getPropertyCascadeStyles();
            Object[] state = persister.getValues(entity);
            for (int i = 0; i < cascadeStyles.length; ++i) {
                Object fetchable;
                if (!cascadeStyles[i].doCascade(action.delegate()) || Hibernate.isInitialized((Object)(fetchable = state[i]))) continue;
                beforeDelete = beforeDelete.thenCompose(v -> ((ReactiveSession)session.unwrap(ReactiveSession.class)).reactiveFetch(fetchable, true));
            }
        }
        return beforeDelete;
    }

    public CompletionStage<Void> cascade() throws HibernateException {
        return CompletionStages.voidFuture().thenCompose(v -> {
            CacheMode cacheMode = this.eventSource.getCacheMode();
            if (this.action == CascadingActions.DELETE) {
                this.eventSource.setCacheMode(CacheMode.GET);
            }
            this.eventSource.getPersistenceContextInternal().incrementCascadeLevel();
            return this.cascadeInternal().whenComplete((vv, e) -> {
                this.eventSource.getPersistenceContextInternal().decrementCascadeLevel();
                this.eventSource.setCacheMode(cacheMode);
            });
        });
    }

    private CompletionStage<Void> cascadeInternal() throws HibernateException {
        if (this.persister.hasCascades() || this.action.requiresNoCascadeChecking()) {
            PersistenceContext persistenceContext;
            EntityEntry entry;
            boolean traceEnabled = LOG.isTraceEnabled();
            if (traceEnabled) {
                LOG.tracev("Processing cascade {0} for: {1}", this.action, this.persister.getEntityName());
            }
            if ((entry = (persistenceContext = this.eventSource.getPersistenceContextInternal()).getEntry(this.parent)) != null && entry.getLoadedState() == null && entry.getStatus() == Status.MANAGED && this.persister.getBytecodeEnhancementMetadata().isEnhancedForLazyLoading()) {
                return CompletionStages.voidFuture();
            }
            Type[] types = this.persister.getPropertyTypes();
            String[] propertyNames = this.persister.getPropertyNames();
            CascadeStyle[] cascadeStyles = this.persister.getPropertyCascadeStyles();
            boolean hasUninitializedLazyProperties = this.persister.hasUninitializedLazyProperties(this.parent);
            for (int i = 0; i < types.length; ++i) {
                CascadeStyle style = cascadeStyles[i];
                String propertyName = propertyNames[i];
                boolean isUninitializedProperty = hasUninitializedLazyProperties && !this.persister.getBytecodeEnhancementMetadata().isAttributeLoaded(this.parent, propertyName);
                Type type = types[i];
                if (style.doCascade(this.action.delegate())) {
                    Object child;
                    if (isUninitializedProperty) {
                        if (entry == null) continue;
                        if (type.isCollectionType()) {
                            CollectionType collectionType = (CollectionType)type;
                            child = collectionType.getCollection(collectionType.getKeyOfOwner(this.parent, (SharedSessionContractImplementor)this.eventSource), (SharedSessionContractImplementor)this.eventSource, this.parent, null);
                        } else {
                            if (type.isComponentType()) {
                                throw new UnsupportedOperationException("Lazy components are not supported.");
                            }
                            if (!this.action.performOnLazyProperty() || !type.isEntityType()) continue;
                            LazyAttributeLoadingInterceptor interceptor = this.persister.getBytecodeEnhancementMetadata().extractInterceptor(this.parent);
                            child = interceptor.fetchAttribute(this.parent, propertyName);
                        }
                    } else {
                        child = this.persister.getValue(this.parent, i);
                    }
                    this.cascadeProperty(null, child, type, style, propertyName, false);
                    continue;
                }
                if (this.action.requiresNoCascadeChecking()) {
                    this.noCascade(this.eventSource, this.parent, this.persister, types, i);
                }
                if (!this.action.deleteOrphans() || isUninitializedProperty) continue;
                this.cascadeLogicalOneToOneOrphanRemoval(null, this.persister.getValue(this.parent, i), type, style, propertyName, false);
            }
            if (traceEnabled) {
                LOG.tracev("Done processing cascade {0} for: {1}", this.action, this.persister.getEntityName());
            }
        }
        return this.stage;
    }

    private void noCascade(EventSource eventSource, Object parent, EntityPersister persister, Type[] types, int i) {
        this.stage = this.stage.thenCompose(v -> this.action.noCascade(eventSource, parent, persister, types[i], i));
    }

    private void cascadeProperty(List<String> componentPath, Object child, Type type, CascadeStyle style, String propertyName, boolean isCascadeDeleteEnabled) throws HibernateException {
        if (child != null) {
            if (type.isAssociationType()) {
                AssociationType associationType = (AssociationType)type;
                if (this.cascadeAssociationNow(this.cascadePoint, associationType)) {
                    this.cascadeAssociation(componentPath, child, type, style, isCascadeDeleteEnabled);
                }
            } else if (type.isComponentType()) {
                if (componentPath == null && propertyName != null) {
                    componentPath = new ArrayList<String>();
                }
                if (componentPath != null) {
                    componentPath.add(propertyName);
                }
                this.cascadeComponent(componentPath, child, (CompositeType)type);
            }
        }
        this.cascadeLogicalOneToOneOrphanRemoval(componentPath, child, type, style, propertyName, isCascadeDeleteEnabled);
    }

    private void cascadeLogicalOneToOneOrphanRemoval(List<String> componentPath, Object child, Type type, CascadeStyle style, String propertyName, boolean isCascadeDeleteEnabled) throws HibernateException {
        PersistenceContext persistenceContext;
        EntityEntry entry;
        if (style.hasOrphanDelete() && this.action.deleteOrphans() && (entry = (persistenceContext = this.eventSource.getPersistenceContextInternal()).getEntry(this.parent)) != null && entry.getStatus() != Status.SAVING) {
            Object loadedValue;
            if (componentPath == null) {
                loadedValue = entry.getLoadedValue(propertyName);
            } else {
                AttributeMapping propertyType = entry.getPersister().findAttributeMapping(componentPath.get(0));
                if (propertyType instanceof ComponentType) {
                    loadedValue = entry.getLoadedValue(componentPath.get(0));
                    ComponentType componentType = (ComponentType)propertyType;
                    if (componentPath.size() != 1) {
                        for (int i = 1; i < componentPath.size(); ++i) {
                            int subPropertyIndex = componentType.getPropertyIndex(componentPath.get(i));
                            loadedValue = componentType.getPropertyValue(loadedValue, subPropertyIndex);
                            componentType = (ComponentType)componentType.getSubtypes()[subPropertyIndex];
                        }
                    }
                    loadedValue = componentType.getPropertyValue(loadedValue, componentType.getPropertyIndex(propertyName));
                } else {
                    loadedValue = null;
                }
            }
            if (child == null || loadedValue != null && child != loadedValue) {
                EntityEntry valueEntry = persistenceContext.getEntry(loadedValue);
                if (valueEntry == null && ManagedTypeHelper.isHibernateProxy((Object)loadedValue)) {
                    loadedValue = persistenceContext.unproxyAndReassociate(loadedValue);
                    valueEntry = persistenceContext.getEntry(loadedValue);
                    if (child == loadedValue) {
                        return;
                    }
                }
                if (valueEntry != null) {
                    EntityPersister persister = valueEntry.getPersister();
                    String entityName = persister.getEntityName();
                    if (LOG.isTraceEnabled()) {
                        LOG.tracev("Deleting orphaned entity instance: {0}", MessageHelper.infoString((String)entityName, (Object)persister.getIdentifier(loadedValue, (SharedSessionContractImplementor)this.eventSource)));
                    }
                    Object loaded = loadedValue;
                    this.stage = type.isAssociationType() && ((AssociationType)type).getForeignKeyDirection().equals((Object)ForeignKeyDirection.TO_PARENT) ? this.stage.thenCompose(v -> ((ReactiveSession)this.eventSource).reactiveRemoveOrphanBeforeUpdates(entityName, loaded)) : this.stage.thenCompose(v -> ((ReactiveSession)this.eventSource).reactiveRemove(entityName, loaded, isCascadeDeleteEnabled, DeleteContext.create()));
                }
            }
        }
    }

    private boolean isLogicalOneToOne(Type type) {
        return type.isEntityType() && ((EntityType)type).isLogicalOneToOne();
    }

    private boolean cascadeAssociationNow(CascadePoint cascadePoint, AssociationType associationType) {
        return associationType.getForeignKeyDirection().cascadeNow(cascadePoint);
    }

    private void cascadeComponent(List<String> componentPath, Object child, CompositeType componentType) {
        Object[] children = null;
        Type[] types = componentType.getSubtypes();
        String[] propertyNames = componentType.getPropertyNames();
        for (int i = 0; i < types.length; ++i) {
            CascadeStyle componentPropertyStyle = componentType.getCascadeStyle(i);
            String subPropertyName = propertyNames[i];
            if (!componentPropertyStyle.doCascade(this.action.delegate()) && (!componentPropertyStyle.hasOrphanDelete() || !this.action.deleteOrphans())) continue;
            if (children == null) {
                children = componentType.getPropertyValues(child, (SharedSessionContractImplementor)this.eventSource);
            }
            this.cascadeProperty(componentPath, children[i], types[i], componentPropertyStyle, subPropertyName, false);
        }
    }

    private void cascadeAssociation(List<String> componentPath, Object child, Type type, CascadeStyle style, boolean isCascadeDeleteEnabled) {
        if (type.isEntityType() || type.isAnyType()) {
            this.cascadeToOne(child, type, style, isCascadeDeleteEnabled);
        } else if (type.isCollectionType()) {
            this.cascadeCollection(componentPath, child, style, (CollectionType)type);
        }
    }

    private void cascadeCollection(List<String> componentPath, Object child, CascadeStyle style, CollectionType type) {
        CollectionPersister persister = this.eventSource.getFactory().getMappingMetamodel().getCollectionDescriptor(type.getRole());
        Type elemType = persister.getElementType();
        CascadePoint elementsCascadePoint = this.cascadePoint;
        if (this.cascadePoint == CascadePoint.AFTER_INSERT_BEFORE_DELETE) {
            this.cascadePoint = CascadePoint.AFTER_INSERT_BEFORE_DELETE_VIA_COLLECTION;
        }
        if (elemType.isEntityType() || elemType.isAnyType() || elemType.isComponentType()) {
            this.cascadeCollectionElements(componentPath, child, type, style, elemType, persister.isCascadeDeleteEnabled());
        }
        this.cascadePoint = elementsCascadePoint;
    }

    private void cascadeToOne(Object child, Type type, CascadeStyle style, boolean isCascadeDeleteEnabled) {
        String entityName;
        String string = entityName = type.isEntityType() ? ((EntityType)type).getAssociatedEntityName() : null;
        if (style.reallyDoCascade(this.action.delegate())) {
            PersistenceContext persistenceContext = this.eventSource.getPersistenceContextInternal();
            persistenceContext.addChildParent(child, this.parent);
            this.stage = this.stage.thenCompose(v -> this.action.cascade(this.eventSource, child, entityName, this.context, isCascadeDeleteEnabled)).whenComplete((vv, e) -> persistenceContext.removeChildParent(child));
        }
    }

    private void cascadeCollectionElements(List<String> componentPath, Object child, CollectionType collectionType, CascadeStyle style, Type elemType, boolean isCascadeDeleteEnabled) throws HibernateException {
        boolean deleteOrphans;
        boolean reallyDoCascade;
        boolean bl = reallyDoCascade = style.reallyDoCascade(this.action.delegate()) && child != CollectionType.UNFETCHED_COLLECTION;
        if (reallyDoCascade) {
            boolean traceEnabled = LOG.isTraceEnabled();
            if (traceEnabled) {
                LOG.tracev("Cascade {0} for collection: {1}", this.action, collectionType.getRole());
            }
            Iterator<?> itr = this.action.getCascadableChildrenIterator(this.eventSource, collectionType, child);
            while (itr.hasNext()) {
                this.cascadeProperty(componentPath, itr.next(), elemType, style, null, isCascadeDeleteEnabled);
            }
            if (traceEnabled) {
                LOG.tracev("Done cascade {0} for collection: {1}", this.action, collectionType.getRole());
            }
        }
        boolean bl2 = deleteOrphans = style.hasOrphanDelete() && this.action.deleteOrphans() && elemType.isEntityType() && child instanceof PersistentCollection && !((PersistentCollection)child).isNewlyInstantiated();
        if (deleteOrphans) {
            boolean traceEnabled = LOG.isTraceEnabled();
            if (traceEnabled) {
                LOG.tracev("Deleting orphans for collection: {0}", collectionType.getRole());
            }
            String entityName = collectionType.getAssociatedEntityName(this.eventSource.getFactory());
            this.deleteOrphans(entityName, (PersistentCollection)child);
            if (traceEnabled) {
                LOG.tracev("Done deleting orphans for collection: {0}", collectionType.getRole());
            }
        }
    }

    private void deleteOrphans(String entityName, PersistentCollection<?> pc) throws HibernateException {
        Collection orphans;
        if (pc.wasInitialized()) {
            CollectionEntry ce = this.eventSource.getPersistenceContextInternal().getCollectionEntry(pc);
            if (ce == null) {
                return;
            }
            orphans = ce.getOrphans(entityName, pc);
        } else {
            orphans = pc.getQueuedOrphans(entityName);
        }
        ReactiveSession session = (ReactiveSession)this.eventSource;
        this.stage = this.stage.thenCompose(v -> CompletionStages.loop(orphans, Objects::nonNull, orphan -> {
            LOG.tracev("Deleting orphaned entity instance: {0}", entityName);
            return session.reactiveRemove(entityName, orphan, false, DeleteContext.create());
        }));
    }
}

