/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.reactive.context.impl;

import java.util.Objects;
import org.hibernate.reactive.context.Context;

public final class BaseKey<T>
implements Context.Key<T> {
    private final Class<T> type;
    private final String id;
    private final int hash;

    public BaseKey(Class<T> type, String id) {
        Objects.requireNonNull(type);
        Objects.requireNonNull(id);
        this.type = type;
        this.id = id;
        this.hash = id.hashCode() * 31 + type.hashCode();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof BaseKey)) {
            return false;
        }
        BaseKey key = (BaseKey)object;
        return Objects.equals(this.id, key.id) && Objects.equals(this.type, key.type);
    }

    public int hashCode() {
        return this.hash;
    }
}

