/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.reactive.common;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import org.hibernate.Incubating;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.internal.util.collections.ArrayHelper;

@Incubating
public class AffectedEntities {
    private static final String[] NO_TABLES = new String[0];
    private final String[] queryTables = NO_TABLES;
    private final Class<?>[] queryEntities;

    public AffectedEntities(Class<?> ... queryEntities) {
        this.queryEntities = queryEntities;
    }

    public String[] getAffectedTables() {
        return this.queryTables;
    }

    public Class<?>[] getAffectedEntities() {
        return this.queryEntities;
    }

    public String[] getAffectedSpaces(SessionFactoryImplementor factory) {
        ArrayList<String> spaces = new ArrayList<String>();
        Collections.addAll(spaces, this.getAffectedTables());
        for (Class<?> entity : this.getAffectedEntities()) {
            Serializable[] querySpaces = factory.getMappingMetamodel().getEntityDescriptor(entity.getName()).getQuerySpaces();
            spaces.addAll(Arrays.asList((String[])querySpaces));
        }
        return spaces.toArray(ArrayHelper.EMPTY_STRING_ARRAY);
    }
}

