/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.reactive.adaptor.impl;

import io.vertx.core.buffer.Buffer;
import io.vertx.sqlclient.PropertyKind;
import io.vertx.sqlclient.Row;
import io.vertx.sqlclient.RowSet;
import io.vertx.sqlclient.Tuple;
import io.vertx.sqlclient.desc.ColumnDescriptor;
import io.vertx.sqlclient.impl.RowBase;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.JDBCType;
import java.sql.NClob;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.function.Function;
import org.hibernate.engine.jdbc.BlobProxy;
import org.hibernate.engine.jdbc.ClobProxy;
import org.hibernate.reactive.adaptor.impl.ArrayAdaptor;
import org.hibernate.reactive.adaptor.impl.PreparedStatementAdaptor;
import org.hibernate.type.descriptor.jdbc.JdbcType;

public class ResultSetAdaptor
implements ResultSet {
    private final Iterator<? extends Row> iterator;
    private final List<ColumnDescriptor> columnDescriptors;
    private final List<String> columnNames;
    private Row row;
    private boolean wasNull;

    public ResultSetAdaptor(Object id, Class<?> idClass, String columnName) {
        Objects.requireNonNull(id);
        this.iterator = List.of(new RowAdaptor(id, idClass, columnName)).iterator();
        this.columnNames = columnName == null ? Collections.emptyList() : List.of(columnName);
        this.columnDescriptors = List.of(ResultSetAdaptor.toColumnDescriptor(idClass, columnName));
    }

    public ResultSetAdaptor(RowSet<Row> rows) {
        Objects.requireNonNull(rows);
        this.iterator = rows.iterator();
        this.columnNames = rows.columnsNames() == null ? Collections.emptyList() : rows.columnsNames();
        this.columnDescriptors = rows.columnDescriptors();
    }

    public ResultSetAdaptor(RowSet<Row> rows, PropertyKind<Row> propertyKind, String idColumnName, Class<?> idClass) {
        this(rows, (Row)rows.property(propertyKind), idColumnName, idClass);
    }

    public ResultSetAdaptor(RowSet<Row> rows, Collection<?> ids, String idColumnName, Class<?> idClass) {
        this(rows, (Row)new RowFromId(ids, idColumnName), idColumnName, idClass);
    }

    private ResultSetAdaptor(RowSet<Row> rows, Row row, String idColumnName, Class<?> idClass) {
        Objects.requireNonNull(rows);
        Objects.requireNonNull(idColumnName);
        this.iterator = List.of(row).iterator();
        this.columnNames = List.of(idColumnName);
        this.columnDescriptors = List.of(ResultSetAdaptor.toColumnDescriptor(idClass, idColumnName));
    }

    private static ColumnDescriptor toColumnDescriptor(final Class<?> idClass, final String idColumnName) {
        return new ColumnDescriptor(){

            public String name() {
                return idColumnName;
            }

            public boolean isArray() {
                return idClass.isArray();
            }

            public String typeName() {
                return idClass.getName();
            }

            public JDBCType jdbcType() {
                return null;
            }
        };
    }

    @Override
    public boolean next() {
        if (this.iterator.hasNext()) {
            this.row = this.iterator.next();
            return true;
        }
        return false;
    }

    @Override
    public void close() {
    }

    @Override
    public boolean wasNull() {
        return this.wasNull;
    }

    @Override
    public String getString(int columnIndex) {
        String string = this.row.getString(columnIndex - 1);
        this.wasNull = string == null;
        return this.wasNull ? null : string;
    }

    @Override
    public boolean getBoolean(int columnIndex) {
        try {
            Boolean bool = this.row.getBoolean(columnIndex - 1);
            this.wasNull = bool == null;
            return !this.wasNull && bool != false;
        }
        catch (ClassCastException cce) {
            try {
                return this.getInt(columnIndex) != 0;
            }
            catch (Exception e) {
                throw cce;
            }
        }
    }

    @Override
    public byte getByte(int columnIndex) {
        Integer integer = this.row.getInteger(columnIndex - 1);
        this.wasNull = integer == null;
        return this.wasNull ? (byte)0 : integer.byteValue();
    }

    @Override
    public short getShort(int columnIndex) {
        Short aShort = this.row.getShort(columnIndex - 1);
        this.wasNull = aShort == null;
        return this.wasNull ? (short)0 : aShort;
    }

    @Override
    public int getInt(int columnIndex) {
        Integer integer = this.row.getInteger(columnIndex - 1);
        this.wasNull = integer == null;
        return this.wasNull ? 0 : integer;
    }

    @Override
    public long getLong(int columnIndex) {
        Long aLong = this.row.getLong(columnIndex - 1);
        this.wasNull = aLong == null;
        return this.wasNull ? 0L : aLong;
    }

    @Override
    public float getFloat(int columnIndex) {
        Float real = this.row.getFloat(columnIndex - 1);
        this.wasNull = real == null;
        return this.wasNull ? 0.0f : real.floatValue();
    }

    @Override
    public double getDouble(int columnIndex) {
        Double real = this.row.getDouble(columnIndex - 1);
        this.wasNull = real == null;
        return this.wasNull ? 0.0 : real;
    }

    @Override
    public BigDecimal getBigDecimal(int columnIndex, int scale) {
        throw new UnsupportedOperationException();
    }

    @Override
    public byte[] getBytes(int columnIndex) {
        Buffer buffer = this.row.getBuffer(columnIndex - 1);
        this.wasNull = buffer == null;
        return this.wasNull ? null : buffer.getBytes();
    }

    @Override
    public Date getDate(int columnIndex) {
        LocalDate localDate = this.row.getLocalDate(columnIndex - 1);
        this.wasNull = localDate == null;
        return this.wasNull ? null : Date.valueOf(localDate);
    }

    @Override
    public Time getTime(int columnIndex) {
        LocalTime localTime = this.row.getLocalTime(columnIndex - 1);
        this.wasNull = localTime == null;
        return this.wasNull ? null : Time.valueOf(localTime);
    }

    @Override
    public Time getTime(int columnIndex, Calendar cal) {
        LocalTime localTime = this.row.getLocalTime(columnIndex - 1);
        this.wasNull = localTime == null;
        return this.wasNull ? null : Time.valueOf(localTime);
    }

    @Override
    public InputStream getAsciiStream(int columnIndex) {
        throw new UnsupportedOperationException("This type hasn't been implemented yet");
    }

    @Override
    public InputStream getUnicodeStream(int columnIndex) {
        throw new UnsupportedOperationException("This type hasn't been implemented yet");
    }

    @Override
    public InputStream getBinaryStream(int columnIndex) {
        throw new UnsupportedOperationException("This type hasn't been implemented yet");
    }

    @Override
    public String getString(String columnLabel) {
        String result = this.caseInsensitiveGet(columnLabel, arg_0 -> ((Row)this.row).getString(arg_0));
        this.wasNull = result == null;
        return result;
    }

    private <T> T caseInsensitiveGet(String columnLabel, Function<String, T> produce) {
        for (String columnName : this.getColumnsNames()) {
            if (!columnName.equalsIgnoreCase(columnLabel)) continue;
            return produce.apply(columnName);
        }
        throw new NoSuchElementException("Column " + columnLabel + " does not exist");
    }

    private List<String> getColumnsNames() {
        return this.columnNames;
    }

    @Override
    public boolean getBoolean(String columnLabel) {
        try {
            Boolean bool = this.row.getBoolean(columnLabel);
            this.wasNull = bool == null;
            return !this.wasNull && bool != false;
        }
        catch (ClassCastException cce) {
            try {
                return this.getInt(columnLabel) != 0;
            }
            catch (Exception e) {
                throw cce;
            }
        }
    }

    @Override
    public byte getByte(String columnLabel) {
        Integer integer = this.row.getInteger(columnLabel);
        this.wasNull = integer == null;
        return this.wasNull ? (byte)0 : integer.byteValue();
    }

    @Override
    public short getShort(String columnLabel) {
        Short aShort = this.row.getShort(columnLabel);
        this.wasNull = aShort == null;
        return this.wasNull ? (short)0 : aShort;
    }

    @Override
    public int getInt(String columnLabel) {
        Integer integer = this.row.getInteger(columnLabel);
        this.wasNull = integer == null;
        return this.wasNull ? 0 : integer;
    }

    @Override
    public long getLong(String columnLabel) {
        Long aLong = this.caseInsensitiveGet(columnLabel, arg_0 -> ((Row)this.row).getLong(arg_0));
        this.wasNull = aLong == null;
        return this.wasNull ? 0L : aLong;
    }

    @Override
    public float getFloat(String columnLabel) {
        Float real = this.row.getFloat(columnLabel);
        this.wasNull = real == null;
        return this.wasNull ? 0.0f : real.floatValue();
    }

    @Override
    public double getDouble(String columnLabel) {
        Double real = this.row.getDouble(columnLabel);
        this.wasNull = real == null;
        return this.wasNull ? 0.0 : real;
    }

    @Override
    public BigDecimal getBigDecimal(String columnLabel, int scale) {
        throw new UnsupportedOperationException();
    }

    @Override
    public byte[] getBytes(String columnLabel) {
        Buffer buffer = this.row.getBuffer(columnLabel);
        this.wasNull = buffer == null;
        return this.wasNull ? null : buffer.getBytes();
    }

    @Override
    public Date getDate(String columnLabel) {
        LocalDate localDate = this.row.getLocalDate(columnLabel);
        this.wasNull = localDate == null;
        return this.wasNull ? null : Date.valueOf(localDate);
    }

    @Override
    public Time getTime(String columnLabel) {
        LocalTime localTime = this.row.getLocalTime(columnLabel);
        this.wasNull = localTime == null;
        return this.wasNull ? null : Time.valueOf(localTime);
    }

    @Override
    public Time getTime(String columnLabel, Calendar cal) {
        LocalTime localTime = this.row.getLocalTime(columnLabel);
        this.wasNull = localTime == null;
        return this.wasNull ? null : Time.valueOf(localTime);
    }

    @Override
    public Timestamp getTimestamp(String columnLabel) {
        LocalDateTime rawValue = this.row.getLocalDateTime(columnLabel);
        this.wasNull = rawValue == null;
        return this.wasNull ? null : Timestamp.valueOf(rawValue);
    }

    @Override
    public Timestamp getTimestamp(String columnLabel, Calendar cal) {
        LocalDateTime localDateTime = this.row.getLocalDateTime(columnLabel);
        this.wasNull = localDateTime == null;
        return this.wasNull ? null : ResultSetAdaptor.toTimestamp(localDateTime, cal);
    }

    private static Timestamp toTimestamp(LocalDateTime localDateTime, Calendar cal) {
        return Timestamp.from(localDateTime.atZone(cal.getTimeZone().toZoneId()).toInstant());
    }

    @Override
    public int getHoldability() {
        return 2;
    }

    @Override
    public boolean isClosed() {
        return false;
    }

    @Override
    public <T> T getObject(int columnIndex, Class<T> type) {
        Object object = this.row.get(type, columnIndex - 1);
        this.wasNull = object == null;
        return (T)(this.wasNull ? null : object);
    }

    @Override
    public <T> T getObject(String columnLabel, Class<T> type) {
        Object object = this.row.get(type, this.row.getColumnIndex(columnLabel));
        this.wasNull = object == null;
        return (T)(this.wasNull ? null : object);
    }

    @Override
    public <T> T unwrap(Class<T> iface) {
        return null;
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) {
        return false;
    }

    @Override
    public SQLWarning getWarnings() {
        return null;
    }

    @Override
    public void clearWarnings() {
    }

    @Override
    public String getCursorName() {
        return null;
    }

    @Override
    public Object getObject(int columnIndex) {
        Object object = this.row.getValue(columnIndex - 1);
        this.wasNull = object == null;
        return this.wasNull ? null : object;
    }

    @Override
    public Object getObject(String columnLabel) {
        Object object = this.row.getValue(columnLabel);
        this.wasNull = object == null;
        return this.wasNull ? null : object;
    }

    @Override
    public int findColumn(String columnLabel) {
        int index = 1;
        for (String column : this.getColumnsNames()) {
            if (column.equalsIgnoreCase(columnLabel)) {
                return index;
            }
            ++index;
        }
        return -1;
    }

    @Override
    public BigDecimal getBigDecimal(int columnIndex) {
        BigDecimal decimal = this.row.getBigDecimal(columnIndex - 1);
        this.wasNull = decimal == null;
        return this.wasNull ? null : decimal;
    }

    @Override
    public BigDecimal getBigDecimal(String columnLabel) {
        BigDecimal decimal = this.row.getBigDecimal(columnLabel);
        this.wasNull = decimal == null;
        return this.wasNull ? null : decimal;
    }

    @Override
    public void setFetchDirection(int direction) {
    }

    @Override
    public int getFetchDirection() {
        return 1000;
    }

    @Override
    public void setFetchSize(int rows) {
    }

    @Override
    public int getFetchSize() {
        return 0;
    }

    @Override
    public int getType() {
        return 1003;
    }

    @Override
    public int getConcurrency() {
        return 1007;
    }

    @Override
    public boolean rowUpdated() {
        return false;
    }

    @Override
    public boolean rowInserted() {
        return false;
    }

    @Override
    public boolean rowDeleted() {
        return false;
    }

    @Override
    public boolean isBeforeFirst() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isAfterLast() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isFirst() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isLast() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void beforeFirst() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void afterLast() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean first() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean last() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean absolute(int row) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean relative(int rows) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean previous() {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getRow() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void insertRow() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateRow() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void deleteRow() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void refreshRow() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void cancelRowUpdates() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void moveToInsertRow() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void moveToCurrentRow() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Statement getStatement() {
        return new PreparedStatementAdaptor();
    }

    @Override
    public InputStream getAsciiStream(String columnLabel) {
        throw new UnsupportedOperationException();
    }

    @Override
    public InputStream getUnicodeStream(String columnLabel) {
        throw new UnsupportedOperationException();
    }

    @Override
    public InputStream getBinaryStream(String columnLabel) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Reader getCharacterStream(int columnIndex) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Reader getCharacterStream(String columnLabel) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Object getObject(int columnIndex, Map<String, Class<?>> map) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Ref getRef(int columnIndex) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Blob getBlob(int columnIndex) {
        Blob blob = this.blob(row -> row.getValue(columnIndex - 1), row -> row.getBuffer(columnIndex - 1));
        this.wasNull = blob == null;
        return blob;
    }

    @Override
    public Clob getClob(int columnIndex) {
        Clob clob = this.clob(row -> row.getString(columnIndex - 1));
        boolean bl = this.wasNull = clob == null;
        if (this.wasNull) {
            return null;
        }
        return clob;
    }

    private Clob clob(Function<Row, String> getString) {
        String value = getString.apply(this.row);
        if (value == null) {
            return null;
        }
        return ClobProxy.generateProxy((String)value);
    }

    @Override
    public Array getArray(int columnIndex) {
        throw new UnsupportedOperationException();
    }

    public Array getArray(int columnIndex, JdbcType elementJdbcType) {
        Object[] objects = (Object[])this.row.getValue(columnIndex - 1);
        boolean bl = this.wasNull = objects == null;
        if (objects == null) {
            return null;
        }
        return new ArrayAdaptor(elementJdbcType, objects);
    }

    @Override
    public Object getObject(String columnLabel, Map<String, Class<?>> map) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Ref getRef(String columnLabel) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Blob getBlob(String columnLabel) {
        Blob blob = this.blob(row -> row.getValue(columnLabel), row -> row.getBuffer(columnLabel));
        this.wasNull = blob == null;
        return blob;
    }

    private Blob blob(Function<Row, Object> getValue, Function<Row, Buffer> getBuffer) {
        Object value = getValue.apply(this.row);
        if (value == null) {
            return null;
        }
        if (value instanceof String) {
            return BlobProxy.generateProxy((byte[])((String)value).getBytes());
        }
        if (value instanceof byte[]) {
            return BlobProxy.generateProxy((byte[])((byte[])value));
        }
        return BlobProxy.generateProxy((byte[])getBuffer.apply(this.row).getBytes());
    }

    @Override
    public Clob getClob(String columnLabel) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Array getArray(String columnLabel) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Date getDate(int columnIndex, Calendar cal) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Date getDate(String columnLabel, Calendar cal) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Timestamp getTimestamp(int columnIndex) {
        LocalDateTime localDateTime = this.row.getLocalDateTime(columnIndex - 1);
        this.wasNull = localDateTime == null;
        return this.wasNull ? null : Timestamp.valueOf(localDateTime);
    }

    @Override
    public Timestamp getTimestamp(int columnIndex, Calendar cal) {
        LocalDateTime localDateTime = this.row.getLocalDateTime(columnIndex - 1);
        this.wasNull = localDateTime == null;
        return this.wasNull ? null : ResultSetAdaptor.toTimestamp(localDateTime, cal);
    }

    @Override
    public URL getURL(int columnIndex) {
        throw new UnsupportedOperationException();
    }

    @Override
    public URL getURL(String columnLabel) {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getNString(int columnIndex) {
        return this.getString(columnIndex);
    }

    @Override
    public String getNString(String columnLabel) {
        return this.getString(columnLabel);
    }

    @Override
    public Reader getNCharacterStream(int columnIndex) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Reader getNCharacterStream(String columnLabel) {
        throw new UnsupportedOperationException();
    }

    @Override
    public NClob getNClob(int columnIndex) {
        throw new UnsupportedOperationException();
    }

    @Override
    public NClob getNClob(String columnLabel) {
        throw new UnsupportedOperationException();
    }

    @Override
    public SQLXML getSQLXML(int columnIndex) {
        throw new UnsupportedOperationException();
    }

    @Override
    public SQLXML getSQLXML(String columnLabel) {
        throw new UnsupportedOperationException();
    }

    @Override
    public RowId getRowId(int columnIndex) {
        Buffer buffer = this.row.getBuffer(columnIndex - 1);
        this.wasNull = buffer == null;
        return this.wasNull ? null : new RowIdAdaptor(buffer);
    }

    @Override
    public RowId getRowId(String columnLabel) {
        Buffer buffer = this.row.getBuffer(columnLabel);
        this.wasNull = buffer == null;
        return this.wasNull ? null : new RowIdAdaptor(buffer);
    }

    @Override
    public void updateNull(int columnIndex) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateBoolean(int columnIndex, boolean x) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateByte(int columnIndex, byte x) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateShort(int columnIndex, short x) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateInt(int columnIndex, int x) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateLong(int columnIndex, long x) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateFloat(int columnIndex, float x) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateDouble(int columnIndex, double x) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateBigDecimal(int columnIndex, BigDecimal x) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateString(int columnIndex, String x) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateBytes(int columnIndex, byte[] x) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateDate(int columnIndex, Date x) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateTime(int columnIndex, Time x) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateTimestamp(int columnIndex, Timestamp x) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateAsciiStream(int columnIndex, InputStream x, int length) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateBinaryStream(int columnIndex, InputStream x, int length) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateCharacterStream(int columnIndex, Reader x, int length) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateObject(int columnIndex, Object x, int scaleOrLength) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateObject(int columnIndex, Object x) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateNull(String columnLabel) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateBoolean(String columnLabel, boolean x) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateByte(String columnLabel, byte x) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateShort(String columnLabel, short x) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateInt(String columnLabel, int x) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateLong(String columnLabel, long x) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateFloat(String columnLabel, float x) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateDouble(String columnLabel, double x) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateBigDecimal(String columnLabel, BigDecimal x) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateString(String columnLabel, String x) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateBytes(String columnLabel, byte[] x) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateDate(String columnLabel, Date x) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateTime(String columnLabel, Time x) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateTimestamp(String columnLabel, Timestamp x) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateAsciiStream(String columnLabel, InputStream x, int length) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateBinaryStream(String columnLabel, InputStream x, int length) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateCharacterStream(String columnLabel, Reader reader, int length) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateObject(String columnLabel, Object x, int scaleOrLength) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateObject(String columnLabel, Object x) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateRef(int columnIndex, Ref x) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateRef(String columnLabel, Ref x) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateBlob(int columnIndex, Blob x) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateBlob(String columnLabel, Blob x) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateClob(int columnIndex, Clob x) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateClob(String columnLabel, Clob x) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateArray(int columnIndex, Array x) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateArray(String columnLabel, Array x) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateRowId(int columnIndex, RowId x) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateRowId(String columnLabel, RowId x) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateNString(int columnIndex, String nString) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateNString(String columnLabel, String nString) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateNClob(int columnIndex, NClob nClob) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateNClob(String columnLabel, NClob nClob) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateSQLXML(int columnIndex, SQLXML xmlObject) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateSQLXML(String columnLabel, SQLXML xmlObject) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateNCharacterStream(int columnIndex, Reader x, long length) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateNCharacterStream(String columnLabel, Reader reader, long length) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateAsciiStream(int columnIndex, InputStream x, long length) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateBinaryStream(int columnIndex, InputStream x, long length) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateCharacterStream(int columnIndex, Reader x, long length) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateAsciiStream(String columnLabel, InputStream x, long length) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateBinaryStream(String columnLabel, InputStream x, long length) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateCharacterStream(String columnLabel, Reader reader, long length) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateBlob(int columnIndex, InputStream inputStream, long length) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateBlob(String columnLabel, InputStream inputStream, long length) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateClob(int columnIndex, Reader reader, long length) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateClob(String columnLabel, Reader reader, long length) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateNClob(int columnIndex, Reader reader, long length) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateNClob(String columnLabel, Reader reader, long length) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateNCharacterStream(int columnIndex, Reader x) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateNCharacterStream(String columnLabel, Reader reader) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateAsciiStream(int columnIndex, InputStream x) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateBinaryStream(int columnIndex, InputStream x) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateCharacterStream(int columnIndex, Reader x) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateAsciiStream(String columnLabel, InputStream x) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateBinaryStream(String columnLabel, InputStream x) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateCharacterStream(String columnLabel, Reader reader) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateBlob(int columnIndex, InputStream inputStream) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateBlob(String columnLabel, InputStream inputStream) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateClob(int columnIndex, Reader reader) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateClob(String columnLabel, Reader reader) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateNClob(int columnIndex, Reader reader) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateNClob(String columnLabel, Reader reader) {
        throw new UnsupportedOperationException();
    }

    @Override
    public ResultSetMetaData getMetaData() {
        return new MetaData(this.columnNames, this.columnDescriptors);
    }

    private static class MetaData
    implements ResultSetMetaData {
        private final List<String> columns;
        private final List<ColumnDescriptor> descriptors;

        public MetaData(List<String> columnNames, List<ColumnDescriptor> columnDescriptors) {
            this.columns = columnNames;
            this.descriptors = columnDescriptors;
        }

        @Override
        public int getColumnCount() {
            return this.columns.size();
        }

        @Override
        public int getColumnType(int column) {
            ColumnDescriptor descriptor = this.descriptors.get(column - 1);
            return descriptor.isArray() ? 2003 : descriptor.jdbcType().getVendorTypeNumber();
        }

        @Override
        public String getColumnLabel(int column) {
            return this.columns.get(column - 1);
        }

        @Override
        public String getColumnName(int column) {
            return this.columns.get(column - 1);
        }

        @Override
        public boolean isAutoIncrement(int column) {
            return false;
        }

        @Override
        public boolean isCaseSensitive(int column) {
            return false;
        }

        @Override
        public boolean isSearchable(int column) {
            return false;
        }

        @Override
        public boolean isCurrency(int column) {
            return false;
        }

        @Override
        public int isNullable(int column) {
            return 2;
        }

        @Override
        public boolean isSigned(int column) {
            return false;
        }

        @Override
        public int getColumnDisplaySize(int column) {
            return 0;
        }

        @Override
        public String getSchemaName(int column) {
            return null;
        }

        @Override
        public int getPrecision(int column) {
            return 0;
        }

        @Override
        public int getScale(int column) {
            return 0;
        }

        @Override
        public String getTableName(int column) {
            return null;
        }

        @Override
        public String getCatalogName(int column) {
            return null;
        }

        @Override
        public String getColumnTypeName(int column) {
            return null;
        }

        @Override
        public boolean isReadOnly(int column) {
            return false;
        }

        @Override
        public boolean isWritable(int column) {
            return false;
        }

        @Override
        public boolean isDefinitelyWritable(int column) {
            return false;
        }

        @Override
        public String getColumnClassName(int column) {
            return null;
        }

        @Override
        public <T> T unwrap(Class<T> iface) {
            return null;
        }

        @Override
        public boolean isWrapperFor(Class<?> iface) {
            return false;
        }
    }

    private static class RowIdAdaptor
    implements RowId {
        private final Buffer buffer;

        private RowIdAdaptor(Buffer buffer) {
            Objects.requireNonNull(buffer);
            this.buffer = buffer;
        }

        @Override
        public byte[] getBytes() {
            return this.buffer.getBytes();
        }
    }

    private static class RowFromId
    extends RowBase {
        private final List<String> columns;

        public RowFromId(Collection<?> ids, String columnName) {
            super(ids);
            this.columns = List.of(Objects.requireNonNull(columnName));
        }

        public String getColumnName(int pos) {
            return pos > 0 ? null : this.columns.get(pos);
        }

        public int getColumnIndex(String column) {
            return this.columns.indexOf(column);
        }
    }

    private static class RowAdaptor
    implements Row {
        private final Object id;
        private final Class<?> idClass;
        private final String columnName;

        public RowAdaptor(Object id, Class<?> idClass, String columnName) {
            this.id = id;
            this.idClass = idClass;
            this.columnName = columnName;
        }

        public Object getValue(String column) {
            return this.id;
        }

        public String getColumnName(int pos) {
            return this.columnName;
        }

        public int getColumnIndex(String column) {
            return 0;
        }

        public Object getValue(int pos) {
            return this.id;
        }

        public Tuple addValue(Object value) {
            return null;
        }

        public int size() {
            return 1;
        }

        public void clear() {
        }

        public List<Class<?>> types() {
            return List.of(this.idClass);
        }
    }
}

