/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.reactive.util.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.Function;
import java.util.function.IntFunction;
import java.util.function.IntPredicate;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.hibernate.reactive.logging.impl.Log;
import org.hibernate.reactive.logging.impl.LogCategory;
import org.hibernate.reactive.logging.impl.LoggerFactory;
import org.hibernate.reactive.util.async.impl.AsyncIterator;
import org.hibernate.reactive.util.async.impl.AsyncTrampoline;
import org.hibernate.reactive.util.impl.IntBiFunction;
import org.hibernate.reactive.util.impl.IntBiPredicate;

public class CompletionStages {
    private static final Log LOG = LoggerFactory.make(Log.class, new LogCategory("org.hibernate.reactive.errors"));
    private static final CompletionStage<Void> VOID = CompletionStages.completedFuture(null);
    private static final CompletionStage<Integer> ZERO = CompletionStages.completedFuture(0);
    private static final CompletionStage<Boolean> TRUE = CompletionStages.completedFuture(true);
    private static final CompletionStage<Boolean> FALSE = CompletionStages.completedFuture(false);

    private static <T> boolean alwaysTrue(T o, int index) {
        return true;
    }

    private static boolean alwaysTrue(int index) {
        return true;
    }

    private static boolean alwaysTrue(Object o) {
        return true;
    }

    private static CompletionStage<Boolean> alwaysContinue(Object ignored) {
        return TRUE;
    }

    public static CompletionStage<Void> voidFuture(Object ignore) {
        return CompletionStages.voidFuture();
    }

    public static CompletionStage<Void> voidFuture() {
        return VOID;
    }

    public static CompletionStage<Integer> zeroFuture() {
        return ZERO;
    }

    public static CompletionStage<Integer> zeroFuture(Object ignore) {
        return CompletionStages.zeroFuture();
    }

    public static CompletionStage<Boolean> trueFuture() {
        return TRUE;
    }

    public static CompletionStage<Boolean> falseFuture() {
        return FALSE;
    }

    public static <T> CompletionStage<T> nullFuture() {
        return VOID;
    }

    public static <T> CompletionStage<T> completedFuture(T value) {
        return CompletableFuture.completedFuture(value);
    }

    public static <T> CompletionStage<T> failedFuture(Throwable t) {
        CompletableFuture ret = new CompletableFuture();
        ret.completeExceptionally(t);
        return ret;
    }

    public static <T extends Throwable, Ret> Ret rethrow(Throwable x) throws T {
        throw x;
    }

    public static <T extends Throwable, Ret> Ret returnNullorRethrow(Throwable x) throws T {
        if (x != null) {
            throw x;
        }
        return null;
    }

    public static <T extends Throwable, Ret> Ret returnOrRethrow(Throwable x, Ret result) throws T {
        if (x != null) {
            throw x;
        }
        return result;
    }

    public static <U> U ignoreErrors(Void unused, Throwable throwable) {
        return null;
    }

    public static void logSqlException(Throwable t, Supplier<String> message, String sql) {
        if (t != null) {
            LOG.failedToExecuteStatement(sql, message.get(), t);
        }
    }

    public static CompletionStage<Integer> total(int start, int end, IntFunction<CompletionStage<Integer>> consumer) {
        return AsyncIterator.range(start, end).thenCompose(i -> (CompletionStage)consumer.apply(i.intValue())).fold(0, Integer::sum);
    }

    public static <T> CompletionStage<Integer> total(Iterator<T> iterator, Function<T, CompletionStage<Integer>> consumer) {
        return AsyncIterator.fromIterator(iterator).thenCompose(consumer).fold(0, Integer::sum);
    }

    public static <T> CompletionStage<Integer> total(T[] array, Function<T, CompletionStage<Integer>> consumer) {
        return CompletionStages.total(0, array.length, index -> (CompletionStage)consumer.apply(array[index]));
    }

    public static <T> CompletionStage<Void> loop(T[] array, Function<T, CompletionStage<?>> consumer) {
        return CompletionStages.loop(0, array.length, (int index) -> (CompletionStage)consumer.apply(array[index]));
    }

    public static <T> CompletionStage<Void> loop(T[] array, IntPredicate filter, IntFunction<CompletionStage<?>> consumer) {
        return CompletionStages.loop(0, array.length, filter, consumer);
    }

    public static <T> CompletionStage<Void> loop(Iterator<T> iterator, IntBiFunction<T, CompletionStage<?>> consumer) {
        return CompletionStages.loop(iterator, CompletionStages::alwaysTrue, consumer);
    }

    public static <T> CompletionStage<Void> loop(Iterator<T> iterator, IntBiPredicate<T> filter, IntBiFunction<T, CompletionStage<?>> consumer) {
        if (iterator.hasNext()) {
            IndexedIteratorLoop<T> loop = new IndexedIteratorLoop<T>(iterator, filter, consumer);
            return AsyncTrampoline.asyncWhile(loop::next);
        }
        return CompletionStages.voidFuture();
    }

    public static <T> CompletionStage<Void> loop(Collection<T> collection, Function<T, CompletionStage<?>> consumer) {
        return CompletionStages.loop(collection, CompletionStages::alwaysTrue, consumer);
    }

    @Deprecated
    public static <T> CompletionStage<Void> loop(Collection<T> collection, Predicate<T> filter, Function<T, CompletionStage<?>> consumer) {
        if (collection instanceof List) {
            return CompletionStages.loop((List)collection, filter, consumer);
        }
        ArrayList<T> list = new ArrayList<T>(collection);
        return CompletionStages.loop(list, filter, consumer);
    }

    public static <T> CompletionStage<Void> loop(List<T> list, Function<T, CompletionStage<?>> consumer) {
        return CompletionStages.loop(list, CompletionStages::alwaysTrue, consumer);
    }

    public static <T> CompletionStage<Void> loop(List<T> list, Predicate<T> filter, Function<T, CompletionStage<?>> consumer) {
        return CompletionStages.loop(0, list.size(), index -> filter.test(list.get(index)), index -> (CompletionStage)consumer.apply(list.get(index)));
    }

    public static <T> CompletionStage<Void> loop(Queue<T> queue, Function<T, CompletionStage<?>> consumer) {
        return CompletionStages.loop(queue.iterator(), CompletionStages::alwaysTrue, (T value, int integer) -> (CompletionStage)consumer.apply(value));
    }

    public static CompletionStage<Void> loop(int start, int end, IntFunction<CompletionStage<?>> consumer) {
        return CompletionStages.loop(start, end, CompletionStages::alwaysTrue, consumer);
    }

    public static CompletionStage<Void> loop(int start, int end, IntPredicate filter, IntFunction<CompletionStage<?>> consumer) {
        if (start < end) {
            ArrayLoop loop = new ArrayLoop(start, end, filter, consumer);
            return AsyncTrampoline.asyncWhile(loop::next);
        }
        return CompletionStages.voidFuture();
    }

    public static CompletionStage<Void> applyToAll(Function<Object, CompletionStage<?>> op, Object[] entity) {
        switch (entity.length) {
            case 0: {
                return CompletionStages.nullFuture();
            }
            case 1: {
                return op.apply(entity[0]).thenCompose(CompletionStages::voidFuture);
            }
        }
        return CompletionStages.loop(entity, op);
    }

    private static class ArrayLoop {
        private final IntPredicate filter;
        private final IntFunction<CompletionStage<?>> consumer;
        private final int end;
        private int current;

        public ArrayLoop(int start, int end, IntPredicate filter, IntFunction<CompletionStage<?>> consumer) {
            this.end = end;
            this.filter = filter;
            this.consumer = consumer;
            this.current = start;
        }

        public CompletionStage<Boolean> next() {
            this.current = this.next(this.current);
            if (this.current < this.end) {
                int index = this.current++;
                return this.consumer.apply(index).thenCompose(x$0 -> CompletionStages.alwaysContinue(x$0));
            }
            return FALSE;
        }

        private int next(int start) {
            int index;
            for (index = start; index < this.end && !this.filter.test(index); ++index) {
            }
            return index;
        }
    }

    private static class IndexedIteratorLoop<T> {
        private final IntBiPredicate<T> filter;
        private final IntBiFunction<T, CompletionStage<?>> consumer;
        private final Iterator<T> iterator;
        private int currentIndex = -1;
        private T currentEntry;

        public IndexedIteratorLoop(Iterator<T> iterator, IntBiPredicate<T> filter, IntBiFunction<T, CompletionStage<?>> consumer) {
            this.iterator = iterator;
            this.filter = filter;
            this.consumer = consumer;
        }

        public CompletionStage<Boolean> next() {
            if (this.hasNext()) {
                T entry = this.currentEntry;
                int index = this.currentIndex;
                return this.consumer.apply(entry, index).thenCompose(x$0 -> CompletionStages.alwaysContinue(x$0));
            }
            return FALSE;
        }

        private boolean hasNext() {
            int index = this.currentIndex;
            T next = this.currentEntry;
            boolean hasNext = false;
            while (this.iterator.hasNext()) {
                next = this.iterator.next();
                if (!this.filter.test(next, ++index)) continue;
                hasNext = true;
                break;
            }
            this.currentEntry = next;
            this.currentIndex = index;
            return hasNext;
        }
    }
}

