/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.reactive.stage.impl;

import jakarta.persistence.EntityGraph;
import jakarta.persistence.criteria.CriteriaDelete;
import jakarta.persistence.criteria.CriteriaQuery;
import jakarta.persistence.criteria.CriteriaUpdate;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.Function;
import org.hibernate.LockMode;
import org.hibernate.graph.spi.RootGraphImplementor;
import org.hibernate.reactive.common.ResultSetMapping;
import org.hibernate.reactive.pool.ReactiveConnection;
import org.hibernate.reactive.session.Criteria;
import org.hibernate.reactive.session.ReactiveStatelessSession;
import org.hibernate.reactive.stage.Stage;
import org.hibernate.reactive.stage.impl.StageQueryImpl;
import org.hibernate.reactive.util.impl.CompletionStages;

public class StageStatelessSessionImpl
implements Stage.StatelessSession {
    private final ReactiveStatelessSession delegate;
    private Transaction<?> currentTransaction;

    public StageStatelessSessionImpl(ReactiveStatelessSession delegate) {
        this.delegate = delegate;
    }

    public ReactiveConnection getReactiveConnection() {
        return this.delegate.getReactiveConnection();
    }

    @Override
    public <T> CompletionStage<T> get(Class<T> entityClass, Object id) {
        return this.delegate.reactiveGet(entityClass, id);
    }

    @Override
    public <T> CompletionStage<T> get(Class<T> entityClass, Object id, LockMode lockMode) {
        return this.delegate.reactiveGet(entityClass, id, lockMode, null);
    }

    @Override
    public <T> CompletionStage<T> get(EntityGraph<T> entityGraph, Object id) {
        Class entityClass = ((RootGraphImplementor)entityGraph).getGraphedType().getJavaType();
        return this.delegate.reactiveGet(entityClass, id, null, entityGraph);
    }

    @Override
    public <R> Stage.Query<R> createQuery(String queryString) {
        return new StageQueryImpl(this.delegate.createReactiveQuery(queryString));
    }

    @Override
    public <R> Stage.Query<R> createQuery(String queryString, Class<R> resultType) {
        return new StageQueryImpl<R>(this.delegate.createReactiveQuery(queryString, resultType));
    }

    @Override
    public <R> Stage.Query<R> createNativeQuery(String queryString) {
        return new StageQueryImpl(this.delegate.createReactiveNativeQuery(queryString));
    }

    @Override
    public <R> Stage.Query<R> createNativeQuery(String queryString, Class<R> resultType) {
        return new StageQueryImpl<R>(this.delegate.createReactiveNativeQuery(queryString, resultType));
    }

    @Override
    public <R> Stage.Query<R> createNativeQuery(String queryString, ResultSetMapping<R> sqlResultSetMapping) {
        return new StageQueryImpl(this.delegate.createReactiveNativeQuery(queryString, sqlResultSetMapping.getName()));
    }

    @Override
    public <R> Stage.Query<R> createNamedQuery(String name) {
        return new StageQueryImpl(this.delegate.createReactiveNamedQuery(name));
    }

    @Override
    public <R> Stage.Query<R> createNamedQuery(String name, Class<R> resultType) {
        return new StageQueryImpl<R>(this.delegate.createReactiveNamedQuery(name, resultType));
    }

    @Override
    public <R> Stage.Query<R> createQuery(CriteriaQuery<R> criteriaQuery) {
        return new StageQueryImpl(this.delegate.createReactiveQuery((Criteria)criteriaQuery));
    }

    @Override
    public <R> Stage.Query<R> createQuery(CriteriaUpdate<R> criteriaUpdate) {
        return new StageQueryImpl(this.delegate.createReactiveQuery((Criteria)criteriaUpdate));
    }

    @Override
    public <R> Stage.Query<R> createQuery(CriteriaDelete<R> criteriaDelete) {
        return new StageQueryImpl(this.delegate.createReactiveQuery((Criteria)criteriaDelete));
    }

    @Override
    public CompletionStage<Void> insert(Object entity) {
        return this.delegate.reactiveInsert(entity);
    }

    @Override
    public CompletionStage<Void> insert(Object ... entities) {
        return this.delegate.reactiveInsertAll(entities);
    }

    @Override
    public CompletionStage<Void> insert(int batchSize, Object ... entities) {
        return this.delegate.reactiveInsertAll(batchSize, entities);
    }

    @Override
    public CompletionStage<Void> delete(Object entity) {
        return this.delegate.reactiveDelete(entity);
    }

    @Override
    public CompletionStage<Void> delete(Object ... entities) {
        return this.delegate.reactiveDeleteAll(entities);
    }

    @Override
    public CompletionStage<Void> delete(int batchSize, Object ... entities) {
        return this.delegate.reactiveDeleteAll(batchSize, entities);
    }

    @Override
    public CompletionStage<Void> update(Object entity) {
        return this.delegate.reactiveUpdate(entity);
    }

    @Override
    public CompletionStage<Void> update(Object ... entities) {
        return this.delegate.reactiveUpdateAll(entities);
    }

    @Override
    public CompletionStage<Void> update(int batchSize, Object ... entities) {
        return this.delegate.reactiveUpdateAll(batchSize, entities);
    }

    @Override
    public CompletionStage<Void> refresh(Object entity) {
        return this.delegate.reactiveRefresh(entity);
    }

    @Override
    public CompletionStage<Void> refresh(Object ... entities) {
        return this.delegate.reactiveRefreshAll(entities);
    }

    @Override
    public CompletionStage<Void> refresh(int batchSize, Object ... entities) {
        return this.delegate.reactiveRefreshAll(batchSize, entities);
    }

    @Override
    public CompletionStage<Void> refresh(Object entity, LockMode lockMode) {
        return this.delegate.reactiveRefresh(entity, lockMode);
    }

    @Override
    public <T> CompletionStage<T> fetch(T association) {
        return this.delegate.reactiveFetch(association, false);
    }

    @Override
    public <T> ResultSetMapping<T> getResultSetMapping(Class<T> resultType, String mappingName) {
        return this.delegate.getResultSetMapping(resultType, mappingName);
    }

    @Override
    public <T> EntityGraph<T> getEntityGraph(Class<T> entity, String name) {
        return this.delegate.getEntityGraph(entity, name);
    }

    @Override
    public <T> EntityGraph<T> createEntityGraph(Class<T> entity) {
        return this.delegate.createEntityGraph(entity);
    }

    @Override
    public <T> EntityGraph<T> createEntityGraph(Class<T> entity, String name) {
        return this.delegate.createEntityGraph(entity, name);
    }

    @Override
    public <T> CompletionStage<T> withTransaction(Function<Stage.Transaction, CompletionStage<T>> work) {
        return this.currentTransaction == null ? new Transaction().execute(work) : work.apply(this.currentTransaction);
    }

    @Override
    public CompletionStage<Void> close() {
        CompletableFuture<Void> closing = new CompletableFuture<Void>();
        this.delegate.close(closing);
        return closing;
    }

    @Override
    public boolean isOpen() {
        return this.delegate.isOpen();
    }

    @Override
    public Stage.Transaction currentTransaction() {
        return this.currentTransaction;
    }

    private class Transaction<T>
    implements Stage.Transaction {
        boolean rollback;
        Throwable error;

        private Transaction() {
        }

        CompletionStage<T> execute(Function<Stage.Transaction, CompletionStage<T>> work) {
            StageStatelessSessionImpl.this.currentTransaction = this;
            return this.begin().thenCompose(v -> this.executeInTransaction(work)).whenComplete((t, x) -> {
                StageStatelessSessionImpl.this.currentTransaction = null;
            });
        }

        CompletionStage<T> executeInTransaction(Function<Stage.Transaction, CompletionStage<T>> work) {
            return work.apply(this).handle(this::processError).thenCompose(result -> this.end().handle(this::processError).thenApply(v -> CompletionStages.returnOrRethrow(this.error, result)));
        }

        CompletionStage<Void> begin() {
            return StageStatelessSessionImpl.this.delegate.getReactiveConnection().beginTransaction();
        }

        CompletionStage<Void> end() {
            ReactiveConnection c = StageStatelessSessionImpl.this.delegate.getReactiveConnection();
            return this.rollback ? c.rollbackTransaction() : c.commitTransaction();
        }

        <R> R processError(R result, Throwable e) {
            if (e != null) {
                this.rollback = true;
                if (this.error == null) {
                    this.error = e;
                } else {
                    this.error.addSuppressed(e);
                }
            }
            return result;
        }

        @Override
        public void markForRollback() {
            this.rollback = true;
        }

        @Override
        public boolean isMarkedForRollback() {
            return this.rollback;
        }
    }
}

