/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.reactive.stage.impl;

import jakarta.persistence.EntityGraph;
import jakarta.persistence.criteria.CriteriaDelete;
import jakarta.persistence.criteria.CriteriaQuery;
import jakarta.persistence.criteria.CriteriaUpdate;
import jakarta.persistence.metamodel.Attribute;
import java.lang.invoke.MethodHandles;
import java.util.List;
import java.util.concurrent.CompletionStage;
import java.util.function.Function;
import org.hibernate.CacheMode;
import org.hibernate.Filter;
import org.hibernate.FlushMode;
import org.hibernate.LockMode;
import org.hibernate.LockOptions;
import org.hibernate.graph.spi.RootGraphImplementor;
import org.hibernate.reactive.common.AffectedEntities;
import org.hibernate.reactive.common.Identifier;
import org.hibernate.reactive.common.ResultSetMapping;
import org.hibernate.reactive.engine.ReactiveActionQueue;
import org.hibernate.reactive.logging.impl.Log;
import org.hibernate.reactive.logging.impl.LoggerFactory;
import org.hibernate.reactive.pool.ReactiveConnection;
import org.hibernate.reactive.session.Criteria;
import org.hibernate.reactive.session.ReactiveSession;
import org.hibernate.reactive.stage.Stage;
import org.hibernate.reactive.stage.impl.StageQueryImpl;
import org.hibernate.reactive.util.impl.CompletionStages;

public class StageSessionImpl
implements Stage.Session {
    private static final Log LOG = LoggerFactory.make(Log.class, MethodHandles.lookup());
    private final ReactiveSession delegate;
    private Transaction<?> currentTransaction;

    public StageSessionImpl(ReactiveSession session) {
        this.delegate = session;
    }

    @Override
    public CompletionStage<Void> flush() {
        return this.delegate.reactiveFlush();
    }

    @Override
    public <T> CompletionStage<T> fetch(T association) {
        return this.delegate.reactiveFetch(association, false);
    }

    @Override
    public <E, T> CompletionStage<T> fetch(E entity, Attribute<E, T> field) {
        return this.delegate.reactiveFetch(entity, field);
    }

    @Override
    public <T> CompletionStage<T> unproxy(T association) {
        return this.delegate.reactiveFetch(association, true);
    }

    public ReactiveConnection getReactiveConnection() {
        return this.delegate.getReactiveConnection();
    }

    @Override
    public <T> T getReference(Class<T> entityClass, Object id) {
        return this.delegate.getReference(entityClass, id);
    }

    @Override
    public <T> T getReference(T entity) {
        return this.delegate.getReference(this.delegate.getEntityClass(entity), this.delegate.getEntityId(entity));
    }

    @Override
    public LockMode getLockMode(Object entity) {
        return this.delegate.getCurrentLockMode(entity);
    }

    @Override
    public boolean contains(Object entity) {
        return this.delegate.contains(entity);
    }

    @Override
    public <T> CompletionStage<T> find(Class<T> entityClass, Object primaryKey) {
        return this.delegate.reactiveFind(entityClass, primaryKey, null, null);
    }

    @Override
    public <T> CompletionStage<List<T>> find(Class<T> entityClass, Object ... ids) {
        return this.delegate.reactiveFind(entityClass, ids);
    }

    @Override
    public <T> CompletionStage<T> find(Class<T> entityClass, Identifier<T> id) {
        return this.delegate.reactiveFind(entityClass, id.namedValues());
    }

    @Override
    public <T> CompletionStage<T> find(Class<T> entityClass, Object primaryKey, LockMode lockMode) {
        return this.delegate.reactiveFind(entityClass, primaryKey, new LockOptions(lockMode), null);
    }

    public <T> CompletionStage<T> find(Class<T> entityClass, Object primaryKey, LockOptions lockOptions) {
        return this.delegate.reactiveFind(entityClass, primaryKey, lockOptions, null);
    }

    @Override
    public <T> CompletionStage<T> find(EntityGraph<T> entityGraph, Object id) {
        Class entityClass = ((RootGraphImplementor)entityGraph).getGraphedType().getJavaType();
        return this.delegate.reactiveFind(entityClass, id, null, entityGraph);
    }

    @Override
    public CompletionStage<Void> persist(Object entity) {
        return this.delegate.reactivePersist(entity);
    }

    @Override
    public CompletionStage<Void> persist(Object ... entity) {
        return CompletionStages.applyToAll(this.delegate::reactivePersist, entity);
    }

    @Override
    public CompletionStage<Void> remove(Object entity) {
        return this.delegate.reactiveRemove(entity);
    }

    @Override
    public CompletionStage<Void> remove(Object ... entity) {
        return CompletionStages.applyToAll(this.delegate::reactiveRemove, entity);
    }

    @Override
    public <T> CompletionStage<T> merge(T entity) {
        return this.delegate.reactiveMerge(entity);
    }

    @Override
    @SafeVarargs
    public final <T> CompletionStage<Void> merge(T ... entity) {
        return CompletionStages.applyToAll(this.delegate::reactiveMerge, entity);
    }

    @Override
    public CompletionStage<Void> refresh(Object entity) {
        return this.delegate.reactiveRefresh(entity, LockOptions.NONE);
    }

    @Override
    public CompletionStage<Void> refresh(Object entity, LockMode lockMode) {
        return this.delegate.reactiveRefresh(entity, new LockOptions(lockMode));
    }

    public CompletionStage<Void> refresh(Object entity, LockOptions lockOptions) {
        return this.delegate.reactiveRefresh(entity, lockOptions);
    }

    @Override
    public CompletionStage<Void> refresh(Object ... entity) {
        return CompletionStages.applyToAll(e -> this.delegate.reactiveRefresh(e, LockOptions.NONE), entity);
    }

    @Override
    public CompletionStage<Void> lock(Object entity, LockMode lockMode) {
        return this.delegate.reactiveLock(entity, new LockOptions(lockMode));
    }

    public CompletionStage<Void> lock(Object entity, LockOptions lockOptions) {
        return this.delegate.reactiveLock(entity, lockOptions);
    }

    @Override
    public <R> Stage.Query<R> createQuery(String jpql) {
        return new StageQueryImpl(this.delegate.createReactiveQuery(jpql));
    }

    @Override
    public <R> Stage.Query<R> createQuery(String jpql, Class<R> resultType) {
        return new StageQueryImpl<R>(this.delegate.createReactiveQuery(jpql, resultType));
    }

    @Override
    public <R> Stage.Query<R> createNativeQuery(String sql) {
        return new StageQueryImpl(this.delegate.createReactiveNativeQuery(sql));
    }

    @Override
    public <R> Stage.Query<R> createNativeQuery(String sql, Class<R> resultType) {
        return new StageQueryImpl<R>(this.delegate.createReactiveNativeQuery(sql, resultType));
    }

    @Override
    public <R> Stage.Query<R> createNativeQuery(String sql, ResultSetMapping<R> resultSetMapping) {
        return new StageQueryImpl(this.delegate.createReactiveNativeQuery(sql, resultSetMapping.getName()));
    }

    @Override
    public <R> Stage.Query<R> createNativeQuery(String sql, Class<R> resultType, AffectedEntities affectedEntities) {
        return new StageQueryImpl<R>(this.delegate.createReactiveNativeQuery(sql, resultType), affectedEntities.getAffectedSpaces(this.delegate.getFactory()));
    }

    @Override
    public <R> Stage.Query<R> createNativeQuery(String sql, ResultSetMapping<R> resultSetMapping, AffectedEntities affectedEntities) {
        return new StageQueryImpl(this.delegate.createReactiveNativeQuery(sql, resultSetMapping.getName()), affectedEntities.getAffectedSpaces(this.delegate.getFactory()));
    }

    @Override
    public <R> Stage.Query<R> createNativeQuery(String sql, AffectedEntities affectedEntities) {
        return new StageQueryImpl(this.delegate.createReactiveNativeQuery(sql), affectedEntities.getAffectedSpaces(this.delegate.getFactory()));
    }

    @Override
    public <R> Stage.Query<R> createNamedQuery(String name) {
        return new StageQueryImpl(this.delegate.createReactiveNamedQuery(name));
    }

    @Override
    public <R> Stage.Query<R> createNamedQuery(String name, Class<R> resultType) {
        return new StageQueryImpl<R>(this.delegate.createReactiveNamedQuery(name, resultType));
    }

    @Override
    public <R> Stage.Query<R> createQuery(CriteriaQuery<R> criteriaQuery) {
        return new StageQueryImpl(this.delegate.createReactiveQuery((Criteria)criteriaQuery));
    }

    @Override
    public <R> Stage.Query<R> createQuery(CriteriaUpdate<R> criteriaUpdate) {
        return new StageQueryImpl(this.delegate.createReactiveQuery((Criteria)criteriaUpdate));
    }

    @Override
    public <R> Stage.Query<R> createQuery(CriteriaDelete<R> criteriaDelete) {
        return new StageQueryImpl(this.delegate.createReactiveQuery((Criteria)criteriaDelete));
    }

    @Override
    public FlushMode getFlushMode() {
        switch (this.delegate.getHibernateFlushMode()) {
            case MANUAL: {
                return FlushMode.MANUAL;
            }
            case COMMIT: {
                return FlushMode.COMMIT;
            }
            case AUTO: {
                return FlushMode.AUTO;
            }
            case ALWAYS: {
                return FlushMode.ALWAYS;
            }
        }
        throw LOG.impossibleFlushModeIllegalState();
    }

    @Override
    public Stage.Session setFlushMode(FlushMode flushMode) {
        switch (flushMode) {
            case COMMIT: {
                this.delegate.setHibernateFlushMode(FlushMode.COMMIT);
                break;
            }
            case AUTO: {
                this.delegate.setHibernateFlushMode(FlushMode.AUTO);
                break;
            }
            case MANUAL: {
                this.delegate.setHibernateFlushMode(FlushMode.MANUAL);
                break;
            }
            case ALWAYS: {
                this.delegate.setHibernateFlushMode(FlushMode.ALWAYS);
            }
        }
        return this;
    }

    @Override
    public Stage.Session setDefaultReadOnly(boolean readOnly) {
        this.delegate.setDefaultReadOnly(readOnly);
        return this;
    }

    @Override
    public boolean isDefaultReadOnly() {
        return this.delegate.isDefaultReadOnly();
    }

    @Override
    public Stage.Session setReadOnly(Object entityOrProxy, boolean readOnly) {
        this.delegate.setReadOnly(entityOrProxy, readOnly);
        return this;
    }

    @Override
    public boolean isReadOnly(Object entityOrProxy) {
        return this.delegate.isReadOnly(entityOrProxy);
    }

    @Override
    public CacheMode getCacheMode() {
        return this.delegate.getCacheMode();
    }

    @Override
    public Stage.Session setCacheMode(CacheMode cacheMode) {
        this.delegate.setCacheMode(cacheMode);
        return this;
    }

    @Override
    public Stage.Session setBatchSize(Integer batchSize) {
        this.delegate.setBatchSize(batchSize);
        return this;
    }

    @Override
    public Integer getBatchSize() {
        return this.delegate.getBatchSize();
    }

    @Override
    public Stage.Session detach(Object entity) {
        this.delegate.detach(entity);
        return this;
    }

    @Override
    public Stage.Session clear() {
        this.delegate.clear();
        return this;
    }

    @Override
    public Stage.Session enableFetchProfile(String name) {
        this.delegate.enableFetchProfile(name);
        return this;
    }

    @Override
    public Stage.Session disableFetchProfile(String name) {
        this.delegate.disableFetchProfile(name);
        return this;
    }

    @Override
    public boolean isFetchProfileEnabled(String name) {
        return this.delegate.isFetchProfileEnabled(name);
    }

    @Override
    public <T> ResultSetMapping<T> getResultSetMapping(Class<T> resultType, String mappingName) {
        return this.delegate.getResultSetMapping(resultType, mappingName);
    }

    @Override
    public <T> EntityGraph<T> getEntityGraph(Class<T> entity, String name) {
        return this.delegate.getEntityGraph(entity, name);
    }

    @Override
    public <T> EntityGraph<T> createEntityGraph(Class<T> entity) {
        return this.delegate.createEntityGraph(entity);
    }

    @Override
    public <T> EntityGraph<T> createEntityGraph(Class<T> entity, String name) {
        return this.delegate.createEntityGraph(entity, name);
    }

    @Override
    public Filter enableFilter(String filterName) {
        return this.delegate.enableFilter(filterName);
    }

    @Override
    public void disableFilter(String filterName) {
        this.delegate.disableFilter(filterName);
    }

    @Override
    public Filter getEnabledFilter(String filterName) {
        return this.delegate.getEnabledFilter(filterName);
    }

    @Override
    public <T> CompletionStage<T> withTransaction(Function<Stage.Transaction, CompletionStage<T>> work) {
        return this.currentTransaction == null ? new Transaction().execute(work) : work.apply(this.currentTransaction);
    }

    @Override
    public Stage.Transaction currentTransaction() {
        return this.currentTransaction;
    }

    @Override
    public CompletionStage<Void> close() {
        return this.delegate.reactiveClose();
    }

    @Override
    public boolean isOpen() {
        return this.delegate.isOpen();
    }

    private class Transaction<T>
    implements Stage.Transaction {
        boolean rollback;
        Throwable error;

        private Transaction() {
        }

        CompletionStage<T> execute(Function<Stage.Transaction, CompletionStage<T>> work) {
            StageSessionImpl.this.currentTransaction = this;
            return this.begin().thenCompose(v -> this.executeInTransaction(work)).whenComplete((t, x) -> {
                StageSessionImpl.this.currentTransaction = null;
            });
        }

        CompletionStage<T> executeInTransaction(Function<Stage.Transaction, CompletionStage<T>> work) {
            return work.apply(this).thenCompose(result -> this.flush().thenApply(v -> result)).handle(this::processError).thenCompose(result -> this.end().handle(this::processError).thenApply(v -> CompletionStages.returnOrRethrow(this.error, result)));
        }

        CompletionStage<Void> flush() {
            return StageSessionImpl.this.delegate.reactiveAutoflush();
        }

        CompletionStage<Void> begin() {
            return StageSessionImpl.this.delegate.getReactiveConnection().beginTransaction();
        }

        CompletionStage<Void> end() {
            ReactiveActionQueue actionQueue = StageSessionImpl.this.delegate.getReactiveActionQueue();
            return actionQueue.beforeTransactionCompletion().thenApply(v -> StageSessionImpl.this.delegate.getReactiveConnection()).thenCompose(c -> this.rollback ? c.rollbackTransaction() : c.commitTransaction()).thenCompose(v -> actionQueue.afterTransactionCompletion(!this.rollback));
        }

        <R> R processError(R result, Throwable e) {
            if (e != null) {
                this.rollback = true;
                if (this.error == null) {
                    this.error = e;
                } else {
                    this.error.addSuppressed(e);
                }
            }
            return result;
        }

        @Override
        public void markForRollback() {
            this.rollback = true;
        }

        @Override
        public boolean isMarkedForRollback() {
            return this.rollback;
        }
    }
}

