/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.reactive.stage.impl;

import jakarta.persistence.EntityGraph;
import jakarta.persistence.Parameter;
import java.util.List;
import java.util.concurrent.CompletionStage;
import org.hibernate.CacheMode;
import org.hibernate.FlushMode;
import org.hibernate.LockMode;
import org.hibernate.LockOptions;
import org.hibernate.reactive.session.ReactiveQuery;
import org.hibernate.reactive.stage.Stage;

public class StageQueryImpl<R>
implements Stage.Query<R> {
    private final ReactiveQuery<R> delegate;

    public StageQueryImpl(ReactiveQuery<R> delegate) {
        this.delegate = delegate;
    }

    public StageQueryImpl(ReactiveQuery<R> delegate, String[] querySpaces) {
        this(delegate);
        delegate.setQuerySpaces(querySpaces);
    }

    @Override
    public Stage.Query<R> setParameter(int position, Object value) {
        this.delegate.setParameter(position, value);
        return this;
    }

    @Override
    public Stage.Query<R> setParameter(String name, Object value) {
        this.delegate.setParameter(name, value);
        return this;
    }

    @Override
    public <T> Stage.Query<R> setParameter(Parameter<T> parameter, T value) {
        this.delegate.setParameter(parameter, value);
        return this;
    }

    @Override
    public Stage.Query<R> setMaxResults(int maxResults) {
        this.delegate.setMaxResults(maxResults);
        return this;
    }

    @Override
    public int getMaxResults() {
        return this.delegate.getMaxResults();
    }

    @Override
    public Stage.Query<R> setFirstResult(int firstResult) {
        this.delegate.setFirstResult(firstResult);
        return this;
    }

    @Override
    public int getFirstResult() {
        return this.delegate.getFirstResult();
    }

    @Override
    public Stage.Query<R> setReadOnly(boolean readOnly) {
        this.delegate.setReadOnly(readOnly);
        return this;
    }

    @Override
    public boolean isReadOnly() {
        return this.delegate.isReadOnly();
    }

    @Override
    public Stage.Query<R> setComment(String comment) {
        this.delegate.setComment(comment);
        return this;
    }

    @Override
    public Stage.Query<R> setCacheable(boolean cacheable) {
        this.delegate.setCacheable(cacheable);
        return this;
    }

    @Override
    public boolean isCacheable() {
        return this.delegate.isCacheable();
    }

    @Override
    public Stage.Query<R> setCacheRegion(String cacheRegion) {
        this.delegate.setCacheRegion(cacheRegion);
        return this;
    }

    @Override
    public String getCacheRegion() {
        return this.delegate.getCacheRegion();
    }

    @Override
    public Stage.Query<R> setLockMode(LockMode lockMode) {
        this.delegate.setLockMode(lockMode);
        return this;
    }

    public Stage.Query<R> setLockOptions(LockOptions lockOptions) {
        this.delegate.setLockOptions(lockOptions);
        return this;
    }

    @Override
    public Stage.Query<R> setLockMode(String alias, LockMode lockMode) {
        this.delegate.setLockMode(alias, lockMode);
        return this;
    }

    @Override
    public Stage.Query<R> setCacheMode(CacheMode cacheMode) {
        this.delegate.setCacheMode(cacheMode);
        return this;
    }

    @Override
    public CacheMode getCacheMode() {
        return this.delegate.getCacheMode();
    }

    @Override
    public Stage.Query<R> setFlushMode(FlushMode flushMode) {
        this.delegate.setHibernateFlushMode(flushMode);
        return this;
    }

    @Override
    public FlushMode getFlushMode() {
        return this.delegate.getHibernateFlushMode();
    }

    @Override
    public Stage.Query<R> setPlan(EntityGraph<R> entityGraph) {
        this.delegate.setPlan(entityGraph);
        return this;
    }

    @Override
    public CompletionStage<Integer> executeUpdate() {
        return this.delegate.executeReactiveUpdate();
    }

    @Override
    public CompletionStage<R> getSingleResult() {
        return this.delegate.getReactiveSingleResult();
    }

    @Override
    public CompletionStage<R> getSingleResultOrNull() {
        return this.delegate.getReactiveSingleResultOrNull();
    }

    @Override
    public CompletionStage<List<R>> getResultList() {
        return this.delegate.getReactiveResultList();
    }
}

