/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.reactive.stage;

import jakarta.persistence.EntityGraph;
import jakarta.persistence.Parameter;
import jakarta.persistence.criteria.CriteriaBuilder;
import jakarta.persistence.criteria.CriteriaDelete;
import jakarta.persistence.criteria.CriteriaQuery;
import jakarta.persistence.criteria.CriteriaUpdate;
import jakarta.persistence.metamodel.Attribute;
import jakarta.persistence.metamodel.Metamodel;
import java.lang.invoke.MethodHandles;
import java.util.List;
import java.util.concurrent.CompletionStage;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.hibernate.Cache;
import org.hibernate.CacheMode;
import org.hibernate.Filter;
import org.hibernate.FlushMode;
import org.hibernate.Incubating;
import org.hibernate.LockMode;
import org.hibernate.collection.internal.AbstractPersistentCollection;
import org.hibernate.collection.spi.PersistentCollection;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.proxy.HibernateProxy;
import org.hibernate.reactive.common.AffectedEntities;
import org.hibernate.reactive.common.Identifier;
import org.hibernate.reactive.common.ResultSetMapping;
import org.hibernate.reactive.logging.impl.Log;
import org.hibernate.reactive.logging.impl.LoggerFactory;
import org.hibernate.reactive.session.ReactiveSession;
import org.hibernate.reactive.util.impl.CompletionStages;
import org.hibernate.stat.Statistics;

public interface Stage {
    public static final Log LOG = LoggerFactory.make(Log.class, MethodHandles.lookup());

    public static <T> CompletionStage<T> fetch(T association) {
        SharedSessionContractImplementor session;
        if (association == null) {
            return CompletionStages.nullFuture();
        }
        if (association instanceof HibernateProxy) {
            session = ((HibernateProxy)association).getHibernateLazyInitializer().getSession();
        } else if (association instanceof PersistentCollection) {
            session = ((AbstractPersistentCollection)association).getSession();
        } else {
            return CompletionStages.completedFuture(association);
        }
        if (session == null) {
            throw LOG.sessionClosedLazyInitializationException();
        }
        return ((ReactiveSession)session).reactiveFetch(association, false);
    }

    public static interface Closeable {
        public CompletionStage<Void> close();
    }

    public static interface SessionFactory
    extends AutoCloseable {
        public CompletionStage<Session> openSession();

        public CompletionStage<Session> openSession(String var1);

        public CompletionStage<StatelessSession> openStatelessSession();

        public CompletionStage<StatelessSession> openStatelessSession(String var1);

        public <T> CompletionStage<T> withSession(Function<Session, CompletionStage<T>> var1);

        public <T> CompletionStage<T> withSession(String var1, Function<Session, CompletionStage<T>> var2);

        public <T> CompletionStage<T> withTransaction(BiFunction<Session, Transaction, CompletionStage<T>> var1);

        default public <T> CompletionStage<T> withTransaction(Function<Session, CompletionStage<T>> work) {
            return this.withTransaction((Session session, Transaction transaction) -> (CompletionStage)work.apply((Session)session));
        }

        public <T> CompletionStage<T> withTransaction(String var1, BiFunction<Session, Transaction, CompletionStage<T>> var2);

        default public <T> CompletionStage<T> withStatelessTransaction(Function<StatelessSession, CompletionStage<T>> work) {
            return this.withStatelessTransaction((StatelessSession statelessSession, Transaction transaction) -> (CompletionStage)work.apply((StatelessSession)statelessSession));
        }

        public <T> CompletionStage<T> withStatelessTransaction(BiFunction<StatelessSession, Transaction, CompletionStage<T>> var1);

        public <T> CompletionStage<T> withStatelessTransaction(String var1, BiFunction<StatelessSession, Transaction, CompletionStage<T>> var2);

        public <T> CompletionStage<T> withStatelessSession(Function<StatelessSession, CompletionStage<T>> var1);

        public <T> CompletionStage<T> withStatelessSession(String var1, Function<StatelessSession, CompletionStage<T>> var2);

        public CriteriaBuilder getCriteriaBuilder();

        public Metamodel getMetamodel();

        public Cache getCache();

        public Statistics getStatistics();

        @Override
        public void close();

        public boolean isOpen();
    }

    public static interface Transaction {
        public void markForRollback();

        public boolean isMarkedForRollback();
    }

    public static interface StatelessSession
    extends Closeable {
        public <T> CompletionStage<T> get(Class<T> var1, Object var2);

        public <T> CompletionStage<T> get(Class<T> var1, Object var2, LockMode var3);

        public <T> CompletionStage<T> get(EntityGraph<T> var1, Object var2);

        public <R> Query<R> createQuery(String var1);

        public <R> Query<R> createQuery(String var1, Class<R> var2);

        public <R> Query<R> createNativeQuery(String var1);

        public <R> Query<R> createNamedQuery(String var1);

        public <R> Query<R> createNamedQuery(String var1, Class<R> var2);

        public <R> Query<R> createNativeQuery(String var1, Class<R> var2);

        public <R> Query<R> createNativeQuery(String var1, ResultSetMapping<R> var2);

        public <R> Query<R> createQuery(CriteriaQuery<R> var1);

        public <R> Query<R> createQuery(CriteriaUpdate<R> var1);

        public <R> Query<R> createQuery(CriteriaDelete<R> var1);

        public CompletionStage<Void> insert(Object var1);

        public CompletionStage<Void> insert(Object ... var1);

        public CompletionStage<Void> insert(int var1, Object ... var2);

        public CompletionStage<Void> delete(Object var1);

        public CompletionStage<Void> delete(Object ... var1);

        public CompletionStage<Void> delete(int var1, Object ... var2);

        public CompletionStage<Void> update(Object var1);

        public CompletionStage<Void> update(Object ... var1);

        public CompletionStage<Void> update(int var1, Object ... var2);

        public CompletionStage<Void> refresh(Object var1);

        public CompletionStage<Void> refresh(Object ... var1);

        public CompletionStage<Void> refresh(int var1, Object ... var2);

        public CompletionStage<Void> refresh(Object var1, LockMode var2);

        public <T> CompletionStage<T> fetch(T var1);

        public <T> ResultSetMapping<T> getResultSetMapping(Class<T> var1, String var2);

        public <T> EntityGraph<T> getEntityGraph(Class<T> var1, String var2);

        public <T> EntityGraph<T> createEntityGraph(Class<T> var1);

        public <T> EntityGraph<T> createEntityGraph(Class<T> var1, String var2);

        public <T> CompletionStage<T> withTransaction(Function<Transaction, CompletionStage<T>> var1);

        public Transaction currentTransaction();

        public boolean isOpen();

        @Override
        public CompletionStage<Void> close();
    }

    public static interface Session
    extends Closeable {
        public <T> CompletionStage<T> find(Class<T> var1, Object var2);

        public <T> CompletionStage<T> find(Class<T> var1, Object var2, LockMode var3);

        public <T> CompletionStage<T> find(EntityGraph<T> var1, Object var2);

        public <T> CompletionStage<List<T>> find(Class<T> var1, Object ... var2);

        @Incubating
        public <T> CompletionStage<T> find(Class<T> var1, Identifier<T> var2);

        public <T> T getReference(Class<T> var1, Object var2);

        public <T> T getReference(T var1);

        public CompletionStage<Void> persist(Object var1);

        public CompletionStage<Void> persist(Object ... var1);

        public CompletionStage<Void> remove(Object var1);

        public CompletionStage<Void> remove(Object ... var1);

        public <T> CompletionStage<T> merge(T var1);

        public <T> CompletionStage<Void> merge(T ... var1);

        public CompletionStage<Void> refresh(Object var1);

        public CompletionStage<Void> refresh(Object var1, LockMode var2);

        public CompletionStage<Void> refresh(Object ... var1);

        public CompletionStage<Void> lock(Object var1, LockMode var2);

        public CompletionStage<Void> flush();

        public <T> CompletionStage<T> fetch(T var1);

        public <E, T> CompletionStage<T> fetch(E var1, Attribute<E, T> var2);

        public <T> CompletionStage<T> unproxy(T var1);

        public LockMode getLockMode(Object var1);

        public boolean contains(Object var1);

        public <R> Query<R> createQuery(String var1);

        public <R> Query<R> createQuery(String var1, Class<R> var2);

        public <R> Query<R> createNamedQuery(String var1);

        public <R> Query<R> createNamedQuery(String var1, Class<R> var2);

        public <R> Query<R> createNativeQuery(String var1, Class<R> var2);

        public <R> Query<R> createNativeQuery(String var1, Class<R> var2, AffectedEntities var3);

        public <R> Query<R> createNativeQuery(String var1, ResultSetMapping<R> var2);

        public <R> Query<R> createNativeQuery(String var1, ResultSetMapping<R> var2, AffectedEntities var3);

        public <R> Query<R> createNativeQuery(String var1);

        public <R> Query<R> createNativeQuery(String var1, AffectedEntities var2);

        public <R> Query<R> createQuery(CriteriaQuery<R> var1);

        public <R> Query<R> createQuery(CriteriaUpdate<R> var1);

        public <R> Query<R> createQuery(CriteriaDelete<R> var1);

        public Session setFlushMode(FlushMode var1);

        public FlushMode getFlushMode();

        public Session detach(Object var1);

        public Session clear();

        public Session enableFetchProfile(String var1);

        public <T> ResultSetMapping<T> getResultSetMapping(Class<T> var1, String var2);

        public <T> EntityGraph<T> getEntityGraph(Class<T> var1, String var2);

        public <T> EntityGraph<T> createEntityGraph(Class<T> var1);

        public <T> EntityGraph<T> createEntityGraph(Class<T> var1, String var2);

        public Session disableFetchProfile(String var1);

        public boolean isFetchProfileEnabled(String var1);

        public Session setDefaultReadOnly(boolean var1);

        public boolean isDefaultReadOnly();

        public Session setReadOnly(Object var1, boolean var2);

        public boolean isReadOnly(Object var1);

        public Session setCacheMode(CacheMode var1);

        public CacheMode getCacheMode();

        public Session setBatchSize(Integer var1);

        public Integer getBatchSize();

        public Filter enableFilter(String var1);

        public void disableFilter(String var1);

        public Filter getEnabledFilter(String var1);

        public <T> CompletionStage<T> withTransaction(Function<Transaction, CompletionStage<T>> var1);

        public Transaction currentTransaction();

        public boolean isOpen();
    }

    public static interface Query<R> {
        public Query<R> setParameter(int var1, Object var2);

        public Query<R> setParameter(String var1, Object var2);

        public <T> Query<R> setParameter(Parameter<T> var1, T var2);

        public Query<R> setMaxResults(int var1);

        public Query<R> setFirstResult(int var1);

        public int getMaxResults();

        public int getFirstResult();

        public CompletionStage<R> getSingleResult();

        public CompletionStage<R> getSingleResultOrNull();

        public CompletionStage<List<R>> getResultList();

        public CompletionStage<Integer> executeUpdate();

        public Query<R> setReadOnly(boolean var1);

        public boolean isReadOnly();

        public Query<R> setComment(String var1);

        public Query<R> setCacheable(boolean var1);

        public boolean isCacheable();

        public Query<R> setCacheRegion(String var1);

        public String getCacheRegion();

        public Query<R> setCacheMode(CacheMode var1);

        public CacheMode getCacheMode();

        public Query<R> setFlushMode(FlushMode var1);

        public FlushMode getFlushMode();

        public Query<R> setLockMode(LockMode var1);

        public Query<R> setLockMode(String var1, LockMode var2);

        public Query<R> setPlan(EntityGraph<R> var1);
    }
}

