/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.reactive.session.impl;

import org.hibernate.engine.ResultSetMappingDefinition;
import org.hibernate.engine.query.spi.sql.NativeSQLQueryCollectionReturn;
import org.hibernate.engine.query.spi.sql.NativeSQLQueryConstructorReturn;
import org.hibernate.engine.query.spi.sql.NativeSQLQueryReturn;
import org.hibernate.engine.query.spi.sql.NativeSQLQueryRootReturn;
import org.hibernate.engine.query.spi.sql.NativeSQLQueryScalarReturn;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.reactive.common.ResultSetMapping;

class ResultSetMappings {
    ResultSetMappings() {
    }

    static <T> ResultSetMapping<T> resultSetMapping(final Class<T> resultType, final String mappingName, SessionFactoryImplementor factory) {
        Class<?> mappedResultType;
        ResultSetMappingDefinition mapping = factory.getNamedQueryRepository().getResultSetMappingDefinition(mappingName);
        if (mapping == null) {
            throw new IllegalArgumentException("result set mapping does not exist: " + mappingName);
        }
        if (resultType != null && !resultType.equals(mappedResultType = ResultSetMappings.getResultType(mapping, factory))) {
            throw new IllegalArgumentException("incorrect result type for result set mapping: " + mappingName + " has type " + mappedResultType.getName());
        }
        return new ResultSetMapping<T>(){

            @Override
            public String getName() {
                return mappingName;
            }

            @Override
            public Class<T> getResultType() {
                return resultType;
            }
        };
    }

    private static Class<?> getResultType(ResultSetMappingDefinition mapping, SessionFactoryImplementor factory) {
        Class mappedResultType = null;
        for (NativeSQLQueryReturn queryReturn : mapping.getQueryReturns()) {
            String entityName;
            if (queryReturn instanceof NativeSQLQueryScalarReturn) {
                if (mappedResultType != null) {
                    return Object[].class;
                }
                mappedResultType = ((NativeSQLQueryScalarReturn)queryReturn).getType().getReturnedClass();
                continue;
            }
            if (queryReturn instanceof NativeSQLQueryRootReturn) {
                if (mappedResultType != null) {
                    return Object[].class;
                }
                NativeSQLQueryRootReturn entityReturn = (NativeSQLQueryRootReturn)queryReturn;
                entityName = entityReturn.getReturnEntityName();
                mappedResultType = factory.getMetamodel().entityPersister(entityName).getMappedClass();
                continue;
            }
            if (queryReturn instanceof NativeSQLQueryCollectionReturn) {
                if (mappedResultType != null) {
                    return Object[].class;
                }
                NativeSQLQueryCollectionReturn collectionReturn = (NativeSQLQueryCollectionReturn)queryReturn;
                entityName = collectionReturn.getOwnerEntityName();
                String propertyName = collectionReturn.getOwnerProperty();
                String role = entityName + "." + propertyName;
                mappedResultType = factory.getMetamodel().collectionPersister(role).getElementClass();
                continue;
            }
            if (!(queryReturn instanceof NativeSQLQueryConstructorReturn)) continue;
            if (mappedResultType != null) {
                return Object[].class;
            }
            mappedResultType = ((NativeSQLQueryConstructorReturn)queryReturn).getTargetClass();
        }
        return mappedResultType;
    }
}

