/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.reactive.session.impl;

import jakarta.persistence.EntityGraph;
import jakarta.persistence.Tuple;
import java.io.Serializable;
import java.lang.invoke.MethodHandles;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import org.hibernate.HibernateException;
import org.hibernate.LockMode;
import org.hibernate.LockOptions;
import org.hibernate.UnresolvableObjectException;
import org.hibernate.action.internal.BulkOperationCleanupAction;
import org.hibernate.bytecode.spi.BytecodeEnhancementMetadata;
import org.hibernate.cache.spi.access.EntityDataAccess;
import org.hibernate.collection.spi.PersistentCollection;
import org.hibernate.dialect.Dialect;
import org.hibernate.engine.internal.Versioning;
import org.hibernate.engine.query.spi.HQLQueryPlan;
import org.hibernate.engine.query.spi.sql.NativeSQLQuerySpecification;
import org.hibernate.engine.spi.EntityKey;
import org.hibernate.engine.spi.NamedQueryDefinition;
import org.hibernate.engine.spi.NamedSQLQueryDefinition;
import org.hibernate.engine.spi.PersistenceContext;
import org.hibernate.engine.spi.QueryParameters;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.graph.GraphSemantic;
import org.hibernate.graph.internal.RootGraphImpl;
import org.hibernate.graph.spi.RootGraphImplementor;
import org.hibernate.internal.SessionCreationOptions;
import org.hibernate.internal.SessionFactoryImpl;
import org.hibernate.internal.StatelessSessionImpl;
import org.hibernate.jpa.spi.CriteriaQueryTupleTransformer;
import org.hibernate.jpa.spi.NativeQueryTupleTransformer;
import org.hibernate.loader.custom.CustomQuery;
import org.hibernate.loader.custom.sql.SQLCustomQuery;
import org.hibernate.metamodel.spi.MetamodelImplementor;
import org.hibernate.persister.collection.CollectionPersister;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.proxy.HibernateProxy;
import org.hibernate.proxy.LazyInitializer;
import org.hibernate.query.ParameterMetadata;
import org.hibernate.query.Query;
import org.hibernate.query.internal.QueryImpl;
import org.hibernate.reactive.common.ResultSetMapping;
import org.hibernate.reactive.engine.impl.ReactivePersistenceContextAdapter;
import org.hibernate.reactive.id.impl.IdentifierGeneration;
import org.hibernate.reactive.loader.custom.impl.ReactiveCustomLoader;
import org.hibernate.reactive.logging.impl.Log;
import org.hibernate.reactive.logging.impl.LoggerFactory;
import org.hibernate.reactive.persister.collection.impl.ReactiveCollectionPersister;
import org.hibernate.reactive.persister.entity.impl.ReactiveEntityPersister;
import org.hibernate.reactive.pool.BatchingConnection;
import org.hibernate.reactive.pool.ReactiveConnection;
import org.hibernate.reactive.session.Criteria;
import org.hibernate.reactive.session.CriteriaQueryOptions;
import org.hibernate.reactive.session.ReactiveNativeQuery;
import org.hibernate.reactive.session.ReactiveQuery;
import org.hibernate.reactive.session.ReactiveStatelessSession;
import org.hibernate.reactive.session.impl.CriteriaQueryRenderingContext;
import org.hibernate.reactive.session.impl.ReactiveHQLQueryPlan;
import org.hibernate.reactive.session.impl.ReactiveNativeQueryImpl;
import org.hibernate.reactive.session.impl.ReactiveNativeSQLQueryPlan;
import org.hibernate.reactive.session.impl.ReactiveQueryImpl;
import org.hibernate.reactive.session.impl.ResultSetMappings;
import org.hibernate.reactive.session.impl.SessionUtil;
import org.hibernate.reactive.util.impl.CompletionStages;
import org.hibernate.transform.ResultTransformer;
import org.hibernate.tuple.entity.EntityMetamodel;
import org.hibernate.type.VersionType;

public class ReactiveStatelessSessionImpl
extends StatelessSessionImpl
implements ReactiveStatelessSession {
    private static final Log LOG = LoggerFactory.make(Log.class, MethodHandles.lookup());
    private ReactiveConnection reactiveConnection;
    private final ReactiveStatelessSession batchingHelperSession;
    private final PersistenceContext persistenceContext;

    public ReactiveStatelessSessionImpl(SessionFactoryImpl factory, SessionCreationOptions options, ReactiveConnection connection) {
        super(factory, options);
        this.reactiveConnection = connection;
        this.persistenceContext = new ReactivePersistenceContextAdapter((SharedSessionContractImplementor)this);
        this.batchingHelperSession = new ReactiveStatelessSessionImpl(factory, options, this.reactiveConnection, this.persistenceContext);
    }

    private ReactiveStatelessSessionImpl(SessionFactoryImpl factory, SessionCreationOptions options, ReactiveConnection connection, PersistenceContext persistenceContext) {
        super(factory, options);
        this.persistenceContext = persistenceContext;
        Integer batchSize = this.getConfiguredJdbcBatchSize();
        this.reactiveConnection = batchSize == null || batchSize < 2 ? connection : new BatchingConnection(connection, batchSize);
        this.reactiveConnection = connection;
        this.batchingHelperSession = this;
    }

    private LockOptions getNullSafeLockOptions(LockMode lockMode) {
        return new LockOptions(lockMode == null ? LockMode.NONE : lockMode);
    }

    public PersistenceContext getPersistenceContext() {
        return this.persistenceContext;
    }

    @Override
    public Dialect getDialect() {
        return this.getJdbcServices().getDialect();
    }

    @Override
    public SharedSessionContractImplementor getSharedContract() {
        return this;
    }

    public PersistenceContext getPersistenceContextInternal() {
        return this.persistenceContext;
    }

    @Override
    public ReactiveConnection getReactiveConnection() {
        return this.reactiveConnection;
    }

    public void checkTransactionNeededForUpdateOperation(String exceptionMessage) {
    }

    @Override
    public <T> CompletionStage<T> reactiveGet(Class<? extends T> entityClass, Object id) {
        return this.reactiveGet(entityClass, id, LockMode.NONE, null);
    }

    @Override
    public <T> CompletionStage<T> reactiveGet(Class<? extends T> entityClass, Object id, LockMode lockMode, EntityGraph<T> fetchGraph) {
        this.checkOpen();
        if (fetchGraph != null) {
            this.getLoadQueryInfluencers().getEffectiveEntityGraph().applyGraph((RootGraphImplementor)fetchGraph, GraphSemantic.FETCH);
        }
        ReactiveEntityPersister persister = (ReactiveEntityPersister)this.getFactory().getMetamodel().entityPersister(entityClass);
        LockOptions lockOptions = this.getNullSafeLockOptions(lockMode);
        return persister.reactiveLoad((Serializable)id, null, lockOptions, (SharedSessionContractImplementor)this).whenComplete((v, e) -> {
            if (this.getPersistenceContext().isLoadFinished()) {
                this.getPersistenceContext().clear();
            }
            this.getLoadQueryInfluencers().getEffectiveEntityGraph().clear();
        }).thenApply(entity -> entity);
    }

    public ReactiveEntityPersister getEntityPersister(String entityName, Object object) throws HibernateException {
        return (ReactiveEntityPersister)super.getEntityPersister(entityName, object);
    }

    @Override
    public CompletionStage<Void> reactiveInsert(Object entity) {
        this.checkOpen();
        ReactiveEntityPersister persister = this.getEntityPersister(null, entity);
        return IdentifierGeneration.generateId(entity, persister, this, (SharedSessionContractImplementor)this).thenCompose(id -> {
            boolean substitute;
            Object[] state = persister.getPropertyValues(entity);
            if (persister.isVersioned() && (substitute = Versioning.seedVersion((Object[])state, (int)persister.getVersionProperty(), (VersionType)persister.getVersionType(), (SharedSessionContractImplementor)this))) {
                persister.setPropertyValues(entity, state);
            }
            if (persister.isIdentifierAssignedByInsert()) {
                return persister.insertReactive(state, entity, (SharedSessionContractImplementor)this).thenAccept(generatedId -> IdentifierGeneration.assignIdIfNecessary(entity, generatedId, persister, (SharedSessionContractImplementor)this));
            }
            id = IdentifierGeneration.assignIdIfNecessary(id, entity, persister, (SharedSessionContractImplementor)this);
            persister.setIdentifier(entity, (Serializable)id, (SharedSessionContractImplementor)this);
            return persister.insertReactive((Serializable)id, state, entity, (SharedSessionContractImplementor)this);
        });
    }

    @Override
    public CompletionStage<Void> reactiveDelete(Object entity) {
        this.checkOpen();
        ReactiveEntityPersister persister = this.getEntityPersister(null, entity);
        Serializable id = persister.getIdentifier(entity, (SharedSessionContractImplementor)this);
        Object version = persister.getVersion(entity);
        return persister.deleteReactive(id, version, entity, (SharedSessionContractImplementor)this);
    }

    @Override
    public CompletionStage<Void> reactiveUpdate(Object entity) {
        this.checkOpen();
        if (entity instanceof HibernateProxy) {
            LazyInitializer hibernateLazyInitializer = ((HibernateProxy)entity).getHibernateLazyInitializer();
            return hibernateLazyInitializer.isUninitialized() ? CompletionStages.failedFuture(LOG.uninitializedProxyUpdate(entity.getClass())) : this.executeReactiveUpdate(hibernateLazyInitializer.getImplementation());
        }
        return this.executeReactiveUpdate(entity);
    }

    private CompletionStage<Void> executeReactiveUpdate(Object entity) {
        Object oldVersion;
        ReactiveEntityPersister persister = this.getEntityPersister(null, entity);
        Serializable id = persister.getIdentifier(entity, (SharedSessionContractImplementor)this);
        Object[] state = persister.getPropertyValues(entity);
        if (persister.isVersioned()) {
            oldVersion = persister.getVersion(entity);
            Object newVersion = Versioning.increment((Object)oldVersion, (VersionType)persister.getVersionType(), (SharedSessionContractImplementor)this);
            Versioning.setVersion((Object[])state, (Object)newVersion, (EntityPersister)persister);
            persister.setPropertyValues(entity, state);
        } else {
            oldVersion = null;
        }
        return persister.updateReactive(id, state, null, false, null, oldVersion, entity, null, (SharedSessionContractImplementor)this);
    }

    @Override
    public CompletionStage<Void> reactiveRefresh(Object entity) {
        return this.reactiveRefresh(entity, LockMode.NONE);
    }

    @Override
    public CompletionStage<Void> reactiveRefresh(Object entity, LockMode lockMode) {
        EntityDataAccess cacheAccess;
        ReactiveEntityPersister persister = this.getEntityPersister(null, entity);
        Serializable id = persister.getIdentifier(entity, (SharedSessionContractImplementor)this);
        if (persister.canWriteToCache() && (cacheAccess = persister.getCacheAccessStrategy()) != null) {
            Object ck = cacheAccess.generateCacheKey((Object)id, (EntityPersister)persister, this.getFactory(), this.getTenantIdentifier());
            cacheAccess.evict(ck);
        }
        String previousFetchProfile = this.getLoadQueryInfluencers().getInternalFetchProfile();
        this.getLoadQueryInfluencers().setInternalFetchProfile("refresh");
        return persister.reactiveLoad(id, entity, this.getNullSafeLockOptions(lockMode), (SharedSessionContractImplementor)this).thenAccept(result -> {
            if (this.getPersistenceContext().isLoadFinished()) {
                this.getPersistenceContext().clear();
            }
            UnresolvableObjectException.throwIfNull((Object)result, (Serializable)id, (String)persister.getEntityName());
        }).whenComplete((v, e) -> this.getLoadQueryInfluencers().setInternalFetchProfile(previousFetchProfile));
    }

    @Override
    public CompletionStage<Void> reactiveInsertAll(Object ... entities) {
        return CompletionStages.loop(entities, this.batchingHelperSession::reactiveInsert).thenCompose(v -> this.batchingHelperSession.getReactiveConnection().executeBatch());
    }

    @Override
    public CompletionStage<Void> reactiveInsertAll(int batchSize, Object ... entities) {
        ReactiveConnection connection = this.batchingConnection(batchSize);
        return CompletionStages.loop(entities, this.batchingHelperSession::reactiveInsert).thenCompose(v -> connection.executeBatch());
    }

    @Override
    public CompletionStage<Void> reactiveUpdateAll(Object ... entities) {
        return CompletionStages.loop(entities, this.batchingHelperSession::reactiveUpdate).thenCompose(v -> this.batchingHelperSession.getReactiveConnection().executeBatch());
    }

    @Override
    public CompletionStage<Void> reactiveUpdateAll(int batchSize, Object ... entities) {
        ReactiveConnection connection = this.batchingConnection(batchSize);
        return CompletionStages.loop(entities, this.batchingHelperSession::reactiveUpdate).thenCompose(v -> connection.executeBatch());
    }

    @Override
    public CompletionStage<Void> reactiveDeleteAll(Object ... entities) {
        return CompletionStages.loop(entities, this.batchingHelperSession::reactiveDelete).thenCompose(v -> this.batchingHelperSession.getReactiveConnection().executeBatch());
    }

    @Override
    public CompletionStage<Void> reactiveDeleteAll(int batchSize, Object ... entities) {
        ReactiveConnection connection = this.batchingConnection(batchSize);
        return CompletionStages.loop(entities, this.batchingHelperSession::reactiveDelete).thenCompose(v -> connection.executeBatch());
    }

    @Override
    public CompletionStage<Void> reactiveRefreshAll(Object ... entities) {
        return CompletionStages.loop(entities, this.batchingHelperSession::reactiveRefresh).thenCompose(v -> this.batchingHelperSession.getReactiveConnection().executeBatch());
    }

    @Override
    public CompletionStage<Void> reactiveRefreshAll(int batchSize, Object ... entities) {
        ReactiveConnection connection = this.batchingConnection(batchSize);
        return CompletionStages.loop(entities, this.batchingHelperSession::reactiveRefresh).thenCompose(v -> connection.executeBatch());
    }

    private ReactiveConnection batchingConnection(int batchSize) {
        return this.batchingHelperSession.getReactiveConnection().withBatchSize(batchSize);
    }

    public <R> ReactiveQueryImpl<R> createReactiveQuery(String queryString) {
        this.checkOpen();
        try {
            ReactiveQueryImpl query = new ReactiveQueryImpl((SharedSessionContractImplementor)this, this.getQueryPlan(queryString, false), queryString);
            this.applyQuerySettingsAndHints((Query)query);
            query.setComment(queryString);
            return query;
        }
        catch (RuntimeException e) {
            this.markForRollbackOnly();
            throw this.getExceptionConverter().convert(e);
        }
    }

    @Override
    public <R> ReactiveQuery<R> createReactiveQuery(String queryString, Class<R> resultType) {
        try {
            ReactiveQuery query = this.createReactiveQuery(queryString);
            this.resultClassChecking(resultType, (QueryImpl)query);
            return query;
        }
        catch (RuntimeException e) {
            throw this.getExceptionConverter().convert(e);
        }
    }

    @Override
    public <R> ReactiveQuery<R> createReactiveNamedQuery(String name) {
        return this.buildReactiveQueryFromName(name, null);
    }

    @Override
    public <R> ReactiveQuery<R> createReactiveNamedQuery(String name, Class<R> resultClass) {
        return this.buildReactiveQueryFromName(name, resultClass);
    }

    private <T> ReactiveQuery<T> buildReactiveQueryFromName(String name, Class<T> resultType) {
        this.checkOpen();
        try {
            this.pulseTransactionCoordinator();
            this.delayedAfterCompletion();
            NamedQueryDefinition namedQueryDefinition = this.getFactory().getNamedQueryRepository().getNamedQueryDefinition(name);
            if (namedQueryDefinition != null) {
                return this.createReactiveQuery(namedQueryDefinition, resultType);
            }
            NamedSQLQueryDefinition nativeQueryDefinition = this.getFactory().getNamedQueryRepository().getNamedSQLQueryDefinition(name);
            if (nativeQueryDefinition != null) {
                return this.createReactiveNativeQuery(nativeQueryDefinition, resultType);
            }
            throw this.getExceptionConverter().convert((RuntimeException)new IllegalArgumentException("no query defined for name '" + name + "'"));
        }
        catch (RuntimeException e) {
            throw !(e instanceof IllegalArgumentException) ? new IllegalArgumentException(e) : e;
        }
    }

    private <T> ReactiveQuery<T> createReactiveQuery(NamedQueryDefinition namedQueryDefinition, Class<T> resultType) {
        ReactiveQuery<T> query = this.createReactiveQuery(namedQueryDefinition);
        if (resultType != null) {
            this.resultClassChecking(resultType, this.createQuery(namedQueryDefinition));
        }
        return query;
    }

    private <T> ReactiveQuery<T> createReactiveQuery(NamedQueryDefinition queryDefinition) {
        String queryString = queryDefinition.getQueryString();
        ReactiveQueryImpl query = new ReactiveQueryImpl((SharedSessionContractImplementor)this, this.getQueryPlan(queryString, false), queryString);
        this.applyQuerySettingsAndHints((Query)query);
        query.setHibernateFlushMode(queryDefinition.getFlushMode());
        query.setComment(ReactiveStatelessSessionImpl.comment(queryDefinition));
        if (queryDefinition.getLockOptions() != null) {
            query.setLockOptions(queryDefinition.getLockOptions());
        }
        this.initQueryFromNamedDefinition((Query)query, queryDefinition);
        return query;
    }

    private <T> ReactiveNativeQuery<T> createReactiveNativeQuery(NamedSQLQueryDefinition queryDefinition, Class<T> resultType) {
        if (resultType != null && !Tuple.class.equals(resultType) && !Object[].class.equals(resultType)) {
            this.resultClassChecking(resultType, queryDefinition);
        }
        ReactiveNativeQueryImpl query = new ReactiveNativeQueryImpl(queryDefinition, (SharedSessionContractImplementor)this, this.getFactory().getQueryPlanCache().getSQLParameterMetadata(queryDefinition.getQueryString(), false));
        if (Tuple.class.equals(resultType)) {
            query.setResultTransformer((ResultTransformer)new NativeQueryTupleTransformer());
        }
        this.applyQuerySettingsAndHints((Query)query);
        query.setHibernateFlushMode(queryDefinition.getFlushMode());
        query.setComment(ReactiveStatelessSessionImpl.comment((NamedQueryDefinition)queryDefinition));
        if (queryDefinition.getLockOptions() != null) {
            query.setLockOptions(queryDefinition.getLockOptions());
        }
        this.initQueryFromNamedDefinition((Query)query, (NamedQueryDefinition)queryDefinition);
        return query;
    }

    public <T> ReactiveNativeQuery<T> createReactiveNativeQuery(String sqlString) {
        this.checkOpen();
        try {
            ParameterMetadata params = this.getFactory().getQueryPlanCache().getSQLParameterMetadata(sqlString, false);
            ReactiveNativeQueryImpl query = new ReactiveNativeQueryImpl(sqlString, false, (SharedSessionContractImplementor)this, params);
            query.setComment("dynamic native SQL query");
            this.applyQuerySettingsAndHints((Query)query);
            return query;
        }
        catch (RuntimeException he) {
            throw this.getExceptionConverter().convert(he);
        }
    }

    public MetamodelImplementor getMetamodel() {
        this.checkOpen();
        return this.getFactory().getMetamodel();
    }

    public <T> ReactiveNativeQuery<T> createReactiveNativeQuery(String sqlString, Class<T> resultClass) {
        try {
            ReactiveQuery query = this.createReactiveNativeQuery(sqlString);
            if (this.getMetamodel().entityPersisters().containsKey(resultClass.getName())) {
                query.addEntity("alias1", resultClass.getName(), LockMode.READ);
            } else if (Tuple.class.equals(resultClass)) {
                query.setResultTransformer((ResultTransformer)new NativeQueryTupleTransformer());
            }
            return query;
        }
        catch (RuntimeException he) {
            throw this.getExceptionConverter().convert(he);
        }
    }

    public <T> ReactiveNativeQuery<T> createReactiveNativeQuery(String sqlString, String resultSetMapping) {
        try {
            ReactiveQuery query = this.createReactiveNativeQuery(sqlString);
            query.setResultSetMapping(resultSetMapping);
            return query;
        }
        catch (RuntimeException he) {
            throw this.getExceptionConverter().convert(he);
        }
    }

    private <T> ReactiveHQLQueryPlan<T> getReactivePlan(String query, QueryParameters parameters) {
        HQLQueryPlan plan = parameters.getQueryPlan();
        if (plan == null) {
            plan = this.getQueryPlan(query, false);
        }
        return (ReactiveHQLQueryPlan)plan;
    }

    @Override
    public <T> CompletionStage<List<T>> reactiveList(String query, QueryParameters parameters) {
        this.checkOpen();
        parameters.validateParameters();
        ReactiveHQLQueryPlan<T> reactivePlan = this.getReactivePlan(query, parameters);
        return reactivePlan.performReactiveList(parameters, (SharedSessionContractImplementor)this).whenComplete((list, x) -> {
            this.getPersistenceContext().clear();
            this.afterOperation(x == null);
        });
    }

    @Override
    public <T> CompletionStage<List<T>> reactiveList(NativeSQLQuerySpecification spec, QueryParameters parameters) {
        this.checkOpen();
        ReactiveCustomLoader loader = new ReactiveCustomLoader(this.getNativeQueryPlan(spec).getCustomQuery(), this.getFactory());
        return loader.reactiveList((SharedSessionContractImplementor)this, parameters).whenComplete((r, x) -> {
            this.getPersistenceContext().clear();
            this.afterOperation(x == null);
        });
    }

    private static String comment(NamedQueryDefinition queryDefinition) {
        return queryDefinition.getComment() != null ? queryDefinition.getComment() : queryDefinition.getName();
    }

    private ReactiveHQLQueryPlan<Void> getReactivePlan(String query) {
        return (ReactiveHQLQueryPlan)this.getQueryPlan(query, false);
    }

    @Override
    public CompletionStage<Integer> executeReactiveUpdate(String query, QueryParameters parameters) {
        this.checkOpen();
        parameters.validateParameters();
        return this.getReactivePlan(query).performExecuteReactiveUpdate(parameters, this).whenComplete((count, x) -> {
            this.getPersistenceContext().clear();
            this.afterOperation(x == null);
        });
    }

    @Override
    public CompletionStage<Integer> executeReactiveUpdate(NativeSQLQuerySpecification specification, QueryParameters parameters) {
        this.checkOpen();
        parameters.validateParameters();
        ReactiveNativeSQLQueryPlan reactivePlan = new ReactiveNativeSQLQueryPlan(specification.getQueryString(), (CustomQuery)new SQLCustomQuery(specification.getQueryString(), specification.getQueryReturns(), (Collection)specification.getQuerySpaces(), this.getFactory()));
        return reactivePlan.performExecuteReactiveUpdate(parameters, this).whenComplete((count, x) -> {
            this.getPersistenceContext().clear();
            this.afterOperation(x == null);
        });
    }

    @Override
    public void addBulkCleanupAction(BulkOperationCleanupAction action) {
        action.getAfterTransactionCompletionProcess().doAfterTransactionCompletion(true, (SharedSessionContractImplementor)this);
    }

    public List<?> list(String query, QueryParameters queryParameters) {
        throw new UnsupportedOperationException();
    }

    public List<?> listCustomQuery(CustomQuery customQuery, QueryParameters queryParameters) {
        throw new UnsupportedOperationException();
    }

    @Override
    public <T> ResultSetMapping<T> getResultSetMapping(Class<T> resultType, String mappingName) {
        return ResultSetMappings.resultSetMapping(resultType, mappingName, this.getFactory());
    }

    private Object createProxy(EntityKey entityKey) {
        Object proxy = entityKey.getPersister().createProxy(entityKey.getIdentifier(), (SharedSessionContractImplementor)this);
        this.getPersistenceContext().addProxy(entityKey, proxy);
        return proxy;
    }

    @Override
    public CompletionStage<Object> reactiveInternalLoad(String entityName, Serializable id, boolean eager, boolean nullable) {
        this.checkOpen();
        EntityPersister persister = this.getFactory().getMetamodel().entityPersister(entityName);
        EntityKey entityKey = this.generateEntityKey(id, persister);
        PersistenceContext persistenceContext = this.getPersistenceContext();
        Object loaded = persistenceContext.getEntity(entityKey);
        if (loaded != null) {
            return CompletionStages.completedFuture(loaded);
        }
        if (!eager) {
            EntityMetamodel entityMetamodel = persister.getEntityMetamodel();
            BytecodeEnhancementMetadata enhancementMetadata = entityMetamodel.getBytecodeEnhancementMetadata();
            if (enhancementMetadata.isEnhancedForLazyLoading()) {
                if (entityMetamodel.getTuplizer().getProxyFactory() != null) {
                    Object proxy = persistenceContext.getProxy(entityKey);
                    if (proxy != null) {
                        return CompletionStages.completedFuture(persistenceContext.narrowProxy(proxy, persister, entityKey, null));
                    }
                    if (entityMetamodel.hasSubclasses()) {
                        return CompletionStages.completedFuture(this.createProxy(entityKey));
                    }
                    return CompletionStages.completedFuture(enhancementMetadata.createEnhancedProxy(entityKey, false, (SharedSessionContractImplementor)this));
                }
                if (!entityMetamodel.hasSubclasses()) {
                    return CompletionStages.completedFuture(enhancementMetadata.createEnhancedProxy(entityKey, false, (SharedSessionContractImplementor)this));
                }
            } else if (persister.hasProxy()) {
                Object existingProxy = persistenceContext.getProxy(entityKey);
                if (existingProxy != null) {
                    return CompletionStages.completedFuture(persistenceContext.narrowProxy(existingProxy, persister, entityKey, null));
                }
                return CompletionStages.completedFuture(this.createProxy(entityKey));
            }
        }
        persistenceContext.beforeLoad();
        return this.reactiveGet(persister.getMappedClass(), id).whenComplete((r, e) -> persistenceContext.afterLoad());
    }

    @Override
    public <T> CompletionStage<T> reactiveFetch(T association, boolean unproxy) {
        this.checkOpen();
        PersistenceContext persistenceContext = this.getPersistenceContext();
        if (association instanceof HibernateProxy) {
            LazyInitializer initializer = ((HibernateProxy)association).getHibernateLazyInitializer();
            if (!initializer.isUninitialized()) {
                return CompletionStages.completedFuture(unproxy ? initializer.getImplementation() : association);
            }
            String entityName = initializer.getEntityName();
            Serializable id = initializer.getIdentifier();
            ReactiveEntityPersister persister = (ReactiveEntityPersister)this.getFactory().getMetamodel().entityPersister(entityName);
            initializer.setSession((SharedSessionContractImplementor)this);
            persistenceContext.beforeLoad();
            return persister.reactiveLoad(id, initializer.getImplementation(), LockOptions.NONE, (SharedSessionContractImplementor)this).whenComplete((v, e) -> {
                persistenceContext.afterLoad();
                if (persistenceContext.isLoadFinished()) {
                    persistenceContext.clear();
                }
            }).thenApply(entity -> {
                SessionUtil.checkEntityFound((SharedSessionContractImplementor)this, entityName, id, entity);
                initializer.setImplementation(entity);
                initializer.unsetSession();
                return unproxy ? entity : association;
            });
        }
        if (association instanceof PersistentCollection) {
            PersistentCollection persistentCollection = (PersistentCollection)association;
            if (persistentCollection.wasInitialized()) {
                return CompletionStages.completedFuture(association);
            }
            ReactiveCollectionPersister persister = (ReactiveCollectionPersister)this.getFactory().getMetamodel().collectionPersister(persistentCollection.getRole());
            Serializable key = persistentCollection.getKey();
            persistenceContext.addUninitializedCollection((CollectionPersister)persister, persistentCollection, key);
            persistentCollection.setCurrentSession((SharedSessionContractImplementor)this);
            return persister.reactiveInitialize(key, (SharedSessionContractImplementor)this).whenComplete((v, e) -> {
                if (persistenceContext.isLoadFinished()) {
                    persistenceContext.clear();
                }
            }).thenApply(v -> association);
        }
        return CompletionStages.completedFuture(association);
    }

    public <T> RootGraphImplementor<T> createEntityGraph(Class<T> entity, String name) {
        RootGraphImplementor<?> entityGraph = this.createEntityGraph(name);
        if (!entityGraph.getGraphedType().getJavaType().equals(entity)) {
            throw LOG.wrongEntityType();
        }
        return entityGraph;
    }

    public <T> RootGraphImplementor<T> getEntityGraph(Class<T> entity, String name) {
        RootGraphImplementor<?> entityGraph = this.getEntityGraph(name);
        if (!entityGraph.getGraphedType().getJavaType().equals(entity)) {
            throw LOG.wrongEntityType();
        }
        return entityGraph;
    }

    public <T> RootGraphImplementor<T> createEntityGraph(Class<T> entity) {
        return new RootGraphImpl(null, this.getFactory().getMetamodel().entity(entity), this.getFactory());
    }

    private RootGraphImplementor<?> createEntityGraph(String graphName) {
        this.checkOpen();
        RootGraphImplementor named = this.getFactory().findEntityGraphByName(graphName);
        if (named != null) {
            return named.makeRootGraph(graphName, true);
        }
        return named;
    }

    private RootGraphImplementor<?> getEntityGraph(String graphName) {
        this.checkOpen();
        RootGraphImplementor named = this.getFactory().findEntityGraphByName(graphName);
        if (named == null) {
            throw new IllegalArgumentException("Could not locate EntityGraph with given name : " + graphName);
        }
        return named;
    }

    @Override
    public <R> ReactiveQuery<R> createReactiveQuery(Criteria<R> criteria) {
        try {
            criteria.validate();
        }
        catch (IllegalStateException ise) {
            throw new IllegalArgumentException("Error occurred validating the Criteria", ise);
        }
        return criteria.build(this.newRenderingContext(), this);
    }

    private CriteriaQueryRenderingContext newRenderingContext() {
        return new CriteriaQueryRenderingContext(this.getFactory());
    }

    @Override
    public <T> ReactiveQuery<T> createReactiveCriteriaQuery(String jpaqlString, Class<T> resultClass, CriteriaQueryOptions queryOptions) {
        try {
            ReactiveQuery query = this.createReactiveQuery(jpaqlString);
            query.setParameterMetadata(queryOptions.getParameterMetadata());
            boolean hasValueHandlers = queryOptions.getValueHandlers() != null;
            boolean hasTupleElements = Tuple.class.equals(resultClass);
            if (!hasValueHandlers) {
                queryOptions.validate(query.getReturnTypes());
            }
            if (hasValueHandlers || hasTupleElements) {
                query.setResultTransformer((ResultTransformer)new CriteriaQueryTupleTransformer(queryOptions.getValueHandlers(), hasTupleElements ? queryOptions.getSelection().getCompoundSelectionItems() : null));
            }
            return query;
        }
        catch (RuntimeException e) {
            throw this.getExceptionConverter().convert(e);
        }
    }

    public void close() {
        throw new UnsupportedOperationException("Non reactive close method called. Use close(CompletableFuture<Void> closing) instead.");
    }

    @Override
    public void close(CompletableFuture<Void> closing) {
        this.reactiveConnection.close().thenAccept(v -> super.close()).whenComplete((unused, throwable) -> {
            if (throwable != null) {
                closing.completeExceptionally((Throwable)throwable);
            } else {
                closing.complete(null);
            }
        });
    }
}

