/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.reactive.session.impl;

import jakarta.persistence.EntityGraph;
import jakarta.persistence.EntityNotFoundException;
import jakarta.persistence.Tuple;
import jakarta.persistence.metamodel.Attribute;
import java.io.Serializable;
import java.lang.invoke.MethodHandles;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.function.Supplier;
import org.hibernate.CacheMode;
import org.hibernate.FlushMode;
import org.hibernate.HibernateException;
import org.hibernate.JDBCException;
import org.hibernate.LockMode;
import org.hibernate.LockOptions;
import org.hibernate.MappingException;
import org.hibernate.ObjectDeletedException;
import org.hibernate.ObjectNotFoundException;
import org.hibernate.TypeMismatchException;
import org.hibernate.UnresolvableObjectException;
import org.hibernate.action.internal.BulkOperationCleanupAction;
import org.hibernate.collection.spi.PersistentCollection;
import org.hibernate.dialect.Dialect;
import org.hibernate.engine.internal.StatefulPersistenceContext;
import org.hibernate.engine.query.spi.HQLQueryPlan;
import org.hibernate.engine.query.spi.sql.NativeSQLQuerySpecification;
import org.hibernate.engine.spi.EffectiveEntityGraph;
import org.hibernate.engine.spi.EntityEntry;
import org.hibernate.engine.spi.EntityKey;
import org.hibernate.engine.spi.ExceptionConverter;
import org.hibernate.engine.spi.NamedQueryDefinition;
import org.hibernate.engine.spi.NamedSQLQueryDefinition;
import org.hibernate.engine.spi.PersistenceContext;
import org.hibernate.engine.spi.QueryParameters;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.engine.spi.Status;
import org.hibernate.event.internal.MergeContext;
import org.hibernate.event.spi.AutoFlushEvent;
import org.hibernate.event.spi.DeleteEvent;
import org.hibernate.event.spi.EventSource;
import org.hibernate.event.spi.FlushEvent;
import org.hibernate.event.spi.InitializeCollectionEvent;
import org.hibernate.event.spi.LoadEvent;
import org.hibernate.event.spi.LoadEventListener;
import org.hibernate.event.spi.LockEvent;
import org.hibernate.event.spi.MergeEvent;
import org.hibernate.event.spi.PersistEvent;
import org.hibernate.event.spi.RefreshEvent;
import org.hibernate.event.spi.ResolveNaturalIdEvent;
import org.hibernate.graph.GraphSemantic;
import org.hibernate.graph.RootGraph;
import org.hibernate.graph.spi.RootGraphImplementor;
import org.hibernate.internal.SessionCreationOptions;
import org.hibernate.internal.SessionFactoryImpl;
import org.hibernate.internal.SessionImpl;
import org.hibernate.internal.util.collections.IdentitySet;
import org.hibernate.jpa.spi.CriteriaQueryTupleTransformer;
import org.hibernate.jpa.spi.NativeQueryTupleTransformer;
import org.hibernate.loader.custom.CustomQuery;
import org.hibernate.loader.custom.sql.SQLCustomQuery;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.persister.entity.MultiLoadOptions;
import org.hibernate.pretty.MessageHelper;
import org.hibernate.proxy.HibernateProxy;
import org.hibernate.proxy.LazyInitializer;
import org.hibernate.query.ParameterMetadata;
import org.hibernate.query.Query;
import org.hibernate.query.internal.QueryImpl;
import org.hibernate.reactive.common.InternalStateAssertions;
import org.hibernate.reactive.common.ResultSetMapping;
import org.hibernate.reactive.engine.ReactiveActionQueue;
import org.hibernate.reactive.engine.impl.ReactivePersistenceContextAdapter;
import org.hibernate.reactive.loader.custom.impl.ReactiveCustomLoader;
import org.hibernate.reactive.logging.impl.Log;
import org.hibernate.reactive.logging.impl.LoggerFactory;
import org.hibernate.reactive.persister.entity.impl.ReactiveEntityPersister;
import org.hibernate.reactive.pool.BatchingConnection;
import org.hibernate.reactive.pool.ReactiveConnection;
import org.hibernate.reactive.session.Criteria;
import org.hibernate.reactive.session.CriteriaQueryOptions;
import org.hibernate.reactive.session.ReactiveNativeQuery;
import org.hibernate.reactive.session.ReactiveQuery;
import org.hibernate.reactive.session.ReactiveSession;
import org.hibernate.reactive.session.impl.CriteriaQueryRenderingContext;
import org.hibernate.reactive.session.impl.ReactiveExceptionConverter;
import org.hibernate.reactive.session.impl.ReactiveHQLQueryPlan;
import org.hibernate.reactive.session.impl.ReactiveNativeQueryImpl;
import org.hibernate.reactive.session.impl.ReactiveNativeSQLQueryPlan;
import org.hibernate.reactive.session.impl.ReactiveQueryImpl;
import org.hibernate.reactive.session.impl.ResultSetMappings;
import org.hibernate.reactive.session.impl.SessionUtil;
import org.hibernate.reactive.util.impl.CompletionStages;
import org.hibernate.transform.ResultTransformer;

public class ReactiveSessionImpl
extends SessionImpl
implements ReactiveSession,
EventSource {
    private static final Log log = LoggerFactory.make(Log.class, MethodHandles.lookup());
    private final transient ReactiveActionQueue reactiveActionQueue = new ReactiveActionQueue(this);
    private ReactiveConnection reactiveConnection;
    private final Thread associatedWorkThread;
    private transient ExceptionConverter exceptionConverter;

    public ReactiveSessionImpl(SessionFactoryImpl delegate, SessionCreationOptions options, ReactiveConnection connection) {
        super(delegate, options);
        InternalStateAssertions.assertUseOnEventLoop();
        this.associatedWorkThread = Thread.currentThread();
        Integer batchSize = this.getConfiguredJdbcBatchSize();
        this.reactiveConnection = batchSize == null || batchSize < 2 ? connection : new BatchingConnection(connection, batchSize);
    }

    @Override
    public SessionImplementor getSharedContract() {
        return this;
    }

    @Override
    public Dialect getDialect() {
        this.threadCheck();
        return this.getJdbcServices().getDialect();
    }

    private void threadCheck() {
        InternalStateAssertions.assertCurrentThreadMatches(this.associatedWorkThread);
    }

    protected StatefulPersistenceContext createPersistenceContext() {
        return new ReactivePersistenceContextAdapter((SharedSessionContractImplementor)this);
    }

    @Override
    public ReactiveActionQueue getReactiveActionQueue() {
        this.threadCheck();
        return this.reactiveActionQueue;
    }

    public Object immediateLoad(String entityName, Serializable id) throws HibernateException {
        throw log.lazyInitializationException(entityName, id);
    }

    @Override
    public CompletionStage<Object> reactiveImmediateLoad(String entityName, Serializable id) throws HibernateException {
        this.threadCheck();
        LoadEvent event = new LoadEvent(id, entityName, true, (EventSource)this, this.getReadOnlyFromLoadQueryInfluencers());
        return this.fireLoadNoChecks(event, LoadEventListener.IMMEDIATE_LOAD).thenApply(v -> event.getResult());
    }

    @Override
    public CompletionStage<Object> reactiveInternalLoad(String entityName, Serializable id, boolean eager, boolean nullable) {
        boolean clearedEffectiveGraph;
        EffectiveEntityGraph effectiveEntityGraph = this.getLoadQueryInfluencers().getEffectiveEntityGraph();
        GraphSemantic semantic = effectiveEntityGraph.getSemantic();
        RootGraphImplementor graph = effectiveEntityGraph.getGraph();
        if (semantic == null || graph.appliesTo(entityName)) {
            clearedEffectiveGraph = false;
        } else {
            clearedEffectiveGraph = true;
            effectiveEntityGraph.clear();
        }
        LoadEventListener.LoadType type = nullable ? LoadEventListener.INTERNAL_LOAD_NULLABLE : (eager ? LoadEventListener.INTERNAL_LOAD_EAGER : LoadEventListener.INTERNAL_LOAD_LAZY);
        this.threadCheck();
        LoadEvent event = new LoadEvent(id, entityName, true, (EventSource)this, this.getReadOnlyFromLoadQueryInfluencers());
        return this.fireLoadNoChecks(event, type).thenApply(v -> {
            Object result = event.getResult();
            if (!nullable) {
                UnresolvableObjectException.throwIfNull((Object)result, (Serializable)id, (String)entityName);
            }
            return result;
        }).whenComplete((v, x) -> {
            if (clearedEffectiveGraph) {
                effectiveEntityGraph.applyGraph(graph, semantic);
            }
        });
    }

    @Override
    public <T> CompletionStage<T> reactiveFetch(T association, boolean unproxy) {
        this.checkOpen();
        if (association instanceof HibernateProxy) {
            LazyInitializer initializer = ((HibernateProxy)association).getHibernateLazyInitializer();
            if (!initializer.isUninitialized()) {
                return CompletionStages.completedFuture(unproxy ? initializer.getImplementation() : association);
            }
            String entityName = initializer.getEntityName();
            Serializable identifier = initializer.getIdentifier();
            return this.reactiveImmediateLoad(entityName, identifier).thenApply(entity -> {
                SessionUtil.checkEntityFound((SharedSessionContractImplementor)this, entityName, identifier, entity);
                initializer.setSession((SharedSessionContractImplementor)this);
                initializer.setImplementation(entity);
                return unproxy ? entity : association;
            });
        }
        if (association instanceof PersistentCollection) {
            PersistentCollection persistentCollection = (PersistentCollection)association;
            if (persistentCollection.wasInitialized()) {
                return CompletionStages.completedFuture(association);
            }
            return this.reactiveInitializeCollection(persistentCollection, false).thenApply(v -> association);
        }
        return CompletionStages.completedFuture(association);
    }

    @Override
    public <E, T> CompletionStage<T> reactiveFetch(E entity, Attribute<E, T> field) {
        return ((ReactiveEntityPersister)this.getEntityPersister(null, entity)).reactiveInitializeLazyProperty(field, entity, (SharedSessionContractImplementor)this);
    }

    public <T> ReactiveNativeQueryImpl<T> createReactiveNativeQuery(String sqlString) {
        this.checkOpen();
        this.pulseTransactionCoordinator();
        this.delayedAfterCompletion();
        try {
            ParameterMetadata params = this.getFactory().getQueryPlanCache().getSQLParameterMetadata(sqlString, false);
            ReactiveNativeQueryImpl query = new ReactiveNativeQueryImpl(sqlString, false, (SharedSessionContractImplementor)this, params);
            query.setComment("dynamic native SQL query");
            this.applyQuerySettingsAndHints((Query)query);
            return query;
        }
        catch (RuntimeException he) {
            throw this.getExceptionConverter().convert(he);
        }
    }

    public <T> ReactiveNativeQuery<T> createReactiveNativeQuery(String sqlString, String resultSetMapping) {
        try {
            ReactiveQuery query = this.createReactiveNativeQuery(sqlString);
            query.setResultSetMapping(resultSetMapping);
            return query;
        }
        catch (RuntimeException he) {
            throw this.getExceptionConverter().convert(he);
        }
    }

    @Override
    public <T> ResultSetMapping<T> getResultSetMapping(Class<T> resultType, String mappingName) {
        return ResultSetMappings.resultSetMapping(resultType, mappingName, this.getFactory());
    }

    @Override
    public <T> ReactiveQuery<T> createReactiveNativeQuery(String sqlString, Class<T> resultClass) {
        try {
            ReactiveQuery query = this.createReactiveNativeQuery(sqlString);
            if (this.getMetamodel().entityPersisters().containsKey(resultClass.getName())) {
                query.addEntity("alias1", resultClass.getName(), LockMode.READ);
            } else if (Tuple.class.equals(resultClass)) {
                query.setResultTransformer((ResultTransformer)new NativeQueryTupleTransformer());
            }
            return query;
        }
        catch (RuntimeException he) {
            throw this.getExceptionConverter().convert(he);
        }
    }

    public <R> ReactiveQueryImpl<R> createReactiveQuery(String queryString) {
        this.checkOpen();
        this.pulseTransactionCoordinator();
        this.delayedAfterCompletion();
        try {
            ReactiveQueryImpl query = new ReactiveQueryImpl((SharedSessionContractImplementor)this, this.getQueryPlan(queryString, false), queryString);
            this.applyQuerySettingsAndHints((Query)query);
            query.setComment(queryString);
            return query;
        }
        catch (RuntimeException e) {
            this.markForRollbackOnly();
            throw this.getExceptionConverter().convert(e);
        }
    }

    @Override
    public <R> ReactiveQuery<R> createReactiveQuery(String queryString, Class<R> resultType) {
        try {
            ReactiveQuery query = this.createReactiveQuery(queryString);
            this.resultClassChecking(resultType, (QueryImpl)query);
            return query;
        }
        catch (RuntimeException e) {
            throw this.getExceptionConverter().convert(e);
        }
    }

    @Deprecated
    public void initializeCollection(PersistentCollection collection, boolean writing) {
        throw log.collectionCannotBeInitializedlazyInitializationException(ReactiveSessionImpl.collectionRoleLogMessage(collection));
    }

    private static String collectionRoleLogMessage(PersistentCollection collection) {
        if (collection == null) {
            return "collection is null";
        }
        return collection.getRole();
    }

    @Override
    public CompletionStage<Void> reactiveInitializeCollection(PersistentCollection collection, boolean writing) {
        this.checkOpenOrWaitingForAutoClose();
        this.pulseTransactionCoordinator();
        InitializeCollectionEvent event = new InitializeCollectionEvent(collection, (EventSource)this);
        return this.fastSessionServices.eventListenerGroup_INIT_COLLECTION.fireEventOnEachListener((Object)event, l -> l::onReactiveInitializeCollection).handle((v, e) -> {
            this.delayedAfterCompletion();
            if (e instanceof MappingException) {
                throw this.getExceptionConverter().convert((RuntimeException)new IllegalArgumentException(e.getMessage()));
            }
            if (e instanceof RuntimeException) {
                throw this.getExceptionConverter().convert((RuntimeException)e);
            }
            return (Void)CompletionStages.returnNullorRethrow(e);
        });
    }

    protected CompletionStage<Void> reactiveAutoFlushIfRequired(Set<?> querySpaces) throws HibernateException {
        this.checkOpen();
        AutoFlushEvent event = new AutoFlushEvent(querySpaces, (EventSource)this);
        return this.fastSessionServices.eventListenerGroup_AUTO_FLUSH.fireEventOnEachListener((Object)event, l -> l::reactiveOnAutoFlush);
    }

    private <T> ReactiveHQLQueryPlan<T> getReactivePlan(String query, QueryParameters parameters) {
        HQLQueryPlan plan = parameters.getQueryPlan();
        if (plan == null) {
            plan = this.getQueryPlan(query, false);
        }
        return (ReactiveHQLQueryPlan)plan;
    }

    @Override
    public <T> CompletionStage<List<T>> reactiveList(String query, QueryParameters parameters) throws HibernateException {
        this.checkOpenOrWaitingForAutoClose();
        this.pulseTransactionCoordinator();
        parameters.validateParameters();
        ReactiveHQLQueryPlan reactivePlan = this.getReactivePlan(query, parameters);
        return this.reactiveAutoFlushIfRequired(reactivePlan.getQuerySpaces()).thenCompose(v -> reactivePlan.performReactiveList(parameters, (SharedSessionContractImplementor)this)).whenComplete((list, x) -> {
            this.afterOperation(x == null);
            this.delayedAfterCompletion();
        });
    }

    @Override
    public <T> CompletionStage<List<T>> reactiveList(NativeSQLQuerySpecification spec, QueryParameters parameters) {
        this.checkOpenOrWaitingForAutoClose();
        this.checkTransactionSynchStatus();
        ReactiveCustomLoader loader = new ReactiveCustomLoader(this.getNativeQueryPlan(spec).getCustomQuery(), this.getFactory());
        return this.reactiveAutoFlushIfRequired(loader.getQuerySpaces()).thenCompose(v -> loader.reactiveList((SharedSessionContractImplementor)this, parameters)).whenComplete((r, e) -> {
            this.afterOperation(e == null);
            this.delayedAfterCompletion();
        });
    }

    @Override
    public <R> ReactiveQuery<R> createReactiveNamedQuery(String name) {
        return this.buildReactiveQueryFromName(name, null);
    }

    @Override
    public <R> ReactiveQuery<R> createReactiveNamedQuery(String name, Class<R> resultClass) {
        return this.buildReactiveQueryFromName(name, resultClass);
    }

    private <T> ReactiveQuery<T> buildReactiveQueryFromName(String name, Class<T> resultType) {
        this.checkOpen();
        try {
            this.pulseTransactionCoordinator();
            this.delayedAfterCompletion();
            NamedQueryDefinition namedQueryDefinition = this.getFactory().getNamedQueryRepository().getNamedQueryDefinition(name);
            if (namedQueryDefinition != null) {
                return this.createReactiveQuery(namedQueryDefinition, resultType);
            }
            NamedSQLQueryDefinition nativeQueryDefinition = this.getFactory().getNamedQueryRepository().getNamedSQLQueryDefinition(name);
            if (nativeQueryDefinition != null) {
                return this.createReactiveNativeQuery(nativeQueryDefinition, resultType);
            }
            throw this.getExceptionConverter().convert((RuntimeException)new IllegalArgumentException("no query defined for name '" + name + "'"));
        }
        catch (RuntimeException e) {
            throw !(e instanceof IllegalArgumentException) ? new IllegalArgumentException(e) : e;
        }
    }

    private <T> ReactiveQuery<T> createReactiveQuery(NamedQueryDefinition namedQueryDefinition, Class<T> resultType) {
        ReactiveQuery<T> query = this.createReactiveQuery(namedQueryDefinition);
        if (resultType != null) {
            this.resultClassChecking(resultType, this.createQuery(namedQueryDefinition));
        }
        return query;
    }

    private static String comment(NamedQueryDefinition queryDefinition) {
        return queryDefinition.getComment() != null ? queryDefinition.getComment() : queryDefinition.getName();
    }

    private <T> ReactiveQuery<T> createReactiveQuery(NamedQueryDefinition queryDefinition) {
        String queryString = queryDefinition.getQueryString();
        ReactiveQueryImpl query = new ReactiveQueryImpl((SharedSessionContractImplementor)this, this.getQueryPlan(queryString, false), queryString);
        this.applyQuerySettingsAndHints((Query)query);
        query.setHibernateFlushMode(queryDefinition.getFlushMode());
        query.setComment(ReactiveSessionImpl.comment(queryDefinition));
        if (queryDefinition.getLockOptions() != null) {
            query.setLockOptions(queryDefinition.getLockOptions());
        }
        this.initQueryFromNamedDefinition((Query)query, queryDefinition);
        return query;
    }

    private <T> ReactiveNativeQuery<T> createReactiveNativeQuery(NamedSQLQueryDefinition queryDefinition, Class<T> resultType) {
        if (resultType != null && !Tuple.class.equals(resultType) && !Object[].class.equals(resultType)) {
            this.resultClassChecking(resultType, queryDefinition);
        }
        ReactiveNativeQueryImpl query = new ReactiveNativeQueryImpl(queryDefinition, (SharedSessionContractImplementor)this, this.getFactory().getQueryPlanCache().getSQLParameterMetadata(queryDefinition.getQueryString(), false));
        if (Tuple.class.equals(resultType)) {
            query.setResultTransformer((ResultTransformer)new NativeQueryTupleTransformer());
        }
        this.applyQuerySettingsAndHints((Query)query);
        query.setHibernateFlushMode(queryDefinition.getFlushMode());
        query.setComment(ReactiveSessionImpl.comment((NamedQueryDefinition)queryDefinition));
        if (queryDefinition.getLockOptions() != null) {
            query.setLockOptions(queryDefinition.getLockOptions());
        }
        this.initQueryFromNamedDefinition((Query)query, (NamedQueryDefinition)queryDefinition);
        return query;
    }

    @Override
    public <R> ReactiveQuery<R> createReactiveQuery(Criteria<R> criteria) {
        try {
            criteria.validate();
        }
        catch (IllegalStateException ise) {
            throw new IllegalArgumentException("Error occurred validating the Criteria", ise);
        }
        return criteria.build(this.newRenderingContext(), this);
    }

    private CriteriaQueryRenderingContext newRenderingContext() {
        return new CriteriaQueryRenderingContext(this.getFactory());
    }

    @Override
    public <T> ReactiveQuery<T> createReactiveCriteriaQuery(String jpaqlString, Class<T> resultClass, CriteriaQueryOptions queryOptions) {
        try {
            ReactiveQuery query = this.createReactiveQuery(jpaqlString);
            query.setParameterMetadata(queryOptions.getParameterMetadata());
            boolean hasValueHandlers = queryOptions.getValueHandlers() != null;
            boolean hasTupleElements = Tuple.class.equals(resultClass);
            if (!hasValueHandlers) {
                queryOptions.validate(query.getReturnTypes());
            }
            if (hasValueHandlers || hasTupleElements) {
                query.setResultTransformer((ResultTransformer)new CriteriaQueryTupleTransformer(queryOptions.getValueHandlers(), hasTupleElements ? queryOptions.getSelection().getCompoundSelectionItems() : null));
            }
            return query;
        }
        catch (RuntimeException e) {
            throw this.getExceptionConverter().convert(e);
        }
    }

    private ReactiveHQLQueryPlan<Void> getReactivePlan(String query) {
        return (ReactiveHQLQueryPlan)this.getQueryPlan(query, false);
    }

    @Override
    public CompletionStage<Integer> executeReactiveUpdate(String query, QueryParameters parameters) {
        this.checkOpenOrWaitingForAutoClose();
        this.pulseTransactionCoordinator();
        parameters.validateParameters();
        ReactiveHQLQueryPlan<Void> reactivePlan = this.getReactivePlan(query);
        return this.reactiveAutoFlushIfRequired(reactivePlan.getQuerySpaces()).thenAccept(v -> this.verifyImmutableEntityUpdate(reactivePlan)).thenCompose(v -> reactivePlan.performExecuteReactiveUpdate(parameters, this)).whenComplete((count, x) -> {
            this.afterOperation(x == null);
            this.delayedAfterCompletion();
        });
    }

    @Override
    public CompletionStage<Integer> executeReactiveUpdate(NativeSQLQuerySpecification specification, QueryParameters parameters) {
        this.checkOpenOrWaitingForAutoClose();
        this.pulseTransactionCoordinator();
        parameters.validateParameters();
        ReactiveNativeSQLQueryPlan reactivePlan = new ReactiveNativeSQLQueryPlan(specification.getQueryString(), (CustomQuery)new SQLCustomQuery(specification.getQueryString(), specification.getQueryReturns(), (Collection)specification.getQuerySpaces(), this.getFactory()));
        return this.reactiveAutoFlushIfRequired(reactivePlan.getCustomQuery().getQuerySpaces()).thenCompose(v -> reactivePlan.performExecuteReactiveUpdate(parameters, this)).whenComplete((count, x) -> {
            this.afterOperation(x == null);
            this.delayedAfterCompletion();
        });
    }

    @Override
    public void addBulkCleanupAction(BulkOperationCleanupAction action) {
        this.getReactiveActionQueue().addAction(action);
    }

    @Override
    public CompletionStage<Void> reactivePersist(Object entity) {
        this.checkOpen();
        return this.firePersist(new PersistEvent(null, entity, (EventSource)this));
    }

    @Override
    public CompletionStage<Void> reactivePersist(Object object, IdentitySet copiedAlready) {
        this.checkOpenOrWaitingForAutoClose();
        return this.firePersist(copiedAlready, new PersistEvent(null, object, (EventSource)this));
    }

    private CompletionStage<Void> firePersist(PersistEvent event) {
        this.checkTransactionSynchStatus();
        this.checkNoUnresolvedActionsBeforeOperation();
        return this.fastSessionServices.eventListenerGroup_PERSIST.fireEventOnEachListener((Object)event, l -> l::reactiveOnPersist).handle((v, e) -> {
            this.checkNoUnresolvedActionsAfterOperation();
            if (e instanceof MappingException) {
                throw this.getExceptionConverter().convert((RuntimeException)new IllegalArgumentException(e.getMessage()));
            }
            if (e instanceof RuntimeException) {
                throw this.getExceptionConverter().convert((RuntimeException)e);
            }
            return (Void)CompletionStages.returnNullorRethrow(e);
        });
    }

    private CompletionStage<Void> firePersist(IdentitySet copiedAlready, PersistEvent event) {
        this.pulseTransactionCoordinator();
        return this.fastSessionServices.eventListenerGroup_PERSIST.fireEventOnEachListener((Object)event, (Object)copiedAlready, l -> l::reactiveOnPersist).handle((v, e) -> {
            this.delayedAfterCompletion();
            if (e instanceof MappingException) {
                throw this.getExceptionConverter().convert((RuntimeException)new IllegalArgumentException(e.getMessage()));
            }
            if (e instanceof RuntimeException) {
                throw this.getExceptionConverter().convert((RuntimeException)e);
            }
            return (Void)CompletionStages.returnNullorRethrow(e);
        });
    }

    @Override
    public CompletionStage<Void> reactivePersistOnFlush(Object entity, IdentitySet copiedAlready) {
        this.checkOpenOrWaitingForAutoClose();
        return this.firePersistOnFlush(copiedAlready, new PersistEvent(null, entity, (EventSource)this));
    }

    private CompletionStage<Void> firePersistOnFlush(IdentitySet copiedAlready, PersistEvent event) {
        this.pulseTransactionCoordinator();
        return this.fastSessionServices.eventListenerGroup_PERSIST.fireEventOnEachListener((Object)event, (Object)copiedAlready, l -> l::reactiveOnPersist).whenComplete((v, e) -> this.delayedAfterCompletion());
    }

    @Override
    public CompletionStage<Void> reactiveRemove(Object entity) {
        this.checkOpen();
        return this.fireRemove(new DeleteEvent(null, entity, (EventSource)this));
    }

    @Override
    public CompletionStage<Void> reactiveRemove(Object object, boolean isCascadeDeleteEnabled, IdentitySet transientEntities) throws HibernateException {
        this.checkOpenOrWaitingForAutoClose();
        return this.fireRemove(new DeleteEvent(null, object, isCascadeDeleteEnabled, ((ReactivePersistenceContextAdapter)this.getPersistenceContextInternal()).isRemovingOrphanBeforeUpates(), (EventSource)this), transientEntities);
    }

    @Override
    public CompletionStage<Void> reactiveRemove(String entityName, Object child, boolean isCascadeDeleteEnabled, IdentitySet transientEntities) {
        this.checkOpenOrWaitingForAutoClose();
        return this.fireRemove(new DeleteEvent(entityName, child, isCascadeDeleteEnabled, ((ReactivePersistenceContextAdapter)this.getPersistenceContextInternal()).isRemovingOrphanBeforeUpates(), (EventSource)this), transientEntities);
    }

    private CompletionStage<Void> fireRemove(DeleteEvent event) {
        this.pulseTransactionCoordinator();
        return this.fastSessionServices.eventListenerGroup_DELETE.fireEventOnEachListener((Object)event, l -> l::reactiveOnDelete).handle((v, e) -> {
            this.delayedAfterCompletion();
            if (e instanceof ObjectDeletedException) {
                throw this.getExceptionConverter().convert((RuntimeException)new IllegalArgumentException((Throwable)e));
            }
            if (e instanceof MappingException) {
                throw this.getExceptionConverter().convert((RuntimeException)new IllegalArgumentException(e.getMessage(), (Throwable)e));
            }
            if (e instanceof RuntimeException) {
                throw this.getExceptionConverter().convert((RuntimeException)e);
            }
            return (Void)CompletionStages.returnNullorRethrow(e);
        });
    }

    private CompletionStage<Void> fireRemove(DeleteEvent event, IdentitySet transientEntities) {
        this.pulseTransactionCoordinator();
        return this.fastSessionServices.eventListenerGroup_DELETE.fireEventOnEachListener((Object)event, (Object)transientEntities, l -> l::reactiveOnDelete).handle((v, e) -> {
            this.delayedAfterCompletion();
            if (e instanceof ObjectDeletedException) {
                throw this.getExceptionConverter().convert((RuntimeException)new IllegalArgumentException((Throwable)e));
            }
            if (e instanceof MappingException) {
                throw this.getExceptionConverter().convert((RuntimeException)new IllegalArgumentException(e.getMessage(), (Throwable)e));
            }
            if (e instanceof RuntimeException) {
                throw this.getExceptionConverter().convert((RuntimeException)e);
            }
            return (Void)CompletionStages.returnNullorRethrow(e);
        });
    }

    @Override
    public <T> CompletionStage<T> reactiveMerge(T object) throws HibernateException {
        this.checkOpen();
        return this.fireMerge(new MergeEvent(null, object, (EventSource)this));
    }

    @Override
    public CompletionStage<Void> reactiveMerge(Object object, MergeContext copiedAlready) throws HibernateException {
        this.checkOpenOrWaitingForAutoClose();
        return this.fireMerge(copiedAlready, new MergeEvent(null, object, (EventSource)this));
    }

    private <T> CompletionStage<T> fireMerge(MergeEvent event) {
        this.checkTransactionSynchStatus();
        this.checkNoUnresolvedActionsBeforeOperation();
        return this.fastSessionServices.eventListenerGroup_MERGE.fireEventOnEachListener((Object)event, l -> l::reactiveOnMerge).handle((v, e) -> {
            this.checkNoUnresolvedActionsAfterOperation();
            if (e instanceof ObjectDeletedException) {
                throw this.getExceptionConverter().convert((RuntimeException)new IllegalArgumentException((Throwable)e));
            }
            if (e instanceof MappingException) {
                throw this.getExceptionConverter().convert((RuntimeException)new IllegalArgumentException(e.getMessage(), (Throwable)e));
            }
            if (e instanceof RuntimeException) {
                throw this.getExceptionConverter().convert((RuntimeException)e);
            }
            return CompletionStages.returnOrRethrow(e, event.getResult());
        });
    }

    private CompletionStage<Void> fireMerge(MergeContext copiedAlready, MergeEvent event) {
        this.pulseTransactionCoordinator();
        return this.fastSessionServices.eventListenerGroup_MERGE.fireEventOnEachListener((Object)event, (Object)copiedAlready, l -> l::reactiveOnMerge).handle((v, e) -> {
            this.delayedAfterCompletion();
            if (e instanceof ObjectDeletedException) {
                throw this.getExceptionConverter().convert((RuntimeException)new IllegalArgumentException((Throwable)e));
            }
            if (e instanceof MappingException) {
                throw this.getExceptionConverter().convert((RuntimeException)new IllegalArgumentException(e.getMessage(), (Throwable)e));
            }
            if (e instanceof RuntimeException) {
                throw this.getExceptionConverter().convert((RuntimeException)e);
            }
            return (Void)CompletionStages.returnNullorRethrow(e);
        });
    }

    @Override
    public CompletionStage<Void> reactiveFlush() {
        this.checkOpen();
        return this.doFlush();
    }

    @Override
    public CompletionStage<Void> reactiveAutoflush() {
        return this.getHibernateFlushMode().lessThan(FlushMode.COMMIT) ? CompletionStages.voidFuture() : this.doFlush();
    }

    private CompletionStage<Void> doFlush() {
        this.checkTransactionNeededForUpdateOperation("no transaction is in progress");
        this.pulseTransactionCoordinator();
        if (this.getPersistenceContextInternal().getCascadeLevel() > 0) {
            throw log.flushDuringCascadeIsDangerous();
        }
        return this.fastSessionServices.eventListenerGroup_FLUSH.fireEventOnEachListener((Object)new FlushEvent((EventSource)this), l -> l::reactiveOnFlush).handle((v, e) -> {
            this.delayedAfterCompletion();
            if (e instanceof CompletionException && e.getCause() instanceof RuntimeException) {
                e = this.getExceptionConverter().convert((RuntimeException)e.getCause());
            }
            return (Void)CompletionStages.returnNullorRethrow(e);
        });
    }

    public ExceptionConverter getExceptionConverter() {
        if (this.exceptionConverter == null) {
            this.exceptionConverter = new ReactiveExceptionConverter((SharedSessionContractImplementor)this);
        }
        return this.exceptionConverter;
    }

    @Override
    public CompletionStage<Void> reactiveRefresh(Object entity, LockOptions lockOptions) {
        this.checkOpen();
        return this.fireRefresh(new RefreshEvent(entity, lockOptions, (EventSource)this));
    }

    @Override
    public CompletionStage<Void> reactiveRefresh(Object object, IdentitySet refreshedAlready) {
        this.checkOpenOrWaitingForAutoClose();
        return this.fireRefresh(refreshedAlready, new RefreshEvent(null, object, (EventSource)this));
    }

    CompletionStage<Void> fireRefresh(RefreshEvent event) {
        if (!this.getSessionFactory().getSessionFactoryOptions().isAllowRefreshDetachedEntity() && (event.getEntityName() != null ? !this.contains(event.getEntityName(), event.getObject()) : !this.contains(event.getObject()))) {
            throw new IllegalArgumentException("Entity not managed");
        }
        this.pulseTransactionCoordinator();
        return this.fastSessionServices.eventListenerGroup_REFRESH.fireEventOnEachListener((Object)event, l -> l::reactiveOnRefresh).handle((v, e) -> {
            this.delayedAfterCompletion();
            if (e instanceof RuntimeException) {
                if (!this.getSessionFactory().getSessionFactoryOptions().isJpaBootstrap() && e instanceof HibernateException) {
                    return (Void)CompletionStages.rethrow(e);
                }
                throw this.getExceptionConverter().convert((RuntimeException)e);
            }
            return (Void)CompletionStages.returnNullorRethrow(e);
        });
    }

    private CompletionStage<Void> fireRefresh(IdentitySet refreshedAlready, RefreshEvent event) {
        this.pulseTransactionCoordinator();
        return this.fastSessionServices.eventListenerGroup_REFRESH.fireEventOnEachListener((Object)event, (Object)refreshedAlready, l -> l::reactiveOnRefresh).handle((v, e) -> {
            this.delayedAfterCompletion();
            if (e instanceof RuntimeException) {
                throw this.getExceptionConverter().convert((RuntimeException)e);
            }
            return (Void)CompletionStages.returnNullorRethrow(e);
        });
    }

    @Override
    public CompletionStage<Void> reactiveLock(Object object, LockOptions lockOptions) {
        this.checkOpen();
        return this.fireLock(new LockEvent(object, lockOptions, (EventSource)this));
    }

    private CompletionStage<Void> fireLock(LockEvent event) {
        this.pulseTransactionCoordinator();
        return this.fastSessionServices.eventListenerGroup_LOCK.fireEventOnEachListener((Object)event, l -> l::reactiveOnLock).handle((v, e) -> {
            this.delayedAfterCompletion();
            if (e instanceof RuntimeException) {
                throw this.getExceptionConverter().convert((RuntimeException)e);
            }
            return (Void)CompletionStages.returnNullorRethrow(e);
        });
    }

    @Override
    public <T> CompletionStage<T> reactiveGet(Class<T> entityClass, Serializable id) {
        return new ReactiveIdentifierLoadAccessImpl<T>(entityClass).load(id);
    }

    @Override
    public <T> CompletionStage<T> reactiveFind(Class<T> entityClass, Object id, LockOptions lockOptions, EntityGraph<T> fetchGraph) {
        this.checkOpen();
        if (fetchGraph != null) {
            this.getLoadQueryInfluencers().getEffectiveEntityGraph().applyGraph((RootGraphImplementor)fetchGraph, GraphSemantic.FETCH);
        }
        ReactiveIdentifierLoadAccessImpl<T> loadAccess = new ReactiveIdentifierLoadAccessImpl<T>(entityClass).with(this.determineAppropriateLocalCacheMode(null)).with(lockOptions);
        return loadAccess.load((Serializable)id).handle((result, e) -> {
            if (e instanceof EntityNotFoundException) {
                return null;
            }
            if (e instanceof ObjectDeletedException) {
                return null;
            }
            if (e instanceof ObjectNotFoundException) {
                throw new IllegalArgumentException(e.getMessage(), (Throwable)e);
            }
            if (e instanceof MappingException || e instanceof TypeMismatchException || e instanceof ClassCastException) {
                throw this.getExceptionConverter().convert((RuntimeException)new IllegalArgumentException(e.getMessage(), (Throwable)e));
            }
            if (e instanceof JDBCException) {
                throw this.getExceptionConverter().convert((HibernateException)((JDBCException)e), lockOptions);
            }
            if (e instanceof RuntimeException) {
                throw this.getExceptionConverter().convert((RuntimeException)e, lockOptions);
            }
            return result;
        }).whenComplete((v, e) -> this.getLoadQueryInfluencers().getEffectiveEntityGraph().clear());
    }

    @Override
    public <T> CompletionStage<List<T>> reactiveFind(Class<T> entityClass, Object ... ids) {
        return new ReactiveMultiIdentifierLoadAccessImpl<T>(entityClass).multiLoad(ids);
    }

    @Override
    public <T> CompletionStage<T> reactiveFind(Class<T> entityClass, Map<String, Object> ids) {
        EntityPersister persister = this.getFactory().getMetamodel().locateEntityPersister(entityClass);
        return new NaturalIdLoadAccessImpl(persister).resolveNaturalId(ids).thenCompose(id -> this.reactiveFind(entityClass, id, null, null));
    }

    private CompletionStage<Void> fireLoad(LoadEvent event, LoadEventListener.LoadType loadType) {
        this.checkOpenOrWaitingForAutoClose();
        return this.fireLoadNoChecks(event, loadType).whenComplete((v, e) -> this.delayedAfterCompletion());
    }

    private CompletionStage<Void> fireLoadNoChecks(LoadEvent event, LoadEventListener.LoadType loadType) {
        this.pulseTransactionCoordinator();
        return this.fastSessionServices.eventListenerGroup_LOAD.fireEventOnEachListener((Object)event, (Object)loadType, l -> l::reactiveOnLoad);
    }

    private CompletionStage<Void> fireResolveNaturalId(ResolveNaturalIdEvent event) {
        this.checkOpenOrWaitingForAutoClose();
        return this.fastSessionServices.eventListenerGroup_RESOLVE_NATURAL_ID.fireEventOnEachListener((Object)event, l -> l::reactiveResolveNaturalId).whenComplete((c, e) -> this.delayedAfterCompletion());
    }

    protected void delayedAfterCompletion() {
    }

    public void afterOperation(boolean success) {
    }

    public void checkTransactionNeededForUpdateOperation(String exceptionMessage) {
    }

    private Boolean getReadOnlyFromLoadQueryInfluencers() {
        return this.getLoadQueryInfluencers().getReadOnly();
    }

    public <T> T unwrap(Class<T> clazz) {
        if (ReactiveSession.class.isAssignableFrom(clazz)) {
            return clazz.cast(this);
        }
        return (T)super.unwrap(clazz);
    }

    @Override
    public ReactiveConnection getReactiveConnection() {
        InternalStateAssertions.assertUseOnEventLoop();
        return this.reactiveConnection;
    }

    public void close() throws HibernateException {
        throw new UnsupportedOperationException("Non reactive close method called. Use 'reactiveClose()' instead.");
    }

    @Override
    public CompletionStage<Void> reactiveClose() {
        super.close();
        return this.reactiveConnection != null ? this.reactiveConnection.close() : CompletionStages.voidFuture();
    }

    public <T> RootGraphImplementor<T> createEntityGraph(Class<T> entity, String name) {
        RootGraphImplementor entityGraph = super.createEntityGraph(name);
        if (!entityGraph.getGraphedType().getJavaType().equals(entity)) {
            throw log.wrongEntityType();
        }
        return entityGraph;
    }

    public <T> RootGraphImplementor<T> createEntityGraph(Class<T> entity) {
        return super.createEntityGraph(entity);
    }

    public <T> RootGraphImplementor<T> getEntityGraph(Class<T> entity, String name) {
        RootGraphImplementor entityGraph = super.getEntityGraph(name);
        if (!entityGraph.getGraphedType().getJavaType().equals(entity)) {
            throw log.wrongEntityType();
        }
        return entityGraph;
    }

    @Override
    public Integer getBatchSize() {
        return this.getJdbcBatchSize();
    }

    @Override
    public void setBatchSize(Integer batchSize) {
        this.setJdbcBatchSize(batchSize);
        this.reactiveConnection = this.reactiveConnection.withBatchSize(batchSize);
    }

    @Override
    public <T> Class<? extends T> getEntityClass(T entity) {
        if (entity instanceof HibernateProxy) {
            return ((HibernateProxy)entity).getHibernateLazyInitializer().getPersistentClass();
        }
        return this.getEntityPersister(null, entity).getMappedClass();
    }

    @Override
    public Serializable getEntityId(Object entity) {
        if (entity instanceof HibernateProxy) {
            return ((HibernateProxy)entity).getHibernateLazyInitializer().getIdentifier();
        }
        return this.getEntityPersister(null, entity).getIdentifier(entity, (SharedSessionContractImplementor)this);
    }

    public void checkOpen() {
        this.threadCheck();
        super.checkOpen();
    }

    public void removeOrphanBeforeUpdates(String entityName, Object child) {
        throw new UnsupportedOperationException();
    }

    @Override
    public CompletionStage<Void> reactiveRemoveOrphanBeforeUpdates(String entityName, Object child) {
        StatefulPersistenceContext persistenceContext = (StatefulPersistenceContext)this.getPersistenceContextInternal();
        persistenceContext.beginRemoveOrphanBeforeUpdates();
        return this.fireRemove(new DeleteEvent(entityName, child, false, true, (EventSource)this)).thenAccept(v -> {
            persistenceContext.endRemoveOrphanBeforeUpdates();
            if (log.isTraceEnabled()) {
                this.logRemoveOrphanBeforeUpdates("end", entityName, child, persistenceContext);
            }
        });
    }

    private void logRemoveOrphanBeforeUpdates(String timing, String entityName, Object entity, StatefulPersistenceContext persistenceContext) {
        if (log.isTraceEnabled()) {
            EntityEntry entityEntry = persistenceContext.getEntry(entity);
            log.tracef("%s remove orphan before updates: [%s]", timing, entityEntry == null ? entityName : MessageHelper.infoString((String)entityName, (Serializable)entityEntry.getId()));
        }
    }

    private class NaturalIdLoadAccessImpl<T> {
        private final EntityPersister entityPersister;
        private LockOptions lockOptions;
        private boolean synchronizationEnabled = true;

        private NaturalIdLoadAccessImpl(EntityPersister entityPersister) {
            this.entityPersister = entityPersister;
            if (!entityPersister.hasNaturalIdentifier()) {
                throw log.entityDidNotDefinedNaturalId(entityPersister.getEntityName());
            }
        }

        public NaturalIdLoadAccessImpl<T> with(LockOptions lockOptions) {
            this.lockOptions = lockOptions;
            return this;
        }

        protected void synchronizationEnabled(boolean synchronizationEnabled) {
            this.synchronizationEnabled = synchronizationEnabled;
        }

        protected final CompletionStage<Serializable> resolveNaturalId(Map<String, Object> naturalIdParameters) {
            this.performAnyNeededCrossReferenceSynchronizations();
            ResolveNaturalIdEvent event = new ResolveNaturalIdEvent(naturalIdParameters, this.entityPersister, (EventSource)ReactiveSessionImpl.this);
            return ReactiveSessionImpl.this.fireResolveNaturalId(event).thenApply(v -> event.getEntityId() == PersistenceContext.NaturalIdHelper.INVALID_NATURAL_ID_REFERENCE ? null : event.getEntityId());
        }

        protected void performAnyNeededCrossReferenceSynchronizations() {
            if (!this.synchronizationEnabled) {
                return;
            }
            if (this.entityPersister.getEntityMetamodel().hasImmutableNaturalId()) {
                return;
            }
            if (!ReactiveSessionImpl.this.isTransactionInProgress()) {
                return;
            }
            PersistenceContext persistenceContext = ReactiveSessionImpl.this.getPersistenceContextInternal();
            for (Serializable pk : persistenceContext.getNaturalIdHelper().getCachedPkResolutions(this.entityPersister)) {
                EntityKey entityKey = ReactiveSessionImpl.this.generateEntityKey(pk, this.entityPersister);
                Object entity = persistenceContext.getEntity(entityKey);
                EntityEntry entry = persistenceContext.getEntry(entity);
                if (entry == null || !entry.requiresDirtyCheck(entity) || entry.getStatus() != Status.MANAGED) continue;
                persistenceContext.getNaturalIdHelper().handleSynchronization(this.entityPersister, pk, entity);
            }
        }

        protected final ReactiveIdentifierLoadAccessImpl getIdentifierLoadAccess() {
            ReactiveIdentifierLoadAccessImpl identifierLoadAccess = new ReactiveIdentifierLoadAccessImpl(this.entityPersister);
            if (this.lockOptions != null) {
                identifierLoadAccess.with(this.lockOptions);
            }
            return identifierLoadAccess;
        }

        protected EntityPersister entityPersister() {
            return this.entityPersister;
        }
    }

    private class ReactiveMultiIdentifierLoadAccessImpl<T>
    implements MultiLoadOptions {
        private final EntityPersister entityPersister;
        private LockOptions lockOptions;
        private CacheMode cacheMode;
        private RootGraphImplementor<T> rootGraph;
        private GraphSemantic graphSemantic;
        private Integer batchSize;
        private boolean sessionCheckingEnabled;
        private boolean returnOfDeletedEntitiesEnabled;
        private boolean orderedReturnEnabled = true;

        public ReactiveMultiIdentifierLoadAccessImpl(EntityPersister entityPersister) {
            this.entityPersister = entityPersister;
        }

        public ReactiveMultiIdentifierLoadAccessImpl(Class<T> entityClass) {
            this(reactiveSessionImpl.getFactory().getMetamodel().locateEntityPersister(entityClass));
        }

        public LockOptions getLockOptions() {
            return this.lockOptions;
        }

        public final ReactiveMultiIdentifierLoadAccessImpl<T> with(LockOptions lockOptions) {
            this.lockOptions = lockOptions;
            return this;
        }

        public ReactiveMultiIdentifierLoadAccessImpl<T> with(CacheMode cacheMode) {
            this.cacheMode = cacheMode;
            return this;
        }

        public ReactiveMultiIdentifierLoadAccessImpl<T> with(RootGraph<T> graph, GraphSemantic semantic) {
            this.rootGraph = (RootGraphImplementor)graph;
            this.graphSemantic = semantic;
            return this;
        }

        public Integer getBatchSize() {
            return this.batchSize;
        }

        public ReactiveMultiIdentifierLoadAccessImpl<T> withBatchSize(int batchSize) {
            this.batchSize = batchSize < 1 ? null : Integer.valueOf(batchSize);
            return this;
        }

        public boolean isSessionCheckingEnabled() {
            return this.sessionCheckingEnabled;
        }

        public boolean isSecondLevelCacheCheckingEnabled() {
            return this.cacheMode == CacheMode.NORMAL || this.cacheMode == CacheMode.GET;
        }

        public ReactiveMultiIdentifierLoadAccessImpl<T> enableSessionCheck(boolean enabled) {
            this.sessionCheckingEnabled = enabled;
            return this;
        }

        public boolean isReturnOfDeletedEntitiesEnabled() {
            return this.returnOfDeletedEntitiesEnabled;
        }

        public ReactiveMultiIdentifierLoadAccessImpl<T> enableReturnOfDeletedEntities(boolean enabled) {
            this.returnOfDeletedEntitiesEnabled = enabled;
            return this;
        }

        public boolean isOrderReturnEnabled() {
            return this.orderedReturnEnabled;
        }

        public ReactiveMultiIdentifierLoadAccessImpl<T> enableOrderedReturn(boolean enabled) {
            this.orderedReturnEnabled = enabled;
            return this;
        }

        public CompletionStage<List<T>> multiLoad(Object ... ids) {
            Serializable[] sids = new Serializable[ids.length];
            System.arraycopy(ids, 0, sids, 0, ids.length);
            return this.perform(() -> ((ReactiveEntityPersister)this.entityPersister).reactiveMultiLoad(sids, (SessionImplementor)ReactiveSessionImpl.this, this));
        }

        public CompletionStage<List<T>> perform(Supplier<CompletionStage<List<T>>> executor) {
            CacheMode sessionCacheMode = ReactiveSessionImpl.this.getCacheMode();
            boolean cacheModeChanged = false;
            if (this.cacheMode != null && this.cacheMode != sessionCacheMode) {
                ReactiveSessionImpl.this.setCacheMode(this.cacheMode);
                cacheModeChanged = true;
            }
            if (this.graphSemantic != null) {
                if (this.rootGraph == null) {
                    throw new IllegalArgumentException("Graph semantic specified, but no RootGraph was supplied");
                }
                ReactiveSessionImpl.this.getLoadQueryInfluencers().getEffectiveEntityGraph().applyGraph(this.rootGraph, this.graphSemantic);
            }
            boolean finalCacheModeChanged = cacheModeChanged;
            return executor.get().whenComplete((v, x) -> {
                if (this.graphSemantic != null) {
                    ReactiveSessionImpl.this.getLoadQueryInfluencers().getEffectiveEntityGraph().clear();
                }
                if (finalCacheModeChanged) {
                    ReactiveSessionImpl.this.setCacheMode(sessionCacheMode);
                }
            });
        }

        public <K extends Serializable> CompletionStage<List<T>> multiLoad(List<K> ids) {
            return this.perform(() -> (CompletionStage)((Object)this.entityPersister.multiLoad(ids.toArray(new Serializable[0]), (SharedSessionContractImplementor)ReactiveSessionImpl.this, (MultiLoadOptions)this)));
        }
    }

    private class ReactiveIdentifierLoadAccessImpl<T> {
        private final EntityPersister entityPersister;
        private LockOptions lockOptions;
        private CacheMode cacheMode;
        private RootGraphImplementor<T> rootGraph;
        private GraphSemantic graphSemantic;

        public ReactiveIdentifierLoadAccessImpl(EntityPersister entityPersister) {
            this.entityPersister = entityPersister;
        }

        public ReactiveIdentifierLoadAccessImpl(String entityName) {
            this(reactiveSessionImpl.getFactory().getMetamodel().locateEntityPersister(entityName));
        }

        public ReactiveIdentifierLoadAccessImpl(Class<T> entityClass) {
            this(reactiveSessionImpl.getFactory().getMetamodel().locateEntityPersister(entityClass));
        }

        public final ReactiveIdentifierLoadAccessImpl<T> with(LockOptions lockOptions) {
            this.lockOptions = lockOptions;
            return this;
        }

        public ReactiveIdentifierLoadAccessImpl<T> with(CacheMode cacheMode) {
            this.cacheMode = cacheMode;
            return this;
        }

        public ReactiveIdentifierLoadAccessImpl<T> with(RootGraph<T> graph, GraphSemantic semantic) {
            this.rootGraph = (RootGraphImplementor)graph;
            this.graphSemantic = semantic;
            return this;
        }

        public final CompletionStage<T> getReference(Serializable id) {
            return this.perform(() -> this.doGetReference(id));
        }

        protected CompletionStage<T> perform(Supplier<CompletionStage<T>> executor) {
            if (this.graphSemantic != null && this.rootGraph == null) {
                throw new IllegalArgumentException("Graph semantic specified, but no RootGraph was supplied");
            }
            CacheMode sessionCacheMode = ReactiveSessionImpl.this.getCacheMode();
            boolean cacheModeChanged = false;
            if (this.cacheMode != null && this.cacheMode != sessionCacheMode) {
                ReactiveSessionImpl.this.setCacheMode(this.cacheMode);
                cacheModeChanged = true;
            }
            if (this.graphSemantic != null) {
                ReactiveSessionImpl.this.getLoadQueryInfluencers().getEffectiveEntityGraph().applyGraph(this.rootGraph, this.graphSemantic);
            }
            boolean finalCacheModeChanged = cacheModeChanged;
            return executor.get().whenComplete((v, x) -> {
                if (this.graphSemantic != null) {
                    ReactiveSessionImpl.this.getLoadQueryInfluencers().getEffectiveEntityGraph().clear();
                }
                if (finalCacheModeChanged) {
                    ReactiveSessionImpl.this.setCacheMode(sessionCacheMode);
                }
            });
        }

        protected CompletionStage<T> doGetReference(Serializable id) {
            if (this.lockOptions != null) {
                LoadEvent event = new LoadEvent(id, this.entityPersister.getEntityName(), this.lockOptions, (EventSource)ReactiveSessionImpl.this, ReactiveSessionImpl.this.getReadOnlyFromLoadQueryInfluencers());
                return ReactiveSessionImpl.this.fireLoad(event, LoadEventListener.LOAD).thenApply(v -> event.getResult());
            }
            LoadEvent event = new LoadEvent(id, this.entityPersister.getEntityName(), false, (EventSource)ReactiveSessionImpl.this, ReactiveSessionImpl.this.getReadOnlyFromLoadQueryInfluencers());
            return ReactiveSessionImpl.this.fireLoad(event, LoadEventListener.LOAD).thenApply(v -> {
                if (event.getResult() == null) {
                    ReactiveSessionImpl.this.getFactory().getEntityNotFoundDelegate().handleEntityNotFound(this.entityPersister.getEntityName(), id);
                }
                return event.getResult();
            }).whenComplete((v, x) -> ReactiveSessionImpl.this.afterOperation(x != null));
        }

        public final CompletionStage<T> load(Serializable id) {
            return this.perform(() -> this.doLoad(id, LoadEventListener.GET));
        }

        protected final CompletionStage<T> doLoad(Serializable id, LoadEventListener.LoadType loadType) {
            if (id == null) {
                return CompletionStages.nullFuture();
            }
            if (this.lockOptions != null) {
                LoadEvent event = new LoadEvent(id, this.entityPersister.getEntityName(), this.lockOptions, (EventSource)ReactiveSessionImpl.this, ReactiveSessionImpl.this.getReadOnlyFromLoadQueryInfluencers());
                return ReactiveSessionImpl.this.fireLoad(event, loadType).thenApply(v -> event.getResult());
            }
            LoadEvent event = new LoadEvent(id, this.entityPersister.getEntityName(), false, (EventSource)ReactiveSessionImpl.this, ReactiveSessionImpl.this.getReadOnlyFromLoadQueryInfluencers());
            return ReactiveSessionImpl.this.fireLoad(event, loadType).whenComplete((v, t) -> ReactiveSessionImpl.this.afterOperation(t != null)).thenApply(v -> event.getResult());
        }
    }
}

