/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.reactive.session.impl;

import java.util.Collections;
import java.util.Map;
import org.hibernate.Filter;
import org.hibernate.boot.spi.MetadataImplementor;
import org.hibernate.boot.spi.SessionFactoryOptions;
import org.hibernate.engine.query.spi.HQLQueryPlan;
import org.hibernate.engine.query.spi.QueryPlanCache;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.internal.SessionFactoryImpl;
import org.hibernate.reactive.mutiny.Mutiny;
import org.hibernate.reactive.mutiny.impl.MutinySessionFactoryImpl;
import org.hibernate.reactive.session.impl.ObjectType;
import org.hibernate.reactive.session.impl.ReactiveHQLQueryPlan;
import org.hibernate.reactive.stage.Stage;
import org.hibernate.reactive.stage.impl.StageSessionFactoryImpl;
import org.hibernate.type.LocalDateTimeType;
import org.hibernate.type.LocalDateType;
import org.hibernate.type.LocalTimeType;
import org.hibernate.type.OffsetDateTimeType;

public class ReactiveSessionFactoryImpl
extends SessionFactoryImpl {
    public ReactiveSessionFactoryImpl(MetadataImplementor metadata, SessionFactoryOptions options) {
        super(metadata, options, new QueryPlanCache.QueryPlanCreator(){

            public HQLQueryPlan createQueryPlan(String queryString, boolean shallow, Map<String, Filter> enabledFilters, SessionFactoryImplementor factory) {
                return new ReactiveHQLQueryPlan(queryString, shallow, enabledFilters, factory);
            }
        });
        Map contributions = this.getMetamodel().getTypeConfiguration().getJdbcToHibernateTypeContributionMap();
        contributions.put(2014, Collections.singleton(OffsetDateTimeType.class.getName()));
        contributions.put(93, Collections.singleton(LocalDateTimeType.class.getName()));
        contributions.put(92, Collections.singleton(LocalTimeType.class.getName()));
        contributions.put(91, Collections.singleton(LocalDateType.class.getName()));
        contributions.put(2000, Collections.singleton(ObjectType.class.getName()));
    }

    public <T> T unwrap(Class<T> type) {
        if (type.isAssignableFrom(Stage.SessionFactory.class)) {
            return type.cast(new StageSessionFactoryImpl(this));
        }
        if (type.isAssignableFrom(Mutiny.SessionFactory.class)) {
            return type.cast(new MutinySessionFactoryImpl(this));
        }
        return (T)super.unwrap(type);
    }
}

