/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.reactive.session.impl;

import antlr.RecognitionException;
import antlr.collections.AST;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletionStage;
import org.hibernate.HibernateException;
import org.hibernate.engine.query.spi.EntityGraphQueryHint;
import org.hibernate.engine.spi.QueryParameters;
import org.hibernate.engine.spi.RowSelection;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.hql.internal.QueryExecutionRequestException;
import org.hibernate.hql.internal.ast.HqlSqlWalker;
import org.hibernate.hql.internal.ast.QuerySyntaxException;
import org.hibernate.hql.internal.ast.QueryTranslatorImpl;
import org.hibernate.hql.internal.ast.SqlGenerator;
import org.hibernate.hql.internal.ast.exec.MultiTableDeleteExecutor;
import org.hibernate.hql.internal.ast.exec.MultiTableUpdateExecutor;
import org.hibernate.hql.internal.ast.exec.StatementExecutor;
import org.hibernate.hql.internal.ast.tree.QueryNode;
import org.hibernate.internal.util.collections.IdentitySet;
import org.hibernate.loader.hql.QueryLoader;
import org.hibernate.param.ParameterSpecification;
import org.hibernate.reactive.bulk.StatementsWithParameters;
import org.hibernate.reactive.loader.hql.impl.ReactiveQueryLoader;
import org.hibernate.reactive.logging.impl.Log;
import org.hibernate.reactive.logging.impl.LoggerFactory;
import org.hibernate.reactive.pool.impl.Parameters;
import org.hibernate.reactive.session.ReactiveQueryExecutor;

public class ReactiveQueryTranslatorImpl<T>
extends QueryTranslatorImpl {
    private static final Log LOG = LoggerFactory.make(Log.class, MethodHandles.lookup());
    private final Parameters parameters;
    private ReactiveQueryLoader<T> queryLoader;
    private final SessionFactoryImplementor factory;

    public ReactiveQueryTranslatorImpl(String queryIdentifier, String query, Map enabledFilters, SessionFactoryImplementor factory) {
        super(queryIdentifier, query, enabledFilters, factory);
        this.factory = factory;
        this.parameters = Parameters.instance(factory.getJdbcServices().getDialect());
    }

    public ReactiveQueryTranslatorImpl(String queryIdentifier, String query, Map enabledFilters, SessionFactoryImplementor factory, EntityGraphQueryHint entityGraphQueryHint) {
        super(queryIdentifier, query, enabledFilters, factory, entityGraphQueryHint);
        this.factory = factory;
        this.parameters = Parameters.instance(factory.getJdbcServices().getDialect());
    }

    protected QueryLoader createQueryLoader(HqlSqlWalker w, SessionFactoryImplementor factory) {
        this.queryLoader = new ReactiveQueryLoader(this, factory, w.getSelectClause());
        return this.queryLoader;
    }

    @Deprecated
    public List<Object> list(SharedSessionContractImplementor session, QueryParameters queryParameters) throws HibernateException {
        throw new UnsupportedOperationException("Use #reactiveList instead");
    }

    public CompletionStage<List<T>> reactiveList(SharedSessionContractImplementor session, QueryParameters queryParameters) throws HibernateException {
        QueryParameters queryParametersToUse;
        boolean needsDistincting;
        this.errorIfDML();
        QueryNode query = (QueryNode)this.getSqlAST();
        boolean hasLimit = queryParameters.getRowSelection() != null && queryParameters.getRowSelection().definesLimits();
        boolean bl = needsDistincting = (query.getSelectClause().isDistinct() || this.getEntityGraphQueryHint() != null || hasLimit) && this.containsCollectionFetches();
        if (hasLimit && this.containsCollectionFetches()) {
            boolean fail = session.getFactory().getSessionFactoryOptions().isFailOnPaginationOverCollectionFetchEnabled();
            if (fail) {
                throw LOG.firstOrMaxResultsFailedBecausePaginationOverCollectionIsEnabled();
            }
            LOG.firstOrMaxResultsSpecifiedWithCollectionFetch();
            RowSelection selection = new RowSelection();
            selection.setFetchSize(queryParameters.getRowSelection().getFetchSize());
            selection.setTimeout(queryParameters.getRowSelection().getTimeout());
            queryParametersToUse = queryParameters.createCopyUsing(selection);
        } else {
            queryParametersToUse = queryParameters;
        }
        return this.queryLoader.reactiveList(session, queryParametersToUse).thenApply(results -> {
            if (needsDistincting) {
                int includedCount = -1;
                int first = !hasLimit || queryParameters.getRowSelection().getFirstRow() == null ? 0 : queryParameters.getRowSelection().getFirstRow();
                int max = !hasLimit || queryParameters.getRowSelection().getMaxRows() == null ? -1 : queryParameters.getRowSelection().getMaxRows();
                ArrayList tmp = new ArrayList();
                IdentitySet distinction = new IdentitySet();
                for (Object result : results) {
                    if (!distinction.add(result) || ++includedCount < first) continue;
                    tmp.add(result);
                    if (max < 0 || includedCount - first < max - 1) continue;
                    break;
                }
                return tmp;
            }
            return results;
        });
    }

    public CompletionStage<Integer> executeReactiveUpdate(QueryParameters queryParameters, ReactiveQueryExecutor session) {
        this.errorIfSelect();
        return this.getUpdateHandler().execute(session, queryParameters);
    }

    private String[] process(String[] sqlStatements, int paramLength) {
        String[] processed = new String[sqlStatements.length];
        for (int i = 0; i < processed.length; ++i) {
            processed[i] = this.parameters.process(sqlStatements[i], paramLength);
        }
        return processed;
    }

    private StatementsWithParameters getUpdateHandler() {
        final StatementExecutor executor = this.getStatementExecutor();
        if (executor instanceof MultiTableUpdateExecutor) {
            return (StatementsWithParameters)((MultiTableUpdateExecutor)executor).getUpdateHandler();
        }
        if (executor instanceof MultiTableDeleteExecutor) {
            return (StatementsWithParameters)((MultiTableDeleteExecutor)executor).getDeleteHandler();
        }
        return new StatementsWithParameters(){
            final ParameterSpecification[] parameterSpecifications;
            final String[] statements;
            {
                this.parameterSpecifications = ReactiveQueryTranslatorImpl.this.getCollectedParameterSpecifications().toArray(new ParameterSpecification[0]);
                this.statements = ReactiveQueryTranslatorImpl.this.process(executor.getSqlStatements(), this.parameterSpecifications.length);
            }

            @Override
            public String[] getSqlStatements() {
                return this.statements;
            }

            @Override
            public ParameterSpecification[][] getParameterSpecifications() {
                ParameterSpecification[][] result = new ParameterSpecification[this.statements.length][];
                Arrays.fill((Object[])result, this.parameterSpecifications);
                return result;
            }
        };
    }

    @Deprecated
    public int executeUpdate(QueryParameters queryParameters, SharedSessionContractImplementor session) {
        throw new UnsupportedOperationException("Use executeReactiveUpdate instead ");
    }

    public List<ParameterSpecification> getCollectedParameterSpecifications() {
        List parameterSpecifications = super.getCollectedParameterSpecifications();
        if (parameterSpecifications == null) {
            SqlGenerator gen = new SqlGenerator(this.factory);
            try {
                gen.statement((AST)this.getSqlAST());
                return gen.getCollectedParameters();
            }
            catch (RecognitionException e) {
                throw QuerySyntaxException.convert((RecognitionException)e);
            }
        }
        return parameterSpecifications;
    }

    private void errorIfSelect() throws HibernateException {
        if (!this.getSqlAST().needsExecutor()) {
            throw new QueryExecutionRequestException("Not supported for select queries", this.getQueryString());
        }
    }
}

