/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.reactive.session.impl;

import jakarta.persistence.EntityGraph;
import jakarta.persistence.Parameter;
import jakarta.persistence.criteria.ParameterExpression;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletionStage;
import org.hibernate.CacheMode;
import org.hibernate.FlushMode;
import org.hibernate.LockMode;
import org.hibernate.LockOptions;
import org.hibernate.engine.query.spi.EntityGraphQueryHint;
import org.hibernate.engine.query.spi.HQLQueryPlan;
import org.hibernate.engine.spi.QueryParameters;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.graph.GraphSemantic;
import org.hibernate.graph.RootGraph;
import org.hibernate.query.criteria.internal.compile.ExplicitParameterInfo;
import org.hibernate.query.criteria.internal.compile.InterpretedParameterMetadata;
import org.hibernate.query.internal.QueryImpl;
import org.hibernate.reactive.session.ReactiveQuery;
import org.hibernate.reactive.session.ReactiveQueryExecutor;
import org.hibernate.reactive.session.impl.QueryType;
import org.hibernate.reactive.session.impl.ReactiveHQLQueryPlan;
import org.hibernate.reactive.util.impl.CompletionStages;
import org.hibernate.transform.ResultTransformer;

public class ReactiveQueryImpl<R>
extends QueryImpl<R>
implements ReactiveQuery<R> {
    private EntityGraphQueryHint entityGraphQueryHint;
    private Map<ParameterExpression<?>, ExplicitParameterInfo<?>> explicitParameterInfoMap;
    private final QueryType type;

    private static QueryType queryType(String queryString) {
        return (queryString = queryString.trim().toLowerCase()).startsWith("insert") || queryString.startsWith("update") || queryString.startsWith("delete") ? QueryType.INSERT_UPDATE_DELETE : QueryType.SELECT;
    }

    public ReactiveQueryImpl(SharedSessionContractImplementor producer, HQLQueryPlan hqlQueryPlan, String queryString) {
        super(producer, hqlQueryPlan, queryString);
        this.type = ReactiveQueryImpl.queryType(queryString);
    }

    private String expandedQuery() {
        return this.getQueryParameterBindings().expandListValuedParameters(this.getQueryString(), this.getProducer());
    }

    @Override
    public void setParameterMetadata(InterpretedParameterMetadata parameterMetadata) {
        this.explicitParameterInfoMap = parameterMetadata.explicitParameterInfoMap();
    }

    @Override
    public CompletionStage<R> getReactiveSingleResult() {
        if (this.type != null && this.type != QueryType.SELECT) {
            throw new UnsupportedOperationException("not a select query");
        }
        return this.getReactiveResultList().thenApply(list -> ReactiveQuery.extractUniqueResult(list, this));
    }

    @Override
    public CompletionStage<R> getReactiveSingleResultOrNull() {
        if (this.type != null && this.type != QueryType.SELECT) {
            throw new UnsupportedOperationException("not a select query");
        }
        return this.getReactiveResultList().thenApply(list -> ReactiveQuery.extractUniqueResultOrNull(list, this));
    }

    @Override
    public CompletionStage<Integer> executeReactiveUpdate() {
        if (this.type != null && this.type != QueryType.INSERT_UPDATE_DELETE) {
            throw new UnsupportedOperationException("not an insert/update/delete query");
        }
        this.getProducer().checkTransactionNeededForUpdateOperation("Executing an update/delete query");
        this.beforeQuery();
        String expanded = this.expandedQuery();
        return this.reactiveProducer().executeReactiveUpdate(expanded, this.makeReactiveQueryParametersForExecution(expanded)).whenComplete((count, error) -> this.afterQuery()).handle((count, error) -> ReactiveQuery.convertQueryException(count, error, this));
    }

    @Override
    public CompletionStage<List<R>> getReactiveResultList() {
        if (this.type != null && this.type != QueryType.SELECT) {
            throw new UnsupportedOperationException("not a select query");
        }
        this.beforeQuery();
        return this.doReactiveList().whenComplete((list, err) -> this.afterQuery()).handle((count, error) -> ReactiveQuery.convertQueryException(count, error, this));
    }

    private CompletionStage<List<R>> doReactiveList() {
        if (this.getMaxResults() == 0) {
            return CompletionStages.completedFuture(Collections.emptyList());
        }
        String expanded = this.expandedQuery();
        return this.reactiveProducer().reactiveList(expanded, this.makeReactiveQueryParametersForExecution(expanded));
    }

    private ReactiveQueryExecutor reactiveProducer() {
        return (ReactiveQueryExecutor)this.getProducer();
    }

    private QueryParameters makeReactiveQueryParametersForExecution(String hql) {
        QueryParameters queryParameters = super.makeQueryParametersForExecution(hql);
        ReactiveHQLQueryPlan plan = new ReactiveHQLQueryPlan(hql, false, this.getProducer().getLoadQueryInfluencers().getEnabledFilters(), this.getProducer().getFactory(), this.entityGraphQueryHint);
        queryParameters.setQueryPlan(plan);
        return queryParameters;
    }

    public void applyEntityGraphQueryHint(EntityGraphQueryHint entityGraphQueryHint) {
        super.applyEntityGraphQueryHint(entityGraphQueryHint);
        this.entityGraphQueryHint = entityGraphQueryHint;
    }

    @Override
    public ReactiveQueryImpl<R> setParameter(int position, Object value) {
        super.setParameter(position, value);
        return this;
    }

    @Override
    public ReactiveQueryImpl<R> setParameter(String name, Object value) {
        super.setParameter(name, value);
        return this;
    }

    @Override
    public <P> ReactiveQueryImpl<R> setParameter(Parameter<P> parameter, P value) {
        if (this.explicitParameterInfoMap == null) {
            super.setParameter(parameter, value);
        } else {
            ExplicitParameterInfo<?> parameterInfo = this.resolveParameterInfo(parameter);
            if (parameterInfo.isNamed()) {
                this.setParameter(parameterInfo.getName(), value);
            } else {
                this.setParameter(parameterInfo.getPosition(), value);
            }
        }
        return this;
    }

    private <T> ExplicitParameterInfo<?> resolveParameterInfo(Parameter<T> param) {
        if (param instanceof ExplicitParameterInfo) {
            return (ExplicitParameterInfo)param;
        }
        if (param instanceof ParameterExpression) {
            return this.explicitParameterInfoMap.get(param);
        }
        for (ExplicitParameterInfo<?> parameterInfo : this.explicitParameterInfoMap.values()) {
            if (param.getName() != null && param.getName().equals(parameterInfo.getName())) {
                return parameterInfo;
            }
            if (param.getPosition() == null || !param.getPosition().equals(parameterInfo.getPosition())) continue;
            return parameterInfo;
        }
        throw new IllegalArgumentException("Unable to locate parameter [" + param + "] in query");
    }

    @Override
    public ReactiveQueryImpl<R> setMaxResults(int maxResults) {
        super.setMaxResults(maxResults);
        return this;
    }

    @Override
    public ReactiveQueryImpl<R> setFirstResult(int firstResult) {
        super.setFirstResult(firstResult);
        return this;
    }

    @Override
    public ReactiveQueryImpl<R> setReadOnly(boolean readOnly) {
        super.setReadOnly(readOnly);
        return this;
    }

    @Override
    public ReactiveQueryImpl<R> setComment(String comment) {
        super.setComment(comment);
        return this;
    }

    @Override
    public ReactiveQuery<R> setLockMode(LockMode lockMode) {
        boolean select;
        this.getProducer().checkOpen();
        if (!LockMode.NONE.equals((Object)lockMode) && !(select = this.getProducer().getFactory().getQueryPlanCache().getHQLQueryPlan(this.getQueryString(), false, Collections.emptyMap()).isSelect())) {
            throw new IllegalArgumentException("Lock mode is only supported for select queries: " + lockMode);
        }
        this.getLockOptions().setLockMode(lockMode);
        return this;
    }

    @Override
    public ReactiveQueryImpl<R> setLockOptions(LockOptions lockOptions) {
        super.setLockOptions(lockOptions);
        return this;
    }

    @Override
    public ReactiveQuery<R> setQueryHint(String hintName, Object value) {
        super.setHint(hintName, value);
        return this;
    }

    @Override
    public ReactiveQueryImpl<R> setLockMode(String alias, LockMode lockMode) {
        super.setLockMode(alias, lockMode);
        return this;
    }

    @Override
    public ReactiveQueryImpl<R> setCacheMode(CacheMode cacheMode) {
        super.setCacheMode(cacheMode);
        return this;
    }

    @Override
    public ReactiveQueryImpl<R> setHibernateFlushMode(FlushMode flushMode) {
        super.setHibernateFlushMode(flushMode);
        return this;
    }

    @Override
    public FlushMode getHibernateFlushMode() {
        return super.getHibernateFlushMode();
    }

    @Override
    public ReactiveQueryImpl<R> setResultTransformer(ResultTransformer resultTransformer) {
        super.setResultTransformer(resultTransformer);
        return this;
    }

    @Override
    public void setPlan(EntityGraph<R> entityGraph) {
        this.applyGraph((RootGraph)entityGraph, GraphSemantic.FETCH);
        this.applyEntityGraphQueryHint(new EntityGraphQueryHint(GraphSemantic.FETCH.getJpaHintName(), entityGraph));
    }

    @Override
    public ReactiveQueryImpl<R> setCacheable(boolean cacheable) {
        super.setCacheable(cacheable);
        return this;
    }

    @Override
    public ReactiveQueryImpl<R> setCacheRegion(String cacheRegion) {
        super.setCacheRegion(cacheRegion);
        return this;
    }

    @Override
    public ReactiveQuery<R> setQuerySpaces(String[] querySpaces) {
        throw new UnsupportedOperationException();
    }
}

