/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.reactive.session.impl;

import java.util.concurrent.CompletionStage;
import org.hibernate.action.internal.BulkOperationCleanupAction;
import org.hibernate.engine.query.spi.NativeSQLQueryPlan;
import org.hibernate.engine.spi.QueryParameters;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.loader.custom.CustomQuery;
import org.hibernate.param.ParameterBinder;
import org.hibernate.reactive.adaptor.impl.PreparedStatementAdaptor;
import org.hibernate.reactive.pool.impl.Parameters;
import org.hibernate.reactive.session.ReactiveQueryExecutor;

public class ReactiveNativeSQLQueryPlan
extends NativeSQLQueryPlan {
    private final String sourceQuery;
    private final CustomQuery customQuery;
    private Parameters parser;

    public ReactiveNativeSQLQueryPlan(String sourceQuery, CustomQuery customQuery) {
        super(sourceQuery, customQuery);
        this.sourceQuery = sourceQuery;
        this.customQuery = customQuery;
    }

    public int performExecuteUpdate(QueryParameters queryParameters, SharedSessionContractImplementor session) {
        throw new UnsupportedOperationException("Use performExecuteReactiveUpdate instead");
    }

    public CompletionStage<Integer> performExecuteReactiveUpdate(QueryParameters queryParameters, ReactiveQueryExecutor session) {
        SharedSessionContractImplementor sessionContract = session.getSharedContract();
        session.addBulkCleanupAction(new BulkOperationCleanupAction(session.getSharedContract(), this.getCustomQuery().getQuerySpaces()));
        if (queryParameters.isCallable()) {
            throw new IllegalArgumentException("callable not yet supported for native queries");
        }
        queryParameters.processFilters(this.customQuery.getSQL(), sessionContract);
        Object[] params = PreparedStatementAdaptor.bind(statement -> {
            int col = 1;
            for (ParameterBinder binder : this.customQuery.getParameterValueBinders()) {
                col += binder.bind(statement, queryParameters, sessionContract, col);
            }
        });
        boolean commentsEnabled = session.getFactory().getSessionFactoryOptions().isCommentsEnabled();
        String sql = session.getDialect().addSqlHintOrComment(queryParameters.getFilteredSQL(), queryParameters, commentsEnabled);
        sql = this.process(session, sql, params);
        return session.getReactiveConnection().update(sql, params);
    }

    private String process(ReactiveQueryExecutor session, String sql, Object[] params) {
        return Parameters.instance(session.getDialect()).process(sql, params.length);
    }
}

