/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.reactive.session.impl;

import jakarta.persistence.EntityGraph;
import jakarta.persistence.Parameter;
import java.util.List;
import java.util.concurrent.CompletionStage;
import org.hibernate.CacheMode;
import org.hibernate.FlushMode;
import org.hibernate.LockMode;
import org.hibernate.LockOptions;
import org.hibernate.engine.query.spi.sql.NativeSQLQueryReturn;
import org.hibernate.engine.query.spi.sql.NativeSQLQuerySpecification;
import org.hibernate.engine.spi.NamedSQLQueryDefinition;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.query.ParameterMetadata;
import org.hibernate.query.criteria.internal.compile.InterpretedParameterMetadata;
import org.hibernate.query.internal.NativeQueryImpl;
import org.hibernate.reactive.session.ReactiveNativeQuery;
import org.hibernate.reactive.session.ReactiveQuery;
import org.hibernate.reactive.session.ReactiveQueryExecutor;
import org.hibernate.transform.ResultTransformer;

public class ReactiveNativeQueryImpl<R>
extends NativeQueryImpl<R>
implements ReactiveNativeQuery<R> {
    public ReactiveNativeQueryImpl(NamedSQLQueryDefinition queryDef, SharedSessionContractImplementor session, ParameterMetadata parameterMetadata) {
        super(queryDef, session, parameterMetadata);
    }

    public ReactiveNativeQueryImpl(String sqlString, boolean callable, SharedSessionContractImplementor session, ParameterMetadata sqlParameterMetadata) {
        super(sqlString, callable, session, sqlParameterMetadata);
    }

    @Override
    public void setParameterMetadata(InterpretedParameterMetadata parameterMetadata) {
        throw new UnsupportedOperationException("not a JPA query");
    }

    @Override
    public ReactiveNativeQueryImpl<R> setResultTransformer(ResultTransformer nativeQueryTupleTransformer) {
        super.setResultTransformer(nativeQueryTupleTransformer);
        return this;
    }

    @Override
    public ReactiveNativeQueryImpl<R> addEntity(String alias, String name, LockMode read) {
        super.addEntity(alias, name, read);
        return this;
    }

    @Override
    public ReactiveNativeQueryImpl<R> setResultSetMapping(String name) {
        super.setResultSetMapping(name);
        return this;
    }

    @Override
    public CompletionStage<R> getReactiveSingleResult() {
        return this.getReactiveResultList().thenApply(list -> ReactiveQuery.extractUniqueResult(list, this));
    }

    @Override
    public CompletionStage<R> getReactiveSingleResultOrNull() {
        return this.getReactiveResultList().thenApply(list -> ReactiveQuery.extractUniqueResultOrNull(list, this));
    }

    @Override
    public CompletionStage<Integer> executeReactiveUpdate() {
        this.getProducer().checkTransactionNeededForUpdateOperation("Executing an update/delete query");
        this.beforeQuery();
        return this.reactiveProducer().executeReactiveUpdate(this.generateQuerySpecification(), this.getQueryParameters()).whenComplete((count, error) -> this.afterQuery()).handle((count, error) -> ReactiveQuery.convertQueryException(count, error, this));
    }

    @Override
    public CompletionStage<List<R>> getReactiveResultList() {
        this.beforeQuery();
        return this.reactiveProducer().reactiveList(this.generateQuerySpecification(), this.getQueryParameters()).whenComplete((list, err) -> this.afterQuery()).handle((list, error) -> ReactiveQuery.convertQueryException(list, error, this));
    }

    private NativeSQLQuerySpecification generateQuerySpecification() {
        return new NativeSQLQuerySpecification(this.getQueryParameterBindings().expandListValuedParameters(this.getQueryString(), this.getProducer()), this.getQueryReturns().toArray(new NativeSQLQueryReturn[0]), this.getSynchronizedQuerySpaces());
    }

    private ReactiveQueryExecutor reactiveProducer() {
        return (ReactiveQueryExecutor)this.getProducer();
    }

    @Override
    public ReactiveNativeQueryImpl<R> setParameter(int position, Object value) {
        super.setParameter(position, value);
        return this;
    }

    @Override
    public ReactiveNativeQueryImpl<R> setParameter(String name, Object value) {
        super.setParameter(name, value);
        return this;
    }

    @Override
    public <P> ReactiveNativeQueryImpl<R> setParameter(Parameter<P> parameter, P value) {
        super.setParameter(parameter, value);
        return this;
    }

    @Override
    public ReactiveNativeQueryImpl<R> setMaxResults(int maxResults) {
        super.setMaxResults(maxResults);
        return this;
    }

    @Override
    public ReactiveNativeQueryImpl<R> setFirstResult(int firstResult) {
        super.setFirstResult(firstResult);
        return this;
    }

    @Override
    public ReactiveNativeQueryImpl<R> setReadOnly(boolean readOnly) {
        super.setReadOnly(readOnly);
        return this;
    }

    @Override
    public ReactiveNativeQueryImpl<R> setComment(String comment) {
        super.setComment(comment);
        return this;
    }

    @Override
    public ReactiveQuery<R> setLockMode(LockMode lockMode) {
        this.setLockOptions(new LockOptions(lockMode));
        return this;
    }

    @Override
    public ReactiveNativeQueryImpl<R> setLockOptions(LockOptions lockOptions) {
        super.setLockOptions(lockOptions);
        return this;
    }

    @Override
    public ReactiveQuery<R> setQueryHint(String hintName, Object value) {
        super.setHint(hintName, value);
        return this;
    }

    @Override
    public ReactiveNativeQueryImpl<R> setLockMode(String alias, LockMode lockMode) {
        super.setLockMode(alias, lockMode);
        return this;
    }

    @Override
    public ReactiveNativeQueryImpl<R> setCacheMode(CacheMode cacheMode) {
        super.setCacheMode(cacheMode);
        return this;
    }

    @Override
    public FlushMode getHibernateFlushMode() {
        return super.getHibernateFlushMode();
    }

    @Override
    public ReactiveNativeQueryImpl<R> setHibernateFlushMode(FlushMode flushMode) {
        super.setHibernateFlushMode(flushMode);
        return this;
    }

    @Override
    public void setPlan(EntityGraph<R> entityGraph) {
        throw new UnsupportedOperationException("native SQL query cannot have a fetch plan");
    }

    @Override
    public ReactiveNativeQueryImpl<R> setCacheable(boolean cacheable) {
        super.setCacheable(cacheable);
        return this;
    }

    @Override
    public ReactiveNativeQueryImpl<R> setCacheRegion(String cacheRegion) {
        super.setCacheRegion(cacheRegion);
        return this;
    }

    @Override
    public ReactiveNativeQueryImpl<R> setQuerySpaces(String[] querySpaces) {
        super.addQuerySpaces(querySpaces);
        return this;
    }
}

