/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.reactive.session.impl;

import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.atomic.AtomicInteger;
import org.hibernate.Filter;
import org.hibernate.HibernateException;
import org.hibernate.action.internal.BulkOperationCleanupAction;
import org.hibernate.engine.query.spi.EntityGraphQueryHint;
import org.hibernate.engine.query.spi.HQLQueryPlan;
import org.hibernate.engine.spi.QueryParameters;
import org.hibernate.engine.spi.RowSelection;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.hql.spi.QueryTranslator;
import org.hibernate.internal.util.collections.IdentitySet;
import org.hibernate.reactive.logging.impl.Log;
import org.hibernate.reactive.logging.impl.LoggerFactory;
import org.hibernate.reactive.session.ReactiveQueryExecutor;
import org.hibernate.reactive.session.impl.ReactiveQueryTranslatorImpl;
import org.hibernate.reactive.util.impl.CompletionStages;

class ReactiveHQLQueryPlan<T>
extends HQLQueryPlan {
    private static final Log log = LoggerFactory.make(Log.class, MethodHandles.lookup());

    public ReactiveHQLQueryPlan(String hql, boolean shallow, Map<String, Filter> enabledFilters, SessionFactoryImplementor factory) {
        super(hql, shallow, enabledFilters, factory);
    }

    public ReactiveHQLQueryPlan(String hql, boolean shallow, Map<String, Filter> enabledFilters, SessionFactoryImplementor factory, EntityGraphQueryHint entityGraphQueryHint) {
        super(hql, shallow, enabledFilters, factory, entityGraphQueryHint);
    }

    public ReactiveHQLQueryPlan(String hql, String collectionRole, boolean shallow, Map<String, Filter> enabledFilters, SessionFactoryImplementor factory, EntityGraphQueryHint entityGraphQueryHint) {
        super(hql, collectionRole, shallow, enabledFilters, factory, entityGraphQueryHint);
    }

    @Deprecated
    public List<Object> performList(QueryParameters queryParameters, SharedSessionContractImplementor session) {
        throw new UnsupportedOperationException("Use performReactiveList instead");
    }

    public int performExecuteUpdate(QueryParameters queryParameters, SharedSessionContractImplementor session) {
        throw new UnsupportedOperationException("Use performExecuteReactiveUpdate instead");
    }

    public CompletionStage<List<T>> performReactiveList(QueryParameters queryParameters, SharedSessionContractImplementor session) throws HibernateException {
        QueryParameters queryParametersToUse;
        boolean needsLimit;
        if (log.isTraceEnabled()) {
            log.tracev("Find: {0}", this.getSourceQuery());
            queryParameters.traceParameters(session.getFactory());
        }
        QueryTranslator[] translators = this.getTranslators();
        RowSelection rowSelection = queryParameters.getRowSelection();
        boolean hasLimit = rowSelection != null && rowSelection.definesLimits();
        boolean bl = needsLimit = hasLimit && translators.length > 1;
        if (needsLimit) {
            log.needsLimit();
            RowSelection selection = new RowSelection();
            selection.setFetchSize(queryParameters.getRowSelection().getFetchSize());
            selection.setTimeout(queryParameters.getRowSelection().getTimeout());
            queryParametersToUse = queryParameters.createCopyUsing(selection);
        } else {
            queryParametersToUse = queryParameters;
        }
        if (translators.length == 1) {
            return this.translator(translators[0]).reactiveList(session, queryParametersToUse);
        }
        int guessedResultSize = this.guessResultSize(rowSelection);
        ArrayList combinedResults = new ArrayList(guessedResultSize);
        IdentitySet distinction = needsLimit ? new IdentitySet(guessedResultSize) : null;
        AtomicInteger includedCount = new AtomicInteger();
        return CompletionStages.loop(translators, translator -> this.translator((QueryTranslator)translator).reactiveList(session, queryParametersToUse).thenAccept(tmpList -> {
            if (needsLimit) {
                this.needsLimitLoop(queryParameters, combinedResults, distinction, includedCount, (List<T>)tmpList);
            } else {
                combinedResults.addAll(tmpList);
            }
        })).thenApply(v -> combinedResults);
    }

    private void needsLimitLoop(QueryParameters queryParameters, List<T> combinedResults, IdentitySet distinction, AtomicInteger includedCount, List<T> tmpList) {
        RowSelection rowSelection = queryParameters.getRowSelection();
        int first = rowSelection.getFirstRow() == null ? 0 : rowSelection.getFirstRow();
        int max = rowSelection.getMaxRows() == null ? -1 : rowSelection.getMaxRows();
        for (T result : tmpList) {
            int included;
            if (!distinction.add(result) || (included = includedCount.getAndIncrement()) < first) continue;
            combinedResults.add(result);
            if (max < 0 || included <= max) continue;
            return;
        }
    }

    public CompletionStage<Integer> performExecuteReactiveUpdate(QueryParameters queryParameters, ReactiveQueryExecutor session) {
        QueryTranslator[] translators;
        if (log.isTraceEnabled()) {
            log.tracev("Execute update: {0}", this.getSourceQuery());
            queryParameters.traceParameters(session.getFactory());
        }
        if ((translators = this.getTranslators()).length != 1) {
            log.splitQueries(this.getSourceQuery(), translators.length);
        }
        return CompletionStages.total(translators, translator -> {
            session.addBulkCleanupAction(new BulkOperationCleanupAction(session.getSharedContract(), translator.getQuerySpaces()));
            return this.translator((QueryTranslator)translator).executeReactiveUpdate(queryParameters, session);
        });
    }

    private ReactiveQueryTranslatorImpl<T> translator(QueryTranslator translator) {
        return (ReactiveQueryTranslatorImpl)translator;
    }
}

