/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.reactive.session.impl;

import jakarta.persistence.TypedQuery;
import jakarta.persistence.criteria.ParameterExpression;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.hibernate.dialect.Dialect;
import org.hibernate.engine.jdbc.spi.JdbcServices;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.internal.util.collections.Stack;
import org.hibernate.internal.util.collections.StandardStack;
import org.hibernate.query.criteria.LiteralHandlingMode;
import org.hibernate.query.criteria.internal.compile.ExplicitParameterInfo;
import org.hibernate.query.criteria.internal.compile.ImplicitParameterBinding;
import org.hibernate.query.criteria.internal.compile.InterpretedParameterMetadata;
import org.hibernate.query.criteria.internal.compile.RenderingContext;
import org.hibernate.query.criteria.internal.expression.function.FunctionExpression;
import org.hibernate.sql.ast.Clause;
import org.hibernate.type.Type;
import org.hibernate.type.TypeResolver;

public class CriteriaQueryRenderingContext
implements RenderingContext,
InterpretedParameterMetadata {
    private final Map<ParameterExpression<?>, ExplicitParameterInfo<?>> explicitParameterInfoMap = new HashMap();
    private final List<ImplicitParameterBinding> implicitParameterBindings = new ArrayList<ImplicitParameterBinding>();
    private int aliasCount;
    private int explicitParameterCount;
    private final Stack<Clause> clauseStack = new StandardStack();
    private final Stack<FunctionExpression> functionContextStack = new StandardStack();
    private final Dialect dialect;
    private final TypeResolver typeResolver;

    public CriteriaQueryRenderingContext(SessionFactoryImplementor sessionFactory) {
        this.dialect = ((JdbcServices)sessionFactory.getServiceRegistry().getService(JdbcServices.class)).getDialect();
        this.typeResolver = sessionFactory.getTypeResolver();
    }

    public Dialect getDialect() {
        return this.dialect;
    }

    public LiteralHandlingMode getCriteriaLiteralHandlingMode() {
        return LiteralHandlingMode.INLINE;
    }

    public Map<ParameterExpression<?>, ExplicitParameterInfo<?>> explicitParameterInfoMap() {
        return this.explicitParameterInfoMap;
    }

    public List<ImplicitParameterBinding> implicitParameterBindings() {
        return this.implicitParameterBindings;
    }

    public String generateAlias() {
        return "generatedAlias" + this.aliasCount++;
    }

    public String generateParameterName() {
        return "param" + this.explicitParameterCount++;
    }

    public Stack<Clause> getClauseStack() {
        return this.clauseStack;
    }

    public Stack<FunctionExpression> getFunctionStack() {
        return this.functionContextStack;
    }

    public ExplicitParameterInfo<?> registerExplicitParameter(ParameterExpression<?> criteriaQueryParameter) {
        ExplicitParameterInfo parameterInfo = this.explicitParameterInfoMap.get(criteriaQueryParameter);
        if (parameterInfo == null) {
            parameterInfo = StringHelper.isNotEmpty((String)criteriaQueryParameter.getName()) ? new ExplicitParameterInfo(criteriaQueryParameter.getName(), null, criteriaQueryParameter.getJavaType()) : (criteriaQueryParameter.getPosition() != null ? new ExplicitParameterInfo(null, criteriaQueryParameter.getPosition(), criteriaQueryParameter.getJavaType()) : new ExplicitParameterInfo(this.generateParameterName(), null, criteriaQueryParameter.getJavaType()));
            this.explicitParameterInfoMap.put(criteriaQueryParameter, parameterInfo);
        }
        return parameterInfo;
    }

    public String registerLiteralParameterBinding(final Object literal, final Class javaType) {
        ImplicitParameterBinding binding = new ImplicitParameterBinding(){
            final String parameterName;
            {
                this.parameterName = CriteriaQueryRenderingContext.this.generateParameterName();
            }

            public String getParameterName() {
                return this.parameterName;
            }

            public Class<?> getJavaType() {
                return javaType;
            }

            public void bind(TypedQuery typedQuery) {
                typedQuery.setParameter(this.parameterName, literal);
            }
        };
        this.implicitParameterBindings.add(binding);
        return binding.getParameterName();
    }

    public String getCastType(Class javaType) {
        Type hibernateType = this.typeResolver.heuristicType(javaType.getName());
        if (hibernateType == null) {
            throw new IllegalArgumentException("Could not convert java type [" + javaType.getName() + "] to Hibernate type");
        }
        return hibernateType.getName();
    }
}

