/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.reactive.session;

import jakarta.persistence.EntityGraph;
import jakarta.persistence.NoResultException;
import jakarta.persistence.Parameter;
import java.util.List;
import java.util.concurrent.CompletionStage;
import org.hibernate.CacheMode;
import org.hibernate.FlushMode;
import org.hibernate.HibernateException;
import org.hibernate.Incubating;
import org.hibernate.LockMode;
import org.hibernate.LockOptions;
import org.hibernate.TypeMismatchException;
import org.hibernate.hql.internal.QueryExecutionRequestException;
import org.hibernate.query.criteria.internal.compile.InterpretedParameterMetadata;
import org.hibernate.query.internal.AbstractProducedQuery;
import org.hibernate.reactive.util.impl.CompletionStages;
import org.hibernate.transform.ResultTransformer;
import org.hibernate.type.Type;

@Incubating
public interface ReactiveQuery<R> {
    public void setParameterMetadata(InterpretedParameterMetadata var1);

    public CompletionStage<R> getReactiveSingleResult();

    public CompletionStage<List<R>> getReactiveResultList();

    public CompletionStage<R> getReactiveSingleResultOrNull();

    public CompletionStage<Integer> executeReactiveUpdate();

    public ReactiveQuery<R> setParameter(int var1, Object var2);

    public ReactiveQuery<R> setParameter(String var1, Object var2);

    public <T> ReactiveQuery<R> setParameter(Parameter<T> var1, T var2);

    public ReactiveQuery<R> setMaxResults(int var1);

    public ReactiveQuery<R> setFirstResult(int var1);

    public int getMaxResults();

    public int getFirstResult();

    public ReactiveQuery<R> setReadOnly(boolean var1);

    public boolean isReadOnly();

    public ReactiveQuery<R> setComment(String var1);

    public ReactiveQuery<R> setQueryHint(String var1, Object var2);

    public ReactiveQuery<R> setLockMode(LockMode var1);

    public ReactiveQuery<R> setLockMode(String var1, LockMode var2);

    public ReactiveQuery<R> setLockOptions(LockOptions var1);

    public ReactiveQuery<R> setCacheMode(CacheMode var1);

    public CacheMode getCacheMode();

    public FlushMode getHibernateFlushMode();

    public ReactiveQuery<R> setHibernateFlushMode(FlushMode var1);

    public ReactiveQuery<R> setResultTransformer(ResultTransformer var1);

    public Type[] getReturnTypes();

    public static <T> T convertQueryException(T result, Throwable e, AbstractProducedQuery<?> query) {
        if (e instanceof QueryExecutionRequestException) {
            throw new IllegalStateException(e);
        }
        if (e instanceof TypeMismatchException) {
            throw new IllegalStateException(e);
        }
        if (e instanceof HibernateException) {
            throw query.getProducer().getExceptionConverter().convert((HibernateException)e, query.getLockOptions());
        }
        return CompletionStages.returnOrRethrow(e, result);
    }

    public static <R> R extractUniqueResult(List<R> list, AbstractProducedQuery<R> query) {
        try {
            if (list.isEmpty()) {
                throw new NoResultException("No entity found for query");
            }
            return (R)AbstractProducedQuery.uniqueElement(list);
        }
        catch (HibernateException e) {
            throw query.getProducer().getExceptionConverter().convert(e, query.getLockOptions());
        }
    }

    public static <R> R extractUniqueResultOrNull(List<R> list, AbstractProducedQuery<R> query) {
        try {
            if (list.isEmpty()) {
                return null;
            }
            return (R)AbstractProducedQuery.uniqueElement(list);
        }
        catch (HibernateException e) {
            throw query.getProducer().getExceptionConverter().convert(e, query.getLockOptions());
        }
    }

    public void setPlan(EntityGraph<R> var1);

    public ReactiveQuery<R> setCacheable(boolean var1);

    public boolean isCacheable();

    public ReactiveQuery<R> setCacheRegion(String var1);

    public String getCacheRegion();

    public ReactiveQuery<R> setQuerySpaces(String[] var1);
}

