/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.reactive.provider.service;

import java.sql.SQLException;
import java.util.ArrayList;
import org.hibernate.boot.model.naming.Identifier;
import org.hibernate.cfg.NotYetImplementedException;
import org.hibernate.reactive.provider.service.AbstractReactiveInformationSchemaBasedExtractorImpl;
import org.hibernate.tool.schema.extract.spi.ExtractionContext;

public class SqlServerReactiveInformationExtractorImpl
extends AbstractReactiveInformationSchemaBasedExtractorImpl {
    public SqlServerReactiveInformationExtractorImpl(ExtractionContext extractionContext) {
        super(extractionContext);
    }

    @Override
    protected <T> T processTableResultSet(String catalog, String schemaPattern, String tableNamePattern, String[] types, ExtractionContext.ResultSetProcessor<T> processor) throws SQLException {
        StringBuilder sb = new StringBuilder().append("select t.table_catalog as ").append(this.getResultSetCatalogLabel()).append(" , OBJECT_SCHEMA_NAME( o.object_id ) as ").append(this.getResultSetSchemaLabel()).append(" , t.table_name as ").append(this.getResultSetTableNameLabel()).append(" , t.table_type as ").append(this.getResultSetTableTypeLabel()).append(" , null as ").append(this.getResultSetRemarksLabel()).append(" from information_schema.tables t inner join sys.objects o").append(" on t.table_name = o.name ").append(" and ( ( t.table_type = 'BASE TABLE' and o.type = 'U' ) or ( t.table_type = 'VIEW' and o.type = 'V' ) )").append(" where 1 = 1");
        ArrayList<Object> parameterValues = new ArrayList<Object>();
        this.appendClauseAndParameterIfNotNullOrEmpty(" and t.table_catalog = ", catalog, sb, parameterValues);
        this.appendClauseAndParameterIfNotNullOrEmpty(" and OBJECT_SCHEMA_NAME( o.object_id ) like ", schemaPattern, sb, parameterValues);
        this.appendClauseAndParameterIfNotNullOrEmpty(" and t.table_name like ", tableNamePattern, sb, parameterValues);
        if (types != null && types.length > 0) {
            this.appendClauseAndParameterIfNotNullOrEmpty(" and t.table_type in ( ", types[0].equals("TABLE") ? this.getResultSetTableTypesPhysicalTableConstant() : types[0], sb, parameterValues);
            for (int i = 1; i < types.length; ++i) {
                this.appendClauseAndParameterIfNotNullOrEmpty(", ", types[i].equals("TABLE") ? this.getResultSetTableTypesPhysicalTableConstant() : types[i], sb, parameterValues);
            }
            sb.append(" ) ");
        }
        return (T)this.getExtractionContext().getQueryResults(sb.toString(), parameterValues.toArray(), processor);
    }

    @Override
    protected <T> T processColumnsResultSet(String catalog, String schemaPattern, String tableNamePattern, String columnNamePattern, ExtractionContext.ResultSetProcessor<T> processor) throws SQLException {
        StringBuilder sb = new StringBuilder().append("select c.table_name as ").append(this.getResultSetTableNameLabel()).append(", c.column_name as ").append(this.getResultSetColumnNameLabel()).append(", c.").append(this.getInformationSchemaColumnsDataTypeColumn()).append(" as ").append(this.getResultSetTypeNameLabel()).append(", null as ").append(this.getResultSetColumnSizeLabel()).append(", null as ").append(this.getResultSetDecimalDigitsLabel()).append(", c.is_nullable as ").append(this.getResultSetIsNullableLabel()).append(", null as ").append(this.getResultSetSqlTypeCodeLabel()).append(" from information_schema.columns c inner join sys.objects o").append(" on c.table_name = o.name and o.type in ( 'U', 'V' ) ").append(" where 1 = 1");
        ArrayList<Object> parameterValues = new ArrayList<Object>();
        this.appendClauseAndParameterIfNotNullOrEmpty(" and c.table_catalog = ", catalog, sb, parameterValues);
        this.appendClauseAndParameterIfNotNullOrEmpty(" and OBJECT_SCHEMA_NAME( o.object_id ) like ", schemaPattern, sb, parameterValues);
        this.appendClauseAndParameterIfNotNullOrEmpty(" and c.table_name like ", tableNamePattern, sb, parameterValues);
        sb.append(" order by c.table_catalog, OBJECT_SCHEMA_NAME( o.object_id ), c.table_name, c.column_name, c.ordinal_position");
        return (T)this.getExtractionContext().getQueryResults(sb.toString(), parameterValues.toArray(), processor);
    }

    protected <T> T processPrimaryKeysResultSet(String catalogFilter, String schemaFilter, Identifier tableName, ExtractionContext.ResultSetProcessor<T> processor) throws SQLException {
        throw new NotYetImplementedException();
    }

    protected <T> T processIndexInfoResultSet(String catalog, String schema, String table, boolean unique, boolean approximate, ExtractionContext.ResultSetProcessor<T> processor) throws SQLException {
        StringBuilder sb = new StringBuilder().append("select i.name as ").append(this.getResultSetIndexNameLabel()).append(" , i.type as ").append(this.getResultSetIndexTypeLabel()).append(" , COL_NAME(ic.object_id, ic.column_id) as ").append(this.getResultSetColumnNameLabel()).append(" from sys.indexes i inner join sys.index_columns ic").append(" on ic.object_id = i.object_id and ic.index_id = i.index_id").append(" where i.index_id > 0").append(" and i.type in (1, 2)").append(" and i.is_primary_key = 0");
        ArrayList<Object> parameterValues = new ArrayList<Object>();
        this.appendClauseAndParameterIfNotNullOrEmpty(" and DB_NAME() = ", catalog, sb, parameterValues);
        this.appendClauseAndParameterIfNotNullOrEmpty(" and OBJECT_NAME( i.object_id ) = ", table, sb, parameterValues);
        this.appendClauseAndParameterIfNotNullOrEmpty(" and OBJECT_SCHEMA_NAME( i.object_id) = ", schema, sb, parameterValues);
        if (unique) {
            sb.append(" and i.is_unique_constraint = true");
        }
        sb.append(" order by OBJECT_SCHEMA_NAME( i.object_id), OBJECT_NAME( i.object_id ), ic.key_ordinal");
        Object result = this.getExtractionContext().getQueryResults(sb.toString(), parameterValues.toArray(), processor);
        return (T)result;
    }

    protected <T> T processImportedKeysResultSet(String catalog, String schema, String table, ExtractionContext.ResultSetProcessor<T> processor) throws SQLException {
        StringBuilder sb = new StringBuilder().append("select OBJECT_NAME( constraint_object_id ) as ").append(this.getResultSetForeignKeyLabel()).append(", DB_NAME() as ").append(this.getResultSetPrimaryKeyCatalogLabel()).append(", OBJECT_SCHEMA_NAME( referenced_object_id ) as ").append(this.getResultSetPrimaryKeySchemaLabel()).append(", OBJECT_NAME( referenced_object_id ) as ").append(this.getResultSetPrimaryKeyTableLabel()).append(", COL_NAME( parent_object_id, parent_column_id ) as ").append(this.getResultSetForeignKeyColumnNameLabel()).append(", COL_NAME( referenced_object_id, referenced_column_id) as ").append(this.getResultSetPrimaryKeyColumnNameLabel()).append(" from sys.foreign_key_columns").append(" where 1 = 1");
        ArrayList<Object> parameters = new ArrayList<Object>();
        ArrayList<String> orderByList = new ArrayList<String>();
        if (this.appendClauseAndParameterIfNotNullOrEmpty(" and DB_NAME() = ", catalog, sb, parameters)) {
            orderByList.add("DB_NAME()");
        }
        if (this.appendClauseAndParameterIfNotNullOrEmpty(" and OBJECT_SCHEMA_NAME( parent_object_id ) = ", schema, sb, parameters)) {
            orderByList.add("OBJECT_SCHEMA_NAME( parent_object_id )");
        }
        if (this.appendClauseAndParameterIfNotNullOrEmpty(" and OBJECT_NAME( parent_object_id ) = ", table, sb, parameters)) {
            orderByList.add("OBJECT_NAME( parent_object_id )");
        }
        orderByList.add("constraint_column_id");
        if (orderByList.size() > 0) {
            sb.append(" order by ").append((String)orderByList.get(0));
            for (int i = 1; i < orderByList.size(); ++i) {
                sb.append(", ").append((String)orderByList.get(i));
            }
        }
        return (T)this.getExtractionContext().getQueryResults(sb.toString(), parameters.toArray(), processor);
    }

    @Override
    protected int dataTypeCode(String typeName) {
        if (typeName.equalsIgnoreCase("float") || typeName.toLowerCase().startsWith("double")) {
            return 8;
        }
        return super.dataTypeCode(typeName);
    }
}

