/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.reactive.provider.service;

import org.hibernate.boot.model.relational.SqlStringGenerationContext;
import org.hibernate.cfg.NotYetImplementedException;
import org.hibernate.dialect.CockroachDB201Dialect;
import org.hibernate.dialect.Dialect;
import org.hibernate.dialect.MariaDB103Dialect;
import org.hibernate.dialect.MySQL8Dialect;
import org.hibernate.dialect.Oracle12cDialect;
import org.hibernate.dialect.PostgreSQL10Dialect;
import org.hibernate.dialect.SQLServer2012Dialect;
import org.hibernate.engine.jdbc.env.spi.JdbcEnvironment;
import org.hibernate.reactive.provider.service.MySqlReactiveInformationExtractorImpl;
import org.hibernate.reactive.provider.service.OracleSqlReactiveInformationExtractorImpl;
import org.hibernate.reactive.provider.service.PostgreSqlReactiveInformationExtractorImpl;
import org.hibernate.reactive.provider.service.ReactiveGenerationTarget;
import org.hibernate.reactive.provider.service.ReactiveImprovedExtractionContextImpl;
import org.hibernate.reactive.provider.service.SqlServerReactiveInformationExtractorImpl;
import org.hibernate.resource.transaction.spi.DdlTransactionIsolator;
import org.hibernate.service.ServiceRegistry;
import org.hibernate.service.spi.ServiceRegistryImplementor;
import org.hibernate.tool.schema.extract.spi.ExtractionContext;
import org.hibernate.tool.schema.extract.spi.InformationExtractor;
import org.hibernate.tool.schema.internal.HibernateSchemaManagementTool;
import org.hibernate.tool.schema.spi.ExtractionTool;

public class ReactiveSchemaManagementTool
extends HibernateSchemaManagementTool {
    public void injectServices(ServiceRegistryImplementor serviceRegistry) {
        super.injectServices(serviceRegistry);
        this.setCustomDatabaseGenerationTarget(new ReactiveGenerationTarget((ServiceRegistry)serviceRegistry));
    }

    public ExtractionTool getExtractionTool() {
        return ReactiveExtractionTool.INSTANCE;
    }

    private static class ReactiveExtractionTool
    implements ExtractionTool {
        private static final ReactiveExtractionTool INSTANCE = new ReactiveExtractionTool();

        private ReactiveExtractionTool() {
        }

        public ExtractionContext createExtractionContext(ServiceRegistry serviceRegistry, JdbcEnvironment jdbcEnvironment, SqlStringGenerationContext sqlStringGenerationContext, DdlTransactionIsolator ddlTransactionIsolator, ExtractionContext.DatabaseObjectAccess databaseObjectAccess) {
            return new ReactiveImprovedExtractionContextImpl(serviceRegistry, sqlStringGenerationContext, databaseObjectAccess);
        }

        public InformationExtractor createInformationExtractor(ExtractionContext extractionContext) {
            Dialect dialect = extractionContext.getJdbcEnvironment().getDialect();
            if (dialect instanceof PostgreSQL10Dialect) {
                return new PostgreSqlReactiveInformationExtractorImpl(extractionContext);
            }
            if (dialect instanceof CockroachDB201Dialect) {
                return new PostgreSqlReactiveInformationExtractorImpl(extractionContext);
            }
            if (dialect instanceof MySQL8Dialect || dialect instanceof MariaDB103Dialect) {
                return new MySqlReactiveInformationExtractorImpl(extractionContext);
            }
            if (dialect instanceof SQLServer2012Dialect) {
                return new SqlServerReactiveInformationExtractorImpl(extractionContext);
            }
            if (dialect instanceof Oracle12cDialect) {
                return new OracleSqlReactiveInformationExtractorImpl(extractionContext);
            }
            throw new NotYetImplementedException("No InformationExtractor for Dialect [" + dialect + "] is implemented yet");
        }
    }
}

