/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.reactive.provider.service;

import java.sql.SQLException;
import java.util.ArrayList;
import org.hibernate.boot.model.naming.Identifier;
import org.hibernate.cfg.NotYetImplementedException;
import org.hibernate.internal.CoreLogging;
import org.hibernate.internal.CoreMessageLogger;
import org.hibernate.reactive.provider.service.AbstractReactiveInformationSchemaBasedExtractorImpl;
import org.hibernate.tool.schema.extract.spi.ExtractionContext;

public class PostgreSqlReactiveInformationExtractorImpl
extends AbstractReactiveInformationSchemaBasedExtractorImpl {
    private static final CoreMessageLogger LOG = CoreLogging.messageLogger(PostgreSqlReactiveInformationExtractorImpl.class);

    public PostgreSqlReactiveInformationExtractorImpl(ExtractionContext extractionContext) {
        super(extractionContext);
    }

    @Override
    protected String getResultSetTableTypesPhysicalTableConstant() {
        return "BASE TABLE";
    }

    protected <T> T processPrimaryKeysResultSet(String catalogFilter, String schemaFilter, Identifier tableName, ExtractionContext.ResultSetProcessor<T> processor) throws SQLException {
        throw new NotYetImplementedException();
    }

    protected <T> T processIndexInfoResultSet(String catalog, String schema, String table, boolean unique, boolean approximate, ExtractionContext.ResultSetProcessor<T> processor) throws SQLException {
        StringBuilder innerQuery = new StringBuilder().append("select ci.relname as index_name").append(" , case i.indisclustered when true then ").append(1).append(" else case am.amname when 'hash' then ").append(2).append(" else ").append(3).append(" end").append(" end as index_type").append(" , (information_schema._pg_expandarray(i.indkey)).n as position").append(" , ci.oid as ci_iod").append(" from pg_catalog.pg_class ct").append(" join pg_catalog.pg_namespace n on (ct.relnamespace = n.oid)").append(" join pg_catalog.pg_index i on (ct.oid = i.indrelid)").append(" join pg_catalog.pg_class ci on (ci.oid = i.indexrelid)").append(" join pg_catalog.pg_am am on (ci.relam = am.oid)").append(" where true");
        ArrayList<Object> parameterValues = new ArrayList<Object>();
        this.appendClauseAndParameterIfNotNullOrEmpty(" and n.nspname = ", schema, innerQuery, parameterValues);
        this.appendClauseAndParameterIfNotNullOrEmpty(" and ct.relname = ", table, innerQuery, parameterValues);
        if (unique) {
            innerQuery.append(" AND i.indisunique = true");
        }
        return (T)this.getExtractionContext().getQueryResults("select tmp.index_name as " + this.getResultSetIndexNameLabel() + ", tmp.index_type as " + this.getResultSetIndexTypeLabel() + ", trim(both '\"' from pg_catalog.pg_get_indexdef(tmp.ci_iod, tmp.position, false)) as " + this.getResultSetColumnNameLabel() + " from ( " + innerQuery + " ) tmp order by " + this.getResultSetIndexNameLabel() + ", tmp.position", parameterValues.toArray(), processor);
    }

    protected <T> T processImportedKeysResultSet(String catalog, String schema, String table, ExtractionContext.ResultSetProcessor<T> processor) throws SQLException {
        StringBuilder sb = new StringBuilder().append("select null as ").append(this.getResultSetPrimaryKeyCatalogLabel()).append(", pkn.nspname as ").append(this.getResultSetPrimaryKeySchemaLabel()).append(", pkc.relname as ").append(this.getResultSetPrimaryKeyTableLabel()).append(", pka.attname as ").append(this.getResultSetPrimaryKeyColumnNameLabel()).append(", fka.attname as ").append(this.getResultSetForeignKeyColumnNameLabel()).append(", pos.n as ").append(this.getResultSetColumnPositionColumn()).append(", con.conname as ").append(this.getResultSetForeignKeyLabel()).append(" from pg_catalog.pg_namespace pkn, pg_catalog.pg_class pkc, pg_catalog.pg_attribute pka").append(",  pg_catalog.pg_namespace fkn, pg_catalog.pg_class fkc, pg_catalog.pg_attribute fka").append(", pg_catalog.pg_constraint con").append(", pg_catalog.generate_series(1, cast( (select setting from pg_catalog.pg_settings where name='max_index_keys') as integer ) ) pos(n)").append(" where pkn.oid = pkc.relnamespace and pkc.oid = pka.attrelid and pka.attnum = con.confkey[pos.n] and con.confrelid = pkc.oid").append(" and fkn.oid = fkc.relnamespace and fkc.oid = fka.attrelid and fka.attnum = con.conkey[pos.n] and con.conrelid = fkc.oid").append(" and con.contype = 'f' ");
        ArrayList<Object> parameterValues = new ArrayList<Object>();
        this.appendClauseAndParameterIfNotNullOrEmpty(" and fkn.nspname = ", schema, sb, parameterValues);
        this.appendClauseAndParameterIfNotNullOrEmpty(" and fkc.relname = ", table, sb, parameterValues);
        sb.append(" order by pkn.nspname, pkc.relname, con.conname, pos.n");
        return (T)this.getExtractionContext().getQueryResults(sb.toString(), parameterValues.toArray(), processor);
    }

    @Override
    protected String getInformationSchemaColumnsDataTypeColumn() {
        return "udt_name";
    }
}

