/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.reactive.provider.service;

import java.sql.SQLException;
import java.util.ArrayList;
import org.hibernate.boot.model.naming.Identifier;
import org.hibernate.cfg.NotYetImplementedException;
import org.hibernate.internal.CoreLogging;
import org.hibernate.internal.CoreMessageLogger;
import org.hibernate.reactive.provider.service.AbstractReactiveInformationSchemaBasedExtractorImpl;
import org.hibernate.reactive.provider.service.PostgreSqlReactiveInformationExtractorImpl;
import org.hibernate.tool.schema.extract.spi.ExtractionContext;

public class OracleSqlReactiveInformationExtractorImpl
extends AbstractReactiveInformationSchemaBasedExtractorImpl {
    private static final CoreMessageLogger LOG = CoreLogging.messageLogger(PostgreSqlReactiveInformationExtractorImpl.class);

    public OracleSqlReactiveInformationExtractorImpl(ExtractionContext extractionContext) {
        super(extractionContext);
    }

    @Override
    protected String getResultSetTableTypesPhysicalTableConstant() {
        return "TABLE";
    }

    protected <T> T processPrimaryKeysResultSet(String catalogFilter, String schemaFilter, Identifier tableName, ExtractionContext.ResultSetProcessor<T> processor) throws SQLException {
        throw new NotYetImplementedException();
    }

    protected <T> T processIndexInfoResultSet(String catalog, String schema, String table, boolean unique, boolean approximate, ExtractionContext.ResultSetProcessor<T> processor) throws SQLException {
        StringBuilder sb = new StringBuilder().append("select uic.index_name as ").append(this.getResultSetIndexNameLabel()).append(", -1 as ").append(this.getResultSetIndexTypeLabel()).append(", uic.column_name as ").append(this.getResultSetColumnNameLabel()).append(" from user_ind_columns uic join user_indexes ui on ui.table_name = uic.table_name").append(" where 1 = 1");
        ArrayList<Object> parameters = new ArrayList<Object>();
        assert (catalog == null || catalog.isEmpty());
        this.appendClauseAndParameterIfNotNullOrEmpty(" and ui.table_owner = ", schema, sb, parameters);
        this.appendClauseAndParameterIfNotNullOrEmpty(" and ui.table_name = ", table, sb, parameters);
        return (T)this.getExtractionContext().getQueryResults(sb.toString(), parameters.toArray(), processor);
    }

    protected <T> T processImportedKeysResultSet(String catalog, String schema, String table, ExtractionContext.ResultSetProcessor<T> processor) throws SQLException {
        String fkNameSubquery = "(select constraint_name from user_constraints where r_owner = '" + schema + "' and table_name = '" + table + "')";
        String constraintSubquery = "(SELECT R_CONSTRAINT_NAME FROM USER_CONSTRAINTS WHERE OWNER = '" + schema + "' and table_name = '" + table + "' and CONSTRAINT_TYPE = 'R')";
        StringBuilder sb = new StringBuilder().append("select " + fkNameSubquery + " as ").append(this.getResultSetForeignKeyLabel()).append(", null as ").append(this.getResultSetPrimaryKeyCatalogLabel()).append(", uc.owner as ").append(this.getResultSetPrimaryKeySchemaLabel()).append(", ucc.table_name as ").append(this.getResultSetPrimaryKeyTableLabel()).append(", ucc.column_name as ").append(this.getResultSetPrimaryKeyColumnNameLabel()).append(", ucc.column_name as ").append(this.getResultSetForeignKeyColumnNameLabel()).append(" from user_constraints uc join user_cons_columns ucc on uc.constraint_name = ucc.constraint_name ").append(" where uc.constraint_name = " + constraintSubquery);
        ArrayList parameters = new ArrayList();
        ArrayList<String> orderByList = new ArrayList<String>();
        orderByList.add("uc.owner");
        orderByList.add("ucc.table_name");
        orderByList.add("ucc.position");
        if (orderByList.size() > 0) {
            sb.append(" order by ").append((String)orderByList.get(0));
            for (int i = 1; i < orderByList.size(); ++i) {
                sb.append(", ").append((String)orderByList.get(i));
            }
        }
        Object result = this.getExtractionContext().getQueryResults(sb.toString(), parameters.toArray(), processor);
        return (T)result;
    }

    @Override
    protected <T> T processTableResultSet(String catalog, String schemaPattern, String tableNamePattern, String[] types, ExtractionContext.ResultSetProcessor<T> processor) throws SQLException {
        String catalogColumn = this.getDatabaseCatalogColumnName("table_catalog", "table_schema");
        String schemaColumn = this.getDatabaseSchemaColumnName("table_catalog", "table_schema");
        StringBuilder sb = new StringBuilder().append("select null").append(" as ").append(this.getResultSetCatalogLabel()).append(" , ").append(schemaColumn).append(" as ").append(this.getResultSetSchemaLabel()).append(" , sat.table_name as ").append(this.getResultSetTableNameLabel()).append(" , 'TABLE' as ").append(this.getResultSetTableTypeLabel()).append(" , satc.comments as ").append(this.getResultSetRemarksLabel()).append(" from sys.all_tables sat join sys.all_tab_comments satc on sat.TABLE_NAME = satc.TABLE_NAME where 1 = 1");
        ArrayList<Object> parameterValues = new ArrayList<Object>();
        this.appendClauseAndParameterIfNotNullOrEmpty(" and " + schemaColumn + " like ", schemaPattern, sb, parameterValues);
        this.appendClauseAndParameterIfNotNullOrEmpty(" and sat.table_name like ", tableNamePattern, sb, parameterValues);
        this.appendClauseAndParameterIfNotNullOrEmpty(" and satc.table_name like ", tableNamePattern, sb, parameterValues);
        return (T)this.getExtractionContext().getQueryResults(sb.toString(), parameterValues.toArray(), processor);
    }

    @Override
    protected <T> T processColumnsResultSet(String catalog, String schemaPattern, String tableNamePattern, String columnNamePattern, ExtractionContext.ResultSetProcessor<T> processor) throws SQLException {
        StringBuilder sb = new StringBuilder().append("select c.table_name as ").append(this.getResultSetTableNameLabel()).append(", c.column_name as ").append(this.getResultSetColumnNameLabel()).append(", c.").append(this.getInformationSchemaColumnsDataTypeColumn()).append(" as ").append(this.getResultSetTypeNameLabel()).append(", null as ").append(this.getResultSetColumnSizeLabel()).append(", null as ").append(this.getResultSetDecimalDigitsLabel()).append(", c.nullable as ").append(this.getResultSetIsNullableLabel()).append(", null as ").append(this.getResultSetSqlTypeCodeLabel()).append(" from sys.user_tab_columns c inner join sys.user_objects o").append(" on c.table_name = o.object_name and o.object_type in ( 'TABLE', 'VIEW' ) ").append(" where 1 = 1");
        ArrayList<Object> parameterValues = new ArrayList<Object>();
        String catalogColumn = this.getDatabaseCatalogColumnName("table_catalog", "table_schema");
        String schemaColumn = this.getDatabaseSchemaColumnName("table_catalog", "table_schema");
        this.appendClauseAndParameterIfNotNullOrEmpty(" and " + catalogColumn + " = ", catalog, sb, parameterValues);
        this.appendClauseAndParameterIfNotNullOrEmpty(" and table_name like ", tableNamePattern, sb, parameterValues);
        sb.append(" order by table_name, column_name, column_id");
        return (T)this.getExtractionContext().getQueryResults(sb.toString(), parameterValues.toArray(), processor);
    }

    @Override
    protected String getDatabaseSchemaColumnName(String catalogColumnName, String schemaColumnName) {
        return "sat.owner";
    }

    @Override
    protected String getResultSetIsNullableLabel() {
        return "nullable";
    }

    @Override
    protected int dataTypeCode(String typeName) {
        if (typeName.equalsIgnoreCase("float") || typeName.toLowerCase().startsWith("double")) {
            return 8;
        }
        return super.dataTypeCode(typeName);
    }
}

