/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.reactive.provider.service;

import java.lang.invoke.MethodHandles;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Map;
import org.hibernate.dialect.CockroachDB201Dialect;
import org.hibernate.dialect.DB297Dialect;
import org.hibernate.dialect.Dialect;
import org.hibernate.dialect.MariaDB103Dialect;
import org.hibernate.dialect.MySQL8Dialect;
import org.hibernate.dialect.Oracle12cDialect;
import org.hibernate.dialect.PostgreSQL10Dialect;
import org.hibernate.dialect.SQLServer2012Dialect;
import org.hibernate.engine.jdbc.connections.spi.ConnectionProvider;
import org.hibernate.engine.jdbc.dialect.spi.DatabaseMetaDataDialectResolutionInfoAdapter;
import org.hibernate.engine.jdbc.dialect.spi.DialectFactory;
import org.hibernate.engine.jdbc.env.internal.JdbcEnvironmentImpl;
import org.hibernate.engine.jdbc.env.internal.JdbcEnvironmentInitiator;
import org.hibernate.engine.jdbc.env.spi.JdbcEnvironment;
import org.hibernate.internal.util.config.ConfigurationHelper;
import org.hibernate.reactive.logging.impl.Log;
import org.hibernate.reactive.logging.impl.LoggerFactory;
import org.hibernate.service.spi.ServiceRegistryImplementor;

public class NoJdbcEnvironmentInitiator
extends JdbcEnvironmentInitiator {
    private static final Log LOG = LoggerFactory.make(Log.class, MethodHandles.lookup());
    public static final NoJdbcEnvironmentInitiator INSTANCE = new NoJdbcEnvironmentInitiator();

    public Class<JdbcEnvironment> getServiceInitiated() {
        return JdbcEnvironment.class;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public JdbcEnvironment initiateService(Map configurationValues, ServiceRegistryImplementor registry) {
        boolean useJdbcMetadata;
        Class<? extends Dialect> dialectClass;
        DialectFactory dialectFactory = (DialectFactory)registry.getService(DialectFactory.class);
        boolean explicitDialect = configurationValues.containsKey("hibernate.dialect");
        String url = configurationValues.getOrDefault("hibernate.connection.url", "").toString();
        if (!explicitDialect && (dialectClass = this.guessDialect(url)) != null) {
            configurationValues.put("hibernate.dialect", dialectClass.getName());
            explicitDialect = true;
        }
        if (useJdbcMetadata = ConfigurationHelper.getBoolean((String)"hibernate.temp.use_jdbc_metadata_defaults", (Map)configurationValues, (boolean)true)) {
            ConnectionProvider connectionProvider = (ConnectionProvider)registry.getService(ConnectionProvider.class);
            JdbcEnvironmentInitiator.ConnectionProviderJdbcConnectionAccess jdbcConnectionAccess = new JdbcEnvironmentInitiator.ConnectionProviderJdbcConnectionAccess(connectionProvider);
            try {
                Connection connection = jdbcConnectionAccess.obtainConnection();
                try {
                    Dialect dialect = dialectFactory.buildDialect(configurationValues, () -> {
                        try {
                            return new DatabaseMetaDataDialectResolutionInfoAdapter(connection.getMetaData());
                        }
                        catch (SQLException sqlException) {
                            return null;
                        }
                    });
                    JdbcEnvironmentImpl jdbcEnvironmentImpl = new JdbcEnvironmentImpl(registry, dialect, connection.getMetaData());
                    return jdbcEnvironmentImpl;
                }
                catch (SQLException sQLException) {
                }
                finally {
                    try {
                        jdbcConnectionAccess.releaseConnection(connection);
                    }
                    catch (SQLException sQLException) {}
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (explicitDialect) {
            return new JdbcEnvironmentImpl(registry, dialectFactory.buildDialect(configurationValues, null));
        }
        if (!url.isEmpty()) throw LOG.couldNotDetermineDialectFromConnectionURI(url);
        throw LOG.couldNotDetermineDialectFromJdbcDriverMetadata();
    }

    protected Class<? extends Dialect> guessDialect(String url) {
        if (url.startsWith("jdbc:")) {
            url = url.substring(5);
        }
        if (url.startsWith("mysql:")) {
            return MySQL8Dialect.class;
        }
        if (url.startsWith("mariadb:")) {
            return MariaDB103Dialect.class;
        }
        if (url.startsWith("postgresql:") || url.startsWith("postgres:")) {
            return PostgreSQL10Dialect.class;
        }
        if (url.startsWith("db2:")) {
            return DB297Dialect.class;
        }
        if (url.startsWith("cockroachdb:")) {
            return CockroachDB201Dialect.class;
        }
        if (url.startsWith("sqlserver:")) {
            return SQLServer2012Dialect.class;
        }
        if (url.startsWith("oracle:")) {
            return Oracle12cDialect.class;
        }
        return null;
    }
}

