/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.reactive.provider.service;

import java.sql.SQLException;
import java.util.ArrayList;
import org.hibernate.boot.model.naming.Identifier;
import org.hibernate.cfg.NotYetImplementedException;
import org.hibernate.reactive.provider.service.AbstractReactiveInformationSchemaBasedExtractorImpl;
import org.hibernate.tool.schema.extract.spi.ExtractionContext;

public class MySqlReactiveInformationExtractorImpl
extends AbstractReactiveInformationSchemaBasedExtractorImpl {
    public MySqlReactiveInformationExtractorImpl(ExtractionContext extractionContext) {
        super(extractionContext);
    }

    @Override
    protected String getResultSetTableTypesPhysicalTableConstant() {
        return "BASE TABLE";
    }

    @Override
    protected String getDatabaseCatalogColumnName(String catalogColumnName, String schemaColumnName) {
        return schemaColumnName;
    }

    @Override
    protected String getDatabaseSchemaColumnName(String catalogColumnName, String schemaColumnName) {
        return null;
    }

    protected <T> T processPrimaryKeysResultSet(String catalogFilter, String schemaFilter, Identifier tableName, ExtractionContext.ResultSetProcessor<T> processor) throws SQLException {
        throw new NotYetImplementedException();
    }

    @Override
    protected <T> T processCatalogsResultSet(ExtractionContext.ResultSetProcessor<T> processor) throws SQLException {
        return (T)this.getExtractionContext().getQueryResults(String.format("select schema_name as %s from information_schema.information_schema.schemata", this.getResultSetCatalogLabel()), null, processor);
    }

    protected <T> T processIndexInfoResultSet(String catalog, String schema, String table, boolean unique, boolean approximate, ExtractionContext.ResultSetProcessor<T> processor) throws SQLException {
        StringBuilder sb = new StringBuilder().append("select index_name as ").append(this.getResultSetIndexNameLabel()).append(", -1 as ").append(this.getResultSetIndexTypeLabel()).append(", column_name as ").append(this.getResultSetColumnNameLabel()).append(" from information_schema.statistics where true");
        ArrayList<Object> parameters = new ArrayList<Object>();
        assert (schema == null || schema.isEmpty());
        this.appendClauseAndParameterIfNotNullOrEmpty(" and table_schema = ", catalog, sb, parameters);
        this.appendClauseAndParameterIfNotNullOrEmpty(" and table_name = ", table, sb, parameters);
        if (unique) {
            this.appendClauseAndParameterIfNotNullOrEmpty(" and non_unique = ", 0, sb, parameters);
        }
        sb.append(" order by index_name, seq_in_index");
        return (T)this.getExtractionContext().getQueryResults(sb.toString(), parameters.toArray(), processor);
    }

    protected <T> T processImportedKeysResultSet(String catalog, String schema, String table, ExtractionContext.ResultSetProcessor<T> processor) throws SQLException {
        StringBuilder sb = new StringBuilder().append("select constraint_name as ").append(this.getResultSetForeignKeyLabel()).append(", referenced_table_schema as ").append(this.getResultSetPrimaryKeyCatalogLabel()).append(", null as ").append(this.getResultSetPrimaryKeySchemaLabel()).append(", referenced_table_name as ").append(this.getResultSetPrimaryKeyTableLabel()).append(", referenced_column_name as ").append(this.getResultSetPrimaryKeyColumnNameLabel()).append(", column_name as ").append(this.getResultSetForeignKeyColumnNameLabel()).append(" from information_schema.key_column_usage").append(" where referenced_table_name is not null");
        ArrayList<Object> parameters = new ArrayList<Object>();
        ArrayList<String> orderByList = new ArrayList<String>();
        if (this.appendClauseAndParameterIfNotNullOrEmpty(" and table_schema = ", catalog, sb, parameters)) {
            orderByList.add("table_schema");
        }
        if (this.appendClauseAndParameterIfNotNullOrEmpty(" and table_name = ", table, sb, parameters)) {
            orderByList.add("table_name");
        }
        orderByList.add("ordinal_position");
        if (orderByList.size() > 0) {
            sb.append(" order by ").append((String)orderByList.get(0));
            for (int i = 1; i < orderByList.size(); ++i) {
                sb.append(", ").append((String)orderByList.get(i));
            }
        }
        return (T)this.getExtractionContext().getQueryResults(sb.toString(), parameters.toArray(), processor);
    }
}

