/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.reactive.provider.impl;

import io.vertx.core.json.JsonObject;
import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.hibernate.boot.model.TypeContributions;
import org.hibernate.boot.model.TypeContributor;
import org.hibernate.dialect.Dialect;
import org.hibernate.dialect.PostgreSQL10Dialect;
import org.hibernate.engine.jdbc.env.spi.JdbcEnvironment;
import org.hibernate.reactive.provider.impl.ReactiveModeCheck;
import org.hibernate.service.ServiceRegistry;
import org.hibernate.type.AbstractSingleColumnStandardBasicType;
import org.hibernate.type.BasicType;
import org.hibernate.type.BasicTypeRegistry;
import org.hibernate.type.descriptor.ValueBinder;
import org.hibernate.type.descriptor.ValueExtractor;
import org.hibernate.type.descriptor.WrapperOptions;
import org.hibernate.type.descriptor.java.JavaTypeDescriptor;
import org.hibernate.type.descriptor.java.PrimitiveByteArrayTypeDescriptor;
import org.hibernate.type.descriptor.java.StringTypeDescriptor;
import org.hibernate.type.descriptor.sql.BasicBinder;
import org.hibernate.type.descriptor.sql.BasicExtractor;
import org.hibernate.type.descriptor.sql.SqlTypeDescriptor;
import org.hibernate.type.descriptor.sql.VarbinaryTypeDescriptor;
import org.hibernate.type.descriptor.sql.VarcharTypeDescriptor;

public class ReactiveTypeContributor
implements TypeContributor {
    public void contribute(TypeContributions typeContributions, ServiceRegistry serviceRegistry) {
        if (ReactiveModeCheck.isReactiveRegistry(serviceRegistry)) {
            this.registerReactiveChanges(typeContributions, serviceRegistry);
        }
    }

    private void registerReactiveChanges(TypeContributions typeContributions, ServiceRegistry serviceRegistry) {
        BasicTypeRegistry basicTypeRegistry = typeContributions.getTypeConfiguration().getBasicTypeRegistry();
        Dialect dialect = ((JdbcEnvironment)serviceRegistry.getService(JdbcEnvironment.class)).getDialect();
        basicTypeRegistry.register((BasicType)new BlobType(dialect));
        basicTypeRegistry.register((BasicType)new ClobType(dialect));
        basicTypeRegistry.register((BasicType)new JsonType(dialect));
    }

    private static class BlobType
    extends AbstractSingleColumnStandardBasicType<byte[]> {
        public BlobType(final Dialect dialect) {
            super((SqlTypeDescriptor)new VarbinaryTypeDescriptor(){

                public int getSqlType() {
                    return dialect instanceof PostgreSQL10Dialect ? -4 : 2004;
                }

                public boolean canBeRemapped() {
                    return false;
                }
            }, (JavaTypeDescriptor)PrimitiveByteArrayTypeDescriptor.INSTANCE);
        }

        public String getName() {
            return "materialized_blob";
        }
    }

    private static class ClobType
    extends AbstractSingleColumnStandardBasicType<String> {
        public ClobType(final Dialect dialect) {
            super((SqlTypeDescriptor)new VarcharTypeDescriptor(){

                public int getSqlType() {
                    return dialect instanceof PostgreSQL10Dialect ? -1 : 2005;
                }

                public boolean canBeRemapped() {
                    return false;
                }
            }, (JavaTypeDescriptor)StringTypeDescriptor.INSTANCE);
        }

        public String getName() {
            return "materialized_clob";
        }
    }

    private static class JsonType
    extends AbstractSingleColumnStandardBasicType<JsonObject> {
        public JsonType(Dialect dialect) {
            super(new SqlTypeDescriptor(){

                public int getSqlType() {
                    return 2000;
                }

                public boolean canBeRemapped() {
                    return true;
                }

                public <X> ValueBinder<X> getBinder(final JavaTypeDescriptor<X> javaTypeDescriptor) {
                    return new BasicBinder<X>(javaTypeDescriptor, this){

                        protected void doBind(PreparedStatement st, X value, int index, WrapperOptions options) throws SQLException {
                            st.setObject(index, javaTypeDescriptor.unwrap(value, JsonObject.class, options));
                        }

                        protected void doBind(CallableStatement st, X value, String name, WrapperOptions options) throws SQLException {
                            throw new UnsupportedOperationException();
                        }
                    };
                }

                public <X> ValueExtractor<X> getExtractor(final JavaTypeDescriptor<X> javaTypeDescriptor) {
                    return new BasicExtractor<X>(javaTypeDescriptor, this){

                        protected X doExtract(ResultSet rs, String name, WrapperOptions options) throws SQLException {
                            Object result = rs.getObject(name);
                            if (result instanceof String) {
                                return javaTypeDescriptor.wrap((Object)new JsonObject(result.toString()), options);
                            }
                            return javaTypeDescriptor.wrap(result, options);
                        }

                        protected X doExtract(CallableStatement statement, int index, WrapperOptions options) throws SQLException {
                            throw new UnsupportedOperationException();
                        }

                        protected X doExtract(CallableStatement statement, String name, WrapperOptions options) throws SQLException {
                            throw new UnsupportedOperationException();
                        }
                    };
                }
            }, (JavaTypeDescriptor)new JavaTypeDescriptor<JsonObject>(){

                public Class<JsonObject> getJavaTypeClass() {
                    return JsonObject.class;
                }

                public JsonObject fromString(String string) {
                    throw new UnsupportedOperationException();
                }

                public <X> X unwrap(JsonObject value, Class<X> type, WrapperOptions options) {
                    return (X)value;
                }

                public <X> JsonObject wrap(X value, WrapperOptions options) {
                    return (JsonObject)value;
                }
            });
        }

        public String getName() {
            return "json";
        }

        public String[] getRegistrationKeys() {
            return new String[]{"json", JsonObject.class.getName()};
        }
    }
}

