/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.reactive.pool.impl;

import io.vertx.sqlclient.Pool;
import io.vertx.sqlclient.SqlConnection;
import java.lang.invoke.MethodHandles;
import java.util.concurrent.CompletionStage;
import org.hibernate.engine.jdbc.spi.SqlStatementLogger;
import org.hibernate.reactive.logging.impl.Log;
import org.hibernate.reactive.logging.impl.LoggerFactory;
import org.hibernate.reactive.pool.ReactiveConnection;
import org.hibernate.reactive.pool.ReactiveConnectionPool;
import org.hibernate.reactive.pool.impl.ProxyConnection;
import org.hibernate.reactive.pool.impl.SqlClientConnection;

public abstract class SqlClientPool
implements ReactiveConnectionPool {
    private static final Log LOG = LoggerFactory.make(Log.class, MethodHandles.lookup());

    protected abstract Pool getPool();

    protected abstract SqlStatementLogger getSqlStatementLogger();

    protected Pool getTenantPool(String tenantId) {
        throw new UnsupportedOperationException("multitenancy not supported by built-in SqlClientPool");
    }

    @Override
    public CompletionStage<ReactiveConnection> getConnection() {
        return this.getConnectionFromPool(this.getPool());
    }

    @Override
    public CompletionStage<ReactiveConnection> getConnection(String tenantId) {
        return this.getConnectionFromPool(this.getTenantPool(tenantId));
    }

    private CompletionStage<ReactiveConnection> getConnectionFromPool(Pool pool) {
        return pool.getConnection().toCompletionStage().thenApply(this::newConnection);
    }

    private SqlClientConnection newConnection(SqlConnection connection) {
        return new SqlClientConnection(connection, this.getPool(), this.getSqlStatementLogger());
    }

    @Override
    public ReactiveConnection getProxyConnection() {
        return new ProxyConnection(this);
    }

    @Override
    public ReactiveConnection getProxyConnection(String tenantId) {
        return new ProxyConnection(this, tenantId);
    }
}

