/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.reactive.pool.impl;

import java.util.Locale;
import org.hibernate.reactive.pool.impl.Parameters;

public class SQLServerParameters
extends Parameters {
    public static final SQLServerParameters INSTANCE = new SQLServerParameters();

    private SQLServerParameters() {
    }

    @Override
    public String process(String sql) {
        if (SQLServerParameters.isProcessingNotRequired(sql)) {
            return sql;
        }
        return new Parser(sql).result();
    }

    @Override
    public String process(String sql, int parameterCount) {
        if (SQLServerParameters.isProcessingNotRequired(sql)) {
            return sql;
        }
        return new Parser(sql, parameterCount).result();
    }

    @Override
    public String processLimit(String sql, Object[] parameterArray, boolean hasOffset) {
        if (SQLServerParameters.isProcessingNotRequired(sql)) {
            return sql;
        }
        int index = hasOffset ? parameterArray.length - 1 : parameterArray.length;
        int pos = sql.indexOf(" offset ");
        if (pos > -1) {
            String offsetQueryString = sql.contains(" offset 0 ") ? " offset 0" : " offset @P" + index++;
            String sqlProcessed = sql.substring(0, pos) + offsetQueryString + " rows";
            if (sql.contains(" fetch next ?")) {
                sqlProcessed = sqlProcessed + " fetch next @P" + index + " rows only ";
            }
            return sqlProcessed;
        }
        if (sql.toLowerCase(Locale.ROOT).startsWith("select top(?)")) {
            String sqlProcessed = "select top(@P" + index + ")" + sql.substring(13);
            this.shiftValues(parameterArray);
            return sqlProcessed;
        }
        return sql;
    }

    private void shiftValues(Object[] parameterArray) {
        Object temp = parameterArray[0];
        System.arraycopy(parameterArray, 1, parameterArray, 0, parameterArray.length - 1);
        parameterArray[parameterArray.length - 1] = temp;
    }

    private static class Parser {
        private boolean inString;
        private boolean inQuoted;
        private boolean inSqlComment;
        private boolean inCComment;
        private boolean escaped;
        private int count = 0;
        private StringBuilder result;
        private int previous;

        private Parser(String sql) {
            this(sql, 10);
        }

        private Parser(String sql, int parameterCount) {
            this.result = new StringBuilder(sql.length() + parameterCount);
            sql.codePoints().forEach(this::append);
        }

        private String result() {
            return this.result.toString();
        }

        private void append(int codePoint) {
            if (this.escaped) {
                this.escaped = false;
            } else {
                switch (codePoint) {
                    case 92: {
                        this.escaped = true;
                        break;
                    }
                    case 34: {
                        if (this.inString || this.inSqlComment || this.inCComment) break;
                        this.inQuoted = !this.inQuoted;
                        break;
                    }
                    case 39: {
                        if (this.inQuoted || this.inSqlComment || this.inCComment) break;
                        this.inString = !this.inString;
                        break;
                    }
                    case 45: {
                        if (this.inQuoted || this.inString || this.inCComment || this.previous != 45) break;
                        this.inSqlComment = true;
                        break;
                    }
                    case 10: {
                        this.inSqlComment = false;
                        break;
                    }
                    case 42: {
                        if (this.inQuoted || this.inString || this.inSqlComment || this.previous != 47) break;
                        this.inCComment = true;
                        break;
                    }
                    case 47: {
                        if (this.previous != 42) break;
                        this.inCComment = false;
                        break;
                    }
                    case 63: {
                        if (this.inQuoted || this.inString) break;
                        this.result.append("@P").append(++this.count);
                        this.previous = 63;
                        return;
                    }
                }
            }
            this.previous = codePoint;
            this.result.appendCodePoint(codePoint);
        }
    }
}

