/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.reactive.pool.impl;

import java.lang.invoke.MethodHandles;
import java.sql.ResultSet;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.Function;
import org.hibernate.reactive.common.InternalStateAssertions;
import org.hibernate.reactive.logging.impl.Log;
import org.hibernate.reactive.logging.impl.LoggerFactory;
import org.hibernate.reactive.pool.ReactiveConnection;
import org.hibernate.reactive.pool.ReactiveConnectionPool;
import org.hibernate.reactive.util.impl.CompletionStages;

final class ProxyConnection
implements ReactiveConnection {
    private static final Log LOG = LoggerFactory.make(Log.class, MethodHandles.lookup());
    private final ReactiveConnectionPool sqlClientPool;
    private ReactiveConnection connection;
    private boolean connected;
    private boolean closed;
    private final String tenantId;

    public ProxyConnection(ReactiveConnectionPool sqlClientPool) {
        this.sqlClientPool = sqlClientPool;
        this.tenantId = null;
    }

    public ProxyConnection(ReactiveConnectionPool sqlClientPool, String tenantId) {
        this.sqlClientPool = sqlClientPool;
        this.tenantId = tenantId;
    }

    private <T> CompletionStage<T> withConnection(Function<ReactiveConnection, CompletionStage<T>> operation) {
        InternalStateAssertions.assertUseOnEventLoop();
        if (this.closed) {
            CompletableFuture ret = new CompletableFuture();
            ret.completeExceptionally(LOG.sessionIsClosed());
            return ret;
        }
        if (!this.connected) {
            this.connected = true;
            CompletionStage<ReactiveConnection> connection = this.tenantId == null ? this.sqlClientPool.getConnection() : this.sqlClientPool.getConnection(this.tenantId);
            return connection.thenApply(newConnection -> {
                this.connection = newConnection;
                return this.connection;
            }).thenCompose(operation);
        }
        if (this.connection == null) {
            CompletableFuture ret = new CompletableFuture();
            ret.completeExceptionally(LOG.sessionIsConnectingToTheDatabase());
            return ret;
        }
        return operation.apply(this.connection);
    }

    @Override
    public CompletionStage<Void> execute(String sql) {
        return this.withConnection(conn -> conn.execute(sql));
    }

    @Override
    public CompletionStage<Void> executeUnprepared(String sql) {
        return this.withConnection(conn -> conn.executeUnprepared(sql));
    }

    @Override
    public CompletionStage<Void> executeOutsideTransaction(String sql) {
        return this.withConnection(conn -> conn.executeOutsideTransaction(sql));
    }

    @Override
    public CompletionStage<Integer> update(String sql) {
        return this.withConnection(conn -> conn.update(sql));
    }

    @Override
    public CompletionStage<Integer> update(String sql, Object[] paramValues) {
        return this.withConnection(conn -> conn.update(sql, paramValues));
    }

    @Override
    public CompletionStage<Void> update(String sql, Object[] paramValues, boolean allowBatching, ReactiveConnection.Expectation expectation) {
        return this.withConnection(conn -> conn.update(sql, paramValues, allowBatching, expectation));
    }

    @Override
    public CompletionStage<int[]> update(String sql, List<Object[]> paramValues) {
        return this.withConnection(conn -> conn.update(sql, paramValues));
    }

    @Override
    public <T> CompletionStage<T> insertAndSelectIdentifier(String sql, Object[] paramValues, Class<T> idClass, String idColumnName) {
        return this.withConnection(conn -> conn.insertAndSelectIdentifier(sql, paramValues, idClass, idColumnName));
    }

    @Override
    public CompletionStage<ReactiveConnection.Result> select(String sql) {
        return this.withConnection(conn -> conn.select(sql));
    }

    @Override
    public CompletionStage<ReactiveConnection.Result> select(String sql, Object[] paramValues) {
        return this.withConnection(conn -> conn.select(sql, paramValues));
    }

    @Override
    public CompletionStage<ResultSet> selectJdbc(String sql, Object[] paramValues) {
        return this.withConnection(conn -> conn.selectJdbc(sql, paramValues));
    }

    @Override
    public CompletionStage<ResultSet> selectJdbcOutsideTransaction(String sql, Object[] paramValues) {
        return this.withConnection(conn -> conn.selectJdbcOutsideTransaction(sql, paramValues));
    }

    @Override
    public <T> CompletionStage<T> selectIdentifier(String sql, Object[] paramValues, Class<T> idClass) {
        return this.withConnection(conn -> conn.selectIdentifier(sql, paramValues, idClass));
    }

    @Override
    public CompletionStage<Void> beginTransaction() {
        return this.withConnection(ReactiveConnection::beginTransaction);
    }

    @Override
    public CompletionStage<Void> commitTransaction() {
        return this.withConnection(ReactiveConnection::commitTransaction);
    }

    @Override
    public CompletionStage<Void> rollbackTransaction() {
        return this.withConnection(ReactiveConnection::rollbackTransaction);
    }

    @Override
    public ReactiveConnection withBatchSize(int batchSize) {
        this.connection = this.connection.withBatchSize(batchSize);
        return this;
    }

    @Override
    public CompletionStage<Void> executeBatch() {
        return this.withConnection(ReactiveConnection::executeBatch);
    }

    @Override
    public CompletionStage<Void> close() {
        CompletionStage<Void> stage = CompletionStages.voidFuture();
        if (this.connection != null) {
            stage = stage.thenCompose(v -> this.connection.close());
        }
        return stage.thenAccept(v -> {
            this.connection = null;
            this.closed = true;
        });
    }
}

