/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.reactive.pool.impl;

import java.util.function.IntConsumer;
import org.hibernate.reactive.pool.impl.Parameters;

public class PostgresParameters
extends Parameters {
    public static final PostgresParameters INSTANCE = new PostgresParameters();

    private PostgresParameters() {
    }

    @Override
    public String process(String sql) {
        if (PostgresParameters.isProcessingNotRequired(sql)) {
            return sql;
        }
        return new Parser(sql).result();
    }

    @Override
    public String processLimit(String sql, Object[] parameterArray, boolean hasOffset) {
        if (PostgresParameters.isProcessingNotRequired(sql)) {
            return sql;
        }
        int index = hasOffset ? parameterArray.length - 1 : parameterArray.length;
        int pos = sql.indexOf(" limit ?");
        if (pos > -1) {
            String sqlProcessed = sql.substring(0, pos) + " limit $" + index++;
            if (hasOffset) {
                sqlProcessed = sqlProcessed + " offset $" + index;
            }
            return sqlProcessed;
        }
        return sql;
    }

    @Override
    public String process(String sql, int parameterCount) {
        if (PostgresParameters.isProcessingNotRequired(sql)) {
            return sql;
        }
        return new Parser(sql, parameterCount).result();
    }

    private static class Parser {
        private boolean inString;
        private boolean inQuoted;
        private boolean inSqlComment;
        private boolean inCComment;
        private boolean escaped;
        private int count = 0;
        private StringBuilder result;
        private int previous;

        private Parser(String sql) {
            this(sql, 10);
        }

        private Parser(String sql, int parameterCount) {
            this.result = new StringBuilder(sql.length() + parameterCount);
            sql.codePoints().forEach(new IntConsumer(){

                @Override
                public void accept(int codePoint) {
                    if (escaped) {
                        escaped = false;
                    } else {
                        switch (codePoint) {
                            case 92: {
                                escaped = true;
                                break;
                            }
                            case 34: {
                                if (inString || inSqlComment || inCComment) break;
                                inQuoted = !inQuoted;
                                break;
                            }
                            case 39: {
                                if (inQuoted || inSqlComment || inCComment) break;
                                inString = !inString;
                                break;
                            }
                            case 45: {
                                if (inQuoted || inString || inCComment || previous != 45) break;
                                inSqlComment = true;
                                break;
                            }
                            case 10: {
                                inSqlComment = false;
                                break;
                            }
                            case 42: {
                                if (inQuoted || inString || inSqlComment || previous != 47) break;
                                inCComment = true;
                                break;
                            }
                            case 47: {
                                if (previous != 42) break;
                                inCComment = false;
                                break;
                            }
                            case 63: {
                                if (inQuoted || inString) break;
                                result.append('$').append(++count);
                                previous = 63;
                                return;
                            }
                        }
                    }
                    previous = codePoint;
                    result.appendCodePoint(codePoint);
                }
            });
        }

        private String result() {
            return this.result.toString();
        }
    }
}

