/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.reactive.pool.impl;

import org.hibernate.reactive.pool.impl.Parameters;

public class OracleParameters
extends Parameters {
    public static final OracleParameters INSTANCE = new OracleParameters();

    private OracleParameters() {
    }

    @Override
    public String process(String sql) {
        if (OracleParameters.isProcessingNotRequired(sql)) {
            return sql;
        }
        return new Parser(sql).result();
    }

    @Override
    public String processLimit(String sql, Object[] parameterArray, boolean hasOffset) {
        if (OracleParameters.isProcessingNotRequired(sql)) {
            return sql;
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public String process(String sql, int parameterCount) {
        if (OracleParameters.isProcessingNotRequired(sql)) {
            return sql;
        }
        return new Parser(sql, parameterCount).result();
    }

    private static class Parser {
        private boolean inString;
        private boolean inQuoted;
        private boolean inSqlComment;
        private boolean inCComment;
        private boolean escaped;
        private int count = 0;
        private StringBuilder result;
        private int previous;

        private Parser(String sql) {
            this(sql, 10);
        }

        private Parser(String sql, int parameterCount) {
            this.result = new StringBuilder(sql.length() + parameterCount);
            sql.codePoints().forEach(this::append);
        }

        private String result() {
            return this.result.toString();
        }

        private void append(int codePoint) {
            if (this.escaped) {
                this.escaped = false;
            } else {
                switch (codePoint) {
                    case 92: {
                        this.escaped = true;
                        break;
                    }
                    case 34: {
                        if (this.inString || this.inSqlComment || this.inCComment) break;
                        this.inQuoted = !this.inQuoted;
                        break;
                    }
                    case 39: {
                        if (this.inQuoted || this.inSqlComment || this.inCComment) break;
                        this.inString = !this.inString;
                        break;
                    }
                    case 45: {
                        if (this.inQuoted || this.inString || this.inCComment || this.previous != 45) break;
                        this.inSqlComment = true;
                        break;
                    }
                    case 10: {
                        this.inSqlComment = false;
                        break;
                    }
                    case 42: {
                        if (this.inQuoted || this.inString || this.inSqlComment || this.previous != 47) break;
                        this.inCComment = true;
                        break;
                    }
                    case 47: {
                        if (this.previous != 42) break;
                        this.inCComment = false;
                        break;
                    }
                    case 63: {
                        if (this.inQuoted || this.inString) break;
                        this.result.append(':').append(++this.count);
                        this.previous = 63;
                        return;
                    }
                }
            }
            this.previous = codePoint;
            this.result.appendCodePoint(codePoint);
        }
    }
}

