/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.reactive.pool.impl;

import io.vertx.sqlclient.PoolOptions;
import io.vertx.sqlclient.SqlConnectOptions;
import java.lang.invoke.MethodHandles;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.hibernate.HibernateError;
import org.hibernate.internal.util.config.ConfigurationHelper;
import org.hibernate.reactive.logging.impl.Log;
import org.hibernate.reactive.logging.impl.LoggerFactory;
import org.hibernate.reactive.pool.impl.SqlClientPoolConfiguration;
import org.hibernate.service.spi.Configurable;

public class DefaultSqlClientPoolConfiguration
implements SqlClientPoolConfiguration,
Configurable {
    private static final Log LOG = LoggerFactory.make(Log.class, MethodHandles.lookup());
    private static final int DEFAULT_POOL_SIZE = 5;
    private int poolSize;
    private Integer maxWaitQueueSize;
    private Integer connectTimeout;
    private Integer idleTimeout;
    private Integer cacheMaxSize;
    private Integer sqlLimit;
    private Integer poolCleanerPeriod;
    private String user;
    private String pass;

    public void configure(Map configuration) {
        this.user = ConfigurationHelper.getString((String)"hibernate.connection.username", (Map)configuration);
        this.pass = ConfigurationHelper.getString((String)"hibernate.connection.password", (Map)configuration);
        this.poolSize = ConfigurationHelper.getInt((String)"hibernate.connection.pool_size", (Map)configuration, (int)5);
        this.maxWaitQueueSize = ConfigurationHelper.getInteger((String)"hibernate.vertx.pool.max_wait_queue_size", (Map)configuration);
        this.cacheMaxSize = ConfigurationHelper.getInteger((String)"hibernate.vertx.prepared_statement_cache.max_size", (Map)configuration);
        this.sqlLimit = ConfigurationHelper.getInteger((String)"hibernate.vertx.prepared_statement_cache.sql_limit", (Map)configuration);
        this.connectTimeout = ConfigurationHelper.getInteger((String)"hibernate.vertx.pool.connect_timeout", (Map)configuration);
        this.idleTimeout = ConfigurationHelper.getInteger((String)"hibernate.vertx.pool.idle_timeout", (Map)configuration);
        this.poolCleanerPeriod = ConfigurationHelper.getInteger((String)"hibernate.vertx.pool.cleaner_period", (Map)configuration);
    }

    @Override
    public PoolOptions poolOptions() {
        PoolOptions poolOptions = new PoolOptions();
        LOG.connectionPoolSize(this.poolSize);
        poolOptions.setMaxSize(this.poolSize);
        if (this.maxWaitQueueSize != null) {
            LOG.connectionPoolMaxWaitSize(this.maxWaitQueueSize);
            poolOptions.setMaxWaitQueueSize(this.maxWaitQueueSize.intValue());
        }
        if (this.idleTimeout != null) {
            LOG.connectionPoolIdleTimeout(this.idleTimeout);
            poolOptions.setIdleTimeout(this.idleTimeout.intValue());
            poolOptions.setIdleTimeoutUnit(TimeUnit.MILLISECONDS);
        }
        if (this.connectTimeout != null) {
            LOG.connectionPoolTimeout(this.connectTimeout);
            poolOptions.setConnectionTimeout(this.connectTimeout.intValue());
            poolOptions.setConnectionTimeoutUnit(TimeUnit.MILLISECONDS);
        }
        if (this.poolCleanerPeriod != null) {
            LOG.connectionPoolCleanerPeriod(this.poolCleanerPeriod);
            poolOptions.setPoolCleanerPeriod(this.poolCleanerPeriod.intValue());
        }
        return poolOptions;
    }

    @Override
    public SqlConnectOptions connectOptions(URI uri) {
        String database;
        String scheme = uri.getScheme();
        String path = scheme.equals("oracle") ? this.oraclePath(uri) : uri.getPath();
        String string = database = path.length() > 0 ? path.substring(1) : "";
        if (scheme.equals("db2") && database.indexOf(58) > 0) {
            database = database.substring(0, database.indexOf(58));
        }
        String host = scheme.equals("oracle") ? this.oracleHost(uri) : uri.getHost();
        int port = scheme.equals("oracle") ? this.oraclePort(uri) : uri.getPort();
        int index = uri.toString().indexOf(59);
        if (scheme.equals("sqlserver") && index > 0) {
            URI uriWithoutParams = URI.create(uri.toString().substring(0, index));
            host = uriWithoutParams.getHost();
            port = uriWithoutParams.getPort();
        }
        if (port == -1) {
            port = this.defaultPort(scheme);
        }
        String username = this.user;
        String password = this.pass;
        HashMap<String, String> extraProps = new HashMap<String, String>();
        if (username == null || password == null) {
            String userInfo = uri.getUserInfo();
            if (userInfo != null) {
                String[] bits = userInfo.split(":");
                username = bits[0];
                if (bits.length > 1) {
                    password = bits[1];
                }
            } else {
                String[] params = new String[]{};
                if (scheme.equals("db2")) {
                    int queryIndex = uri.getPath().indexOf(58) + 1;
                    if (queryIndex > 0) {
                        params = uri.getPath().substring(queryIndex).split(";");
                    }
                } else if (scheme.contains("sqlserver")) {
                    String query = uri.getQuery();
                    String rawQuery = uri.getRawQuery();
                    String s = uri.toString();
                    int queryIndex = s.indexOf(59) + 1;
                    if (queryIndex > 0) {
                        params = s.substring(queryIndex).split(";");
                    }
                } else {
                    String query;
                    String string2 = query = scheme.equals("oracle") ? this.oracleQuery(uri) : uri.getQuery();
                    if (query != null) {
                        params = query.split("&");
                    }
                }
                for (String param : params) {
                    if (param.startsWith("user=")) {
                        username = param.substring(5);
                        continue;
                    }
                    if (param.startsWith("pass=")) {
                        password = param.substring(5);
                        continue;
                    }
                    if (param.startsWith("password=")) {
                        password = param.substring(9);
                        continue;
                    }
                    if (param.startsWith("database=")) {
                        database = param.substring(9);
                        continue;
                    }
                    int position = param.indexOf("=");
                    if (position != -1) {
                        String key = param.substring(0, position);
                        String value = param.substring(position + 1);
                        extraProps.put(key, value);
                        continue;
                    }
                    extraProps.put(param, null);
                }
            }
        }
        if (username == null) {
            throw new HibernateError("database username not specified (set the property 'jakarta.persistence.jdbc.user', or include it as a parameter in the connection URL)");
        }
        SqlConnectOptions connectOptions = new SqlConnectOptions().setHost(host).setPort(port).setDatabase(database).setUser(username);
        if (password != null) {
            connectOptions.setPassword(password);
        }
        for (String key : extraProps.keySet()) {
            connectOptions.addProperty(key, (String)extraProps.get(key));
        }
        connectOptions.setCachePreparedStatements(true);
        if (this.cacheMaxSize != null) {
            if (this.cacheMaxSize <= 0) {
                LOG.preparedStatementCacheDisabled();
                connectOptions.setCachePreparedStatements(false);
            } else {
                LOG.preparedStatementCacheMaxSize(this.cacheMaxSize);
                connectOptions.setCachePreparedStatements(true);
                connectOptions.setPreparedStatementCacheMaxSize(this.cacheMaxSize.intValue());
            }
        }
        if (this.sqlLimit != null) {
            LOG.preparedStatementCacheSQLLimit(this.sqlLimit);
            connectOptions.setPreparedStatementCacheSqlLimit(this.sqlLimit.intValue());
        }
        return connectOptions;
    }

    private int oraclePort(URI uri) {
        String s = uri.toString().substring("oracle:thin:".length());
        if (s.indexOf(58) > -1) {
            if ((s = s.substring(s.indexOf(58) + 1)).indexOf(47) != -1) {
                s = s.substring(0, s.indexOf(47));
                return Integer.valueOf(s);
            }
            if (s.indexOf(63) != -1) {
                s = s.substring(0, s.indexOf(63));
                return Integer.valueOf(s);
            }
            return Integer.valueOf(s);
        }
        return -1;
    }

    private String oracleHost(URI uri) {
        String s = uri.toString();
        String host = s.substring(s.indexOf(64) + 1);
        int end = host.indexOf(58);
        if (end == -1 && (end = host.indexOf(47)) == -1) {
            end = host.indexOf(63);
        }
        return host.substring(0, end);
    }

    private String oracleQuery(URI uri) {
        String string = uri.toString();
        int start = string.indexOf(63);
        return start == -1 ? null : string.substring(start + 1);
    }

    private String oraclePath(URI uri) {
        String string = uri.toString();
        int i = string.indexOf(64);
        int start = (string = string.substring(i + 1)).indexOf(47);
        if (start == -1) {
            return "";
        }
        int end = string.indexOf(63) == -1 ? string.length() : string.indexOf(63);
        return string.substring(start, end);
    }

    private int defaultPort(String scheme) {
        switch (scheme) {
            case "postgresql": 
            case "postgres": {
                return 5432;
            }
            case "mariadb": 
            case "mysql": {
                return 3306;
            }
            case "db2": {
                return 50000;
            }
            case "cockroachdb": {
                return 26257;
            }
            case "sqlserver": {
                return 1433;
            }
            case "oracle": {
                return 1521;
            }
        }
        throw new IllegalArgumentException("Unknown default port for scheme: " + scheme);
    }
}

