/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.reactive.pool.impl;

import io.vertx.core.Future;
import io.vertx.core.Vertx;
import io.vertx.sqlclient.Pool;
import io.vertx.sqlclient.PoolOptions;
import io.vertx.sqlclient.SqlConnectOptions;
import io.vertx.sqlclient.spi.Driver;
import java.lang.invoke.MethodHandles;
import java.net.URI;
import java.util.Collections;
import java.util.Map;
import java.util.ServiceConfigurationError;
import java.util.ServiceLoader;
import java.util.concurrent.CompletionStage;
import org.hibernate.HibernateError;
import org.hibernate.engine.jdbc.spi.JdbcServices;
import org.hibernate.engine.jdbc.spi.SqlStatementLogger;
import org.hibernate.internal.util.config.ConfigurationException;
import org.hibernate.internal.util.config.ConfigurationHelper;
import org.hibernate.reactive.logging.impl.Log;
import org.hibernate.reactive.logging.impl.LoggerFactory;
import org.hibernate.reactive.pool.impl.SqlClientPool;
import org.hibernate.reactive.pool.impl.SqlClientPoolConfiguration;
import org.hibernate.reactive.vertx.VertxInstance;
import org.hibernate.service.spi.Configurable;
import org.hibernate.service.spi.ServiceRegistryAwareService;
import org.hibernate.service.spi.ServiceRegistryImplementor;
import org.hibernate.service.spi.Startable;
import org.hibernate.service.spi.Stoppable;

public class DefaultSqlClientPool
extends SqlClientPool
implements ServiceRegistryAwareService,
Configurable,
Stoppable,
Startable {
    private static final Log LOG = LoggerFactory.make(Log.class, MethodHandles.lookup());
    private Pool pools;
    private SqlStatementLogger sqlStatementLogger;
    private URI uri;
    private ServiceRegistryImplementor serviceRegistry;
    private volatile Future<Void> closeFuture = Future.succeededFuture();

    public void injectServices(ServiceRegistryImplementor serviceRegistry) {
        this.serviceRegistry = serviceRegistry;
        this.sqlStatementLogger = ((JdbcServices)serviceRegistry.getService(JdbcServices.class)).getSqlStatementLogger();
    }

    public void configure(Map configuration) {
        this.uri = this.jdbcUrl(configuration);
    }

    public void start() {
        if (this.pools == null) {
            this.pools = this.createPool(this.uri);
        }
    }

    @Override
    public CompletionStage<Void> getCloseFuture() {
        return this.closeFuture.toCompletionStage();
    }

    @Override
    protected Pool getPool() {
        return this.pools;
    }

    @Override
    protected SqlStatementLogger getSqlStatementLogger() {
        return this.sqlStatementLogger;
    }

    protected Pool createPool(URI uri) {
        SqlClientPoolConfiguration configuration = (SqlClientPoolConfiguration)this.serviceRegistry.getService(SqlClientPoolConfiguration.class);
        VertxInstance vertx = (VertxInstance)this.serviceRegistry.getService(VertxInstance.class);
        return this.createPool(uri, configuration.connectOptions(uri), configuration.poolOptions(), vertx.getVertx());
    }

    protected Pool createPool(URI uri, SqlConnectOptions connectOptions, PoolOptions poolOptions, Vertx vertx) {
        try {
            return Pool.pool((Vertx)vertx, (SqlConnectOptions)connectOptions, (PoolOptions)poolOptions);
        }
        catch (ServiceConfigurationError e) {
            Driver driver = this.findDriver(uri, e);
            return driver.createPool(vertx, Collections.singletonList(connectOptions), poolOptions);
        }
    }

    protected URI jdbcUrl(Map<?, ?> configurationValues) {
        String url = ConfigurationHelper.getString((String)"hibernate.connection.url", configurationValues);
        LOG.sqlClientUrl(url);
        return DefaultSqlClientPool.parse(url);
    }

    private Driver findDriver(URI uri, ServiceConfigurationError originalError) {
        String scheme = this.scheme(uri);
        for (Driver d : ServiceLoader.load(Driver.class)) {
            String driverName = d.getClass().getCanonicalName();
            LOG.detectedDriver(driverName);
            if (!this.matchesScheme(driverName, scheme)) continue;
            return d;
        }
        throw new ConfigurationException("No suitable drivers found for URI scheme: " + scheme, (Throwable)originalError);
    }

    private String scheme(URI uri) {
        return uri.getScheme().toLowerCase().startsWith("cockroach") ? "postgresql" : uri.getScheme();
    }

    private boolean matchesScheme(String driverName, String scheme) {
        VertxDriver vertxDriver = VertxDriver.findByClassName(driverName);
        return vertxDriver != null && vertxDriver.matches(scheme);
    }

    public void stop() {
        if (this.pools != null) {
            this.closeFuture = this.pools.close();
        }
    }

    public static URI parse(String url) {
        if (url == null || url.trim().isEmpty()) {
            throw new HibernateError("The configuration property 'hibernate.connection.url' was not provided, or is in invalid format. This is required when using the default DefaultSqlClientPool: either provide the configuration setting or integrate with a different SqlClientPool implementation");
        }
        if (url.startsWith("jdbc:")) {
            return URI.create(url.substring(5));
        }
        return URI.create(url);
    }

    private static enum VertxDriver {
        DB2("io.vertx.db2client.spi.DB2Driver", "db2"),
        MYSQL("io.vertx.mysqlclient.spi.MySQLDriver", "mysql", "mariadb"),
        POSTGRES("io.vertx.pgclient.spi.PgDriver", "postgres", "postgre", "postgresql", "cockroachdb"),
        MSSQL("io.vertx.mssqlclient.spi.MSSQLDriver", "sqlserver"),
        ORACLE("io.vertx.oracleclient.spi.OracleDriver", "oracle");

        private final String className;
        private final String[] schemas;

        private VertxDriver(String className, String ... schemas) {
            this.className = className;
            this.schemas = schemas;
        }

        public boolean matches(String schema) {
            for (String alias : this.schemas) {
                if (!alias.equalsIgnoreCase(schema)) continue;
                return true;
            }
            return false;
        }

        public static VertxDriver findByClassName(String className) {
            for (VertxDriver driver : VertxDriver.values()) {
                if (!driver.className.equalsIgnoreCase(className)) continue;
                return driver;
            }
            return null;
        }
    }
}

