/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.reactive.pool;

import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletionStage;
import org.hibernate.reactive.pool.ReactiveConnection;
import org.hibernate.reactive.util.impl.CompletionStages;

public class BatchingConnection
implements ReactiveConnection {
    private final ReactiveConnection delegate;
    private int batchSize;
    private String batchedSql;
    private ReactiveConnection.Expectation batchedExpectation;
    private List<Object[]> batchParamValues;

    public BatchingConnection(ReactiveConnection delegate, int batchSize) {
        this.delegate = delegate;
        this.batchSize = batchSize;
    }

    @Override
    public ReactiveConnection withBatchSize(int batchSize) {
        if (batchSize <= 1) {
            return this.delegate;
        }
        this.batchSize = batchSize;
        return this;
    }

    @Override
    public CompletionStage<Void> executeBatch() {
        if (!this.hasBatch()) {
            return CompletionStages.voidFuture();
        }
        String sql = this.batchedSql;
        ReactiveConnection.Expectation expectation = this.batchedExpectation;
        List<Object[]> paramValues = this.batchParamValues;
        this.batchedSql = null;
        this.batchParamValues = null;
        this.batchedExpectation = null;
        if (paramValues.size() == 1) {
            return this.update(sql, paramValues.get(0)).thenAccept(rowCount -> expectation.verifyOutcome((int)rowCount, -1, sql));
        }
        return this.update(sql, paramValues).thenAccept(rowCounts -> {
            for (int i = 0; i < ((int[])rowCounts).length; ++i) {
                expectation.verifyOutcome(rowCounts[i], i, sql);
            }
        });
    }

    @Override
    public CompletionStage<Void> update(String sql, Object[] paramValues, boolean allowBatching, ReactiveConnection.Expectation expectation) {
        if (allowBatching && this.batchSize > 0) {
            if (!this.hasBatch()) {
                this.newBatch(sql, paramValues, expectation);
                return CompletionStages.voidFuture();
            }
            if (this.batchedSql.equals(sql) && this.batchParamValues.size() < this.batchSize) {
                this.batchParamValues.add(paramValues);
                return CompletionStages.voidFuture();
            }
            CompletionStage<Void> lastBatch = this.executeBatch();
            this.newBatch(sql, paramValues, expectation);
            return lastBatch;
        }
        return this.delegate.update(sql, paramValues, false, expectation);
    }

    private void newBatch(String sql, Object[] paramValues, ReactiveConnection.Expectation expectation) {
        this.batchedSql = sql;
        this.batchedExpectation = expectation;
        this.batchParamValues = new ArrayList<Object[]>();
        this.batchParamValues.add(paramValues);
    }

    private boolean hasBatch() {
        return this.batchedSql != null;
    }

    @Override
    public CompletionStage<Void> execute(String sql) {
        return this.delegate.execute(sql);
    }

    @Override
    public CompletionStage<Void> executeUnprepared(String sql) {
        return this.delegate.executeUnprepared(sql);
    }

    @Override
    public CompletionStage<Void> executeOutsideTransaction(String sql) {
        return this.delegate.executeOutsideTransaction(sql);
    }

    @Override
    public CompletionStage<Integer> update(String sql) {
        return this.hasBatch() ? this.executeBatch().thenCompose(v -> this.delegate.update(sql)) : this.delegate.update(sql);
    }

    @Override
    public CompletionStage<Integer> update(String sql, Object[] paramValues) {
        return this.hasBatch() ? this.executeBatch().thenCompose(v -> this.delegate.update(sql, paramValues)) : this.delegate.update(sql, paramValues);
    }

    @Override
    public CompletionStage<int[]> update(String sql, List<Object[]> paramValues) {
        return this.hasBatch() ? this.executeBatch().thenCompose(v -> this.delegate.update(sql, paramValues)) : this.delegate.update(sql, paramValues);
    }

    @Override
    public <T> CompletionStage<T> insertAndSelectIdentifier(String sql, Object[] paramValues, Class<T> idClass, String idColumnName) {
        return this.hasBatch() ? this.executeBatch().thenCompose(v -> this.delegate.insertAndSelectIdentifier(sql, paramValues, idClass, idColumnName)) : this.delegate.insertAndSelectIdentifier(sql, paramValues, idClass, idColumnName);
    }

    @Override
    public CompletionStage<ReactiveConnection.Result> select(String sql) {
        return this.hasBatch() ? this.executeBatch().thenCompose(v -> this.delegate.select(sql)) : this.delegate.select(sql);
    }

    @Override
    public CompletionStage<ReactiveConnection.Result> select(String sql, Object[] paramValues) {
        return this.hasBatch() ? this.executeBatch().thenCompose(v -> this.delegate.select(sql, paramValues)) : this.delegate.select(sql, paramValues);
    }

    @Override
    public CompletionStage<ResultSet> selectJdbc(String sql, Object[] paramValues) {
        return this.hasBatch() ? this.executeBatch().thenCompose(v -> this.delegate.selectJdbc(sql, paramValues)) : this.delegate.selectJdbc(sql, paramValues);
    }

    @Override
    public CompletionStage<ResultSet> selectJdbcOutsideTransaction(String sql, Object[] paramValues) {
        return this.delegate.selectJdbcOutsideTransaction(sql, paramValues);
    }

    @Override
    public <T> CompletionStage<T> selectIdentifier(String sql, Object[] paramValues, Class<T> idClass) {
        return this.delegate.selectIdentifier(sql, paramValues, idClass);
    }

    @Override
    public CompletionStage<Void> beginTransaction() {
        return this.delegate.beginTransaction();
    }

    @Override
    public CompletionStage<Void> commitTransaction() {
        return this.delegate.commitTransaction();
    }

    @Override
    public CompletionStage<Void> rollbackTransaction() {
        return this.delegate.rollbackTransaction();
    }

    @Override
    public CompletionStage<Void> close() {
        return this.delegate.close();
    }
}

