/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.reactive.persister.entity.impl;

import java.util.Iterator;
import org.hibernate.HibernateException;
import org.hibernate.MappingException;
import org.hibernate.boot.model.relational.SqlStringGenerationContext;
import org.hibernate.dialect.CockroachDB192Dialect;
import org.hibernate.dialect.DB2Dialect;
import org.hibernate.dialect.Dialect;
import org.hibernate.dialect.PostgreSQL81Dialect;
import org.hibernate.dialect.SQLServerDialect;
import org.hibernate.id.IdentityGenerator;
import org.hibernate.id.PostInsertIdentityPersister;
import org.hibernate.id.insert.IdentifierGeneratingInsert;
import org.hibernate.id.insert.InsertGeneratedIdentifierDelegate;
import org.hibernate.sql.Insert;

public class ReactiveIdentityGenerator
extends IdentityGenerator {
    public InsertGeneratedIdentifierDelegate getInsertGeneratedIdentifierDelegate(PostInsertIdentityPersister persister, Dialect dialect, boolean isGetGeneratedKeysEnabled) throws HibernateException {
        return new ReactiveInsertAndSelectDelegate(persister, dialect);
    }

    public static class SqlServerIdentifierGeneratingInsert
    extends IdentifierGeneratingInsert {
        private String identityColumnName;

        public SqlServerIdentifierGeneratingInsert(Dialect dialect) {
            super(dialect);
        }

        public Insert addIdentityColumn(String columnName) {
            this.identityColumnName = columnName;
            return super.addIdentityColumn(columnName);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public String toStatementString() {
            StringBuilder buf = new StringBuilder(this.columns.size() * 15 + this.tableName.length() + 10);
            if (this.comment != null) {
                buf.append("/* ").append(Dialect.escapeComment((String)this.comment)).append(" */ ");
            }
            buf.append("insert into ").append(this.tableName);
            if (this.columns.size() == 0) {
                if (!this.getDialect().supportsNoColumnsInsert()) throw new MappingException(String.format("The INSERT statement for table [%s] contains no column, and this is not supported by [%s]", this.tableName, this.getDialect()));
                buf.append(" output inserted.").append(this.identityColumnName);
                buf.append(' ').append(this.getDialect().getNoColumnsInsertString());
                return buf.toString();
            } else {
                buf.append(" (");
                Iterator<Object> iter = this.columns.keySet().iterator();
                while (iter.hasNext()) {
                    buf.append((String)iter.next());
                    if (!iter.hasNext()) continue;
                    buf.append(", ");
                }
                buf.append(")");
                buf.append(" output inserted.").append(this.identityColumnName);
                buf.append(" values (");
                iter = this.columns.values().iterator();
                while (iter.hasNext()) {
                    buf.append((String)iter.next());
                    if (!iter.hasNext()) continue;
                    buf.append(", ");
                }
                buf.append(')');
            }
            return buf.toString();
        }
    }

    public static class PostgresIdentifierGeneratingInsert
    extends IdentifierGeneratingInsert {
        private String identityColumnName;

        public PostgresIdentifierGeneratingInsert(Dialect dialect) {
            super(dialect);
        }

        public Insert addIdentityColumn(String columnName) {
            this.identityColumnName = columnName;
            return super.addIdentityColumn(columnName);
        }

        public String toStatementString() {
            return super.toStatementString() + " returning " + this.identityColumnName;
        }
    }

    public static class Db2IdentifierGeneratingInsert
    extends IdentifierGeneratingInsert {
        private String identityColumnName;

        public Db2IdentifierGeneratingInsert(Dialect dialect) {
            super(dialect);
        }

        public Insert addIdentityColumn(String columnName) {
            this.identityColumnName = columnName;
            return super.addIdentityColumn(columnName);
        }

        public String toStatementString() {
            return "select " + this.identityColumnName + " from new table (" + super.toStatementString() + ")";
        }
    }

    public static class ReactiveInsertAndSelectDelegate
    extends IdentityGenerator.InsertSelectDelegate {
        private final PostInsertIdentityPersister persister;
        private final Dialect dialect;

        public ReactiveInsertAndSelectDelegate(PostInsertIdentityPersister persister, Dialect dialect) {
            super(persister, dialect);
            this.persister = persister;
            this.dialect = dialect;
        }

        public IdentifierGeneratingInsert prepareIdentifierGeneratingInsert(SqlStringGenerationContext context) {
            IdentifierGeneratingInsert insert = this.createInsert(context);
            insert.addIdentityColumn(this.persister.getRootTableKeyColumnNames()[0]);
            return insert;
        }

        private IdentifierGeneratingInsert createInsert(SqlStringGenerationContext context) {
            if (this.dialect instanceof PostgreSQL81Dialect || this.dialect instanceof CockroachDB192Dialect) {
                return new PostgresIdentifierGeneratingInsert(this.dialect);
            }
            if (this.dialect instanceof SQLServerDialect) {
                return new SqlServerIdentifierGeneratingInsert(this.dialect);
            }
            if (this.dialect instanceof DB2Dialect) {
                return new Db2IdentifierGeneratingInsert(this.dialect);
            }
            return super.prepareIdentifierGeneratingInsert(context);
        }
    }
}

