/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.reactive.persister.entity.impl;

import jakarta.persistence.metamodel.Attribute;
import java.io.Serializable;
import java.lang.invoke.MethodHandles;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletionStage;
import org.hibernate.AssertionFailure;
import org.hibernate.HibernateException;
import org.hibernate.JDBCException;
import org.hibernate.LockMode;
import org.hibernate.LockOptions;
import org.hibernate.Session;
import org.hibernate.StaleObjectStateException;
import org.hibernate.bytecode.enhance.spi.interceptor.LazyAttributeDescriptor;
import org.hibernate.collection.spi.PersistentCollection;
import org.hibernate.dialect.Dialect;
import org.hibernate.engine.OptimisticLockStyle;
import org.hibernate.engine.internal.Versioning;
import org.hibernate.engine.spi.EntityEntry;
import org.hibernate.engine.spi.EntityKey;
import org.hibernate.engine.spi.ExecuteUpdateResultCheckStyle;
import org.hibernate.engine.spi.LoadQueryInfluencers;
import org.hibernate.engine.spi.Mapping;
import org.hibernate.engine.spi.PersistenceContext;
import org.hibernate.engine.spi.PersistentAttributeInterceptable;
import org.hibernate.engine.spi.PersistentAttributeInterceptor;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.event.spi.EventSource;
import org.hibernate.internal.SessionFactoryImpl;
import org.hibernate.internal.util.collections.ArrayHelper;
import org.hibernate.jdbc.Expectation;
import org.hibernate.jdbc.Expectations;
import org.hibernate.loader.entity.UniqueEntityLoader;
import org.hibernate.persister.entity.AbstractEntityPersister;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.persister.entity.Lockable;
import org.hibernate.persister.entity.MultiLoadOptions;
import org.hibernate.persister.entity.OuterJoinLoadable;
import org.hibernate.pretty.MessageHelper;
import org.hibernate.reactive.adaptor.impl.PreparedStatementAdaptor;
import org.hibernate.reactive.id.impl.IdentifierGeneration;
import org.hibernate.reactive.loader.entity.impl.ReactiveDynamicBatchingEntityLoaderBuilder;
import org.hibernate.reactive.loader.entity.impl.ReactiveEntityLoader;
import org.hibernate.reactive.logging.impl.Log;
import org.hibernate.reactive.logging.impl.LoggerFactory;
import org.hibernate.reactive.mutiny.impl.MutinySessionFactoryImpl;
import org.hibernate.reactive.mutiny.impl.MutinySessionImpl;
import org.hibernate.reactive.persister.entity.impl.ReactiveEntityPersister;
import org.hibernate.reactive.pool.ReactiveConnection;
import org.hibernate.reactive.pool.impl.Parameters;
import org.hibernate.reactive.session.ReactiveConnectionSupplier;
import org.hibernate.reactive.session.ReactiveSession;
import org.hibernate.reactive.stage.impl.StageSessionFactoryImpl;
import org.hibernate.reactive.stage.impl.StageSessionImpl;
import org.hibernate.reactive.tuple.MutinyValueGenerator;
import org.hibernate.reactive.tuple.StageValueGenerator;
import org.hibernate.reactive.util.impl.CompletionStages;
import org.hibernate.sql.Delete;
import org.hibernate.sql.SimpleSelect;
import org.hibernate.sql.Update;
import org.hibernate.tuple.GenerationTiming;
import org.hibernate.tuple.InMemoryValueGenerationStrategy;
import org.hibernate.tuple.NonIdentifierAttribute;
import org.hibernate.tuple.ValueGenerator;
import org.hibernate.type.EntityType;
import org.hibernate.type.Type;
import org.hibernate.type.VersionType;

public interface ReactiveAbstractEntityPersister
extends ReactiveEntityPersister,
OuterJoinLoadable,
Lockable {
    public static final Log log = LoggerFactory.make(Log.class, MethodHandles.lookup());

    default public Parameters parameters() {
        return Parameters.instance(this.getFactory().getJdbcServices().getDialect());
    }

    default public AbstractEntityPersister delegate() {
        return (AbstractEntityPersister)this;
    }

    default public ReactiveConnection getReactiveConnection(SharedSessionContractImplementor session) {
        return ((ReactiveConnectionSupplier)session).getReactiveConnection();
    }

    public String getSqlInsertGeneratedValuesSelectString();

    public String getSqlUpdateGeneratedValuesSelectString();

    @Override
    default public CompletionStage<Void> reactiveProcessInsertGenerated(Serializable id, Object entity, Object[] state, SharedSessionContractImplementor session) {
        if (!this.hasInsertGeneratedProperties()) {
            throw new AssertionFailure("no insert-generated properties");
        }
        return this.processGeneratedProperties(id, entity, state, session, this.getSqlInsertGeneratedValuesSelectString(), GenerationTiming.INSERT);
    }

    @Override
    default public CompletionStage<Void> reactiveProcessUpdateGenerated(Serializable id, Object entity, Object[] state, SharedSessionContractImplementor session) {
        if (!this.hasUpdateGeneratedProperties()) {
            throw new AssertionFailure("no update-generated properties");
        }
        return this.processGeneratedProperties(id, entity, state, session, this.getSqlUpdateGeneratedValuesSelectString(), GenerationTiming.ALWAYS);
    }

    default public CompletionStage<Void> processGeneratedProperties(Serializable id, Object entity, Object[] state, SharedSessionContractImplementor session, String selectionSQL, GenerationTiming matchTiming) {
        ReactiveConnection connection = this.getReactiveConnection(session);
        return connection.executeBatch().thenCompose(v -> connection.selectJdbc(selectionSQL, PreparedStatementAdaptor.bind(ps -> this.getIdentifierType().nullSafeSet(ps, (Object)id, 1, session)))).thenAccept(rs -> {
            try {
                if (!rs.next()) {
                    throw log.unableToRetrieveGeneratedProperties(MessageHelper.infoString((EntityPersister)this, (Object)id, (SessionFactoryImplementor)this.getFactory()));
                }
                int propertyIndex = -1;
                for (NonIdentifierAttribute attribute : this.getEntityMetamodel().getProperties()) {
                    ++propertyIndex;
                    if (!AbstractEntityPersister.isValueGenerationRequired((NonIdentifierAttribute)attribute, (GenerationTiming)matchTiming)) continue;
                    Object hydratedState = attribute.getType().hydrate(rs, this.getPropertyAliases("", propertyIndex), session, entity);
                    state[propertyIndex] = attribute.getType().resolve(hydratedState, session, entity);
                    this.setPropertyValue(entity, propertyIndex, state[propertyIndex]);
                }
            }
            catch (SQLException sqle) {
                throw new JDBCException("unable to select generated column values: " + selectionSQL, sqle);
            }
        });
    }

    @Override
    default public CompletionStage<Serializable> insertReactive(Object[] fields, Object object, SharedSessionContractImplementor session) {
        return this.reactivePreInsertInMemoryValueGeneration(fields, object, session).thenCompose(unused -> {
            int span = this.delegate().getTableSpan();
            if (this.delegate().getEntityMetamodel().isDynamicInsert()) {
                boolean[] notNull = this.delegate().getPropertiesToInsert(fields);
                return this.insertReactive(fields, notNull, this.delegate().generateIdentityInsertString(this.getFactory().getSqlStringGenerationContext(), notNull), session).thenCompose(id -> CompletionStages.loop(1, span, table -> this.insertReactive((Serializable)id, fields, notNull, table, this.delegate().generateInsertString(notNull, table), session)).thenApply(v -> id));
            }
            return this.insertReactive(fields, this.delegate().getPropertyInsertability(), this.delegate().getSQLIdentityInsertString(), session).thenCompose(id -> CompletionStages.loop(1, span, table -> this.insertReactive((Serializable)id, fields, this.delegate().getPropertyInsertability(), table, this.delegate().getSQLInsertStrings()[table], session)).thenApply(v -> id));
        });
    }

    default public CompletionStage<Void> reactivePreInsertInMemoryValueGeneration(Object[] fields, Object object, SharedSessionContractImplementor session) {
        CompletionStage<Void> stage = CompletionStages.voidFuture();
        if (this.getEntityMetamodel().hasPreInsertGeneratedValues()) {
            InMemoryValueGenerationStrategy[] strategies = this.getEntityMetamodel().getInMemoryValueGenerationStrategies();
            for (int i = 0; i < strategies.length; ++i) {
                int index = i;
                InMemoryValueGenerationStrategy strategy = strategies[i];
                if (strategy == null || !strategy.getGenerationTiming().includesInsert()) continue;
                stage = stage.thenCompose(v -> this.generateValue(object, session, strategy).thenAccept(value -> {
                    fields[index] = value;
                    this.setPropertyValue(object, index, value);
                }));
            }
        }
        return stage;
    }

    @Override
    default public CompletionStage<Void> insertReactive(Serializable id, Object[] fields, Object object, SharedSessionContractImplementor session) {
        return this.reactivePreInsertInMemoryValueGeneration(fields, object, session).thenCompose(v -> {
            int span = this.delegate().getTableSpan();
            if (this.delegate().getEntityMetamodel().isDynamicInsert()) {
                boolean[] notNull = this.delegate().getPropertiesToInsert(fields);
                return CompletionStages.loop(0, span, table -> this.insertReactive(id, fields, notNull, table, this.delegate().generateInsertString(notNull, table), session));
            }
            return CompletionStages.loop(0, span, table -> this.insertReactive(id, fields, this.delegate().getPropertyInsertability(), table, this.delegate().getSQLInsertStrings()[table], session));
        });
    }

    default public CompletionStage<Void> insertReactive(Serializable id, Object[] fields, boolean[] notNull, int j, String sql, SharedSessionContractImplementor session) {
        Expectation expectation;
        if (this.delegate().isInverseTable(j)) {
            return CompletionStages.voidFuture();
        }
        if (this.delegate().isNullableTable(j) && this.delegate().isAllNull(fields, j)) {
            return CompletionStages.voidFuture();
        }
        if (log.isTraceEnabled()) {
            log.tracev("Inserting entity: {0}", MessageHelper.infoString((EntityPersister)this.delegate(), (Object)id, (SessionFactoryImplementor)this.delegate().getFactory()));
            if (j == 0 && this.delegate().isVersioned()) {
                log.tracev("Version: {0}", Versioning.getVersion((Object[])fields, (EntityPersister)this.delegate()));
            }
        }
        boolean useBatch = (expectation = Expectations.appropriateExpectation((ExecuteUpdateResultCheckStyle)this.delegate().getInsertResultCheckStyles()[j])).canBeBatched() && this.getIdentifierGenerator().supportsJdbcBatchInserts();
        Object[] params = PreparedStatementAdaptor.bind(insert -> {
            boolean[][] insertable = this.delegate().getPropertyColumnInsertable();
            int index = this.delegate().dehydrate(id, fields, notNull, insertable, j, insert, session, false);
        });
        return this.getReactiveConnection(session).update(sql, params, useBatch, new InsertExpectation(expectation, this));
    }

    default public CompletionStage<Serializable> insertReactive(Object[] fields, boolean[] notNull, String sql, SharedSessionContractImplementor session) {
        if (log.isTraceEnabled()) {
            log.tracev("Inserting entity: {0}", MessageHelper.infoString((EntityPersister)this.delegate()));
            if (this.delegate().isVersioned()) {
                log.tracev("Version: {0}", Versioning.getVersion((Object[])fields, (EntityPersister)this.delegate()));
            }
        }
        Object[] params = PreparedStatementAdaptor.bind(insert -> {
            boolean[][] insertable = this.delegate().getPropertyColumnInsertable();
            this.delegate().dehydrate(null, fields, notNull, insertable, 0, insert, session, false);
        });
        Class<Long> idClass = this.delegate().getIdentifierType().getReturnedClass();
        if (idClass.equals(Integer.class) || idClass.equals(Short.class)) {
            idClass = Long.class;
        }
        return this.getReactiveConnection(session).insertAndSelectIdentifier(sql, params, idClass, this.delegate().getIdentifierColumnNames()[0]).thenApply(generatedId -> {
            log.debugf("Natively generated identity: %s", generatedId);
            if (generatedId == null) {
                throw log.noNativelyGeneratedValueReturned();
            }
            return IdentifierGeneration.castToIdentifierType(generatedId, this);
        });
    }

    default public CompletionStage<Void> deleteReactive(Serializable id, Object version, int j, String sql, SharedSessionContractImplementor session, Object[] loadedState) {
        boolean useBatch;
        if (this.delegate().isInverseTable(j)) {
            return CompletionStages.voidFuture();
        }
        boolean useVersion = j == 0 && this.delegate().isVersioned();
        Expectation expectation = Expectations.appropriateExpectation((ExecuteUpdateResultCheckStyle)this.delegate().getDeleteResultCheckStyles()[j]);
        boolean bl = useBatch = j == 0 && this.isBatchable() && expectation.canBeBatched();
        if (log.isTraceEnabled()) {
            log.tracev("Deleting entity: {0}", MessageHelper.infoString((EntityPersister)this.delegate(), (Object)id, (SessionFactoryImplementor)this.delegate().getFactory()));
            if (useVersion) {
                log.tracev("Version: {0}", version);
            }
        }
        if (this.delegate().isTableCascadeDeleteEnabled(j)) {
            if (log.isTraceEnabled()) {
                log.tracev("Delete handled by foreign key constraint: {0}", this.delegate().getTableName(j));
            }
            return CompletionStages.voidFuture();
        }
        Object[] params = PreparedStatementAdaptor.bind(delete -> {
            int index = 1;
            this.delegate().getIdentifierType().nullSafeSet(delete, (Object)id, index += expectation.prepare(delete), session);
            index += this.delegate().getIdentifierColumnSpan();
            if (useVersion) {
                this.delegate().getVersionType().nullSafeSet(delete, version, index, session);
            } else if (this.isAllOrDirtyOptimisticLocking() && loadedState != null) {
                boolean[] versionability = this.delegate().getPropertyVersionability();
                Type[] types = this.delegate().getPropertyTypes();
                for (int i = 0; i < this.delegate().getEntityMetamodel().getPropertySpan(); ++i) {
                    if (!this.delegate().isPropertyOfTable(i, j) || !versionability[i]) continue;
                    boolean[] settable = types[i].toColumnNullness(loadedState[i], (Mapping)this.delegate().getFactory());
                    types[i].nullSafeSet(delete, loadedState[i], index, settable, session);
                    index += ArrayHelper.countTrue((boolean[])settable);
                }
            }
        });
        return this.getReactiveConnection(session).update(sql, params, useBatch, new DeleteExpectation(id, j, expectation, this));
    }

    @Override
    default public CompletionStage<Void> deleteReactive(Serializable id, Object version, Object object, SharedSessionContractImplementor session) {
        int span = this.delegate().getTableSpan();
        boolean isImpliedOptimisticLocking = !this.delegate().getEntityMetamodel().isVersioned() && this.isAllOrDirtyOptimisticLocking();
        Object[] loadedState = null;
        if (isImpliedOptimisticLocking) {
            EntityKey key = session.generateEntityKey(id, (EntityPersister)this.delegate());
            PersistenceContext persistenceContext = session.getPersistenceContextInternal();
            Object entity = persistenceContext.getEntity(key);
            if (entity != null) {
                EntityEntry entry = persistenceContext.getEntry(entity);
                loadedState = entry.getLoadedState();
            }
        }
        String[] deleteStrings = isImpliedOptimisticLocking && loadedState != null ? this.generateDynamicSQLDeleteStrings(loadedState) : this.delegate().getSQLDeleteStrings();
        Object[] state = loadedState;
        return CompletionStages.loop(0, span, table -> this.deleteReactive(id, version, span - table - 1, deleteStrings[span - table - 1], session, state));
    }

    default public boolean isAllOrDirtyOptimisticLocking() {
        OptimisticLockStyle optimisticLockStyle = this.delegate().getEntityMetamodel().getOptimisticLockStyle();
        return optimisticLockStyle == OptimisticLockStyle.DIRTY || optimisticLockStyle == OptimisticLockStyle.ALL;
    }

    default public String[] generateDynamicSQLDeleteStrings(Object[] loadedState) {
        int span = this.delegate().getTableSpan();
        String[] deleteStrings = new String[span];
        for (int j = span - 1; j >= 0; --j) {
            Delete delete = new Delete().setTableName(this.delegate().getTableName(j)).addPrimaryKeyColumns(this.delegate().getKeyColumns(j));
            if (this.delegate().getFactory().getSessionFactoryOptions().isCommentsEnabled()) {
                delete.setComment("delete " + this.delegate().getEntityName() + " [" + j + "]");
            }
            boolean[] versionability = this.delegate().getPropertyVersionability();
            Type[] types = this.delegate().getPropertyTypes();
            for (int i = 0; i < this.delegate().getEntityMetamodel().getPropertySpan(); ++i) {
                if (!this.delegate().isPropertyOfTable(i, j) || !versionability[i]) continue;
                String[] propertyColumnNames = this.delegate().getPropertyColumnNames(i);
                boolean[] propertyNullness = types[i].toColumnNullness(loadedState[i], (Mapping)this.delegate().getFactory());
                for (int k = 0; k < propertyNullness.length; ++k) {
                    if (propertyNullness[k]) {
                        delete.addWhereFragment(propertyColumnNames[k] + " = ?");
                        continue;
                    }
                    delete.addWhereFragment(propertyColumnNames[k] + " is null");
                }
            }
            deleteStrings[j] = this.parameters().process(delete.toStatementString());
        }
        return deleteStrings;
    }

    default public CompletionStage<Boolean> updateReactive(Serializable id, Object[] fields, Object[] oldFields, Object rowId, boolean[] includeProperty, int j, Object oldVersion, String sql, SharedSessionContractImplementor session) {
        boolean useVersion;
        Expectation expectation = Expectations.appropriateExpectation((ExecuteUpdateResultCheckStyle)this.delegate().getUpdateResultCheckStyles()[j]);
        boolean useBatch = expectation.canBeBatched() && this.isBatchable();
        boolean bl = useVersion = j == 0 && this.delegate().isVersioned();
        if (log.isTraceEnabled()) {
            log.tracev("Updating entity: {0}", MessageHelper.infoString((EntityPersister)this.delegate(), (Object)id, (SessionFactoryImplementor)this.delegate().getFactory()));
            if (useVersion) {
                log.tracev("Existing version: {0} -> New version:{1}", oldVersion, fields[this.delegate().getVersionProperty()]);
            }
        }
        Object[] params = PreparedStatementAdaptor.bind(update -> {
            int index = 1;
            index += expectation.prepare(update);
            index = this.delegate().dehydrate(id, fields, rowId, includeProperty, this.delegate().getPropertyColumnUpdateable(), j, update, session, index, true);
            if (useVersion && this.delegate().getEntityMetamodel().getOptimisticLockStyle() == OptimisticLockStyle.VERSION) {
                if (this.delegate().checkVersion(includeProperty)) {
                    this.delegate().getVersionType().nullSafeSet(update, oldVersion, index, session);
                }
            } else if (this.isAllOrDirtyOptimisticLocking() && oldFields != null) {
                boolean[] versionability = this.delegate().getPropertyVersionability();
                boolean[] includeOldField = this.delegate().getEntityMetamodel().getOptimisticLockStyle() == OptimisticLockStyle.ALL ? this.delegate().getPropertyUpdateability() : includeProperty;
                Type[] types = this.delegate().getPropertyTypes();
                for (int i = 0; i < this.delegate().getEntityMetamodel().getPropertySpan(); ++i) {
                    boolean include;
                    boolean bl = include = includeOldField[i] && this.delegate().isPropertyOfTable(i, j) && versionability[i];
                    if (!include) continue;
                    boolean[] settable = types[i].toColumnNullness(oldFields[i], (Mapping)this.delegate().getFactory());
                    types[i].nullSafeSet(update, oldFields[i], index, settable, session);
                    index += ArrayHelper.countTrue((boolean[])settable);
                }
            }
        });
        UpdateExpectation result = new UpdateExpectation(id, j, expectation, this);
        return this.getReactiveConnection(session).update(sql, params, useBatch, result).thenApply(v -> useBatch || result.isSuccessful());
    }

    public boolean check(int var1, Serializable var2, int var3, Expectation var4, PreparedStatement var5, String var6) throws HibernateException;

    @Override
    default public CompletionStage<Void> updateReactive(Serializable id, Object[] fields, int[] paramDirtyFields, boolean hasDirtyCollection, Object[] oldFields, Object oldVersion, Object object, Object rowId, SharedSessionContractImplementor session) {
        InMemoryValueGenerationStrategy[] valueGenerationStrategies;
        int valueGenerationStrategiesSize;
        CompletionStage<Void> stage = CompletionStages.voidFuture();
        CompletionStage<int[]> dirtyFieldsStage = CompletionStages.completedFuture(paramDirtyFields);
        if (this.delegate().getEntityMetamodel().hasPreUpdateGeneratedValues() && (valueGenerationStrategiesSize = (valueGenerationStrategies = this.delegate().getEntityMetamodel().getInMemoryValueGenerationStrategies()).length) != 0) {
            int[] fieldsPreUpdateNeeded = new int[valueGenerationStrategiesSize];
            int count = 0;
            for (int i = 0; i < valueGenerationStrategiesSize; ++i) {
                int index = i;
                if (valueGenerationStrategies[i] == null || !valueGenerationStrategies[i].getGenerationTiming().includesUpdate()) continue;
                stage = stage.thenCompose(v -> this.generateValue(object, session, valueGenerationStrategies[index]).thenAccept(value -> this.setFieldValue(fields, object, index, value)));
                fieldsPreUpdateNeeded[count++] = i;
            }
            int finalCount = count;
            dirtyFieldsStage = stage.thenApply(v -> paramDirtyFields != null ? ArrayHelper.join((int[])paramDirtyFields, (int[])ArrayHelper.trim((int[])fieldsPreUpdateNeeded, (int)finalCount)) : null);
        }
        return dirtyFieldsStage.thenCompose(dirtyFields -> {
            String[] updateStrings;
            boolean[] propsToUpdate;
            boolean[] tableUpdateNeeded = this.delegate().getTableUpdateNeeded(dirtyFields, hasDirtyCollection);
            int span = this.delegate().getTableSpan();
            EntityEntry entry = session.getPersistenceContextInternal().getEntry(object);
            if (entry == null && !this.delegate().isMutable()) {
                throw log.updatingImmutableEntityThatsNotInTheSession();
            }
            if (this.delegate().getEntityMetamodel().isDynamicUpdate() && dirtyFields != null) {
                propsToUpdate = this.delegate().getPropertiesToUpdate(dirtyFields, hasDirtyCollection);
                updateStrings = new String[span];
                for (int j = 0; j < span; ++j) {
                    boolean useRowId = j == 0 && rowId != null;
                    updateStrings[j] = tableUpdateNeeded[j] ? this.delegate().generateUpdateString(propsToUpdate, j, oldFields, useRowId) : null;
                }
            } else if (!this.delegate().isModifiableEntity(entry)) {
                propsToUpdate = this.delegate().getPropertiesToUpdate(dirtyFields == null ? ArrayHelper.EMPTY_INT_ARRAY : dirtyFields, hasDirtyCollection);
                updateStrings = new String[span];
                for (int j = 0; j < span; ++j) {
                    boolean useRowId = j == 0 && rowId != null;
                    updateStrings[j] = tableUpdateNeeded[j] ? this.delegate().generateUpdateString(propsToUpdate, j, oldFields, useRowId) : null;
                }
            } else {
                boolean hasUninitializedLazy = this.delegate().hasUninitializedLazyProperties(object);
                updateStrings = this.getUpdateStrings(rowId != null, hasUninitializedLazy);
                propsToUpdate = this.delegate().getPropertyUpdateability(object);
            }
            return CompletionStages.loop(0, span, i -> tableUpdateNeeded[i], table -> this.updateOrInsertReactive(id, fields, oldFields, table == 0 ? rowId : null, propsToUpdate, table, oldVersion, updateStrings[table], session));
        });
    }

    default public CompletionStage<?> generateValue(Object owner, SharedSessionContractImplementor session, InMemoryValueGenerationStrategy valueGenerationStrategy) {
        ValueGenerator valueGenerator = valueGenerationStrategy.getValueGenerator();
        if (valueGenerator instanceof StageValueGenerator) {
            StageSessionFactoryImpl stageFactory = new StageSessionFactoryImpl((SessionFactoryImpl)session.getFactory());
            StageSessionImpl stageSession = new StageSessionImpl((ReactiveSession)session);
            return ((StageValueGenerator)valueGenerator).generateValue(stageSession, owner);
        }
        if (valueGenerator instanceof MutinyValueGenerator) {
            MutinySessionFactoryImpl mutinyFactory = new MutinySessionFactoryImpl((SessionFactoryImpl)session.getFactory());
            MutinySessionImpl mutinySession = new MutinySessionImpl((ReactiveSession)session, mutinyFactory);
            return ((MutinyValueGenerator)valueGenerator).generateValue(mutinySession, owner).subscribeAsCompletionStage();
        }
        return CompletionStages.completedFuture(valueGenerationStrategy.getValueGenerator().generateValue((Session)session, owner));
    }

    default public void setFieldValue(Object[] fields, Object object, int index, Object value) {
        fields[index] = value;
        this.delegate().setPropertyValue(object, index, fields[index]);
    }

    public String[] getUpdateStrings(boolean var1, boolean var2);

    default public CompletionStage<Void> updateOrInsertReactive(Serializable id, Object[] fields, Object[] oldFields, Object rowId, boolean[] includeProperty, int j, Object oldVersion, String sql, SharedSessionContractImplementor session) {
        if (!this.delegate().isInverseTable(j)) {
            if (this.delegate().isNullableTable(j) && oldFields != null && this.delegate().isAllNull(oldFields, j)) {
                if (!this.delegate().isAllNull(fields, j)) {
                    return this.insertReactive(id, fields, this.delegate().getPropertyInsertability(), j, this.delegate().getSQLInsertStrings()[j], session);
                }
            } else {
                if (this.delegate().isNullableTable(j) && this.delegate().isAllNull(fields, j)) {
                    return this.deleteReactive(id, oldVersion, j, this.delegate().getSQLDeleteStrings()[j], session, null);
                }
                return this.updateReactive(id, fields, oldFields, rowId, includeProperty, j, oldVersion, sql, session).thenCompose(updated -> {
                    if (!updated.booleanValue() && !this.delegate().isAllNull(fields, j)) {
                        return this.insertReactive(id, fields, this.delegate().getPropertyInsertability(), j, this.delegate().getSQLInsertStrings()[j], session);
                    }
                    return CompletionStages.voidFuture();
                });
            }
        }
        return CompletionStages.voidFuture();
    }

    default public String generateSelectLockString(LockOptions lockOptions) {
        SessionFactoryImplementor factory = this.getFactory();
        Dialect dialect = factory.getJdbcServices().getDialect();
        SimpleSelect select = new SimpleSelect(dialect).setLockOptions(lockOptions).setTableName(this.getRootTableName()).addColumn(this.getRootTableIdentifierColumnNames()[0]).addCondition(this.getRootTableIdentifierColumnNames(), "=?");
        if (this.isVersioned()) {
            select.addCondition(this.getVersionColumnName(), "=?");
        }
        if (factory.getSessionFactoryOptions().isCommentsEnabled()) {
            select.setComment(lockOptions.getLockMode() + " lock " + this.getEntityName());
        }
        return this.parameters().process(select.toStatementString());
    }

    default public String generateUpdateLockString(LockOptions lockOptions) {
        SessionFactoryImplementor factory = this.getFactory();
        Dialect dialect = factory.getJdbcServices().getDialect();
        Update update = new Update(dialect);
        update.setTableName(this.getRootTableName());
        update.addPrimaryKeyColumns(this.getRootTableIdentifierColumnNames());
        update.setVersionColumnName(this.getVersionColumnName());
        update.addColumn(this.getVersionColumnName());
        if (factory.getSessionFactoryOptions().isCommentsEnabled()) {
            update.setComment(lockOptions.getLockMode() + " lock " + this.getEntityName());
        }
        return this.parameters().process(update.toStatementString());
    }

    @Override
    default public CompletionStage<Void> lockReactive(Serializable id, Object version, Object object, LockOptions lockOptions, SharedSessionContractImplementor session) throws HibernateException {
        boolean writeLock;
        String sql;
        LockMode lockMode = lockOptions.getLockMode();
        Object nextVersion = this.nextVersionForLock(lockMode, id, version, object, session);
        switch (lockMode) {
            case NONE: {
                return CompletionStages.voidFuture();
            }
            case PESSIMISTIC_READ: 
            case PESSIMISTIC_WRITE: 
            case UPGRADE: 
            case UPGRADE_NOWAIT: 
            case UPGRADE_SKIPLOCKED: {
                sql = this.generateSelectLockString(lockOptions);
                writeLock = false;
                break;
            }
            case PESSIMISTIC_FORCE_INCREMENT: 
            case FORCE: {
                sql = this.generateUpdateLockString(lockOptions);
                writeLock = true;
                break;
            }
            case OPTIMISTIC: 
            case OPTIMISTIC_FORCE_INCREMENT: {
                throw new AssertionFailure("optimistic lock mode is not supported here");
            }
            case READ: 
            case WRITE: {
                throw new AssertionFailure("implicit lock mode is not supported here");
            }
            default: {
                throw new AssertionFailure("illegal lock mode");
            }
        }
        Object[] arguments = PreparedStatementAdaptor.bind(statement -> {
            int offset = 1;
            if (writeLock) {
                this.getVersionType().nullSafeSet(statement, nextVersion, offset, session);
                ++offset;
            }
            this.getIdentifierType().nullSafeSet(statement, (Object)id, offset, session);
            offset += this.getIdentifierType().getColumnSpan((Mapping)this.getFactory());
            if (this.isVersioned()) {
                this.getVersionType().nullSafeSet(statement, version, offset, session);
            }
        });
        ReactiveConnection connection = this.getReactiveConnection(session);
        CompletionStage<Boolean> lock = writeLock ? connection.update(sql, arguments).thenApply(affected -> affected > 0) : connection.select(sql, arguments).thenApply(Iterator::hasNext);
        return lock.thenAccept(rowExisted -> {
            if (!rowExisted.booleanValue()) {
                throw new StaleObjectStateException(this.getEntityName(), id);
            }
        }).handle((r, e) -> {
            CompletionStages.logSqlException(e, () -> "could not lock: " + MessageHelper.infoString((EntityPersister)this, (Object)id, (SessionFactoryImplementor)this.getFactory()), sql);
            return CompletionStages.returnOrRethrow(e, r);
        });
    }

    public VersionType<Object> getVersionType();

    default public Object nextVersionForLock(LockMode lockMode, Serializable id, Object version, Object entity, SharedSessionContractImplementor session) {
        if (lockMode == LockMode.PESSIMISTIC_FORCE_INCREMENT) {
            if (!this.isVersioned()) {
                throw new IllegalArgumentException("increment locks not supported for unversioned entity");
            }
            VersionType<Object> versionType = this.getVersionType();
            Object nextVersion = versionType.next(version, session);
            if (log.isTraceEnabled()) {
                log.trace("Forcing version increment [" + MessageHelper.infoString((EntityPersister)this, (Object)id, (SessionFactoryImplementor)this.getFactory()) + "; " + versionType.toLoggableString(version, this.getFactory()) + " -> " + versionType.toLoggableString(nextVersion, this.getFactory()) + "]");
            }
            session.getPersistenceContextInternal().getEntry(entity).forceLocked(entity, nextVersion);
            return nextVersion;
        }
        return version;
    }

    @Override
    default public CompletionStage<Object> reactiveLoad(Serializable id, Object optionalObject, LockOptions lockOptions, SharedSessionContractImplementor session) {
        return this.reactiveLoad(id, optionalObject, lockOptions, session, null);
    }

    @Override
    default public CompletionStage<Object> reactiveLoad(Serializable id, Object optionalObject, LockOptions lockOptions, SharedSessionContractImplementor session, Boolean readOnly) {
        if (log.isTraceEnabled()) {
            log.tracev("Fetching entity: {0}", MessageHelper.infoString((EntityPersister)this, (Object)id, (SessionFactoryImplementor)this.getFactory()));
        }
        return this.getAppropriateLoader(lockOptions, session).load(id, optionalObject, session, lockOptions, readOnly);
    }

    @Override
    default public CompletionStage<Object> reactiveLoadByUniqueKey(String propertyName, Object uniqueKey, SharedSessionContractImplementor session) {
        return this.getAppropriateUniqueKeyLoader(propertyName, session).load(uniqueKey, session, LockOptions.NONE);
    }

    @Override
    default public CompletionStage<List<Object>> reactiveMultiLoad(Serializable[] ids, SessionImplementor session, MultiLoadOptions loadOptions) {
        return ReactiveDynamicBatchingEntityLoaderBuilder.INSTANCE.multiLoad(this, ids, session, loadOptions);
    }

    @Override
    default public CompletionStage<Object[]> reactiveGetDatabaseSnapshot(Serializable id, SharedSessionContractImplementor session) {
        if (log.isTraceEnabled()) {
            log.tracev("Getting current persistent state for: {0}", MessageHelper.infoString((EntityPersister)this, (Object)id, (SessionFactoryImplementor)this.getFactory()));
        }
        Object[] params = PreparedStatementAdaptor.bind(statement -> this.getIdentifierType().nullSafeSet(statement, (Object)id, 1, session));
        return this.getReactiveConnection(session).selectJdbc(this.delegate().getSQLSnapshotSelectString(), params).thenApply(resultSet -> this.processSnapshot(session, (ResultSet)resultSet));
    }

    @Override
    default public CompletionStage<Object> reactiveGetCurrentVersion(Serializable id, SharedSessionContractImplementor session) {
        if (log.isTraceEnabled()) {
            log.tracev("Getting version: {0}", MessageHelper.infoString((EntityPersister)this, (Object)id, (SessionFactoryImplementor)this.getFactory()));
        }
        Object[] params = PreparedStatementAdaptor.bind(statement -> this.getIdentifierType().nullSafeSet(statement, (Object)id, 1, session));
        return this.getReactiveConnection(session).selectJdbc(this.delegate().getVersionSelectString(), params).thenApply(resultSet -> {
            try {
                if (!resultSet.next()) {
                    return null;
                }
                if (!this.isVersioned()) {
                    return this;
                }
                return this.getVersionType().nullSafeGet(resultSet, "version_", session, null);
            }
            catch (SQLException sqle) {
                throw new JDBCException("error reading version", sqle);
            }
        });
    }

    default public Object[] processSnapshot(SharedSessionContractImplementor session, ResultSet resultSet) {
        try {
            if (resultSet.next()) {
                Type[] types = this.getPropertyTypes();
                Object[] values = new Object[types.length];
                boolean[] includeProperty = this.getPropertyUpdateability();
                for (int i = 0; i < types.length; ++i) {
                    if (!includeProperty[i]) continue;
                    values[i] = types[i].hydrate(resultSet, this.getPropertyAliases("", i), session, null);
                }
                return values;
            }
            return null;
        }
        catch (SQLException e) {
            throw new JDBCException("error while binding parameters", e);
        }
    }

    default public boolean hasUnenhancedProxy() {
        return this.getEntityMetamodel().isLazy() && !this.getEntityMetamodel().getBytecodeEnhancementMetadata().isEnhancedForLazyLoading();
    }

    public Object initializeLazyProperty(String var1, Object var2, SharedSessionContractImplementor var3);

    @Override
    default public <E, T> CompletionStage<T> reactiveInitializeLazyProperty(Attribute<E, T> field, E entity, SharedSessionContractImplementor session) {
        String fieldName = field.getName();
        Object result = this.initializeLazyProperty(fieldName, entity, session);
        if (result instanceof CompletionStage) {
            return (CompletionStage)result;
        }
        if (result instanceof PersistentCollection) {
            PersistentCollection collection;
            String[] propertyNames = this.getPropertyNames();
            for (int index = 0; index < propertyNames.length; ++index) {
                if (!propertyNames[index].equals(fieldName)) continue;
                this.setPropertyValue(entity, index, result);
                break;
            }
            return (collection = (PersistentCollection)result).wasInitialized() ? CompletionStages.completedFuture(collection) : ((ReactiveSession)session).reactiveInitializeCollection(collection, false).thenApply(v -> result);
        }
        return CompletionStages.completedFuture(result);
    }

    default public CompletionStage<Object> reactiveInitializeLazyPropertiesFromDatastore(String fieldName, Object entity, SharedSessionContractImplementor session, Serializable id, EntityEntry entry) {
        if (!this.hasLazyProperties()) {
            throw new AssertionFailure("no lazy properties");
        }
        PersistentAttributeInterceptor interceptor = ((PersistentAttributeInterceptable)entity).$$_hibernate_getInterceptor();
        if (interceptor == null) {
            throw new AssertionFailure("Expecting bytecode interceptor to be non-null");
        }
        log.tracef("Initializing lazy properties from datastore (triggered for `%s`)", fieldName);
        String fetchGroup = this.getEntityMetamodel().getBytecodeEnhancementMetadata().getLazyAttributesMetadata().getFetchGroupName(fieldName);
        List fetchGroupAttributeDescriptors = this.getEntityMetamodel().getBytecodeEnhancementMetadata().getLazyAttributesMetadata().getFetchGroupAttributeDescriptors(fetchGroup);
        Set initializedLazyAttributeNames = interceptor.getInitializedLazyAttributeNames();
        Object[] arguments = PreparedStatementAdaptor.bind(statement -> this.getIdentifierType().nullSafeSet(statement, (Object)id, 1, session));
        String lazySelect = this.getSQLLazySelectString(fetchGroup);
        if (lazySelect == null) {
            return CompletionStages.completedFuture(this.initLazyProperty(fieldName, entity, session, entry, interceptor, fetchGroupAttributeDescriptors, initializedLazyAttributeNames, null));
        }
        return this.getReactiveConnection(session).selectJdbc(lazySelect, arguments).thenApply(resultSet -> {
            try {
                resultSet.next();
                return this.initLazyProperty(fieldName, entity, session, entry, interceptor, fetchGroupAttributeDescriptors, initializedLazyAttributeNames, (ResultSet)resultSet);
            }
            catch (SQLException sqle) {
                throw new JDBCException("error initializing lazy property", sqle);
            }
        });
    }

    default public Object initLazyProperty(String fieldName, Object entity, SharedSessionContractImplementor session, EntityEntry entry, PersistentAttributeInterceptor interceptor, List<LazyAttributeDescriptor> fetchGroupAttributeDescriptors, Set<String> initializedLazyAttributeNames, ResultSet resultSet) {
        for (LazyAttributeDescriptor fetchGroupAttributeDescriptor : fetchGroupAttributeDescriptors) {
            Object selectedValue;
            if (initializedLazyAttributeNames.contains(fetchGroupAttributeDescriptor.getName())) continue;
            try {
                selectedValue = fetchGroupAttributeDescriptor.getType().nullSafeGet(resultSet, this.getLazyPropertyColumnAliases()[fetchGroupAttributeDescriptor.getLazyIndex()], session, entity);
            }
            catch (SQLException sqle) {
                throw new JDBCException("error initializing lazy property", sqle);
            }
            boolean set = this.initializeLazyProperty(fieldName, entity, session, entry, fetchGroupAttributeDescriptor.getLazyIndex(), selectedValue);
            if (set) {
                interceptor.attributeInitialized(fetchGroupAttributeDescriptor.getName());
            }
            log.trace("Done initializing lazy properties");
            return selectedValue;
        }
        return null;
    }

    default public UniqueEntityLoader createReactiveUniqueKeyLoader(Type uniqueKeyType, String[] columns, LoadQueryInfluencers loadQueryInfluencers) {
        if (uniqueKeyType.isEntityType()) {
            String className = ((EntityType)uniqueKeyType).getAssociatedEntityName();
            uniqueKeyType = this.getFactory().getMetamodel().entityPersister(className).getIdentifierType();
        }
        return new ReactiveEntityLoader(this, columns, uniqueKeyType, 1, LockMode.NONE, this.getFactory(), loadQueryInfluencers);
    }

    @Override
    default public CompletionStage<Serializable> reactiveLoadEntityIdByNaturalId(Object[] naturalIdValues, LockOptions lockOptions, EventSource session) {
        if (log.isTraceEnabled()) {
            log.tracef("Resolving natural-id [%s] to id : %s ", Arrays.asList(naturalIdValues), MessageHelper.infoString((EntityPersister)this));
        }
        Object[] parameters = PreparedStatementAdaptor.bind(statement -> {
            int positions = 1;
            int loop = 0;
            for (int idPosition : this.getNaturalIdentifierProperties()) {
                Object naturalIdValue;
                if ((naturalIdValue = naturalIdValues[loop++]) == null) continue;
                Type type = this.getPropertyTypes()[idPosition];
                type.nullSafeSet(statement, naturalIdValue, positions, (SharedSessionContractImplementor)session);
                positions += type.getColumnSpan((Mapping)session.getFactory());
            }
        });
        String sql = this.determinePkByNaturalIdQuery(AbstractEntityPersister.determineValueNullness((Object[])naturalIdValues));
        return this.getReactiveConnection((SharedSessionContractImplementor)session).selectJdbc(this.parameters().process(sql), parameters).thenApply(resultSet -> {
            try {
                if (!resultSet.next()) {
                    return null;
                }
                Object hydratedId = this.getIdentifierType().hydrate(resultSet, this.getIdentifierAliases(), (SharedSessionContractImplementor)session, null);
                return (Serializable)this.getIdentifierType().resolve(hydratedId, (SharedSessionContractImplementor)session, null);
            }
            catch (SQLException sqle) {
                throw new JDBCException("could not resolve natural-id: " + sql, sqle);
            }
        });
    }

    public String[] getIdentifierAliases();

    public String determinePkByNaturalIdQuery(boolean[] var1);

    public boolean initializeLazyProperty(String var1, Object var2, SharedSessionContractImplementor var3, EntityEntry var4, int var5, Object var6);

    public String[][] getLazyPropertyColumnAliases();

    public String getSQLLazySelectString(String var1);

    public boolean isBatchable();

    public static class InsertExpectation
    implements ReactiveConnection.Expectation {
        private final Expectation expectation;
        private final ReactiveAbstractEntityPersister persister;

        public InsertExpectation(Expectation expectation, ReactiveAbstractEntityPersister persister) {
            this.expectation = expectation;
            this.persister = persister;
        }

        @Override
        public void verifyOutcome(int rowCount, int batchPosition, String batchSql) {
            try {
                this.expectation.verifyOutcome(rowCount, null, batchPosition, batchSql);
            }
            catch (SQLException e) {
                throw new JDBCException("error while verifying result count", e);
            }
        }
    }

    public static class DeleteExpectation
    implements ReactiveConnection.Expectation {
        private final Serializable id;
        private final int table;
        private final Expectation expectation;
        private final ReactiveAbstractEntityPersister persister;

        public DeleteExpectation(Serializable id, int table, Expectation expectation, ReactiveAbstractEntityPersister persister) {
            this.id = id;
            this.table = table;
            this.expectation = expectation;
            this.persister = persister;
        }

        @Override
        public void verifyOutcome(int rowCount, int batchPosition, String batchSql) {
            this.persister.check(rowCount, this.id, this.table, this.expectation, null, batchSql);
        }
    }

    public static class UpdateExpectation
    implements ReactiveConnection.Expectation {
        private boolean successful;
        private final Serializable id;
        private final int table;
        private final Expectation expectation;
        private final ReactiveAbstractEntityPersister persister;

        public UpdateExpectation(Serializable id, int table, Expectation expectation, ReactiveAbstractEntityPersister persister) {
            this.id = id;
            this.table = table;
            this.expectation = expectation;
            this.persister = persister;
        }

        @Override
        public void verifyOutcome(int rowCount, int batchPosition, String batchSql) {
            this.successful = this.persister.check(rowCount, this.id, this.table, this.expectation, new PreparedStatementAdaptor(), batchSql);
        }

        public boolean isSuccessful() {
            return this.successful;
        }
    }
}

