/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.reactive.persister.collection.impl;

import java.io.Serializable;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.List;
import java.util.concurrent.CompletionStage;
import org.hibernate.HibernateException;
import org.hibernate.MappingException;
import org.hibernate.cache.CacheException;
import org.hibernate.cache.spi.access.CollectionDataAccess;
import org.hibernate.collection.spi.PersistentCollection;
import org.hibernate.engine.spi.ExecuteUpdateResultCheckStyle;
import org.hibernate.engine.spi.LoadQueryInfluencers;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.engine.spi.SubselectFetch;
import org.hibernate.internal.util.collections.ArrayHelper;
import org.hibernate.jdbc.Expectation;
import org.hibernate.jdbc.Expectations;
import org.hibernate.mapping.Collection;
import org.hibernate.persister.collection.CollectionPersister;
import org.hibernate.persister.collection.OneToManyPersister;
import org.hibernate.persister.collection.QueryableCollection;
import org.hibernate.persister.spi.PersisterCreationContext;
import org.hibernate.reactive.adaptor.impl.PreparedStatementAdaptor;
import org.hibernate.reactive.loader.collection.ReactiveCollectionInitializer;
import org.hibernate.reactive.loader.collection.impl.ReactiveBatchingCollectionInitializerBuilder;
import org.hibernate.reactive.loader.collection.impl.ReactiveSubselectOneToManyLoader;
import org.hibernate.reactive.persister.collection.impl.ReactiveAbstractCollectionPersister;
import org.hibernate.reactive.pool.impl.Parameters;
import org.hibernate.reactive.util.impl.CompletionStages;

public class ReactiveOneToManyPersister
extends OneToManyPersister
implements ReactiveAbstractCollectionPersister {
    private Parameters parameters() {
        return Parameters.instance(this.getFactory().getJdbcServices().getDialect());
    }

    public ReactiveOneToManyPersister(Collection collectionBinding, CollectionDataAccess cacheAccessStrategy, PersisterCreationContext creationContext) throws MappingException, CacheException {
        super(collectionBinding, cacheAccessStrategy, creationContext);
    }

    @Override
    public CompletionStage<Void> reactiveInitialize(Serializable key, SharedSessionContractImplementor session) {
        return this.getAppropriateInitializer(key, session).reactiveInitialize(key, session);
    }

    protected ReactiveCollectionInitializer createCollectionInitializer(LoadQueryInfluencers loadQueryInfluencers) {
        return ReactiveBatchingCollectionInitializerBuilder.getBuilder(this.getFactory()).createBatchingOneToManyInitializer((QueryableCollection)this, this.batchSize, this.getFactory(), loadQueryInfluencers);
    }

    protected ReactiveCollectionInitializer createSubselectInitializer(SubselectFetch subselect, SharedSessionContractImplementor session) {
        return new ReactiveSubselectOneToManyLoader((QueryableCollection)this, subselect.toSubselectString(this.getCollectionType().getLHSPropertyName()), subselect.getResult(), subselect.getQueryParameters(), subselect.getNamedParameterLocMap(), session.getFactory(), session.getLoadQueryInfluencers());
    }

    protected ReactiveCollectionInitializer getAppropriateInitializer(Serializable key, SharedSessionContractImplementor session) {
        return (ReactiveCollectionInitializer)super.getAppropriateInitializer(key, session);
    }

    @Override
    public boolean isRowDeleteEnabled() {
        return super.isRowDeleteEnabled();
    }

    @Override
    public boolean isRowInsertEnabled() {
        return super.isRowInsertEnabled();
    }

    @Override
    public boolean hasIdentifier() {
        return this.hasIdentifier;
    }

    @Override
    public boolean indexContainsFormula() {
        return this.indexContainsFormula;
    }

    @Override
    public int writeElement(PreparedStatement st, Object element, int loc, SharedSessionContractImplementor session) throws SQLException {
        return super.writeElement(st, element, loc, session);
    }

    @Override
    public int writeIndex(PreparedStatement st, Object index, int loc, SharedSessionContractImplementor session) throws SQLException {
        return super.writeIndex(st, index, loc, session);
    }

    @Override
    public int writeKey(PreparedStatement st, Serializable id, int offset, SharedSessionContractImplementor session) throws SQLException {
        return super.writeKey(st, id, offset, session);
    }

    @Override
    public int writeElementToWhere(PreparedStatement st, Object entry, int loc, SharedSessionContractImplementor session) throws SQLException {
        return super.writeElementToWhere(st, entry, loc, session);
    }

    @Override
    public int writeIndexToWhere(PreparedStatement st, Object entry, int loc, SharedSessionContractImplementor session) throws SQLException {
        return super.writeIndexToWhere(st, entry, loc, session);
    }

    protected String generateInsertRowString() {
        String sql = super.generateInsertRowString();
        return this.parameters().process(sql);
    }

    protected String generateUpdateRowString() {
        String sql = super.generateUpdateRowString();
        return this.parameters().process(sql);
    }

    protected String generateDeleteRowString() {
        String sql = super.generateDeleteRowString();
        return this.parameters().process(sql);
    }

    protected String generateDeleteString() {
        String sql = super.generateDeleteString();
        return this.parameters().process(sql);
    }

    @Override
    public String getSQLInsertRowString() {
        return super.getSQLInsertRowString();
    }

    @Override
    public String getSQLUpdateRowString() {
        return super.getSQLUpdateRowString();
    }

    @Override
    public String getSQLDeleteRowString() {
        return super.getSQLDeleteRowString();
    }

    @Override
    public String getSQLDeleteString() {
        return super.getSQLDeleteString();
    }

    @Override
    public ExecuteUpdateResultCheckStyle getInsertCheckStyle() {
        return super.getInsertCheckStyle();
    }

    @Override
    public ExecuteUpdateResultCheckStyle getDeleteCheckStyle() {
        return super.getDeleteCheckStyle();
    }

    @Override
    public CompletionStage<Void> doReactiveUpdateRows(Serializable id, PersistentCollection collection, SharedSessionContractImplementor session) {
        List entries = this.entryList(collection);
        if (!this.needsUpdate(collection, entries)) {
            return CompletionStages.voidFuture();
        }
        CompletionStage<Void> result = CompletionStages.voidFuture();
        if (this.isRowDeleteEnabled()) {
            Expectation deleteExpectation = Expectations.appropriateExpectation((ExecuteUpdateResultCheckStyle)this.getDeleteCheckStyle());
            result = result.thenCompose(v -> CompletionStages.loop(0, entries.size(), i -> collection.needsUpdating(entries.get(i), i, this.elementType), i -> {
                Object entry = entries.get(i);
                int offset = 1;
                return this.getReactiveConnection(session).update(this.getSQLDeleteRowString(), PreparedStatementAdaptor.bind(st -> {
                    int loc = this.writeKey(st, id, offset, session);
                    this.writeElementToWhere(st, collection.getSnapshotElement(entry, i), loc, session);
                }), deleteExpectation.canBeBatched(), new ReactiveAbstractCollectionPersister.ExpectationAdaptor(deleteExpectation, this.getSQLDeleteRowString(), this.getSQLExceptionConverter()));
            }));
        }
        if (this.isRowInsertEnabled()) {
            Expectation insertExpectation = Expectations.appropriateExpectation((ExecuteUpdateResultCheckStyle)this.getInsertCheckStyle());
            result = result.thenCompose(v -> CompletionStages.loop(0, entries.size(), i -> collection.needsUpdating(entries.get(i), i, this.elementType), i -> {
                Object entry = entries.get(i);
                return this.getReactiveConnection(session).update(this.getSQLInsertRowString(), PreparedStatementAdaptor.bind(st -> {
                    int offset = 1;
                    int loc = this.writeKey(st, id, offset += insertExpectation.prepare(st), session);
                    if (this.hasIndex && !this.indexContainsFormula) {
                        loc = this.writeIndexToWhere(st, collection.getIndex(entry, i, (CollectionPersister)this), loc, session);
                    }
                    this.writeElementToWhere(st, collection.getElement(entry), loc, session);
                }), insertExpectation.canBeBatched(), new ReactiveAbstractCollectionPersister.ExpectationAdaptor(insertExpectation, this.getSQLInsertRowString(), this.getSQLExceptionConverter()));
            }));
        }
        return result;
    }

    @Override
    public CompletionStage<Void> recreateReactive(PersistentCollection collection, Serializable id, SharedSessionContractImplementor session) throws HibernateException {
        return this.reactiveWriteIndex(collection, id, session, ReactiveAbstractCollectionPersister.super.recreateReactive(collection, id, session));
    }

    @Override
    public CompletionStage<Void> reactiveInsertRows(PersistentCollection collection, Serializable id, SharedSessionContractImplementor session) throws HibernateException {
        return this.reactiveWriteIndex(collection, id, session, ReactiveAbstractCollectionPersister.super.reactiveInsertRows(collection, id, session));
    }

    private CompletionStage<Void> reactiveWriteIndex(PersistentCollection collection, Serializable id, SharedSessionContractImplementor session, CompletionStage<Void> stage) {
        if (this.isInverse && this.hasIndex && !this.indexContainsFormula && ArrayHelper.countTrue((boolean[])this.indexColumnIsSettable) > 0) {
            List entries = this.entryList(collection);
            if (entries.isEmpty()) {
                return stage;
            }
            Expectation expectation = Expectations.appropriateExpectation((ExecuteUpdateResultCheckStyle)this.getUpdateCheckStyle());
            return stage.thenCompose(v -> CompletionStages.loop(0, entries.size(), index -> {
                Object entry = entries.get(index);
                return entry != null && collection.entryExists(entry, index);
            }, index -> {
                Object entry = entries.get(index);
                return this.getReactiveConnection(session).update(this.getSQLUpdateRowString(), PreparedStatementAdaptor.bind(st -> {
                    int offset = 1;
                    offset += expectation.prepare(st);
                    if (this.hasIdentifier) {
                        offset = this.writeIdentifier(st, collection.getIdentifier(entry, index), offset, session);
                    }
                    offset = this.writeIndex(st, collection.getIndex(entry, index, (CollectionPersister)this), offset, session);
                    offset = this.writeElement(st, collection.getElement(entry), offset, session);
                }), expectation.canBeBatched(), new ReactiveAbstractCollectionPersister.ExpectationAdaptor(expectation, this.getSQLUpdateRowString(), this.getSQLExceptionConverter()));
            }));
        }
        return stage;
    }
}

