/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.reactive.persister.collection.impl;

import java.io.Serializable;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.List;
import java.util.concurrent.CompletionStage;
import org.hibernate.MappingException;
import org.hibernate.cache.CacheException;
import org.hibernate.cache.spi.access.CollectionDataAccess;
import org.hibernate.collection.spi.PersistentCollection;
import org.hibernate.engine.spi.ExecuteUpdateResultCheckStyle;
import org.hibernate.engine.spi.LoadQueryInfluencers;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.engine.spi.SubselectFetch;
import org.hibernate.internal.util.collections.ArrayHelper;
import org.hibernate.jdbc.Expectation;
import org.hibernate.jdbc.Expectations;
import org.hibernate.mapping.Collection;
import org.hibernate.persister.collection.BasicCollectionPersister;
import org.hibernate.persister.collection.CollectionPersister;
import org.hibernate.persister.collection.QueryableCollection;
import org.hibernate.persister.spi.PersisterCreationContext;
import org.hibernate.reactive.adaptor.impl.PreparedStatementAdaptor;
import org.hibernate.reactive.loader.collection.ReactiveCollectionInitializer;
import org.hibernate.reactive.loader.collection.impl.ReactiveBatchingCollectionInitializerBuilder;
import org.hibernate.reactive.loader.collection.impl.ReactiveSubselectCollectionLoader;
import org.hibernate.reactive.persister.collection.impl.ReactiveAbstractCollectionPersister;
import org.hibernate.reactive.pool.impl.Parameters;
import org.hibernate.reactive.util.impl.CompletionStages;

public class ReactiveBasicCollectionPersister
extends BasicCollectionPersister
implements ReactiveAbstractCollectionPersister {
    private Parameters parameters() {
        return Parameters.instance(this.getFactory().getJdbcServices().getDialect());
    }

    public ReactiveBasicCollectionPersister(Collection collectionBinding, CollectionDataAccess cacheAccessStrategy, PersisterCreationContext creationContext) throws MappingException, CacheException {
        super(collectionBinding, cacheAccessStrategy, creationContext);
    }

    @Override
    public CompletionStage<Void> reactiveInitialize(Serializable key, SharedSessionContractImplementor session) {
        return this.getAppropriateInitializer(key, session).reactiveInitialize(key, session);
    }

    protected ReactiveCollectionInitializer createCollectionInitializer(LoadQueryInfluencers loadQueryInfluencers) {
        return ReactiveBatchingCollectionInitializerBuilder.getBuilder(this.getFactory()).createBatchingCollectionInitializer((QueryableCollection)this, this.batchSize, this.getFactory(), loadQueryInfluencers);
    }

    protected ReactiveCollectionInitializer createSubselectInitializer(SubselectFetch subselect, SharedSessionContractImplementor session) {
        return new ReactiveSubselectCollectionLoader((QueryableCollection)this, subselect.toSubselectString(this.getCollectionType().getLHSPropertyName()), subselect.getResult(), subselect.getQueryParameters(), subselect.getNamedParameterLocMap(), session.getFactory(), session.getLoadQueryInfluencers());
    }

    protected ReactiveCollectionInitializer getAppropriateInitializer(Serializable key, SharedSessionContractImplementor session) {
        return (ReactiveCollectionInitializer)super.getAppropriateInitializer(key, session);
    }

    @Override
    public boolean isRowDeleteEnabled() {
        return super.isRowDeleteEnabled();
    }

    @Override
    public boolean isRowInsertEnabled() {
        return super.isRowInsertEnabled();
    }

    @Override
    public boolean hasIdentifier() {
        return this.hasIdentifier;
    }

    @Override
    public boolean indexContainsFormula() {
        return this.indexContainsFormula;
    }

    @Override
    public int writeElement(PreparedStatement st, Object element, int loc, SharedSessionContractImplementor session) throws SQLException {
        return super.writeElement(st, element, loc, session);
    }

    @Override
    public int writeIndex(PreparedStatement st, Object index, int loc, SharedSessionContractImplementor session) throws SQLException {
        return super.writeIndex(st, index, loc, session);
    }

    @Override
    public int writeKey(PreparedStatement st, Serializable id, int offset, SharedSessionContractImplementor session) throws SQLException {
        return super.writeKey(st, id, offset, session);
    }

    @Override
    public int writeElementToWhere(PreparedStatement st, Object entry, int loc, SharedSessionContractImplementor session) throws SQLException {
        return super.writeElementToWhere(st, entry, loc, session);
    }

    @Override
    public int writeIndexToWhere(PreparedStatement st, Object entry, int loc, SharedSessionContractImplementor session) throws SQLException {
        return super.writeIndexToWhere(st, entry, loc, session);
    }

    protected String generateInsertRowString() {
        String sql = super.generateInsertRowString();
        return this.parameters().process(sql);
    }

    protected String generateUpdateRowString() {
        String sql = super.generateUpdateRowString();
        return this.parameters().process(sql);
    }

    protected String generateDeleteRowString() {
        String sql = super.generateDeleteRowString();
        return this.parameters().process(sql);
    }

    protected String generateDeleteString() {
        String sql = super.generateDeleteString();
        return this.parameters().process(sql);
    }

    @Override
    public String getSQLInsertRowString() {
        return super.getSQLInsertRowString();
    }

    @Override
    public String getSQLUpdateRowString() {
        return super.getSQLUpdateRowString();
    }

    @Override
    public String getSQLDeleteRowString() {
        return super.getSQLDeleteRowString();
    }

    @Override
    public String getSQLDeleteString() {
        return super.getSQLDeleteString();
    }

    @Override
    public ExecuteUpdateResultCheckStyle getInsertCheckStyle() {
        return super.getInsertCheckStyle();
    }

    @Override
    public ExecuteUpdateResultCheckStyle getDeleteCheckStyle() {
        return super.getDeleteCheckStyle();
    }

    @Override
    public CompletionStage<Void> doReactiveUpdateRows(Serializable id, PersistentCollection collection, SharedSessionContractImplementor session) {
        if (ArrayHelper.isAllFalse((boolean[])this.elementColumnIsSettable)) {
            return CompletionStages.voidFuture();
        }
        List entries = this.entryList(collection);
        if (!this.needsUpdate(collection, entries)) {
            return CompletionStages.voidFuture();
        }
        Expectation expectation = Expectations.appropriateExpectation((ExecuteUpdateResultCheckStyle)this.getUpdateCheckStyle());
        boolean useBatch = expectation.canBeBatched() && session.getConfiguredJdbcBatchSize() > 1;
        Integer[] indices = this.orderedIndices(collection, entries);
        return CompletionStages.loop(indices, i -> collection.needsUpdating(entries.get(indices[i]), indices[i].intValue(), this.elementType), i -> this.getReactiveConnection(session).update(this.getSQLUpdateRowString(), this.updateRowsParamValues(entries.get(indices[i]), indices[i], collection, id, session), useBatch, new ReactiveAbstractCollectionPersister.ExpectationAdaptor(expectation, this.getSQLUpdateRowString(), this.getSQLExceptionConverter())));
    }

    private Integer[] orderedIndices(PersistentCollection collection, List<Object> elements) {
        Integer[] indices = new Integer[elements.size()];
        if (collection.isElementRemoved()) {
            int j = 0;
            for (int i = elements.size() - 1; i >= 0; --i) {
                indices[j++] = i;
            }
        } else {
            int j = 0;
            for (int i = 0; i < elements.size(); ++i) {
                indices[j++] = i;
            }
        }
        return indices;
    }

    private Object[] updateRowsParamValues(Object entry, int i, PersistentCollection collection, Serializable id, SharedSessionContractImplementor session) {
        int offset = 1;
        return PreparedStatementAdaptor.bind(st -> {
            int loc = this.writeElement(st, collection.getElement(entry), offset, session);
            if (this.hasIdentifier) {
                this.writeIdentifier(st, collection.getIdentifier(entry, i), loc, session);
            } else {
                loc = this.writeKey(st, id, loc, session);
                if (this.hasIndex && !this.indexContainsFormula) {
                    this.writeIndexToWhere(st, collection.getIndex(entry, i, (CollectionPersister)this), loc, session);
                } else {
                    this.writeElementToWhere(st, collection.getSnapshotElement(entry, i), loc, session);
                }
            }
        });
    }
}

