/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.reactive.persister.collection.impl;

import java.io.Serializable;
import java.lang.invoke.MethodHandles;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CompletionStage;
import org.hibernate.HibernateException;
import org.hibernate.collection.spi.PersistentCollection;
import org.hibernate.engine.spi.ExecuteUpdateResultCheckStyle;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.exception.spi.SQLExceptionConverter;
import org.hibernate.jdbc.Expectation;
import org.hibernate.jdbc.Expectations;
import org.hibernate.persister.collection.CollectionPersister;
import org.hibernate.pretty.MessageHelper;
import org.hibernate.reactive.adaptor.impl.PreparedStatementAdaptor;
import org.hibernate.reactive.logging.impl.Log;
import org.hibernate.reactive.logging.impl.LoggerFactory;
import org.hibernate.reactive.persister.collection.impl.ReactiveCollectionPersister;
import org.hibernate.reactive.pool.ReactiveConnection;
import org.hibernate.reactive.session.ReactiveConnectionSupplier;
import org.hibernate.reactive.util.impl.CompletionStages;

public interface ReactiveAbstractCollectionPersister
extends ReactiveCollectionPersister {
    public static final Log LOG = LoggerFactory.make(Log.class, MethodHandles.lookup());

    default public ReactiveConnection getReactiveConnection(SharedSessionContractImplementor session) {
        return ((ReactiveConnectionSupplier)session).getReactiveConnection();
    }

    @Override
    default public CompletionStage<Void> recreateReactive(PersistentCollection collection, Serializable id, SharedSessionContractImplementor session) throws HibernateException {
        if (this.isInverse() || !this.isRowInsertEnabled()) {
            return CompletionStages.voidFuture();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debugf("Inserting collection: %s", MessageHelper.collectionInfoString((CollectionPersister)this, (PersistentCollection)collection, (Serializable)id, (SharedSessionContractImplementor)session));
        }
        ReactiveConnection connection = this.getReactiveConnection(session);
        Iterator entries = collection.entries((CollectionPersister)this);
        Expectation expectation = Expectations.appropriateExpectation((ExecuteUpdateResultCheckStyle)this.getInsertCheckStyle());
        return CompletionStages.loop(entries, (arg_0, arg_1) -> ((PersistentCollection)collection).entryExists(arg_0, arg_1), (entry, index) -> connection.update(this.getSQLInsertRowString(), this.insertRowsParamValues(entry, index, collection, id, session), expectation.canBeBatched(), new ExpectationAdaptor(expectation, this.getSQLInsertRowString(), this.getSqlExceptionConverter())));
    }

    @Override
    default public CompletionStage<Void> removeReactive(Serializable id, SharedSessionContractImplementor session) {
        if (this.isInverse() || !this.isRowDeleteEnabled()) {
            return CompletionStages.voidFuture();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debugf("Deleting collection: %s", MessageHelper.collectionInfoString((CollectionPersister)this, (Serializable)id, (SessionFactoryImplementor)this.getFactory()));
        }
        Expectation expectation = Expectations.appropriateExpectation((ExecuteUpdateResultCheckStyle)this.getDeleteCheckStyle());
        return this.getReactiveConnection(session).update(this.getSQLDeleteString(), new Object[]{id}, expectation.canBeBatched(), new ExpectationAdaptor(expectation, this.getSQLDeleteString(), this.getSqlExceptionConverter()));
    }

    @Override
    default public CompletionStage<Void> reactiveDeleteRows(PersistentCollection collection, Serializable id, SharedSessionContractImplementor session) {
        if (this.isInverse() || !this.isRowDeleteEnabled()) {
            return CompletionStages.voidFuture();
        }
        Iterator deletes = collection.getDeletes((CollectionPersister)this, !this.deleteByIndex());
        if (!deletes.hasNext()) {
            return CompletionStages.voidFuture();
        }
        ReactiveConnection connection = this.getReactiveConnection(session);
        Expectation expectation = Expectations.appropriateExpectation((ExecuteUpdateResultCheckStyle)this.getDeleteCheckStyle());
        return CompletionStages.loop(deletes, (entry, index) -> connection.update(this.getSQLDeleteRowString(), this.deleteRowsParamValues(entry, 1, id, session), expectation.canBeBatched(), new ExpectationAdaptor(expectation, this.getSQLDeleteRowString(), this.getSqlExceptionConverter())));
    }

    @Override
    default public CompletionStage<Void> reactiveInsertRows(PersistentCollection collection, Serializable id, SharedSessionContractImplementor session) {
        if (this.isInverse() || !this.isRowDeleteEnabled()) {
            return CompletionStages.voidFuture();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debugf("Inserting rows of collection: %s", MessageHelper.collectionInfoString((CollectionPersister)this, (PersistentCollection)collection, (Serializable)id, (SharedSessionContractImplementor)session));
        }
        ReactiveConnection connection = this.getReactiveConnection(session);
        List<Object> entries = this.entryList(collection);
        if (!this.needsInsert(collection, entries)) {
            return CompletionStages.voidFuture();
        }
        Expectation expectation = Expectations.appropriateExpectation((ExecuteUpdateResultCheckStyle)this.getInsertCheckStyle());
        return CompletionStages.loop(entries.iterator(), (entry, index) -> collection.needsInserting(entry, index, this.getElementType()), (entry, index) -> connection.update(this.getSQLInsertRowString(), this.insertRowsParamValues(entry, index, collection, id, session), expectation.canBeBatched(), new ExpectationAdaptor(expectation, this.getSQLInsertRowString(), this.getSqlExceptionConverter()))).thenAccept(total -> LOG.debugf("Done inserting rows: %s inserted", total));
    }

    @Override
    default public CompletionStage<Void> reactiveUpdateRows(PersistentCollection collection, Serializable id, SharedSessionContractImplementor session) {
        if (!this.isInverse() && collection.isRowUpdatePossible()) {
            if (LOG.isDebugEnabled()) {
                LOG.debugf("Updating rows of collection: %s", MessageHelper.collectionInfoString((CollectionPersister)this, (PersistentCollection)collection, (Serializable)id, (SharedSessionContractImplementor)session));
            }
            return this.doReactiveUpdateRows(id, collection, session);
        }
        return CompletionStages.voidFuture();
    }

    public CompletionStage<Void> doReactiveUpdateRows(Serializable var1, PersistentCollection var2, SharedSessionContractImplementor var3);

    default public Object[] insertRowsParamValues(Object entry, int index, PersistentCollection collection, Serializable id, SharedSessionContractImplementor session) {
        int offset = 1;
        return PreparedStatementAdaptor.bind(st -> {
            int loc = this.writeKey(st, id, offset, session);
            if (this.hasIdentifier()) {
                loc = this.writeIdentifier(st, collection.getIdentifier(entry, index), loc, session);
            }
            if (this.hasIndex() && !this.indexContainsFormula()) {
                loc = this.writeIndex(st, collection.getIndex(entry, index, (CollectionPersister)this), loc, session);
            }
            this.writeElement(st, collection.getElement(entry), loc, session);
        });
    }

    default public Object[] deleteRowsParamValues(Object entry, int offset, Serializable id, SharedSessionContractImplementor session) {
        return PreparedStatementAdaptor.bind(st -> {
            int loc = offset;
            if (this.hasIdentifier()) {
                this.writeIdentifier(st, entry, loc, session);
            } else {
                loc = this.writeKey(st, id, loc, session);
                if (this.deleteByIndex()) {
                    this.writeIndexToWhere(st, entry, loc, session);
                } else {
                    this.writeElementToWhere(st, entry, loc, session);
                }
            }
        });
    }

    default public boolean deleteByIndex() {
        return !this.isOneToMany() && this.hasIndex() && !this.indexContainsFormula();
    }

    public boolean isRowDeleteEnabled();

    public boolean isRowInsertEnabled();

    public boolean hasIdentifier();

    public boolean indexContainsFormula();

    public ExecuteUpdateResultCheckStyle getInsertCheckStyle();

    public ExecuteUpdateResultCheckStyle getDeleteCheckStyle();

    public int writeElement(PreparedStatement var1, Object var2, int var3, SharedSessionContractImplementor var4) throws SQLException;

    public int writeIndex(PreparedStatement var1, Object var2, int var3, SharedSessionContractImplementor var4) throws SQLException;

    public int writeIdentifier(PreparedStatement var1, Object var2, int var3, SharedSessionContractImplementor var4) throws SQLException;

    public int writeKey(PreparedStatement var1, Serializable var2, int var3, SharedSessionContractImplementor var4) throws SQLException;

    public int writeElementToWhere(PreparedStatement var1, Object var2, int var3, SharedSessionContractImplementor var4) throws SQLException;

    public int writeIndexToWhere(PreparedStatement var1, Object var2, int var3, SharedSessionContractImplementor var4) throws SQLException;

    public String getSQLInsertRowString();

    public String getSQLDeleteRowString();

    public String getSQLDeleteString();

    public String getSQLUpdateRowString();

    default public List<Object> entryList(PersistentCollection collection) {
        Iterator entries = collection.entries((CollectionPersister)this);
        ArrayList<Object> elements = new ArrayList<Object>();
        while (entries.hasNext()) {
            elements.add(entries.next());
        }
        return elements;
    }

    default public boolean needsUpdate(PersistentCollection collection, List<Object> entries) {
        int size = entries.size();
        for (int i = 0; i < size; ++i) {
            Object element = entries.get(i);
            if (!collection.needsUpdating(element, i, this.getElementType())) continue;
            return true;
        }
        return false;
    }

    default public boolean needsInsert(PersistentCollection collection, List<Object> entries) {
        int size = entries.size();
        for (int i = 0; i < size; ++i) {
            Object element = entries.get(i);
            if (!collection.needsInserting(element, i, this.getElementType())) continue;
            return true;
        }
        return false;
    }

    default public SQLExceptionConverter getSqlExceptionConverter() {
        return this.getFactory().getJdbcServices().getSqlExceptionHelper().getSqlExceptionConverter();
    }

    public static class ExpectationAdaptor
    implements ReactiveConnection.Expectation {
        private Expectation expectation;
        private String sql;
        private SQLExceptionConverter converter;

        ExpectationAdaptor(Expectation expectation, String sql, SQLExceptionConverter converter) {
            this.expectation = expectation;
            this.sql = sql;
            this.converter = converter;
        }

        @Override
        public void verifyOutcome(int rowCount, int batchPosition, String sql) {
            try {
                this.expectation.verifyOutcome(rowCount, (PreparedStatement)new PreparedStatementAdaptor(), batchPosition, sql);
            }
            catch (SQLException sqle) {
                throw this.converter.convert(sqle, "could not update collection row", sql);
            }
        }
    }
}

