/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.reactive.mutiny.impl;

import io.smallrye.mutiny.Uni;
import jakarta.persistence.EntityGraph;
import jakarta.persistence.criteria.CriteriaDelete;
import jakarta.persistence.criteria.CriteriaQuery;
import jakarta.persistence.criteria.CriteriaUpdate;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.Function;
import java.util.function.Supplier;
import org.hibernate.LockMode;
import org.hibernate.graph.spi.RootGraphImplementor;
import org.hibernate.reactive.common.ResultSetMapping;
import org.hibernate.reactive.mutiny.Mutiny;
import org.hibernate.reactive.mutiny.impl.MutinyQueryImpl;
import org.hibernate.reactive.mutiny.impl.MutinySessionFactoryImpl;
import org.hibernate.reactive.pool.ReactiveConnection;
import org.hibernate.reactive.session.Criteria;
import org.hibernate.reactive.session.ReactiveStatelessSession;

public class MutinyStatelessSessionImpl
implements Mutiny.StatelessSession {
    private final ReactiveStatelessSession delegate;
    private final MutinySessionFactoryImpl factory;
    private Transaction<?> currentTransaction;

    public MutinyStatelessSessionImpl(ReactiveStatelessSession delegate, MutinySessionFactoryImpl factory) {
        this.delegate = delegate;
        this.factory = factory;
    }

    public ReactiveConnection getReactiveConnection() {
        return this.delegate.getReactiveConnection();
    }

    <T> Uni<T> uni(Supplier<CompletionStage<T>> stageSupplier) {
        return this.factory.uni(stageSupplier);
    }

    @Override
    public <T> Uni<T> get(Class<T> entityClass, Object id) {
        return this.uni(() -> this.delegate.reactiveGet(entityClass, id));
    }

    @Override
    public <T> Uni<T> get(Class<T> entityClass, Object id, LockMode lockMode) {
        return this.uni(() -> this.delegate.reactiveGet(entityClass, id, lockMode, null));
    }

    @Override
    public <T> Uni<T> get(EntityGraph<T> entityGraph, Object id) {
        Class entityClass = ((RootGraphImplementor)entityGraph).getGraphedType().getJavaType();
        return this.uni(() -> this.delegate.reactiveGet(entityClass, id, null, entityGraph));
    }

    @Override
    public <R> Mutiny.Query<R> createQuery(String queryString) {
        return new MutinyQueryImpl(this.delegate.createReactiveQuery(queryString), this.factory);
    }

    @Override
    public <R> Mutiny.Query<R> createQuery(String queryString, Class<R> resultType) {
        return new MutinyQueryImpl<R>(this.delegate.createReactiveQuery(queryString, resultType), this.factory);
    }

    @Override
    public <R> Mutiny.Query<R> createNativeQuery(String queryString) {
        return new MutinyQueryImpl(this.delegate.createReactiveNativeQuery(queryString), this.factory);
    }

    @Override
    public <R> Mutiny.Query<R> createNativeQuery(String queryString, Class<R> resultType) {
        return new MutinyQueryImpl<R>(this.delegate.createReactiveNativeQuery(queryString, resultType), this.factory);
    }

    @Override
    public <R> Mutiny.Query<R> createNativeQuery(String queryString, ResultSetMapping<R> resultSetMapping) {
        return new MutinyQueryImpl(this.delegate.createReactiveNativeQuery(queryString, resultSetMapping.getName()), this.factory);
    }

    @Override
    public <R> Mutiny.Query<R> createNamedQuery(String name) {
        return new MutinyQueryImpl(this.delegate.createReactiveNamedQuery(name), this.factory);
    }

    @Override
    public <R> Mutiny.Query<R> createNamedQuery(String name, Class<R> resultType) {
        return new MutinyQueryImpl<R>(this.delegate.createReactiveNamedQuery(name, resultType), this.factory);
    }

    @Override
    public <R> Mutiny.Query<R> createQuery(CriteriaQuery<R> criteriaQuery) {
        return new MutinyQueryImpl(this.delegate.createReactiveQuery((Criteria)criteriaQuery), this.factory);
    }

    @Override
    public <R> Mutiny.Query<R> createQuery(CriteriaUpdate<R> criteriaUpdate) {
        return new MutinyQueryImpl(this.delegate.createReactiveQuery((Criteria)criteriaUpdate), this.factory);
    }

    @Override
    public <R> Mutiny.Query<R> createQuery(CriteriaDelete<R> criteriaDelete) {
        return new MutinyQueryImpl(this.delegate.createReactiveQuery((Criteria)criteriaDelete), this.factory);
    }

    @Override
    public Uni<Void> insert(Object entity) {
        return this.uni(() -> this.delegate.reactiveInsert(entity));
    }

    @Override
    public Uni<Void> insertAll(Object ... entities) {
        return this.uni(() -> this.delegate.reactiveInsertAll(entities));
    }

    @Override
    public Uni<Void> insertAll(int batchSize, Object ... entities) {
        return this.uni(() -> this.delegate.reactiveInsertAll(batchSize, entities));
    }

    @Override
    public Uni<Void> delete(Object entity) {
        return this.uni(() -> this.delegate.reactiveDelete(entity));
    }

    @Override
    public Uni<Void> deleteAll(Object ... entities) {
        return this.uni(() -> this.delegate.reactiveDeleteAll(entities));
    }

    @Override
    public Uni<Void> deleteAll(int batchSize, Object ... entities) {
        return this.uni(() -> this.delegate.reactiveDeleteAll(entities));
    }

    @Override
    public Uni<Void> update(Object entity) {
        return this.uni(() -> this.delegate.reactiveUpdate(entity));
    }

    @Override
    public Uni<Void> updateAll(Object ... entities) {
        return this.uni(() -> this.delegate.reactiveUpdateAll(entities));
    }

    @Override
    public Uni<Void> updateAll(int batchSize, Object ... entities) {
        return this.uni(() -> this.delegate.reactiveUpdateAll(batchSize, entities));
    }

    @Override
    public Uni<Void> refresh(Object entity) {
        return this.uni(() -> this.delegate.reactiveRefresh(entity));
    }

    @Override
    public Uni<Void> refreshAll(Object ... entities) {
        return this.uni(() -> this.delegate.reactiveRefreshAll(entities));
    }

    @Override
    public Uni<Void> refreshAll(int batchSize, Object ... entities) {
        return this.uni(() -> this.delegate.reactiveRefreshAll(batchSize, entities));
    }

    @Override
    public Uni<Void> refresh(Object entity, LockMode lockMode) {
        return this.uni(() -> this.delegate.reactiveRefresh(entity, lockMode));
    }

    @Override
    public <T> Uni<T> fetch(T association) {
        return this.uni(() -> this.delegate.reactiveFetch(association, false));
    }

    @Override
    public <T> ResultSetMapping<T> getResultSetMapping(Class<T> resultType, String mappingName) {
        return this.delegate.getResultSetMapping(resultType, mappingName);
    }

    @Override
    public <T> EntityGraph<T> getEntityGraph(Class<T> entity, String name) {
        return this.delegate.getEntityGraph(entity, name);
    }

    @Override
    public <T> EntityGraph<T> createEntityGraph(Class<T> entity) {
        return this.delegate.createEntityGraph(entity);
    }

    @Override
    public <T> EntityGraph<T> createEntityGraph(Class<T> entity, String name) {
        return this.delegate.createEntityGraph(entity, name);
    }

    @Override
    public <T> Uni<T> withTransaction(Function<Mutiny.Transaction, Uni<T>> work) {
        return this.currentTransaction == null ? new Transaction().execute(work) : work.apply(this.currentTransaction);
    }

    @Override
    public Mutiny.Transaction currentTransaction() {
        return this.currentTransaction;
    }

    @Override
    public Uni<Void> close() {
        return this.uni(() -> {
            CompletableFuture<Void> closing = new CompletableFuture<Void>();
            this.delegate.close(closing);
            return closing;
        });
    }

    @Override
    public boolean isOpen() {
        return this.delegate.isOpen();
    }

    private class Transaction<T>
    implements Mutiny.Transaction {
        boolean rollback;

        private Transaction() {
        }

        Uni<T> execute(Function<Mutiny.Transaction, Uni<T>> work) {
            MutinyStatelessSessionImpl.this.currentTransaction = this;
            return this.begin().chain(() -> this.executeInTransaction(work)).eventually(() -> {
                MutinyStatelessSessionImpl.this.currentTransaction = null;
            });
        }

        Uni<T> executeInTransaction(Function<Mutiny.Transaction, Uni<T>> work) {
            return work.apply(this).onFailure().call(this::rollback).onCancellation().call(this::rollback).call(() -> this.rollback ? this.rollback() : this.commit());
        }

        Uni<Void> begin() {
            return Uni.createFrom().completionStage(MutinyStatelessSessionImpl.this.delegate.getReactiveConnection().beginTransaction());
        }

        Uni<Void> rollback() {
            return Uni.createFrom().completionStage(MutinyStatelessSessionImpl.this.delegate.getReactiveConnection().rollbackTransaction());
        }

        Uni<Void> commit() {
            return Uni.createFrom().completionStage(MutinyStatelessSessionImpl.this.delegate.getReactiveConnection().commitTransaction());
        }

        @Override
        public void markForRollback() {
            this.rollback = true;
        }

        @Override
        public boolean isMarkedForRollback() {
            return this.rollback;
        }
    }
}

