/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.reactive.mutiny.impl;

import io.smallrye.mutiny.Uni;
import jakarta.persistence.EntityGraph;
import jakarta.persistence.Parameter;
import java.util.List;
import java.util.concurrent.CompletionStage;
import java.util.function.Supplier;
import org.hibernate.CacheMode;
import org.hibernate.FlushMode;
import org.hibernate.LockMode;
import org.hibernate.LockOptions;
import org.hibernate.reactive.mutiny.Mutiny;
import org.hibernate.reactive.mutiny.impl.MutinySessionFactoryImpl;
import org.hibernate.reactive.session.ReactiveQuery;

public class MutinyQueryImpl<R>
implements Mutiny.Query<R> {
    private final ReactiveQuery<R> delegate;
    private final MutinySessionFactoryImpl factory;

    public MutinyQueryImpl(ReactiveQuery<R> delegate, MutinySessionFactoryImpl factory) {
        this.delegate = delegate;
        this.factory = factory;
    }

    public MutinyQueryImpl(ReactiveQuery<R> delegate, String[] querySpaces, MutinySessionFactoryImpl factory) {
        this(delegate, factory);
        delegate.setQuerySpaces(querySpaces);
    }

    <T> Uni<T> uni(Supplier<CompletionStage<T>> stageSupplier) {
        return this.factory.uni(stageSupplier);
    }

    @Override
    public Mutiny.Query<R> setParameter(int position, Object value) {
        this.delegate.setParameter(position, value);
        return this;
    }

    @Override
    public Mutiny.Query<R> setParameter(String name, Object value) {
        this.delegate.setParameter(name, value);
        return this;
    }

    @Override
    public <T> Mutiny.Query<R> setParameter(Parameter<T> name, T value) {
        this.delegate.setParameter(name, value);
        return this;
    }

    @Override
    public Mutiny.Query<R> setMaxResults(int maxResults) {
        this.delegate.setMaxResults(maxResults);
        return this;
    }

    @Override
    public int getMaxResults() {
        return this.delegate.getMaxResults();
    }

    @Override
    public Mutiny.Query<R> setFirstResult(int firstResult) {
        this.delegate.setFirstResult(firstResult);
        return this;
    }

    @Override
    public int getFirstResult() {
        return this.delegate.getFirstResult();
    }

    @Override
    public Mutiny.Query<R> setReadOnly(boolean readOnly) {
        this.delegate.setReadOnly(readOnly);
        return this;
    }

    @Override
    public boolean isReadOnly() {
        return this.delegate.isReadOnly();
    }

    @Override
    public Mutiny.Query<R> setComment(String comment) {
        this.delegate.setComment(comment);
        return this;
    }

    @Override
    public Mutiny.Query<R> setCacheable(boolean cacheable) {
        this.delegate.setCacheable(cacheable);
        return this;
    }

    @Override
    public boolean isCacheable() {
        return this.delegate.isCacheable();
    }

    @Override
    public Mutiny.Query<R> setCacheRegion(String cacheRegion) {
        this.delegate.setCacheRegion(cacheRegion);
        return this;
    }

    @Override
    public String getCacheRegion() {
        return this.delegate.getCacheRegion();
    }

    @Override
    public Mutiny.Query<R> setLockMode(LockMode lockMode) {
        this.delegate.setLockMode(lockMode);
        return this;
    }

    public Mutiny.Query<R> setLockOptions(LockOptions lockOptions) {
        this.delegate.setLockOptions(lockOptions);
        return this;
    }

    @Override
    public Mutiny.Query<R> setLockMode(String alias, LockMode lockMode) {
        this.delegate.setLockMode(alias, lockMode);
        return this;
    }

    @Override
    public Mutiny.Query<R> setCacheMode(CacheMode cacheMode) {
        this.delegate.setCacheMode(cacheMode);
        return this;
    }

    @Override
    public CacheMode getCacheMode() {
        return this.delegate.getCacheMode();
    }

    @Override
    public Mutiny.Query<R> setFlushMode(FlushMode flushMode) {
        this.delegate.setHibernateFlushMode(flushMode);
        return this;
    }

    @Override
    public FlushMode getFlushMode() {
        return this.delegate.getHibernateFlushMode();
    }

    @Override
    public Mutiny.Query<R> setPlan(EntityGraph<R> entityGraph) {
        this.delegate.setPlan(entityGraph);
        return this;
    }

    @Override
    public Uni<Integer> executeUpdate() {
        return this.uni(this.delegate::executeReactiveUpdate);
    }

    @Override
    public Uni<R> getSingleResult() {
        return this.uni(this.delegate::getReactiveSingleResult);
    }

    @Override
    public Uni<R> getSingleResultOrNull() {
        return this.uni(this.delegate::getReactiveSingleResultOrNull);
    }

    @Override
    public Uni<List<R>> getResultList() {
        return this.uni(this.delegate::getReactiveResultList);
    }
}

