/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.reactive.mutiny;

import io.smallrye.mutiny.Uni;
import jakarta.persistence.EntityGraph;
import jakarta.persistence.Parameter;
import jakarta.persistence.criteria.CriteriaBuilder;
import jakarta.persistence.criteria.CriteriaDelete;
import jakarta.persistence.criteria.CriteriaQuery;
import jakarta.persistence.criteria.CriteriaUpdate;
import jakarta.persistence.metamodel.Attribute;
import jakarta.persistence.metamodel.Metamodel;
import java.lang.invoke.MethodHandles;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.hibernate.Cache;
import org.hibernate.CacheMode;
import org.hibernate.Filter;
import org.hibernate.FlushMode;
import org.hibernate.Incubating;
import org.hibernate.LockMode;
import org.hibernate.collection.internal.AbstractPersistentCollection;
import org.hibernate.collection.spi.PersistentCollection;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.proxy.HibernateProxy;
import org.hibernate.reactive.common.AffectedEntities;
import org.hibernate.reactive.common.Identifier;
import org.hibernate.reactive.common.ResultSetMapping;
import org.hibernate.reactive.logging.impl.Log;
import org.hibernate.reactive.logging.impl.LoggerFactory;
import org.hibernate.reactive.session.ReactiveSession;
import org.hibernate.stat.Statistics;

public interface Mutiny {
    public static final Log LOG = LoggerFactory.make(Log.class, MethodHandles.lookup());

    public static <T> Uni<T> fetch(T association) {
        SharedSessionContractImplementor session;
        if (association == null) {
            return Uni.createFrom().nullItem();
        }
        if (association instanceof HibernateProxy) {
            session = ((HibernateProxy)association).getHibernateLazyInitializer().getSession();
        } else if (association instanceof PersistentCollection) {
            session = ((AbstractPersistentCollection)association).getSession();
        } else {
            return Uni.createFrom().item(association);
        }
        if (session == null) {
            throw LOG.sessionClosedLazyInitializationException();
        }
        return Uni.createFrom().completionStage(((ReactiveSession)session).reactiveFetch(association, false));
    }

    public static interface Closeable {
        public Uni<Void> close();
    }

    public static interface SessionFactory
    extends AutoCloseable {
        public Uni<Session> openSession();

        public Uni<Session> openSession(String var1);

        public Uni<StatelessSession> openStatelessSession();

        public Uni<StatelessSession> openStatelessSession(String var1);

        public <T> Uni<T> withSession(Function<Session, Uni<T>> var1);

        public <T> Uni<T> withSession(String var1, Function<Session, Uni<T>> var2);

        public <T> Uni<T> withTransaction(BiFunction<Session, Transaction, Uni<T>> var1);

        default public <T> Uni<T> withTransaction(Function<Session, Uni<T>> work) {
            return this.withTransaction((Session session, Transaction transaction) -> (Uni)work.apply((Session)session));
        }

        default public <T> Uni<T> withStatelessTransaction(Function<StatelessSession, Uni<T>> work) {
            return this.withStatelessTransaction((StatelessSession statelessSession, Transaction transaction) -> (Uni)work.apply((StatelessSession)statelessSession));
        }

        public <T> Uni<T> withStatelessTransaction(BiFunction<StatelessSession, Transaction, Uni<T>> var1);

        public <T> Uni<T> withStatelessSession(Function<StatelessSession, Uni<T>> var1);

        public <T> Uni<T> withStatelessSession(String var1, Function<StatelessSession, Uni<T>> var2);

        public <T> Uni<T> withTransaction(String var1, BiFunction<Session, Transaction, Uni<T>> var2);

        public <T> Uni<T> withStatelessTransaction(String var1, BiFunction<StatelessSession, Transaction, Uni<T>> var2);

        public CriteriaBuilder getCriteriaBuilder();

        public Metamodel getMetamodel();

        public Cache getCache();

        public Statistics getStatistics();

        @Override
        public void close();

        public boolean isOpen();
    }

    public static interface Transaction {
        public void markForRollback();

        public boolean isMarkedForRollback();
    }

    public static interface StatelessSession
    extends Closeable {
        public <T> Uni<T> get(Class<T> var1, Object var2);

        public <T> Uni<T> get(Class<T> var1, Object var2, LockMode var3);

        public <T> Uni<T> get(EntityGraph<T> var1, Object var2);

        public <R> Query<R> createQuery(String var1);

        public <R> Query<R> createQuery(String var1, Class<R> var2);

        public <R> Query<R> createNamedQuery(String var1);

        public <R> Query<R> createNamedQuery(String var1, Class<R> var2);

        public <R> Query<R> createNativeQuery(String var1);

        public <R> Query<R> createNativeQuery(String var1, Class<R> var2);

        public <R> Query<R> createNativeQuery(String var1, ResultSetMapping<R> var2);

        public <R> Query<R> createQuery(CriteriaQuery<R> var1);

        public <R> Query<R> createQuery(CriteriaUpdate<R> var1);

        public <R> Query<R> createQuery(CriteriaDelete<R> var1);

        public Uni<Void> insert(Object var1);

        public Uni<Void> insertAll(Object ... var1);

        public Uni<Void> insertAll(int var1, Object ... var2);

        public Uni<Void> delete(Object var1);

        public Uni<Void> deleteAll(Object ... var1);

        public Uni<Void> deleteAll(int var1, Object ... var2);

        public Uni<Void> update(Object var1);

        public Uni<Void> updateAll(Object ... var1);

        public Uni<Void> updateAll(int var1, Object ... var2);

        public Uni<Void> refresh(Object var1);

        public Uni<Void> refreshAll(Object ... var1);

        public Uni<Void> refreshAll(int var1, Object ... var2);

        public Uni<Void> refresh(Object var1, LockMode var2);

        public <T> Uni<T> fetch(T var1);

        public <T> ResultSetMapping<T> getResultSetMapping(Class<T> var1, String var2);

        public <T> EntityGraph<T> getEntityGraph(Class<T> var1, String var2);

        public <T> EntityGraph<T> createEntityGraph(Class<T> var1);

        public <T> EntityGraph<T> createEntityGraph(Class<T> var1, String var2);

        public <T> Uni<T> withTransaction(Function<Transaction, Uni<T>> var1);

        public Transaction currentTransaction();

        public boolean isOpen();

        @Override
        public Uni<Void> close();
    }

    public static interface Session
    extends Closeable {
        public <T> Uni<T> find(Class<T> var1, Object var2);

        public <T> Uni<T> find(Class<T> var1, Object var2, LockMode var3);

        public <T> Uni<T> find(EntityGraph<T> var1, Object var2);

        public <T> Uni<List<T>> find(Class<T> var1, Object ... var2);

        @Incubating
        public <T> Uni<T> find(Class<T> var1, Identifier<T> var2);

        public <T> T getReference(Class<T> var1, Object var2);

        public <T> T getReference(T var1);

        public Uni<Void> persist(Object var1);

        public Uni<Void> persistAll(Object ... var1);

        public Uni<Void> remove(Object var1);

        public Uni<Void> removeAll(Object ... var1);

        public <T> Uni<T> merge(T var1);

        public <T> Uni<Void> mergeAll(T ... var1);

        public Uni<Void> refresh(Object var1);

        public Uni<Void> refresh(Object var1, LockMode var2);

        public Uni<Void> refreshAll(Object ... var1);

        public Uni<Void> lock(Object var1, LockMode var2);

        public Uni<Void> flush();

        public <T> Uni<T> fetch(T var1);

        public <E, T> Uni<T> fetch(E var1, Attribute<E, T> var2);

        public <T> Uni<T> unproxy(T var1);

        public LockMode getLockMode(Object var1);

        public boolean contains(Object var1);

        public <R> Query<R> createQuery(String var1);

        public <R> Query<R> createQuery(String var1, Class<R> var2);

        public <R> Query<R> createNamedQuery(String var1);

        public <R> Query<R> createNamedQuery(String var1, Class<R> var2);

        public <R> Query<R> createNativeQuery(String var1);

        public <R> Query<R> createNativeQuery(String var1, AffectedEntities var2);

        public <R> Query<R> createNativeQuery(String var1, Class<R> var2);

        public <R> Query<R> createNativeQuery(String var1, Class<R> var2, AffectedEntities var3);

        public <R> Query<R> createNativeQuery(String var1, ResultSetMapping<R> var2);

        public <R> Query<R> createNativeQuery(String var1, ResultSetMapping<R> var2, AffectedEntities var3);

        public <R> Query<R> createQuery(CriteriaQuery<R> var1);

        public <R> Query<R> createQuery(CriteriaUpdate<R> var1);

        public <R> Query<R> createQuery(CriteriaDelete<R> var1);

        public Session setFlushMode(FlushMode var1);

        public FlushMode getFlushMode();

        public Session detach(Object var1);

        public Session clear();

        public Session enableFetchProfile(String var1);

        public <T> ResultSetMapping<T> getResultSetMapping(Class<T> var1, String var2);

        public <T> EntityGraph<T> getEntityGraph(Class<T> var1, String var2);

        public <T> EntityGraph<T> createEntityGraph(Class<T> var1);

        public <T> EntityGraph<T> createEntityGraph(Class<T> var1, String var2);

        public Session disableFetchProfile(String var1);

        public boolean isFetchProfileEnabled(String var1);

        public Session setDefaultReadOnly(boolean var1);

        public boolean isDefaultReadOnly();

        public Session setReadOnly(Object var1, boolean var2);

        public boolean isReadOnly(Object var1);

        public Session setCacheMode(CacheMode var1);

        public CacheMode getCacheMode();

        public Session setBatchSize(Integer var1);

        public Integer getBatchSize();

        public Filter enableFilter(String var1);

        public void disableFilter(String var1);

        public Filter getEnabledFilter(String var1);

        public <T> Uni<T> withTransaction(Function<Transaction, Uni<T>> var1);

        public Transaction currentTransaction();

        public boolean isOpen();
    }

    public static interface Query<R> {
        public Query<R> setParameter(int var1, Object var2);

        public Query<R> setParameter(String var1, Object var2);

        public <T> Query<R> setParameter(Parameter<T> var1, T var2);

        public Query<R> setMaxResults(int var1);

        public Query<R> setFirstResult(int var1);

        public int getMaxResults();

        public int getFirstResult();

        public Uni<R> getSingleResult();

        public Uni<R> getSingleResultOrNull();

        public Uni<List<R>> getResultList();

        public Uni<Integer> executeUpdate();

        public Query<R> setReadOnly(boolean var1);

        public boolean isReadOnly();

        public Query<R> setComment(String var1);

        public Query<R> setCacheable(boolean var1);

        public boolean isCacheable();

        public Query<R> setCacheRegion(String var1);

        public String getCacheRegion();

        public Query<R> setCacheMode(CacheMode var1);

        public CacheMode getCacheMode();

        public Query<R> setFlushMode(FlushMode var1);

        public FlushMode getFlushMode();

        public Query<R> setLockMode(LockMode var1);

        public Query<R> setLockMode(String var1, LockMode var2);

        public Query<R> setPlan(EntityGraph<R> var1);
    }
}

