/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.reactive.logging.impl;

import jakarta.persistence.PersistenceException;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Locale;
import org.hibernate.HibernateException;
import org.hibernate.LazyInitializationException;
import org.hibernate.cache.CacheException;
import org.hibernate.reactive.logging.impl.ClassFormatter;
import org.hibernate.reactive.logging.impl.Log;
import org.jboss.logging.BasicLogger;
import org.jboss.logging.DelegatingBasicLogger;
import org.jboss.logging.Logger;

public class Log_$logger
extends DelegatingBasicLogger
implements Log,
BasicLogger,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final String FQCN = Log_$logger.class.getName();
    private static final Locale LOCALE = Locale.ROOT;

    public Log_$logger(Logger log) {
        super(log);
    }

    protected Locale getLoggingLocale() {
        return LOCALE;
    }

    @Override
    public final void startHibernateReactive() {
        this.log.logf(FQCN, Logger.Level.INFO, null, this.startHibernateReactive$str(), new Object[0]);
    }

    protected String startHibernateReactive$str() {
        return "HR000001: Hibernate Reactive";
    }

    @Override
    public final void creatingVertxInstance() {
        this.log.logf(FQCN, Logger.Level.INFO, null, this.creatingVertxInstance$str(), new Object[0]);
    }

    protected String creatingVertxInstance$str() {
        return "HR000002: Vert.x not detected, creating a new instance";
    }

    @Override
    public final void vertxInstanceStopped() {
        this.log.logf(FQCN, Logger.Level.INFO, null, this.vertxInstanceStopped$str(), new Object[0]);
    }

    protected String vertxInstanceStopped$str() {
        return "HR000003: Vert.x instance stopped";
    }

    @Override
    public final void sqlClientUrl(String url) {
        this.log.logf(FQCN, Logger.Level.INFO, null, this.sqlClientUrl$str(), (Object)url);
    }

    protected String sqlClientUrl$str() {
        return "HR000011: SQL Client URL [%1$s]";
    }

    @Override
    public final void detectedDriver(String driverName) {
        this.log.logf(FQCN, Logger.Level.INFO, null, this.detectedDriver$str(), (Object)driverName);
    }

    protected String detectedDriver$str() {
        return "HR000013: Detected driver [%1$s]";
    }

    @Override
    public final void preparedStatementCacheDisabled() {
        this.log.logf(FQCN, Logger.Level.INFO, null, this.preparedStatementCacheDisabled$str(), new Object[0]);
    }

    protected String preparedStatementCacheDisabled$str() {
        return "HR000014: Prepared statement cache disabled";
    }

    @Override
    public final void preparedStatementCacheMaxSize(Comparable<Integer> cacheMaxSize) {
        this.log.logf(FQCN, Logger.Level.INFO, null, this.preparedStatementCacheMaxSize$str(), cacheMaxSize);
    }

    protected String preparedStatementCacheMaxSize$str() {
        return "HR000015: Prepared statement cache max size: %1$d";
    }

    @Override
    public final void preparedStatementCacheSQLLimit(Integer sqlLimit) {
        this.log.logf(FQCN, Logger.Level.INFO, null, this.preparedStatementCacheSQLLimit$str(), (Object)sqlLimit);
    }

    protected String preparedStatementCacheSQLLimit$str() {
        return "HR000016: Prepared statement cache SQL limit: %1$d";
    }

    @Override
    public final void sqlClientConfiguration(String configClassName) {
        this.log.logf(FQCN, Logger.Level.INFO, null, this.sqlClientConfiguration$str(), (Object)configClassName);
    }

    protected String sqlClientConfiguration$str() {
        return "HR000017: Using SQL client configuration [%1$s]";
    }

    @Override
    public final void instantiatingReactivePool(Class<?> implClass) {
        this.log.logf(FQCN, Logger.Level.INFO, null, this.instantiatingReactivePool$str(), (Object)new ClassFormatter(implClass));
    }

    protected String instantiatingReactivePool$str() {
        return "HR000018: Instantiating reactive pool: %1$s";
    }

    @Override
    public final void ddlCommandFailed(String message) {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.ddlCommandFailed$str(), (Object)message);
    }

    protected String ddlCommandFailed$str() {
        return "HR000021: DDL command failed [%1$s]";
    }

    @Override
    public final void connectionPoolSize(int poolSize) {
        this.log.logf(FQCN, Logger.Level.INFO, null, this.connectionPoolSize$str(), (Object)poolSize);
    }

    protected String connectionPoolSize$str() {
        return "HR000025: Connection pool size: %1$d";
    }

    @Override
    public final void connectionPoolMaxWaitSize(Integer maxWaitQueueSize) {
        this.log.logf(FQCN, Logger.Level.INFO, null, this.connectionPoolMaxWaitSize$str(), (Object)maxWaitQueueSize);
    }

    protected String connectionPoolMaxWaitSize$str() {
        return "HR000026: Connection pool max wait queue size: %1$d";
    }

    @Override
    public final void connectionPoolIdleTimeout(Integer idleTimeout) {
        this.log.logf(FQCN, Logger.Level.INFO, null, this.connectionPoolIdleTimeout$str(), (Object)idleTimeout);
    }

    protected String connectionPoolIdleTimeout$str() {
        return "HR000027: Connection pool idle timeout: %1$d ms";
    }

    @Override
    public final void connectionPoolTimeout(Integer connectTimeout) {
        this.log.logf(FQCN, Logger.Level.INFO, null, this.connectionPoolTimeout$str(), (Object)connectTimeout);
    }

    protected String connectionPoolTimeout$str() {
        return "HR000028: Connection pool connection timeout: %1$d ms";
    }

    @Override
    public final void connectionPoolCleanerPeriod(Integer poolCleanerPeriod) {
        this.log.logf(FQCN, Logger.Level.INFO, null, this.connectionPoolCleanerPeriod$str(), (Object)poolCleanerPeriod);
    }

    protected String connectionPoolCleanerPeriod$str() {
        return "HR000029: Connection pool cleaner period: %1$d ms";
    }

    protected String moreThanOneRowWithTheGivenIdentifier$str() {
        return "HR000031: More than one row with the given identifier was found: %1$s, for class: %2$s";
    }

    @Override
    public final HibernateException moreThanOneRowWithTheGivenIdentifier(Object id, String entityName) {
        HibernateException result = new HibernateException(String.format(this.getLoggingLocale(), this.moreThanOneRowWithTheGivenIdentifier$str(), id, entityName));
        Log_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    private static void _copyStackTraceMinusOne(Throwable e) {
        StackTraceElement[] st = e.getStackTrace();
        e.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
    }

    protected String couldNotInstantiatePoolConfiguration$str() {
        return "HR000032: Could not instantiate SQL client pool configuration [%1$s]";
    }

    @Override
    public final HibernateException couldNotInstantiatePoolConfiguration(String configClassName, Throwable error) {
        HibernateException result = new HibernateException(String.format(this.getLoggingLocale(), this.couldNotInstantiatePoolConfiguration$str(), configClassName), error);
        Log_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String unableToRetrieveGeneratedProperties$str() {
        return "HR000033: Unable to locate row for retrieval of generated properties: %1$s";
    }

    @Override
    public final HibernateException unableToRetrieveGeneratedProperties(String infoString) {
        HibernateException result = new HibernateException(String.format(this.getLoggingLocale(), this.unableToRetrieveGeneratedProperties$str(), infoString));
        Log_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String noNativelyGeneratedValueReturned$str() {
        return "HR000034: The database returned no natively generated identity value";
    }

    @Override
    public final HibernateException noNativelyGeneratedValueReturned() {
        HibernateException result = new HibernateException(String.format(this.getLoggingLocale(), this.noNativelyGeneratedValueReturned$str(), new Object[0]));
        Log_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String nativelyGeneratedValueMustBeLong$str() {
        return "HR000035: The database can only generate identifiers of type Long";
    }

    @Override
    public final HibernateException nativelyGeneratedValueMustBeLong() {
        HibernateException result = new HibernateException(String.format(this.getLoggingLocale(), this.nativelyGeneratedValueMustBeLong$str(), new Object[0]));
        Log_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String wrongEntityType$str() {
        return "HR000356: Wrong entity type!";
    }

    @Override
    public final HibernateException wrongEntityType() {
        HibernateException result = new HibernateException(String.format(this.getLoggingLocale(), this.wrongEntityType$str(), new Object[0]));
        Log_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String firstOrMaxResultsFailedBecausePaginationOverCollectionIsEnabled$str() {
        return "HR000036: firstResult/maxResults specified with collection fetch. In memory pagination was about to be applied. Failing because 'Fail on pagination over collection fetch' is enabled.";
    }

    @Override
    public final HibernateException firstOrMaxResultsFailedBecausePaginationOverCollectionIsEnabled() {
        HibernateException result = new HibernateException(String.format(this.getLoggingLocale(), this.firstOrMaxResultsFailedBecausePaginationOverCollectionIsEnabled$str(), new Object[0]));
        Log_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String lazyInitializationException$str() {
        return "HR000037: Reactive sessions do not support transparent lazy fetching - use Session.fetch() (entity '%1$s' with id '%2$s' was not loaded)";
    }

    @Override
    public final LazyInitializationException lazyInitializationException(String entityName, Serializable id) {
        LazyInitializationException result = new LazyInitializationException(String.format(this.getLoggingLocale(), this.lazyInitializationException$str(), entityName, id));
        Log_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String entityDidNotDefinedNaturalId$str() {
        return "HR000038: Entity [%1$s] did not define a natural id";
    }

    @Override
    public final HibernateException entityDidNotDefinedNaturalId(String entityName) {
        HibernateException result = new HibernateException(String.format(this.getLoggingLocale(), this.entityDidNotDefinedNaturalId$str(), entityName));
        Log_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String flushDuringCascadeIsDangerous$str() {
        return "HR000039: Flush during cascade is dangerous";
    }

    @Override
    public final HibernateException flushDuringCascadeIsDangerous() {
        HibernateException result = new HibernateException(String.format(this.getLoggingLocale(), this.flushDuringCascadeIsDangerous$str(), new Object[0]));
        Log_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String immutableNaturalIdentifierAltered$str() {
        return "HR000040: An immutable natural identifier of entity %1$s was altered from %2$s to %3$s";
    }

    @Override
    public final HibernateException immutableNaturalIdentifierAltered(String entityName, String from, String to) {
        HibernateException result = new HibernateException(String.format(this.getLoggingLocale(), this.immutableNaturalIdentifierAltered$str(), entityName, from, to));
        Log_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String identifierAltered$str() {
        return "HR000041: Identifier of an instance of %1$s was altered from %2$s to %3$s";
    }

    @Override
    public final HibernateException identifierAltered(String entityName, Serializable id, Serializable oid) {
        HibernateException result = new HibernateException(String.format(this.getLoggingLocale(), this.identifierAltered$str(), entityName, id, oid));
        Log_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String mergeRequestedIdNotMatchingIdOfPassedEntity$str() {
        return "HR000042: Merge requested with id not matching id of passed entity";
    }

    @Override
    public final HibernateException mergeRequestedIdNotMatchingIdOfPassedEntity() {
        HibernateException result = new HibernateException(String.format(this.getLoggingLocale(), this.mergeRequestedIdNotMatchingIdOfPassedEntity$str(), new Object[0]));
        Log_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String unableToLocatePersister$str() {
        return "HR000043: Unable to locate persister: %1$s";
    }

    @Override
    public final HibernateException unableToLocatePersister(String persister) {
        HibernateException result = new HibernateException(String.format(this.getLoggingLocale(), this.unableToLocatePersister$str(), persister));
        Log_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String invalidLockModeForLock$str() {
        return "HR000044: Invalid lock mode for lock()";
    }

    @Override
    public final HibernateException invalidLockModeForLock() {
        HibernateException result = new HibernateException(String.format(this.getLoggingLocale(), this.invalidLockModeForLock$str(), new Object[0]));
        Log_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String collectionWasEvicted$str() {
        return "HR000045: Collection was evicted";
    }

    @Override
    public final HibernateException collectionWasEvicted() {
        HibernateException result = new HibernateException(String.format(this.getLoggingLocale(), this.collectionWasEvicted$str(), new Object[0]));
        Log_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String unexpectedBatchSizeSpread$str() {
        return "HR000046: Unexpected batch size spread";
    }

    @Override
    public final HibernateException unexpectedBatchSizeSpread() {
        HibernateException result = new HibernateException(String.format(this.getLoggingLocale(), this.unexpectedBatchSizeSpread$str(), new Object[0]));
        Log_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String generatedIdentifierSmallerOrEqualThanZero$str() {
        return "HR000047: Generated identifier smaller or equal to 0: %1$d";
    }

    @Override
    public final HibernateException generatedIdentifierSmallerOrEqualThanZero(Long id) {
        HibernateException result = new HibernateException(String.format(this.getLoggingLocale(), this.generatedIdentifierSmallerOrEqualThanZero$str(), id));
        Log_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String couldNotDetermineDialectFromJdbcDriverMetadata$str() {
        return "HR000048: Could not determine Dialect from JDBC driver metadata (specify a connection URI with scheme 'postgresql:', 'mysql:', 'cockroachdb', or 'db2:')";
    }

    @Override
    public final HibernateException couldNotDetermineDialectFromJdbcDriverMetadata() {
        HibernateException result = new HibernateException(String.format(this.getLoggingLocale(), this.couldNotDetermineDialectFromJdbcDriverMetadata$str(), new Object[0]));
        Log_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String couldNotDetermineDialectFromConnectionURI$str() {
        return "HR000049: Could not determine Dialect from connection URI: '%1$s' (specify a connection URI with scheme 'postgresql:', 'mysql:', 'cockroachdb', or 'db2:')";
    }

    @Override
    public final HibernateException couldNotDetermineDialectFromConnectionURI(String url) {
        HibernateException result = new HibernateException(String.format(this.getLoggingLocale(), this.couldNotDetermineDialectFromConnectionURI$str(), url));
        Log_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String selectGeneratorIsNotSupportedInHibernateReactive$str() {
        return "HR000050: SelectGenerator is not supported in Hibernate Reactive";
    }

    @Override
    public final HibernateException selectGeneratorIsNotSupportedInHibernateReactive() {
        HibernateException result = new HibernateException(String.format(this.getLoggingLocale(), this.selectGeneratorIsNotSupportedInHibernateReactive$str(), new Object[0]));
        Log_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String cannotGenerateIdentifiersOfType$str() {
        return "HR000051: Cannot generate identifiers of type %1$S for: %2$s";
    }

    @Override
    public final HibernateException cannotGenerateIdentifiersOfType(String simpleName, String entityName) {
        HibernateException result = new HibernateException(String.format(this.getLoggingLocale(), this.cannotGenerateIdentifiersOfType$str(), simpleName, entityName));
        Log_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String generatedIdentifierTooBigForTheField$str() {
        return "HR000052: Generated identifier for %1$s too big to be assigned to a field of type %2$s: %3$s";
    }

    @Override
    public final HibernateException generatedIdentifierTooBigForTheField(String entityName, String simpleName, Long id) {
        HibernateException result = new HibernateException(String.format(this.getLoggingLocale(), this.generatedIdentifierTooBigForTheField$str(), entityName, simpleName, id));
        Log_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String couldNotLocateEntityEntryAfterTwoPhaseLoad$str() {
        return "HR000053: Could not locate EntityEntry immediately after two-phase load";
    }

    @Override
    public final HibernateException couldNotLocateEntityEntryAfterTwoPhaseLoad() {
        HibernateException result = new HibernateException(String.format(this.getLoggingLocale(), this.couldNotLocateEntityEntryAfterTwoPhaseLoad$str(), new Object[0]));
        Log_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String cannotRecreateCollectionWhileFilterIsEnabled$str() {
        return "HR000054: Cannot recreate collection while filter is enabled: %1$s";
    }

    @Override
    public final HibernateException cannotRecreateCollectionWhileFilterIsEnabled(String collectionInfoString) {
        HibernateException result = new HibernateException(String.format(this.getLoggingLocale(), this.cannotRecreateCollectionWhileFilterIsEnabled$str(), collectionInfoString));
        Log_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String sessionClosedLazyInitializationException$str() {
        return "HR000055: Session closed";
    }

    @Override
    public final LazyInitializationException sessionClosedLazyInitializationException() {
        LazyInitializationException result = new LazyInitializationException(String.format(this.getLoggingLocale(), this.sessionClosedLazyInitializationException$str(), new Object[0]));
        Log_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String collectionCannotBeInitializedlazyInitializationException$str() {
        return "HR000056: Collection cannot be initialized: %1$s";
    }

    @Override
    public final LazyInitializationException collectionCannotBeInitializedlazyInitializationException(String role) {
        LazyInitializationException result = new LazyInitializationException(String.format(this.getLoggingLocale(), this.collectionCannotBeInitializedlazyInitializationException$str(), role));
        Log_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    @Override
    public final void failedToExecuteStatement(String sql, String s, Throwable t) {
        this.log.logf(FQCN, Logger.Level.ERROR, t, this.failedToExecuteStatement$str(), (Object)sql, (Object)s);
    }

    protected String failedToExecuteStatement$str() {
        return "HR000057: Failed to execute statement [$1%s]: $2%s";
    }

    protected String impossibleFlushModeIllegalState$str() {
        return "HR000058: Impossible flush mode";
    }

    @Override
    public final IllegalStateException impossibleFlushModeIllegalState() {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.impossibleFlushModeIllegalState$str(), new Object[0]));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String numberOfResultsGreaterThanBatchedParameters$str() {
        return "HR000059: Number of results is greater than number of batched parameters";
    }

    @Override
    public final IllegalStateException numberOfResultsGreaterThanBatchedParameters() {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.numberOfResultsGreaterThanBatchedParameters$str(), new Object[0]));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String sessionIsClosed$str() {
        return "HR000060: Session is closed";
    }

    @Override
    public final IllegalStateException sessionIsClosed() {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.sessionIsClosed$str(), new Object[0]));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String sessionIsConnectingToTheDatabase$str() {
        return "HR000061: Session is currently connecting to database";
    }

    @Override
    public final IllegalStateException sessionIsConnectingToTheDatabase() {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.sessionIsConnectingToTheDatabase$str(), new Object[0]));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String updatingImmutableEntityThatsNotInTheSession$str() {
        return "HR000062: Updating immutable entity that is not in session yet!";
    }

    @Override
    public final IllegalStateException updatingImmutableEntityThatsNotInTheSession() {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.updatingImmutableEntityThatsNotInTheSession$str(), new Object[0]));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String entityDeleteStateIllegal$str() {
        return "HR000063: Entity has status Status.DELETED but values != entry.getDeletedState";
    }

    @Override
    public final IllegalStateException entityDeleteStateIllegal() {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.entityDeleteStateIllegal$str(), new Object[0]));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String unexpectedNumberOfReturnedValues$str() {
        return "HR000064: Number of return values [%1$s] did not match expected [%2$s]";
    }

    @Override
    public final IllegalStateException unexpectedNumberOfReturnedValues(int length, int size) {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.unexpectedNumberOfReturnedValues$str(), length, size));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String notVertxContextActive$str() {
        return "HR000065: No Vert.x context active";
    }

    @Override
    public final IllegalStateException notVertxContextActive() {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.notVertxContextActive$str(), new Object[0]));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String unknownStructureType$str() {
        return "HR000066: Unknown structure type";
    }

    @Override
    public final IllegalStateException unknownStructureType() {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.unknownStructureType$str(), new Object[0]));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String serviceNotInitialized$str() {
        return "HR000067: Service not initialized";
    }

    @Override
    public final IllegalStateException serviceNotInitialized() {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.serviceNotInitialized$str(), new Object[0]));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String shouldBeInvokedInVertxEventLoopThread$str() {
        return "HR000068: This method should exclusively be invoked from a Vert.x EventLoop thread; currently running on thread '%1$s'";
    }

    @Override
    public final IllegalStateException shouldBeInvokedInVertxEventLoopThread(String name) {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.shouldBeInvokedInVertxEventLoopThread$str(), name));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String detectedUsedOfTheSessionOnTheWrongThread$str() {
        return "HR000069: Detected use of the reactive Session from a different Thread than the one which was used to open the reactive Session - this suggests an invalid integration; original thread [%1$s]: '%2$s' current Thread [%3$s]: '%4$s'";
    }

    @Override
    public final IllegalStateException detectedUsedOfTheSessionOnTheWrongThread(long expectedThreadId, String expectedThreadName, long currentThreadId, String currentThreadName) {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.detectedUsedOfTheSessionOnTheWrongThread$str(), expectedThreadId, expectedThreadName, currentThreadId, currentThreadName));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String unableToLocatePersistenceUnits$str() {
        return "HR000070: Unable to locate persistence units";
    }

    @Override
    public final PersistenceException unableToLocatePersistenceUnits(Throwable e) {
        PersistenceException result = new PersistenceException(String.format(this.getLoggingLocale(), this.unableToLocatePersistenceUnits$str(), new Object[0]), e);
        Log_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String noNameProvidedAndMultiplePersistenceUnitsFound$str() {
        return "HR000071: No name provided and multiple persistence units found";
    }

    @Override
    public final PersistenceException noNameProvidedAndMultiplePersistenceUnitsFound() {
        PersistenceException result = new PersistenceException(String.format(this.getLoggingLocale(), this.noNameProvidedAndMultiplePersistenceUnitsFound$str(), new Object[0]));
        Log_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String uninitializedProxyUpdate$str() {
        return "HR000072: Cannot update an uninitialized proxy. Make sure to fetch the value before trying to update it: %1$s";
    }

    @Override
    public final HibernateException uninitializedProxyUpdate(Object entity) {
        HibernateException result = new HibernateException(String.format(this.getLoggingLocale(), this.uninitializedProxyUpdate$str(), entity));
        Log_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    @Override
    public final void firstOrMaxResultsSpecifiedWithCollectionFetch() {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.firstOrMaxResultsSpecifiedWithCollectionFetch$str(), new Object[0]);
    }

    protected String firstOrMaxResultsSpecifiedWithCollectionFetch$str() {
        return "HR000104: firstResult/maxResults specified with collection fetch; applying in memory!";
    }

    @Override
    public final void handlingTransientEntity() {
        this.log.logf(FQCN, Logger.Level.INFO, null, this.handlingTransientEntity$str(), new Object[0]);
    }

    protected String handlingTransientEntity$str() {
        return "HR000114: Handling transient entity in delete processing";
    }

    @Override
    public final void needsLimit() {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.needsLimit$str(), new Object[0]);
    }

    protected String needsLimit$str() {
        return "HR000180: FirstResult/maxResults specified on polymorphic query; applying in memory!";
    }

    @Override
    public final void splitQueries(String sourceQuery, int length) {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.splitQueries$str(), (Object)sourceQuery, (Object)length);
    }

    protected String splitQueries$str() {
        return "HR000245: Manipulation query [%s] resulted in [%s] split queries";
    }

    @Override
    public final void unableToLoadCommand(HibernateException e) {
        this.log.logf(FQCN, Logger.Level.INFO, (Throwable)e, this.unableToLoadCommand$str(), new Object[0]);
    }

    protected String unableToLoadCommand$str() {
        return "HR000327: Error performing load command";
    }

    @Override
    public final void unableToReleaseCacheLock(CacheException ce) {
        this.log.logf(FQCN, Logger.Level.ERROR, null, this.unableToReleaseCacheLock$str(), (Object)ce);
    }

    protected String unableToReleaseCacheLock$str() {
        return "HR000353: Could not release a cache lock : %s";
    }

    @Override
    public final void explicitSkipLockedLockCombo() {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.explicitSkipLockedLockCombo$str(), new Object[0]);
    }

    protected String explicitSkipLockedLockCombo$str() {
        return "HR000447: Explicit use of UPGRADE_SKIPLOCKED in lock() calls is not recommended; use normal UPGRADE locking instead";
    }
}

