/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.reactive.loader.entity.impl;

import java.io.Serializable;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import java.util.concurrent.CompletionStage;
import org.hibernate.LockMode;
import org.hibernate.LockOptions;
import org.hibernate.MappingException;
import org.hibernate.engine.spi.LoadQueryInfluencers;
import org.hibernate.engine.spi.QueryParameters;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.event.spi.EventSource;
import org.hibernate.event.spi.PostLoadEvent;
import org.hibernate.event.spi.PreLoadEvent;
import org.hibernate.loader.entity.plan.AbstractLoadPlanBasedEntityLoader;
import org.hibernate.loader.plan.exec.internal.EntityLoadQueryDetails;
import org.hibernate.loader.plan.exec.process.internal.AbstractRowReader;
import org.hibernate.loader.plan.exec.process.internal.ResultSetProcessingContextImpl;
import org.hibernate.loader.plan.exec.process.internal.ResultSetProcessorImpl;
import org.hibernate.loader.plan.exec.process.spi.ReaderCollector;
import org.hibernate.loader.plan.exec.process.spi.ResultSetProcessingContext;
import org.hibernate.loader.plan.exec.process.spi.RowReader;
import org.hibernate.loader.plan.exec.query.internal.QueryBuildingParametersImpl;
import org.hibernate.loader.plan.exec.query.spi.NamedParameterContext;
import org.hibernate.loader.plan.exec.query.spi.QueryBuildingParameters;
import org.hibernate.loader.plan.exec.spi.AliasResolutionContext;
import org.hibernate.loader.plan.spi.LoadPlan;
import org.hibernate.loader.spi.AfterLoadAction;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.persister.entity.OuterJoinLoadable;
import org.hibernate.pretty.MessageHelper;
import org.hibernate.reactive.loader.ReactiveLoader;
import org.hibernate.reactive.loader.ReactiveResultSetProcessor;
import org.hibernate.reactive.loader.entity.ReactiveUniqueEntityLoader;
import org.hibernate.reactive.pool.impl.Parameters;
import org.hibernate.reactive.util.impl.CompletionStages;
import org.hibernate.transform.ResultTransformer;
import org.hibernate.type.Type;

public class ReactivePlanEntityLoader
extends AbstractLoadPlanBasedEntityLoader
implements ReactiveUniqueEntityLoader,
ReactiveLoader {
    private final OuterJoinLoadable persister;
    private final Parameters parameters;
    private final String processedSQL;
    private final ReactiveResultSetProcessor reactiveResultSetProcessor;

    private ReactivePlanEntityLoader(SessionFactoryImplementor factory, OuterJoinLoadable persister, String[] uniqueKeyColumnNames, Type uniqueKeyType, QueryBuildingParameters buildingParameters) throws MappingException {
        super(persister, factory, uniqueKeyColumnNames, uniqueKeyType, buildingParameters, (loadPlan, aliasResolutionContext, readerCollector, shouldUseOptionalEntityInstance, hadSubselectFetches) -> new ReactiveLoadPlanBasedResultSetProcessor(loadPlan, aliasResolutionContext, new ReactiveRowReader(readerCollector), shouldUseOptionalEntityInstance, hadSubselectFetches));
        this.persister = persister;
        this.reactiveResultSetProcessor = (ReactiveResultSetProcessor)this.getStaticLoadQuery().getResultSetProcessor();
        this.parameters = Parameters.instance(factory.getJdbcServices().getDialect());
        this.processedSQL = this.parameters.process(this.getStaticLoadQuery().getSqlStatement());
    }

    private ReactivePlanEntityLoader(SessionFactoryImplementor factory, OuterJoinLoadable persister, ReactivePlanEntityLoader entityLoaderTemplate, Type uniqueKeyType, QueryBuildingParameters buildingParameters) throws MappingException {
        super(persister, factory, entityLoaderTemplate.getStaticLoadQuery(), uniqueKeyType, buildingParameters, (loadPlan, aliasResolutionContext, readerCollector, shouldUseOptionalEntityInstance, hadSubselectFetches) -> new ReactiveLoadPlanBasedResultSetProcessor(loadPlan, aliasResolutionContext, new ReactiveRowReader(readerCollector), shouldUseOptionalEntityInstance, hadSubselectFetches));
        this.persister = persister;
        this.reactiveResultSetProcessor = (ReactiveResultSetProcessor)this.getStaticLoadQuery().getResultSetProcessor();
        this.parameters = Parameters.instance(factory.getJdbcServices().getDialect());
        this.processedSQL = this.parameters.process(this.getStaticLoadQuery().getSqlStatement());
    }

    @Override
    public Parameters parameters() {
        return this.parameters;
    }

    protected EntityLoadQueryDetails getStaticLoadQuery() {
        return (EntityLoadQueryDetails)super.getStaticLoadQuery();
    }

    @Override
    public CompletionStage<Object> load(Serializable id, Object optionalObject, SharedSessionContractImplementor session) {
        return this.load(id, optionalObject, session, LockOptions.NONE, null);
    }

    @Override
    public CompletionStage<Object> load(Serializable id, Object optionalObject, SharedSessionContractImplementor session, Boolean readOnly) {
        return this.load(id, optionalObject, session, LockOptions.NONE, readOnly);
    }

    @Override
    public CompletionStage<Object> load(Serializable id, Object optionalObject, SharedSessionContractImplementor session, LockOptions lockOptions) {
        return this.load(id, optionalObject, session, lockOptions, null);
    }

    @Override
    public CompletionStage<Object> load(Object id, SharedSessionContractImplementor session, LockOptions lockOptions) {
        throw new UnsupportedOperationException();
    }

    @Override
    public CompletionStage<Object> load(Serializable id, Object optionalObject, SharedSessionContractImplementor session, LockOptions lockOptions, Boolean readOnly) {
        QueryParameters parameters = this.buildQueryParameters(id, optionalObject, lockOptions, readOnly);
        String sql = this.hasFilters(session) ? this.getStaticLoadQuery().getSqlStatement() : this.processedSQL;
        return this.doReactiveQueryAndInitializeNonLazyCollections(sql, session, parameters).thenApply(results -> this.extractEntityResult((List)results, id)).handle((list, err) -> {
            CompletionStages.logSqlException(err, () -> "could not load an entity: " + MessageHelper.infoString((EntityPersister)this.persister, (Object)id, (Type)this.persister.getIdentifierType(), (SessionFactoryImplementor)this.getFactory()), sql);
            return CompletionStages.returnOrRethrow(err, list);
        });
    }

    private boolean hasFilters(SharedSessionContractImplementor session) {
        return !session.getLoadQueryInfluencers().getEnabledFilters().isEmpty();
    }

    private QueryParameters buildQueryParameters(Serializable id, Object optionalObject, LockOptions lockOptions, Boolean readOnly) {
        QueryParameters qp = new QueryParameters();
        qp.setPositionalParameterTypes(new Type[]{this.persister.getIdentifierType()});
        qp.setPositionalParameterValues(new Object[]{id});
        qp.setOptionalObject(optionalObject);
        qp.setOptionalEntityName(this.persister.getEntityName());
        qp.setOptionalId(id);
        qp.setLockOptions(lockOptions);
        if (readOnly != null) {
            qp.setReadOnly(readOnly.booleanValue());
        }
        return qp;
    }

    @Override
    public ReactiveResultSetProcessor getReactiveResultSetProcessor() {
        return this.reactiveResultSetProcessor;
    }

    @Override
    public String preprocessSQL(String sql, QueryParameters queryParameters, SessionFactoryImplementor factory, List<AfterLoadAction> afterLoadActions) {
        return sql;
    }

    private static class ReactiveRowReader
    extends AbstractRowReader {
        private final ReaderCollector readerCollector;

        public ReactiveRowReader(ReaderCollector readerCollector) {
            super(readerCollector);
            this.readerCollector = readerCollector;
        }

        protected Object readLogicalRow(ResultSet resultSet, ResultSetProcessingContextImpl context) throws SQLException {
            return this.readerCollector.getReturnReader().read(resultSet, (ResultSetProcessingContext)context);
        }

        public void finishUp(ResultSetProcessingContextImpl context, List<AfterLoadAction> afterLoadActionList) {
            throw new UnsupportedOperationException("Use #reactiveFinishUp instead.");
        }

        public CompletionStage<Void> reactiveFinishUp(ReactiveLoadPlanBasedResultSetProcessor resultSetProcessor, ResultSetProcessingContextImpl context, List<AfterLoadAction> afterLoadActionList) {
            PostLoadEvent postLoadEvent;
            PreLoadEvent preLoadEvent;
            this.finishLoadingArrays(context);
            if (context.getSession().isEventSource()) {
                EventSource session = (EventSource)context.getSession();
                preLoadEvent = new PreLoadEvent(session);
                postLoadEvent = new PostLoadEvent(session);
            } else {
                preLoadEvent = null;
                postLoadEvent = null;
            }
            return this.reactivePerformTwoPhaseLoad(resultSetProcessor, preLoadEvent, context).thenAccept(v -> {
                List hydratedEntityRegistrations = context.getHydratedEntityRegistrationList();
                this.finishLoadingCollections(context);
                this.afterInitialize(context, hydratedEntityRegistrations);
                this.postLoad(postLoadEvent, context, hydratedEntityRegistrations, afterLoadActionList);
            });
        }

        public CompletionStage<Void> reactivePerformTwoPhaseLoad(ReactiveLoadPlanBasedResultSetProcessor resultSetProcessor, PreLoadEvent preLoadEvent, ResultSetProcessingContextImpl context) {
            List hydratedEntityRegistrations = context.getHydratedEntityRegistrationList();
            if (hydratedEntityRegistrations == null || hydratedEntityRegistrations.isEmpty()) {
                return CompletionStages.voidFuture();
            }
            SharedSessionContractImplementor session = context.getSession();
            return CompletionStages.loop(hydratedEntityRegistrations, registration -> resultSetProcessor.initializeEntity(registration.getInstance(), false, session, preLoadEvent));
        }
    }

    private static class ReactiveLoadPlanBasedResultSetProcessor
    extends ResultSetProcessorImpl
    implements ReactiveResultSetProcessor {
        private final ReactiveRowReader rowReader;

        public ReactiveLoadPlanBasedResultSetProcessor(LoadPlan loadPlan, AliasResolutionContext aliasResolutionContext, ReactiveRowReader rowReader, boolean shouldUseOptionalEntityInstance, boolean hadSubselectFetches) {
            super(loadPlan, aliasResolutionContext, (RowReader)rowReader, shouldUseOptionalEntityInstance, hadSubselectFetches);
            this.rowReader = rowReader;
        }

        public List<Object> extractResults(ResultSet resultSet, SharedSessionContractImplementor session, QueryParameters queryParameters, NamedParameterContext namedParameterContext, boolean returnProxies, boolean readOnly, ResultTransformer forcedResultTransformer, List<AfterLoadAction> afterLoadActionList) {
            throw new UnsupportedOperationException("#reactiveExtractResults should be used instead");
        }

        @Override
        public CompletionStage<List<Object>> reactiveExtractResults(ResultSet resultSet, SharedSessionContractImplementor session, QueryParameters queryParameters, NamedParameterContext namedParameterContext, boolean returnProxies, boolean readOnly, ResultTransformer forcedResultTransformer, List<AfterLoadAction> afterLoadActionList) throws SQLException {
            this.handlePotentiallyEmptyCollectionRootReturns(queryParameters.getCollectionKeys(), resultSet, session);
            ResultSetProcessingContextImpl context = this.createResultSetProcessingContext(resultSet, session, queryParameters, namedParameterContext, returnProxies, readOnly);
            List loadResults = this.extractRows(resultSet, queryParameters, context);
            return this.rowReader.reactiveFinishUp(this, context, afterLoadActionList).thenAccept(v -> context.wrapUp()).thenApply(v -> loadResults);
        }
    }

    public static class Builder {
        private final OuterJoinLoadable persister;
        private ReactivePlanEntityLoader entityLoaderTemplate;
        private int batchSize = 1;
        private LoadQueryInfluencers influencers = LoadQueryInfluencers.NONE;
        private LockMode lockMode = LockMode.NONE;
        private LockOptions lockOptions;

        public Builder(OuterJoinLoadable persister) {
            this.persister = persister;
        }

        public Builder withEntityLoaderTemplate(ReactivePlanEntityLoader entityLoaderTemplate) {
            this.entityLoaderTemplate = entityLoaderTemplate;
            return this;
        }

        public Builder withBatchSize(int batchSize) {
            this.batchSize = batchSize;
            return this;
        }

        public Builder withInfluencers(LoadQueryInfluencers influencers) {
            this.influencers = influencers;
            return this;
        }

        public Builder withLockMode(LockMode lockMode) {
            this.lockMode = lockMode;
            return this;
        }

        public Builder withLockOptions(LockOptions lockOptions) {
            this.lockOptions = lockOptions;
            return this;
        }

        public ReactivePlanEntityLoader byPrimaryKey() {
            return this.byUniqueKey(this.persister.getIdentifierColumnNames(), this.persister.getIdentifierType());
        }

        public ReactivePlanEntityLoader byUniqueKey(String[] keyColumnNames, Type keyType) {
            if (this.entityLoaderTemplate == null) {
                return new ReactivePlanEntityLoader(this.persister.getFactory(), this.persister, keyColumnNames, keyType, (QueryBuildingParameters)new QueryBuildingParametersImpl(this.influencers, this.batchSize, this.lockMode, this.lockOptions));
            }
            return new ReactivePlanEntityLoader(this.persister.getFactory(), this.persister, this.entityLoaderTemplate, keyType, (QueryBuildingParameters)new QueryBuildingParametersImpl(this.influencers, this.batchSize, this.lockMode, this.lockOptions));
        }
    }
}

