/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.reactive.loader.entity.impl;

import java.io.Serializable;
import java.lang.invoke.MethodHandles;
import java.util.concurrent.CompletionStage;
import org.hibernate.LockMode;
import org.hibernate.LockOptions;
import org.hibernate.engine.internal.BatchFetchQueueHelper;
import org.hibernate.engine.spi.LoadQueryInfluencers;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.internal.util.collections.ArrayHelper;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.persister.entity.OuterJoinLoadable;
import org.hibernate.reactive.loader.entity.impl.ReactiveBatchingEntityLoader;
import org.hibernate.reactive.loader.entity.impl.ReactiveEntityLoader;
import org.hibernate.reactive.logging.impl.Log;
import org.hibernate.reactive.logging.impl.LoggerFactory;

public class ReactivePaddedBatchingEntityLoader
extends ReactiveBatchingEntityLoader {
    private static final Log LOG = LoggerFactory.make(Log.class, MethodHandles.lookup());
    private final int[] batchSizes;
    private final ReactiveEntityLoader[] loaders;

    public ReactivePaddedBatchingEntityLoader(OuterJoinLoadable persister, int maxBatchSize, LockMode lockMode, SessionFactoryImplementor factory, LoadQueryInfluencers loadQueryInfluencers) {
        super(persister);
        this.batchSizes = ArrayHelper.getBatchSizes((int)maxBatchSize);
        this.loaders = new ReactiveEntityLoader[this.batchSizes.length];
        for (int i = 0; i < this.batchSizes.length; ++i) {
            this.loaders[i] = new ReactiveEntityLoader(persister, this.batchSizes[i], lockMode, factory, loadQueryInfluencers);
        }
        this.validate(maxBatchSize);
    }

    public ReactivePaddedBatchingEntityLoader(OuterJoinLoadable persister, int maxBatchSize, LockOptions lockOptions, SessionFactoryImplementor factory, LoadQueryInfluencers loadQueryInfluencers) {
        super(persister);
        this.batchSizes = ArrayHelper.getBatchSizes((int)maxBatchSize);
        this.loaders = new ReactiveEntityLoader[this.batchSizes.length];
        for (int i = 0; i < this.batchSizes.length; ++i) {
            this.loaders[i] = new ReactiveEntityLoader(persister, this.batchSizes[i], lockOptions, factory, loadQueryInfluencers);
        }
        this.validate(maxBatchSize);
    }

    @Override
    public CompletionStage<Object> load(Serializable id, Object optionalObject, SharedSessionContractImplementor session, LockOptions lockOptions) {
        return this.load(id, optionalObject, session, lockOptions, null);
    }

    private void validate(int max) {
        if (this.batchSizes[0] != max) {
            throw LOG.unexpectedBatchSizeSpread();
        }
        if (this.batchSizes[this.batchSizes.length - 1] != 1) {
            throw LOG.unexpectedBatchSizeSpread();
        }
    }

    @Override
    public CompletionStage<Object> load(Serializable id, Object optionalObject, SharedSessionContractImplementor session, LockOptions lockOptions, Boolean readOnly) {
        Serializable[] batch = session.getPersistenceContextInternal().getBatchFetchQueue().getEntityBatch(this.persister(), id, this.batchSizes[0], this.persister().getEntityMode());
        int numberOfIds = ArrayHelper.countNonNull((Serializable[])batch);
        if (numberOfIds <= 1) {
            return this.loaders[this.batchSizes.length - 1].load(id, optionalObject, session).thenApply(optional -> {
                if (optional == null) {
                    BatchFetchQueueHelper.removeBatchLoadableEntityKey((Serializable)id, (EntityPersister)this.persister(), (SharedSessionContractImplementor)session);
                }
                return optional;
            });
        }
        int indexToUse = this.batchSizes.length - 1;
        int i = 0;
        while (i < this.batchSizes.length - 1 && this.batchSizes[i] >= numberOfIds) {
            indexToUse = i++;
        }
        Serializable[] idsToLoad = new Serializable[this.batchSizes[indexToUse]];
        System.arraycopy(batch, 0, idsToLoad, 0, numberOfIds);
        for (int i2 = numberOfIds; i2 < this.batchSizes[indexToUse]; ++i2) {
            idsToLoad[i2] = id;
        }
        return this.doBatchLoad(id, this.loaders[indexToUse], session, idsToLoad, optionalObject, lockOptions, readOnly);
    }
}

