/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.reactive.loader.entity.impl;

import org.hibernate.LockMode;
import org.hibernate.LockOptions;
import org.hibernate.MappingException;
import org.hibernate.engine.spi.LoadQueryInfluencers;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.loader.JoinWalker;
import org.hibernate.loader.entity.EntityJoinWalker;
import org.hibernate.persister.entity.OuterJoinLoadable;
import org.hibernate.reactive.loader.entity.impl.ReactiveAbstractEntityLoader;
import org.hibernate.type.Type;

public class ReactiveEntityLoader
extends ReactiveAbstractEntityLoader {
    private final int[][] compositeKeyManyToOneTargetIndices;

    public ReactiveEntityLoader(OuterJoinLoadable persister, SessionFactoryImplementor factory, LockMode lockMode, LoadQueryInfluencers loadQueryInfluencers) throws MappingException {
        this(persister, 1, lockMode, factory, loadQueryInfluencers);
    }

    public ReactiveEntityLoader(OuterJoinLoadable persister, int batchSize, LockMode lockMode, SessionFactoryImplementor factory, LoadQueryInfluencers loadQueryInfluencers) throws MappingException {
        this(persister, persister.getIdentifierType(), factory, loadQueryInfluencers, new EntityJoinWalker(persister, persister.getIdentifierColumnNames(), batchSize, lockMode, factory, loadQueryInfluencers));
        if (LOG.isDebugEnabled()) {
            LOG.debugf("Static select for entity %s [%s]: %s", this.entityName, lockMode, this.getSQLString());
        }
    }

    public ReactiveEntityLoader(OuterJoinLoadable persister, int batchSize, LockOptions lockOptions, SessionFactoryImplementor factory, LoadQueryInfluencers loadQueryInfluencers) throws MappingException {
        this(persister, persister.getIdentifierType(), factory, loadQueryInfluencers, new EntityJoinWalker(persister, persister.getIdentifierColumnNames(), batchSize, lockOptions, factory, loadQueryInfluencers));
        if (LOG.isDebugEnabled()) {
            LOG.debugf("Static select for entity %s [%s:%s]: %s", new Object[]{this.entityName, lockOptions.getLockMode(), lockOptions.getTimeOut(), this.getSQLString()});
        }
    }

    public ReactiveEntityLoader(OuterJoinLoadable persister, String[] uniqueKey, Type uniqueKeyType, int batchSize, LockMode lockMode, SessionFactoryImplementor factory, LoadQueryInfluencers loadQueryInfluencers) throws MappingException {
        this(persister, uniqueKeyType, factory, loadQueryInfluencers, new EntityJoinWalker(persister, uniqueKey, batchSize, lockMode, factory, loadQueryInfluencers));
        if (LOG.isDebugEnabled()) {
            LOG.debugf("Static select for entity %s [%s]: %s", this.entityName, lockMode, this.getSQLString());
        }
    }

    private ReactiveEntityLoader(OuterJoinLoadable persister, Type uniqueKeyType, SessionFactoryImplementor factory, LoadQueryInfluencers loadQueryInfluencers, EntityJoinWalker walker) throws MappingException {
        super(persister, uniqueKeyType, factory, loadQueryInfluencers);
        this.initFromWalker((JoinWalker)walker);
        this.compositeKeyManyToOneTargetIndices = walker.getCompositeKeyManyToOneTargetIndices();
        this.postInstantiate();
    }

    public int[][] getCompositeKeyManyToOneTargetIndices() {
        return this.compositeKeyManyToOneTargetIndices;
    }
}

