/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.reactive.loader.entity.impl;

import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.CompletionStage;
import org.hibernate.LockMode;
import org.hibernate.LockOptions;
import org.hibernate.engine.spi.EntityEntry;
import org.hibernate.engine.spi.EntityKey;
import org.hibernate.engine.spi.LoadQueryInfluencers;
import org.hibernate.engine.spi.Mapping;
import org.hibernate.engine.spi.PersistenceContext;
import org.hibernate.engine.spi.QueryParameters;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.engine.spi.Status;
import org.hibernate.event.spi.EventSource;
import org.hibernate.event.spi.LoadEvent;
import org.hibernate.event.spi.LoadEventListener;
import org.hibernate.internal.util.collections.CollectionHelper;
import org.hibernate.loader.entity.CacheEntityLoaderHelper;
import org.hibernate.loader.entity.UniqueEntityLoader;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.persister.entity.MultiLoadOptions;
import org.hibernate.persister.entity.OuterJoinLoadable;
import org.hibernate.reactive.loader.entity.impl.ReactiveBatchingEntityLoaderBuilder;
import org.hibernate.reactive.loader.entity.impl.ReactiveDynamicBatchingEntityDelegator;
import org.hibernate.reactive.loader.entity.impl.ReactiveDynamicBatchingEntityLoader;
import org.hibernate.reactive.util.impl.CompletionStages;
import org.hibernate.type.Type;

public class ReactiveDynamicBatchingEntityLoaderBuilder
extends ReactiveBatchingEntityLoaderBuilder {
    public static final ReactiveDynamicBatchingEntityLoaderBuilder INSTANCE = new ReactiveDynamicBatchingEntityLoaderBuilder();

    public CompletionStage<List<Object>> multiLoad(OuterJoinLoadable persister, Serializable[] ids, SessionImplementor session, MultiLoadOptions loadOptions) {
        return loadOptions.isOrderReturnEnabled() ? this.performOrderedMultiLoad(persister, ids, session, loadOptions) : this.performUnorderedMultiLoad(persister, ids, session, loadOptions);
    }

    private CompletionStage<List<Object>> performOrderedBatchLoad(List<Serializable> idsInBatch, LockOptions lockOptions, OuterJoinLoadable persister, SessionImplementor session) {
        int batchSize = idsInBatch.size();
        ReactiveDynamicBatchingEntityLoader batchingLoader = new ReactiveDynamicBatchingEntityLoader(persister, batchSize, lockOptions, session.getFactory(), session.getLoadQueryInfluencers());
        Serializable[] idsInBatchArray = idsInBatch.toArray(new Serializable[0]);
        QueryParameters qp = ReactiveDynamicBatchingEntityLoaderBuilder.buildMultiLoadQueryParameters(persister, idsInBatchArray, lockOptions);
        CompletionStage<List<Object>> result = batchingLoader.doEntityBatchFetch(session, qp, idsInBatchArray);
        idsInBatch.clear();
        return result;
    }

    private CompletionStage<List<Object>> performUnorderedMultiLoad(OuterJoinLoadable persister, Serializable[] ids, SessionImplementor session, MultiLoadOptions loadOptions) {
        LockOptions lockOptions;
        assert (!loadOptions.isOrderReturnEnabled());
        ArrayList result = CollectionHelper.arrayList((int)ids.length);
        LockOptions lockOptions2 = lockOptions = loadOptions.getLockOptions() == null ? new LockOptions(LockMode.NONE) : loadOptions.getLockOptions();
        if (loadOptions.isSessionCheckingEnabled() || loadOptions.isSecondLevelCacheCheckingEnabled()) {
            boolean foundAnyManagedEntities = false;
            ArrayList<Serializable> nonManagedIds = new ArrayList<Serializable>();
            for (Serializable id : ids) {
                EntityKey entityKey = new EntityKey(id, (EntityPersister)persister);
                LoadEvent loadEvent = new LoadEvent(id, persister.getMappedClass().getName(), lockOptions, (EventSource)session, null);
                Object managedEntity = null;
                CacheEntityLoaderHelper.PersistenceContextEntry persistenceContextEntry = CacheEntityLoaderHelper.INSTANCE.loadFromSessionCache(loadEvent, entityKey, LoadEventListener.GET);
                if (loadOptions.isSessionCheckingEnabled() && (managedEntity = persistenceContextEntry.getEntity()) != null && !loadOptions.isReturnOfDeletedEntitiesEnabled() && !persistenceContextEntry.isManaged()) {
                    foundAnyManagedEntities = true;
                    result.add(null);
                    continue;
                }
                if (managedEntity == null && loadOptions.isSecondLevelCacheCheckingEnabled()) {
                    managedEntity = CacheEntityLoaderHelper.INSTANCE.loadFromSecondLevelCache(loadEvent, (EntityPersister)persister, entityKey);
                }
                if (managedEntity != null) {
                    foundAnyManagedEntities = true;
                    result.add(managedEntity);
                    continue;
                }
                nonManagedIds.add(id);
            }
            if (foundAnyManagedEntities) {
                if (nonManagedIds.isEmpty()) {
                    return CompletionStages.completedFuture(result);
                }
                ids = nonManagedIds.toArray((Serializable[])Array.newInstance(ids.getClass().getComponentType(), nonManagedIds.size()));
            }
        }
        int numberOfIdsLeft = ids.length;
        int maxBatchSize = loadOptions.getBatchSize() != null && loadOptions.getBatchSize() > 0 ? loadOptions.getBatchSize().intValue() : session.getJdbcServices().getJdbcEnvironment().getDialect().getDefaultBatchLoadSizingStrategy().determineOptimalBatchLoadSize(persister.getIdentifierType().getColumnSpan((Mapping)session.getFactory()), numberOfIdsLeft);
        CompletionStage<Void> stage = CompletionStages.voidFuture();
        int idPosition = 0;
        while (numberOfIdsLeft > 0) {
            int batchSize = Math.min(numberOfIdsLeft, maxBatchSize);
            ReactiveDynamicBatchingEntityLoader batchingLoader = new ReactiveDynamicBatchingEntityLoader(persister, batchSize, lockOptions, session.getFactory(), session.getLoadQueryInfluencers());
            Serializable[] idsInBatch = new Serializable[batchSize];
            System.arraycopy(ids, idPosition, idsInBatch, 0, batchSize);
            QueryParameters qp = ReactiveDynamicBatchingEntityLoaderBuilder.buildMultiLoadQueryParameters(persister, idsInBatch, lockOptions);
            CompletionStage<Void> fetch = batchingLoader.doEntityBatchFetch(session, qp, idsInBatch).thenAccept(result::addAll);
            stage = stage.thenCompose(v -> fetch);
            numberOfIdsLeft -= batchSize;
            idPosition += batchSize;
        }
        return stage.thenApply(v -> result);
    }

    private static QueryParameters buildMultiLoadQueryParameters(OuterJoinLoadable persister, Serializable[] ids, LockOptions lockOptions) {
        Object[] types = new Type[ids.length];
        Arrays.fill(types, persister.getIdentifierType());
        QueryParameters qp = new QueryParameters();
        qp.setOptionalEntityName(persister.getEntityName());
        qp.setPositionalParameterTypes((Type[])types);
        qp.setPositionalParameterValues((Object[])ids);
        qp.setLockOptions(lockOptions);
        qp.setOptionalObject(null);
        qp.setOptionalId(null);
        return qp;
    }

    @Override
    protected UniqueEntityLoader buildBatchingLoader(OuterJoinLoadable persister, int batchSize, LockMode lockMode, SessionFactoryImplementor factory, LoadQueryInfluencers influencers) {
        return new ReactiveDynamicBatchingEntityDelegator(persister, batchSize, lockMode, factory, influencers);
    }

    @Override
    protected UniqueEntityLoader buildBatchingLoader(OuterJoinLoadable persister, int batchSize, LockOptions lockOptions, SessionFactoryImplementor factory, LoadQueryInfluencers influencers) {
        return new ReactiveDynamicBatchingEntityDelegator(persister, batchSize, lockOptions, factory, influencers);
    }

    private CompletionStage<List<Object>> performOrderedMultiLoad(OuterJoinLoadable persister, Serializable[] ids, SessionImplementor session, MultiLoadOptions loadOptions) {
        assert (loadOptions.isOrderReturnEnabled());
        ArrayList result = CollectionHelper.arrayList((int)ids.length);
        LockOptions lockOptions = loadOptions.getLockOptions() == null ? new LockOptions(LockMode.NONE) : loadOptions.getLockOptions();
        int maxBatchSize = loadOptions.getBatchSize() != null && loadOptions.getBatchSize() > 0 ? loadOptions.getBatchSize().intValue() : session.getJdbcServices().getJdbcEnvironment().getDialect().getDefaultBatchLoadSizingStrategy().determineOptimalBatchLoadSize(persister.getIdentifierType().getColumnSpan((Mapping)session.getFactory()), ids.length);
        ArrayList<Serializable> idsInBatch = new ArrayList<Serializable>();
        ArrayList<Integer> elementPositionsLoadedByBatch = new ArrayList<Integer>();
        CompletionStage<Void> stage = CompletionStages.voidFuture();
        for (int i = 0; i < ids.length; ++i) {
            Serializable id = ids[i];
            EntityKey entityKey = new EntityKey(id, (EntityPersister)persister);
            if (loadOptions.isSessionCheckingEnabled() || loadOptions.isSecondLevelCacheCheckingEnabled()) {
                CacheEntityLoaderHelper.PersistenceContextEntry persistenceContextEntry;
                LoadEvent loadEvent = new LoadEvent(id, persister.getMappedClass().getName(), lockOptions, (EventSource)session, null);
                Object managedEntity = null;
                if (loadOptions.isSessionCheckingEnabled() && (managedEntity = (persistenceContextEntry = CacheEntityLoaderHelper.INSTANCE.loadFromSessionCache(loadEvent, entityKey, LoadEventListener.GET)).getEntity()) != null && !loadOptions.isReturnOfDeletedEntitiesEnabled() && !persistenceContextEntry.isManaged()) {
                    result.add(i, null);
                    continue;
                }
                if (managedEntity == null && loadOptions.isSecondLevelCacheCheckingEnabled()) {
                    managedEntity = CacheEntityLoaderHelper.INSTANCE.loadFromSecondLevelCache(loadEvent, (EntityPersister)persister, entityKey);
                }
                if (managedEntity != null) {
                    result.add(i, managedEntity);
                    continue;
                }
            }
            idsInBatch.add(ids[i]);
            if (idsInBatch.size() >= maxBatchSize) {
                CompletionStage<List<Object>> load = this.performOrderedBatchLoad(idsInBatch, lockOptions, persister, session);
                stage = stage.thenCompose(v -> load);
            }
            result.add(i, entityKey);
            elementPositionsLoadedByBatch.add(i);
        }
        if (!idsInBatch.isEmpty()) {
            CompletionStage<List<Object>> load = this.performOrderedBatchLoad(idsInBatch, lockOptions, persister, session);
            stage = stage.thenCompose(v -> load);
        }
        return stage.thenApply(v -> {
            PersistenceContext persistenceContext = session.getPersistenceContextInternal();
            for (Integer position : elementPositionsLoadedByBatch) {
                EntityEntry entry;
                EntityKey entityKey = (EntityKey)result.get(position);
                Object entity = persistenceContext.getEntity(entityKey);
                if (!(entity == null || loadOptions.isReturnOfDeletedEntitiesEnabled() || (entry = persistenceContext.getEntry(entity)).getStatus() != Status.DELETED && entry.getStatus() != Status.GONE)) {
                    entity = null;
                }
                result.set(position, entity);
            }
            return result;
        });
    }
}

