/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.reactive.loader.entity.impl;

import java.io.Serializable;
import java.util.List;
import java.util.concurrent.CompletionStage;
import org.hibernate.LockMode;
import org.hibernate.LockOptions;
import org.hibernate.dialect.Dialect;
import org.hibernate.engine.spi.LoadQueryInfluencers;
import org.hibernate.engine.spi.QueryParameters;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.loader.JoinWalker;
import org.hibernate.loader.entity.EntityJoinWalker;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.persister.entity.OuterJoinLoadable;
import org.hibernate.pretty.MessageHelper;
import org.hibernate.reactive.loader.entity.impl.ReactiveEntityLoader;
import org.hibernate.reactive.util.impl.CompletionStages;

class ReactiveDynamicBatchingEntityLoader
extends ReactiveEntityLoader {
    private final String sqlTemplate;
    private final String alias;

    public ReactiveDynamicBatchingEntityLoader(OuterJoinLoadable persister, int maxBatchSize, LockOptions lockOptions, SessionFactoryImplementor factory, LoadQueryInfluencers loadQueryInfluencers) {
        this(persister, maxBatchSize, lockOptions.getLockMode(), factory, loadQueryInfluencers);
    }

    public ReactiveDynamicBatchingEntityLoader(OuterJoinLoadable persister, int maxBatchSize, LockMode lockMode, SessionFactoryImplementor factory, LoadQueryInfluencers loadQueryInfluencers) {
        super(persister, -1, lockMode, factory, loadQueryInfluencers);
        EntityJoinWalker walker = new EntityJoinWalker(persister, persister.getIdentifierColumnNames(), -1, lockMode, factory, loadQueryInfluencers){

            protected StringBuilder whereString(String alias, String[] columnNames, int batchSize) {
                return ReactiveDynamicBatchingEntityLoader.buildBatchFetchRestrictionFragment(alias, columnNames, this.getDialect());
            }
        };
        this.initFromWalker((JoinWalker)walker);
        this.sqlTemplate = walker.getSQLString();
        this.alias = walker.getAlias();
        this.postInstantiate();
        if (LOG.isDebugEnabled()) {
            LOG.debugf("SQL-template for dynamic entity [%s] batch-fetching [%s] : %s", this.entityName, lockMode, this.sqlTemplate);
        }
    }

    protected boolean isSingleRowLoader() {
        return false;
    }

    @Override
    public boolean isSubselectLoadingEnabled() {
        return this.persister.hasSubselectLoadableCollections();
    }

    public CompletionStage<List<Object>> doEntityBatchFetch(SessionImplementor session, QueryParameters queryParameters, Serializable[] ids) {
        String sql = ReactiveDynamicBatchingEntityLoader.expandBatchIdPlaceholder(this.sqlTemplate, ids, this.alias, this.persister.getKeyColumnNames(), this.getDialect());
        String processedSQL = session.getLoadQueryInfluencers().hasEnabledFilters() ? sql : this.parameters().process(sql);
        return this.doReactiveQueryAndInitializeNonLazyCollections(processedSQL, (SharedSessionContractImplementor)session, queryParameters).handle((results, err) -> {
            CompletionStages.logSqlException(err, () -> "could not load an entity batch: " + MessageHelper.infoString((EntityPersister)this.getEntityPersisters()[0], (Serializable[])ids, (SessionFactoryImplementor)session.getFactory()), sql);
            return CompletionStages.returnOrRethrow(err, results);
        });
    }

    private static StringBuilder buildBatchFetchRestrictionFragment(String alias, String[] columnNames, Dialect dialect) {
        if (columnNames.length == 1) {
            return new StringBuilder(StringHelper.qualify((String)alias, (String)columnNames[0])).append(" in (").append("$$BATCH_ID_PLACEHOLDER$$").append(')');
        }
        if (dialect.supportsRowValueConstructorSyntaxInInList()) {
            StringBuilder builder = new StringBuilder();
            builder.append('(');
            boolean firstPass = true;
            String deliminator = "";
            for (String columnName : columnNames) {
                builder.append(deliminator).append(StringHelper.qualify((String)alias, (String)columnName));
                if (!firstPass) continue;
                firstPass = false;
                deliminator = ",";
            }
            builder.append(") in (");
            builder.append("$$BATCH_ID_PLACEHOLDER$$");
            builder.append(')');
            return builder;
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append('(').append("$$BATCH_ID_PLACEHOLDER$$").append(')');
        return stringBuilder;
    }

    static String expandBatchIdPlaceholder(String sql, Serializable[] ids, String alias, String[] keyColumnNames, Dialect dialect) {
        if (keyColumnNames.length == 1) {
            return StringHelper.replace((String)sql, (String)"$$BATCH_ID_PLACEHOLDER$$", (String)StringHelper.repeat((String)"?", (int)ids.length, (String)","));
        }
        if (dialect.supportsRowValueConstructorSyntaxInInList()) {
            String tuple = "(" + StringHelper.repeat((String)"?", (int)keyColumnNames.length, (String)",") + ")";
            return StringHelper.replace((String)sql, (String)"$$BATCH_ID_PLACEHOLDER$$", (String)StringHelper.repeat((String)tuple, (int)ids.length, (String)","));
        }
        String keyCheck = "(" + StringHelper.joinWithQualifierAndSuffix((String[])keyColumnNames, (String)alias, (String)" = ?", (String)" and ") + ")";
        return StringHelper.replace((String)sql, (String)"$$BATCH_ID_PLACEHOLDER$$", (String)StringHelper.repeat((String)keyCheck, (int)ids.length, (String)" or "));
    }
}

